/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.phuspm;

import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Element;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.SequenceList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoPHUSPM {
    int maxMemory = 0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    public static int numberOfHUSP = 0;
    public static int numberOfCandidates = 0;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output, int minUtility, float minProbability) throws IOException {
        ArrayList<List<Itemset>> revisedDatabase;
        HashMap<Integer, Float> orderSWP;
        HashMap<Integer, Integer> orderSWU;
        HashMap<Integer, SequenceList> sequenceListMap;
        block38: {
            String thisLine;
            HashMap<Integer, Float> Probability;
            HashMap<Integer, Integer> RSU;
            BufferedReader myInput;
            block36: {
                this.maxMemory = 0;
                this.startTimestamp = System.currentTimeMillis();
                numberOfHUSP = 0;
                numberOfCandidates = 0;
                this.writer = new BufferedWriter(new FileWriter(output));
                myInput = null;
                RSU = new HashMap<Integer, Integer>();
                Probability = new HashMap<Integer, Float>();
                sequenceListMap = new HashMap<Integer, SequenceList>();
                orderSWU = new HashMap<Integer, Integer>();
                orderSWP = new HashMap<Integer, Float>();
                revisedDatabase = new ArrayList<List<Itemset>>();
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        thisLine = null;
                        while ((thisLine = myInput.readLine()) != null) {
                            HashSet<Integer> set = new HashSet<Integer>();
                            String[] arry = thisLine.split(" -1 ");
                            int lineUtility = Integer.parseInt(arry[arry.length - 2]);
                            float lineProbability = Float.parseFloat(arry[arry.length - 1]);
                            int i = 0;
                            while (i < arry.length - 2) {
                                String[] itemset2 = arry[i].split(" , ");
                                int j = 0;
                                while (j < itemset2.length) {
                                    String[] itemProperty = itemset2[j].split(" ");
                                    int item = Integer.parseInt(itemProperty[0]);
                                    set.add(item);
                                    ++j;
                                }
                                ++i;
                            }
                            Iterator it = set.iterator();
                            while (it.hasNext()) {
                                int item = (Integer)it.next();
                                if (!RSU.containsKey(item)) {
                                    RSU.put(item, lineUtility);
                                } else {
                                    RSU.put(item, (Integer)RSU.get(item) + lineUtility);
                                }
                                if (!Probability.containsKey(item)) {
                                    Probability.put(item, Float.valueOf(lineProbability));
                                    continue;
                                }
                                Probability.put(item, Float.valueOf(((Float)Probability.get(item)).floatValue() + lineProbability));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    thisLine = null;
                    int order = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        ArrayList<Itemset> sequnce = new ArrayList<Itemset>();
                        String[] arry = thisLine.split(" -1 ");
                        int lineSWU = Integer.parseInt(arry[arry.length - 2]);
                        float lineSWP = Float.parseFloat(arry[arry.length - 1]);
                        int i = 0;
                        while (i < arry.length - 2) {
                            Itemset sitemset = new Itemset();
                            String[] itemset3 = arry[i].split(" , ");
                            int j = 0;
                            while (j < itemset3.length) {
                                String[] itemProperty = itemset3[j].split(" ");
                                int item = Integer.parseInt(itemProperty[0]);
                                int utility = Integer.parseInt(itemProperty[1]);
                                if ((Integer)RSU.get(item) >= minUtility && ((Float)Probability.get(item)).floatValue() >= minProbability) {
                                    Item sitem = new Item();
                                    sitem.item = item;
                                    sitem.utility = utility;
                                    sitemset.Itemset.add(sitem);
                                } else {
                                    lineSWU -= utility;
                                }
                                ++j;
                            }
                            if (!sitemset.Itemset.isEmpty()) {
                                sequnce.add(sitemset);
                            }
                            ++i;
                        }
                        if (sequnce.isEmpty()) continue;
                        revisedDatabase.add(sequnce);
                        orderSWU.put(order, lineSWU);
                        orderSWP.put(order, Float.valueOf(lineSWP));
                        ++order;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        int i = 0;
        while (i < revisedDatabase.size()) {
            int lineSWU = (Integer)orderSWU.get(i);
            float lineProbability = ((Float)orderSWP.get(i)).floatValue();
            int restUtility = lineSWU;
            int j = 0;
            while (j < ((List)revisedDatabase.get(i)).size()) {
                int k = 0;
                while (k < ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.size()) {
                    int item = ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.get((int)k).item;
                    int utility = ((Itemset)((List)revisedDatabase.get((int)i)).get((int)j)).Itemset.get((int)k).utility;
                    Element element = new Element(i, j, utility, lineProbability, restUtility -= utility);
                    if (sequenceListMap.containsKey(item)) {
                        ((SequenceList)sequenceListMap.get(item)).addElement(element);
                    } else {
                        SequenceList Seq = new SequenceList();
                        ArrayList<Integer> itemSet = new ArrayList<Integer>();
                        itemSet.add(item);
                        Seq.addItemset(itemSet);
                        Seq.addElement(element);
                        sequenceListMap.put(item, Seq);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        ArrayList oneSequenceList = new ArrayList(sequenceListMap.values());
        int i2 = 0;
        while (i2 < oneSequenceList.size()) {
            ((SequenceList)oneSequenceList.get(i2)).calculate();
            if (((SequenceList)oneSequenceList.get((int)i2)).sumSWU < minUtility || ((SequenceList)oneSequenceList.get((int)i2)).sumProbability < minProbability) {
                oneSequenceList.remove(i2);
                --i2;
            }
            ++i2;
        }
        Collections.sort(oneSequenceList, new Comparator<SequenceList>(){

            @Override
            public int compare(SequenceList mc1, SequenceList mc2) {
                return mc1.itemsets.get(0).get(0) - mc2.itemsets.get(0).get(0);
            }
        });
        for (SequenceList Seq : oneSequenceList) {
            this.AlgoPHUSPM(Seq, revisedDatabase, minUtility, minProbability);
        }
        numberOfCandidates += oneSequenceList.size();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    public void AlgoPHUSPM(SequenceList Seq, List<List<Itemset>> revisedDatabase, int minUtility, float minProbability) throws IOException {
        ++numberOfCandidates;
        if (Seq.sumUtility >= minUtility && Seq.sumProbability >= minProbability) {
            ++numberOfHUSP;
            this.writeOut(Seq);
        }
        MemoryLogger.getInstance().checkMemory();
        ArrayList<SequenceList> nextGeneration = new ArrayList<SequenceList>();
        HashMap<Integer, SequenceList> itemExtend = new HashMap<Integer, SequenceList>();
        HashMap<Integer, SequenceList> itemsetExtend = new HashMap<Integer, SequenceList>();
        for (Element element : Seq.elements) {
            int item;
            int SID = element.SID;
            int location = element.location;
            int preUtility = 0;
            int i = 0;
            i = 0;
            while (i < revisedDatabase.get((int)SID).get((int)location).Itemset.size()) {
                item = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).item;
                if (item == Seq.itemsets.get(Seq.itemsets.size() - 1).get(Seq.itemsets.get(Seq.itemsets.size() - 1).size() - 1)) {
                    ++i;
                    break;
                }
                ++i;
            }
            while (i < revisedDatabase.get((int)SID).get((int)location).Itemset.size()) {
                item = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).item;
                int utility = revisedDatabase.get((int)SID).get((int)location).Itemset.get((int)i).utility;
                Element newElement = new Element(SID, location, element.utility + utility, element.probability, element.restUtility - (preUtility += utility));
                if (!itemExtend.containsKey(item)) {
                    SequenceList newlist = new SequenceList();
                    newlist.itemsets.addAll(Seq.itemsets);
                    ArrayList<Integer> itemset2 = new ArrayList<Integer>();
                    itemset2.addAll((Collection)Seq.itemsets.get(Seq.itemsets.size() - 1));
                    itemset2.add(item);
                    newlist.itemsets.remove(newlist.itemsets.size() - 1);
                    newlist.itemsets.add(itemset2);
                    newlist.addElement(newElement);
                    itemExtend.put(item, newlist);
                } else {
                    ((SequenceList)itemExtend.get(item)).addElement(newElement);
                }
                ++i;
            }
            int j = element.location + 1;
            while (j < revisedDatabase.get(SID).size()) {
                int k = 0;
                while (k < revisedDatabase.get((int)SID).get((int)j).Itemset.size()) {
                    int item2 = revisedDatabase.get((int)SID).get((int)j).Itemset.get((int)k).item;
                    int utility = revisedDatabase.get((int)SID).get((int)j).Itemset.get((int)k).utility;
                    Element newElement = new Element(SID, j, element.utility + utility, element.probability, element.restUtility - (preUtility += utility));
                    if (!itemsetExtend.containsKey(item2)) {
                        SequenceList newlist = new SequenceList();
                        newlist.itemsets.addAll(Seq.itemsets);
                        ArrayList<Integer> itemset3 = new ArrayList<Integer>();
                        itemset3.add(item2);
                        newlist.itemsets.add(itemset3);
                        newlist.addElement(newElement);
                        itemsetExtend.put(item2, newlist);
                    } else {
                        ((SequenceList)itemsetExtend.get(item2)).addElement(newElement);
                    }
                    ++k;
                }
                ++j;
            }
        }
        for (Map.Entry entry : itemExtend.entrySet()) {
            ((SequenceList)entry.getValue()).calculate();
            if (((SequenceList)entry.getValue()).sumSWU < minUtility || !(((SequenceList)entry.getValue()).sumProbability >= minProbability)) continue;
            nextGeneration.add((SequenceList)entry.getValue());
        }
        for (Map.Entry entry : itemsetExtend.entrySet()) {
            ((SequenceList)entry.getValue()).calculate();
            if (((SequenceList)entry.getValue()).sumSWU < minUtility || !(((SequenceList)entry.getValue()).sumProbability >= minProbability)) continue;
            nextGeneration.add((SequenceList)entry.getValue());
        }
        for (SequenceList nextlist : nextGeneration) {
            this.AlgoPHUSPM(nextlist, revisedDatabase, minUtility, minProbability);
        }
    }

    private void writeOut(SequenceList sequence) throws IOException {
        for (List<Integer> items : sequence.itemsets) {
            for (int item : items) {
                this.writer.write(String.valueOf(item) + " ");
            }
            this.writer.write("-1 ");
        }
        this.writer.write("#UITL: ");
        this.writer.write(Integer.toString(sequence.sumUtility));
        this.writer.write(" #SP: ");
        this.writer.write(Float.toString(sequence.sumProbability));
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=======  THE RESULT OF THE ALGORITHM - STATS ============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) / 1000L + " s");
        System.out.println(" Candidates count: " + numberOfCandidates);
        System.out.println(" HUSPs count: " + numberOfHUSP);
        System.out.println(" Max memory: " + MemoryLogger.getInstance().getMaxMemory() + "  MB");
        System.out.println("======================================================");
    }
}

