/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.lapin;

import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.IEPositionList;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.PositionVector;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.Prefix;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.SEPositionList;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.Table;
import ca.pfv.spmf.datastructures.triangularmatrix.AbstractTriangularMatrix;
import ca.pfv.spmf.datastructures.triangularmatrix.SparseTriangularMatrix;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoLAPIN_LCI {
    private long startTime;
    private long endTime;
    private int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Table[] tables = null;
    SEPositionList[] sePositionList;
    IEPositionList[] iePositionList;
    final boolean DEBUG = false;
    SequenceDatabase seqDB = null;
    private AbstractTriangularMatrix matrixPairCount;
    String input;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        this.input = input;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.lapin(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void lapin(String input, double minsupRel) throws IOException {
        String thisLine;
        BufferedReader reader;
        int sequenceCount = 0;
        int largestItemID = 0;
        HashMap mapItemFirstOccurrences = new HashMap();
        try {
            String thisLine2;
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine2 = reader2.readLine()) != null) {
                if (thisLine2.charAt(0) == '#' || thisLine2.charAt(0) == '%' || thisLine2.charAt(0) == '@') continue;
                HashSet itemsAlreadySeen = new HashSet();
                short itemsetID = 0;
                String[] stringArray = thisLine2.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer item;
                    String integer = stringArray[n2];
                    if ("-1".equals(integer)) {
                        itemsetID = (short)(itemsetID + 1);
                    } else if (!"-2".equals(integer) && !itemsAlreadySeen.contains(item = Integer.valueOf(integer))) {
                        ArrayList<Position> list = (ArrayList<Position>)mapItemFirstOccurrences.get(item);
                        if (list == null) {
                            list = new ArrayList<Position>();
                            mapItemFirstOccurrences.put(item, list);
                        }
                        Position position = new Position(sequenceCount, itemsetID);
                        list.add(position);
                        itemsAlreadySeen.add(item);
                        if (item > largestItemID) {
                            largestItemID = item;
                        }
                    }
                    ++n2;
                }
                ++sequenceCount;
            }
            reader2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tables = new Table[sequenceCount];
        this.minsup = (int)Math.ceil(minsupRel * (double)sequenceCount);
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemFirstOccurrences.entrySet()) {
            List itemBorder = (List)entry.getValue();
            if (itemBorder.size() < this.minsup) continue;
            Integer item = (Integer)entry.getKey();
            this.savePattern(item, itemBorder.size());
            frequentItems.add(item);
        }
        Collections.sort(frequentItems);
        this.matrixPairCount = new SparseTriangularMatrix(largestItemID + 1);
        this.sePositionList = new SEPositionList[sequenceCount];
        this.iePositionList = new IEPositionList[sequenceCount];
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int currentSequenceID = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                SparseTriangularMatrix matrixPairLastSeenInSID = new SparseTriangularMatrix(largestItemID + 1);
                int positionCount = -1;
                char[] list = thisLine.toCharArray();
                int item = list.length;
                int n = 0;
                while (n < item) {
                    char caracter = list[n];
                    if (caracter == '-') {
                        ++positionCount;
                    }
                    ++n;
                }
                HashSet<Integer> itemsAlreadySeen = new HashSet<Integer>();
                Table table = new Table();
                BitSet currentBitset = new BitSet(mapItemFirstOccurrences.size());
                boolean seenNewItem = false;
                String[] tokens = thisLine.split(" ");
                int currentPosition = positionCount;
                ArrayList<Integer> currentItemset = new ArrayList<Integer>();
                int i = tokens.length - 1;
                while (i >= 0) {
                    Integer item2;
                    String token = tokens[i];
                    if ("-1".equals(token)) {
                        int k = 0;
                        while (k < currentItemset.size()) {
                            Integer item1 = (Integer)currentItemset.get(k);
                            int m = k + 1;
                            while (m < currentItemset.size()) {
                                Integer item22 = (Integer)currentItemset.get(m);
                                int sid = matrixPairLastSeenInSID.getSupportForItems(item1, item22);
                                if (sid != currentSequenceID + 1) {
                                    this.matrixPairCount.incrementCount(item1, item22);
                                    matrixPairLastSeenInSID.setSupport(item1, item22, currentSequenceID + 1);
                                }
                                ++m;
                            }
                            ++k;
                        }
                        currentItemset.clear();
                        --currentPosition;
                        if (seenNewItem) {
                            PositionVector vector = new PositionVector(currentPosition, (BitSet)currentBitset.clone());
                            table.add(vector);
                        }
                    } else if (!"-2".equals(token) && ((List)mapItemFirstOccurrences.get(item2 = Integer.valueOf(token))).size() >= this.minsup) {
                        if (!itemsAlreadySeen.contains(item2)) {
                            seenNewItem = true;
                            itemsAlreadySeen.add(item2);
                            currentBitset.set(item2);
                        }
                        currentItemset.add(item2);
                    }
                    --i;
                }
                int k = 0;
                while (k < currentItemset.size()) {
                    Integer item1 = (Integer)currentItemset.get(k);
                    int m = k + 1;
                    while (m < currentItemset.size()) {
                        Integer item2 = (Integer)currentItemset.get(m);
                        int sid = matrixPairLastSeenInSID.getSupportForItems(item1, item2);
                        if (sid != currentSequenceID + 1) {
                            this.matrixPairCount.incrementCount(item1, item2);
                            matrixPairLastSeenInSID.setSupport(item1, item2, currentSequenceID + 1);
                        }
                        ++m;
                    }
                    ++k;
                }
                if (seenNewItem) {
                    PositionVector vector = new PositionVector(-1, (BitSet)currentBitset.clone());
                    table.add(vector);
                }
                this.sePositionList[currentSequenceID] = new SEPositionList(itemsAlreadySeen);
                this.iePositionList[currentSequenceID] = new IEPositionList();
                this.tables[currentSequenceID] = table;
                ++currentSequenceID;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int currentSequenceID = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                String[] tokens = thisLine.split(" ");
                ArrayList<Integer> currentItemset = new ArrayList<Integer>();
                short itemsetID = 0;
                currentItemset.clear();
                int i = 0;
                while (i < tokens.length) {
                    Integer item;
                    String token = tokens[i];
                    if ("-1".equals(token)) {
                        if (currentItemset.size() > 1) {
                            int k = 0;
                            while (k < currentItemset.size()) {
                                Integer item1 = (Integer)currentItemset.get(k);
                                int m = k + 1;
                                while (m < currentItemset.size()) {
                                    Integer item2 = (Integer)currentItemset.get(m);
                                    int support = this.matrixPairCount.getSupportForItems(item1, item2);
                                    if (support >= this.minsup) {
                                        this.iePositionList[currentSequenceID].register(item1, item2, itemsetID);
                                    }
                                    ++m;
                                }
                                ++k;
                            }
                        }
                        itemsetID = (short)(itemsetID + 1);
                        currentItemset.clear();
                    } else if (!"-2".equals(token) && ((List)mapItemFirstOccurrences.get(item = Integer.valueOf(token))).size() >= this.minsup) {
                        this.sePositionList[currentSequenceID].register(item, itemsetID);
                        currentItemset.add(item);
                    }
                    ++i;
                }
                this.iePositionList[currentSequenceID].sort();
                ++currentSequenceID;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < frequentItems.size()) {
            int item1 = (Integer)frequentItems.get(i);
            List item1Border = (List)mapItemFirstOccurrences.get(item1);
            if (item1Border.size() >= this.minsup) {
                Prefix prefix = new Prefix();
                ArrayList<Integer> itemset2 = new ArrayList<Integer>(1);
                itemset2.add(item1);
                prefix.itemsets.add(itemset2);
                this.genPatterns(prefix, item1Border, frequentItems, frequentItems, item1, true);
            }
            int k = i + 1;
            while (k < frequentItems.size()) {
                int item2 = (Integer)frequentItems.get(k);
                int support = this.matrixPairCount.getSupportForItems(item1, item2);
                if (support >= this.minsup) {
                    List item2Border = (List)mapItemFirstOccurrences.get(item2);
                    ArrayList<Position> ie12Border = new ArrayList<Position>();
                    List borderToUse = item2Border.size() < item1Border.size() ? item2Border : item1Border;
                    block22: for (Position sequenceToUse : borderToUse) {
                        int sid = sequenceToUse.sid;
                        List<Short> listPosition1 = this.sePositionList[sid].getListForItem(item1);
                        List<Short> listPosition2 = this.sePositionList[sid].getListForItem(item2);
                        if (listPosition1 == null || listPosition2 == null) continue;
                        int index1 = 0;
                        int index2 = 0;
                        while (index1 < listPosition1.size() && index2 < listPosition2.size()) {
                            short position2;
                            short position1 = listPosition1.get(index1);
                            if (position1 < (position2 = listPosition2.get(index2).shortValue())) {
                                ++index1;
                                continue;
                            }
                            if (position1 > position2) {
                                ++index2;
                                continue;
                            }
                            ie12Border.add(new Position(sid, position1));
                            continue block22;
                        }
                    }
                    Prefix prefix = new Prefix();
                    ArrayList<Integer> itemset3 = new ArrayList<Integer>(2);
                    itemset3.add(item1);
                    itemset3.add(item2);
                    prefix.itemsets.add(itemset3);
                    this.savePattern(prefix, support);
                    this.genPatterns(prefix, ie12Border, frequentItems, frequentItems, item2, false);
                }
                ++k;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
    }

    private void genPatterns(Prefix prefix, List<Position> prefixBorder, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, boolean doNotPerformIExtensions) throws IOException {
        int index;
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Integer> sTempSupport = new ArrayList<Integer>();
        for (Integer item : sn) {
            int support = this.calculateSupportSStep(item, prefixBorder);
            if (support < this.minsup) continue;
            sTemp.add(item);
            sTempSupport.add(support);
        }
        int k = 0;
        while (k < sTemp.size()) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            ArrayList<Integer> itemset2 = new ArrayList<Integer>(1);
            itemset2.add(item);
            prefixSStep.itemsets.add(itemset2);
            this.savePattern(prefixSStep, (int)((Integer)sTempSupport.get(k)));
            List<Position> newBorder = this.recalculateBorderForSExtension(prefixBorder, item);
            this.genPatterns(prefixSStep, newBorder, sTemp, sTemp, item, false);
            ++k;
        }
        if (doNotPerformIExtensions) {
            return;
        }
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<List<Position>> iTempBorder = new ArrayList<List<Position>>();
        int i = index = Collections.binarySearch(in, hasToBeGreaterThanForIStep);
        while (i < in.size()) {
            List<Position> newBorder;
            Integer item = in.get(i);
            List<Integer> lastItemset = prefix.itemsets.get(prefix.itemsets.size() - 1);
            boolean willAddSecondItem = lastItemset.size() == 1;
            int support = this.estimateSupportIStep(item, prefixBorder);
            if (support >= this.minsup && (newBorder = this.recalculateBorderForIExtension(lastItemset, prefixBorder, hasToBeGreaterThanForIStep, item, willAddSecondItem)).size() >= this.minsup) {
                iTemp.add(item);
                iTempBorder.add(newBorder);
            }
            ++i;
        }
        int k2 = 0;
        while (k2 < iTemp.size()) {
            int item = (Integer)iTemp.get(k2);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.itemsets.get(prefixIStep.size() - 1).add(item);
            List newBorder = (List)iTempBorder.get(k2);
            this.savePattern(prefixIStep, newBorder.size());
            this.genPatterns(prefixIStep, newBorder, sTemp, iTemp, item, false);
            ++k2;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private List<Position> recalculateBorderForIExtension(List<Integer> prefixLastItemset, List<Position> prefixBorder, int item1, int item2, boolean willAddSecondItem) {
        ArrayList<Position> newBorder = new ArrayList<Position>();
        block0: for (Position previousPosition : prefixBorder) {
            int sid = previousPosition.sid;
            short previousItemsetID = previousPosition.position;
            IEPositionList positionLists = this.iePositionList[sid];
            List<Short> listPositions = positionLists.getListForPair(item1, item2);
            if (listPositions == null) continue;
            block1: for (short pos : listPositions) {
                if (pos < previousItemsetID) continue;
                if (!willAddSecondItem) {
                    SEPositionList plists = this.sePositionList[sid];
                    int i = 0;
                    while (i < prefixLastItemset.size() - 1) {
                        Integer itemX = prefixLastItemset.get(i);
                        List<Short> plistX = plists.getListForItem(itemX);
                        int index = Collections.binarySearch(plistX, pos);
                        if (index < 0) continue block1;
                        ++i;
                    }
                }
                Position newPosition = new Position(sid, pos);
                newBorder.add(newPosition);
                continue block0;
            }
        }
        return newBorder;
    }

    private int estimateSupportIStep(Integer item, List<Position> itemBorder) {
        int support = 0;
        block0: for (Position pos : itemBorder) {
            Table table = this.tables[pos.sid];
            int numberOfVectors = table.positionVectors.size();
            int j = 0;
            while (j < numberOfVectors) {
                PositionVector vector = table.positionVectors.get(j);
                if (vector.position < pos.position) {
                    if (!vector.bitset.get(item)) continue block0;
                    ++support;
                    continue block0;
                }
                ++j;
            }
        }
        return support;
    }

    private int calculateSupportSStep(Integer item, List<Position> itemBorder) {
        int support = 0;
        block0: for (Position pos : itemBorder) {
            Table table = this.tables[pos.sid];
            int numberOfVectors = table.positionVectors.size();
            int j = numberOfVectors - 2;
            while (j >= 0) {
                PositionVector vector = table.positionVectors.get(j);
                if (vector.position >= pos.position) {
                    if (!vector.bitset.get(item)) continue block0;
                    ++support;
                    continue block0;
                }
                --j;
            }
        }
        return support;
    }

    private List<Position> recalculateBorderForSExtension(List<Position> prefixBorder, int item) {
        ArrayList<Position> newBorder = new ArrayList<Position>();
        block0: for (Position previousPosition : prefixBorder) {
            int sid = previousPosition.sid;
            short previousItemsetID = previousPosition.position;
            SEPositionList positionLists = this.sePositionList[sid];
            List<Short> listPositions = positionLists.getListForItem(item);
            if (listPositions == null) continue;
            for (short pos : listPositions) {
                if (pos <= previousItemsetID) continue;
                Position newPosition = new Position(sid, pos);
                newBorder.add(newPosition);
                continue block0;
            }
        }
        return newBorder;
    }

    private void savePattern(Integer item, int support) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        r.append(item);
        r.append(" -1 ");
        r.append("#SUP: ");
        r.append(support);
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, int support) throws IOException {
        ++this.patternCount;
        StringBuilder r = new StringBuilder("");
        for (List<Integer> itemset2 : prefix.itemsets) {
            for (Integer item : itemset2) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("#SUP: ");
        r.append(support);
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  LAPIN - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================");
        System.out.println(r.toString());
    }

    class Position {
        int sid;
        short position;

        public Position(int sid, short position) {
            this.sid = sid;
            this.position = position;
        }
    }
}

