/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sequences {
    public List<List<Pattern>> levels = new ArrayList<List<Pattern>>();
    public int numberOfFrequentSequences = 0;
    private String string;

    public Sequences(String string) {
        this.levels.add(new ArrayList());
        this.string = string;
    }

    public void printFrequentSequences() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.string);
        int levelCount = 0;
        for (List<Pattern> level : this.levels) {
            sb.append("\n***Level ").append(levelCount).append("***\n\n");
            for (Pattern sequence : level) {
                sb.append(sequence.toString());
                sb.append('\n');
            }
            ++levelCount;
        }
        return sb.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        StringBuilder sb = new StringBuilder();
        int levelCount = 0;
        for (List<Pattern> level : this.levels) {
            for (Pattern sequence : level) {
                sb.append(sequence.toStringToFile(outputSequenceIdentifiers));
                sb.append('\n');
            }
            ++levelCount;
        }
        return sb.toString();
    }

    public void addSequence(Pattern sequence, int levelIndex) {
        while (this.levels.size() <= levelIndex) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(levelIndex).add(sequence);
        ++this.numberOfFrequentSequences;
    }

    public void addSequences(List<Pattern> sequences, int levelIndex) {
        for (Pattern pattern : sequences) {
            this.addSequence(pattern, levelIndex);
        }
    }

    public List<Pattern> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size() - 1;
    }

    public List<List<Pattern>> getLevels() {
        return this.levels;
    }

    public int size() {
        return this.numberOfFrequentSequences;
    }

    public void sort() {
        for (List<Pattern> level : this.levels) {
            Collections.sort(level);
        }
    }

    public void delete(int i) {
        this.numberOfFrequentSequences -= this.levels.get(i).size();
        this.levels.get(i).clear();
    }

    public void clear() {
        for (List<Pattern> level : this.levels) {
            level.clear();
        }
        this.levels.clear();
        this.levels = null;
        this.numberOfFrequentSequences = 0;
    }
}

