/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Itemset;
import java.util.ArrayList;
import java.util.List;

public class Sequence {
    private int numberOfItems = 0;
    private final List<Itemset> itemsets = new ArrayList<Itemset>();
    private int id;

    public Sequence(int id) {
        this.id = id;
    }

    public void addItemset(Itemset itemset2) {
        this.itemsets.add(itemset2);
        this.numberOfItems += itemset2.size();
    }

    public void addItem(Item item) {
        this.itemsets.get(this.size() - 1).addItem(item);
        ++this.numberOfItems;
    }

    public void addItem(int indexItemset, Item item) {
        this.itemsets.get(indexItemset).addItem(item);
        ++this.numberOfItems;
    }

    public void addItem(int indexItemset, int indexItem, Item item) {
        this.itemsets.get(indexItemset).addItem(indexItem, item);
        ++this.numberOfItems;
    }

    public Itemset remove(int indexItemset) {
        Itemset itemset2 = this.itemsets.remove(indexItemset);
        this.numberOfItems -= itemset2.size();
        return itemset2;
    }

    public Item remove(int indexItemset, int indexItem) {
        --this.numberOfItems;
        return this.itemsets.get(indexItemset).removeItem(indexItem);
    }

    public void remove(int indexItemset, Item item) {
        this.itemsets.get(indexItemset).removeItem(item);
        --this.numberOfItems;
    }

    public Sequence cloneSequence() {
        Sequence sequence = new Sequence(this.getId());
        for (Itemset itemset2 : this.itemsets) {
            sequence.addItemset(itemset2.cloneItemset());
        }
        return sequence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (Itemset itemset2 : this.itemsets) {
            sb.append("{t=");
            sb.append(itemset2.getTimestamp());
            sb.append(", ");
            for (Item item : itemset2.getItems()) {
                String string = item.toString();
                sb.append(string);
                sb.append(' ');
            }
            sb.append('}');
        }
        return sb.append("    ").toString();
    }

    public int getId() {
        return this.id;
    }

    void setId(Integer integer) {
        this.id = integer;
    }

    public List<Itemset> getItemsets() {
        return this.itemsets;
    }

    public Itemset get(int index) {
        return this.itemsets.get(index);
    }

    public int size() {
        return this.itemsets.size();
    }

    public int getLength() {
        return this.numberOfItems;
    }

    public long getTimeLength() {
        return this.itemsets.get(this.itemsets.size() - 1).getTimestamp() - this.itemsets.get(0).getTimestamp();
    }

    public int[] searchForTheFirstAppearance(int itemsetIndex, int itemIndex, Item item) {
        if (itemsetIndex < this.size()) {
            int i = itemsetIndex;
            while (i < this.itemsets.size()) {
                Itemset currentItemset = this.itemsets.get(i);
                int beginning = i == itemsetIndex ? itemIndex : 0;
                int pos = currentItemset.binarySearch(item);
                if (pos >= beginning) {
                    return new int[]{i, pos};
                }
                ++i;
            }
        }
        return null;
    }

    public int[] SearchForItemAtTheSameItemset(Item item, int itemsetIndex, int itemIndex) {
        Itemset currentItemset;
        int pos;
        if (itemsetIndex < this.size() && (pos = (currentItemset = this.itemsets.get(itemsetIndex)).binarySearch(item)) >= itemIndex) {
            return new int[]{itemsetIndex, pos};
        }
        return null;
    }

    public int[] searchForItemInAConcreteTemporalDistance(Item item, int itemsetIndex, int itemIndex, long temporalDistance) {
        if (itemsetIndex < this.size()) {
            Itemset currentItemset;
            int pos;
            long initialTimestamp = this.itemsets.get(itemsetIndex).getTimestamp();
            long objectiveTimestamp = initialTimestamp + temporalDistance;
            int itemset2 = itemsetIndex + 1;
            while (itemset2 < this.itemsets.size() && this.itemsets.get(itemset2).getTimestamp() < objectiveTimestamp) {
                ++itemset2;
            }
            if (itemset2 < this.itemsets.size() && this.itemsets.get(itemset2).getTimestamp() == objectiveTimestamp && (pos = (currentItemset = this.itemsets.get(itemset2)).binarySearch(item)) >= 0) {
                return new int[]{itemset2, pos};
            }
        }
        return null;
    }

    public int numberOfItemsAfterPositionIth(int itemsetIndex, int itemIndex) {
        int size = 0;
        if (itemsetIndex < this.itemsets.size() - 1) {
            int currentItemset;
            int i = currentItemset = itemsetIndex + 1;
            while (i < this.itemsets.size()) {
                size += this.itemsets.get(currentItemset).size();
                ++i;
            }
        }
        return size += this.itemsets.get(itemsetIndex).size() - itemIndex - 1;
    }
}

