/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp;

import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.AlgoGoKrimp;
import ca.pfv.spmf.algorithms.sequentialpatterns.goKrimp.Event;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class DataReader {
    AlgoGoKrimp readData(String databasename, String labelfilename) {
        AlgoGoKrimp gk = new AlgoGoKrimp();
        gk.labels = this.readLabel(labelfilename);
        gk.data = new ArrayList();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(databasename);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int size = 0;
            while ((strLine = br.readLine()) != null) {
                if (strLine.charAt(0) == '#' || strLine.charAt(0) == '%' || strLine.charAt(0) == '@') continue;
                String delimiter = " ";
                String[] temp = strLine.split(delimiter);
                ArrayList s = new ArrayList();
                gk.data.add(s);
                int ts = 0;
                int prev = 0;
                ++size;
                int i = 0;
                while (i < temp.length) {
                    Event e = new Event();
                    e.id = Integer.parseInt(temp[i]);
                    e.ts = ts;
                    e.gap = ts - prev;
                    prev = ts++;
                    gk.data.get(gk.data.size() - 1).add(e);
                    ++i;
                }
            }
            System.err.println("data size:" + size);
            in.close();
        }
        catch (IOException e) {
            System.err.println("Error: " + e.getMessage());
        }
        return gk;
    }

    public AlgoGoKrimp readData_SPMF(String databasename, String labelfilename) throws IOException {
        String strLine;
        AlgoGoKrimp gk = new AlgoGoKrimp();
        gk.labels = this.readLabel(labelfilename);
        gk.data = new ArrayList();
        FileInputStream fstream = new FileInputStream(databasename);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            if (strLine.isEmpty() || strLine.charAt(0) == '#' || strLine.charAt(0) == '%' || strLine.charAt(0) == '@') continue;
            String delimiter = " ";
            String[] temp = strLine.split(delimiter);
            ArrayList s = new ArrayList();
            gk.data.add(s);
            int ts = 0;
            int prev = 0;
            int i = 0;
            while (i < temp.length) {
                if (!temp[i].contains("-")) {
                    Event e = new Event();
                    e.id = gk.labels.isEmpty() ? Integer.parseInt(temp[i]) : Integer.parseInt(temp[i]) - 1;
                    e.ts = ts;
                    e.gap = ts - prev;
                    prev = ts++;
                    gk.data.get(gk.data.size() - 1).add(e);
                }
                ++i;
            }
        }
        in.close();
        return gk;
    }

    HashMap<Integer, String> readLabel(String dataname) {
        HashMap<Integer, String> labels = new HashMap<Integer, String>();
        File file = new File(dataname);
        if (!file.exists()) {
            return labels;
        }
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(dataname);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int k = 0;
            while ((strLine = br.readLine()) != null) {
                if (strLine.charAt(0) == '#' || strLine.charAt(0) == '%' || strLine.charAt(0) == '@') continue;
                labels.put(k, strLine);
                ++k;
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println("Warning: " + e.getMessage());
        }
        return labels;
    }
}

