/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.MDPattern;
import java.util.ArrayList;
import java.util.List;

public class MDPatternsDatabase {
    private final List<MDPattern> patterns = new ArrayList<MDPattern>();
    private int[] valuesCountForDimension = null;

    public void addMDPattern(MDPattern pattern) {
        this.patterns.add(pattern);
        if (this.valuesCountForDimension == null) {
            this.valuesCountForDimension = new int[pattern.size()];
        } else {
            int i = 0;
            while (i < pattern.size()) {
                int value = pattern.get(i);
                if (value > this.valuesCountForDimension[i] && value != 9999) {
                    this.valuesCountForDimension[i] = value;
                }
                ++i;
            }
        }
    }

    public void printDatabase() {
        System.out.println("============  MDPatterns Context ==========");
        System.out.println("Dimensions count : " + this.getDimensionCount());
        System.out.print("Number of value for each dimension  : ");
        int[] nArray = this.valuesCountForDimension;
        int n = this.valuesCountForDimension.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            System.out.print(" " + j + " ");
            ++n2;
        }
        System.out.println();
        for (MDPattern pattern : this.patterns) {
            System.out.print(String.valueOf(pattern.getId()) + ":  ");
            pattern.print();
            System.out.println("");
        }
    }

    public int size() {
        return this.patterns.size();
    }

    public List<MDPattern> getMDPatterns() {
        return this.patterns;
    }

    public int getDimensionCount() {
        return this.valuesCountForDimension.length;
    }
}

