/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import java.util.ArrayList;
import java.util.List;

public class Sequences {
    final List<List<Sequence>> levels = new ArrayList<List<Sequence>>();
    int sequenceCount = 0;
    private final String name;

    public Sequences(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printSequentialPatterns(int databaseSize) {
        System.out.println(this.toString(databaseSize));
    }

    public String toString(int databaseSize) {
        StringBuilder r = new StringBuilder(200);
        r.append(" ----------");
        r.append(this.name);
        r.append(" -------\n");
        int levelCount = 0;
        for (List<Sequence> level : this.levels) {
            r.append("  L");
            r.append(levelCount);
            r.append(" \n");
            for (Sequence sequence : level) {
                r.append("  pattern ");
                r.append(sequence.getId());
                r.append(":  ");
                r.append(sequence.toString());
                r.append("support :  ");
                r.append(sequence.getRelativeSupportFormated(databaseSize));
                r.append(" (");
                r.append(sequence.getAbsoluteSupport());
                r.append('/');
                r.append(databaseSize);
                r.append(") \n");
            }
            ++levelCount;
        }
        r.append(" -------------------------------- Patterns count : ");
        r.append(this.sequenceCount);
        return r.toString();
    }

    void addSequence(Sequence sequence, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(sequence);
        ++this.sequenceCount;
    }

    public List<Sequence> getLevel(int index) {
        return this.levels.get(index);
    }

    public int getLevelCount() {
        return this.levels.size();
    }

    public List<List<Sequence>> getLevels() {
        return this.levels;
    }
}

