/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim;

import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AbstractAlgoPrefixSpan;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.ItemSimple;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Pair;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.PseudoSequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.Sequences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoPrefixSpanMDSPM
extends AbstractAlgoPrefixSpan {
    private Sequences patterns = null;
    private long startTime;
    private long endTime;
    private final double minsup;
    private int minsuppRelative;

    public AlgoPrefixSpanMDSPM(double minsup) {
        this.minsup = minsup;
    }

    @Override
    public double getMinSupp() {
        return this.minsup;
    }

    @Override
    public Sequences runAlgorithm(SequenceDatabase database) {
        this.patterns = new Sequences("FREQUENT SEQUENTIAL PATTERNS");
        this.minsuppRelative = (int)Math.ceil(this.minsup * (double)database.size());
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.startTime = System.currentTimeMillis();
        this.prefixSpan(database);
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void prefixSpan(SequenceDatabase database) {
        Map<ItemSimple, Set<Integer>> mapSequenceID = this.calculateSupportOfItems(database);
        PseudoSequenceDatabase initialDatabase = new PseudoSequenceDatabase();
        for (Sequence sequence : database.getSequences()) {
            Sequence optimizedSequence = sequence.cloneSequenceMinusItems(mapSequenceID, this.minsuppRelative);
            if (optimizedSequence.size() == 0) continue;
            initialDatabase.addSequence(new PseudoSequence(0L, optimizedSequence, 0, 0));
        }
        for (Map.Entry entry : mapSequenceID.entrySet()) {
            if (((Set)entry.getValue()).size() < this.minsuppRelative) continue;
            ItemSimple item = (ItemSimple)entry.getKey();
            PseudoSequenceDatabase projectedDatabase = this.buildProjectedContext(item, initialDatabase, false);
            Sequence prefix = new Sequence(0);
            prefix.addItemset(new Itemset(item, 0L));
            prefix.setSequencesID((Set)entry.getValue());
            this.patterns.addSequence(prefix, 1);
            this.recursion(prefix, 2, projectedDatabase);
        }
    }

    private Map<ItemSimple, Set<Integer>> calculateSupportOfItems(SequenceDatabase database) {
        HashSet<Integer> alreadyCounted = new HashSet<Integer>();
        Sequence lastSequence = null;
        HashMap<ItemSimple, Set<Integer>> mapSequenceID = new HashMap<ItemSimple, Set<Integer>>();
        for (Sequence sequence : database.getSequences()) {
            if (lastSequence == null || lastSequence.getId() != sequence.getId()) {
                alreadyCounted.clear();
                lastSequence = sequence;
            }
            for (Itemset itemset2 : sequence.getItemsets()) {
                for (ItemSimple item : itemset2.getItems()) {
                    if (alreadyCounted.contains(item.getId())) continue;
                    HashSet<Integer> sequenceIDs = (HashSet<Integer>)mapSequenceID.get(item);
                    if (sequenceIDs == null) {
                        sequenceIDs = new HashSet<Integer>();
                        mapSequenceID.put(item, sequenceIDs);
                    }
                    sequenceIDs.add(sequence.getId());
                    alreadyCounted.add(item.getId());
                }
            }
        }
        return mapSequenceID;
    }

    private PseudoSequenceDatabase buildProjectedContext(ItemSimple item, PseudoSequenceDatabase database, boolean inSuffix) {
        PseudoSequenceDatabase sequenceDatabase = new PseudoSequenceDatabase();
        for (PseudoSequence sequence : database.getPseudoSequences()) {
            int i = 0;
            while (i < sequence.size()) {
                int index = sequence.indexOf(i, item.getId());
                if (index != -1 && sequence.isCutAtLeft(i) == inSuffix) {
                    PseudoSequence newSequence;
                    if (index != sequence.getSizeOfItemsetAt(i) - 1) {
                        newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i, index + 1);
                        if (newSequence.size() > 0) {
                            sequenceDatabase.addSequence(newSequence);
                        }
                    } else if (i != sequence.size() - 1 && (newSequence = new PseudoSequence(sequence.getAbsoluteTimeStamp(i), sequence, i + 1, 0)).size() > 0) {
                        sequenceDatabase.addSequence(newSequence);
                    }
                }
                ++i;
            }
        }
        return sequenceDatabase;
    }

    private void recursion(Sequence prefix, int k, PseudoSequenceDatabase database) {
        Set<Pair> pairs = this.findAlllPairsAndCountTheirSupport(database.getPseudoSequences());
        for (Pair paire : pairs) {
            if (paire.getCount() < this.minsuppRelative) continue;
            Sequence newPrefix = paire.isPostfix() ? this.appendItemToPrefixOfSequence(prefix, paire.getItem()) : this.appendItemToSequence(prefix, paire.getItem(), paire.getTimestamp());
            PseudoSequenceDatabase projectedContext = this.buildProjectedContext(paire.getItem(), database, paire.isPostfix());
            Sequence prefix2 = newPrefix.cloneSequence();
            prefix2.setSequencesID(paire.getSequencesID());
            this.patterns.addSequence(prefix2, prefix2.size());
            this.recursion(prefix2, k + 1, projectedContext);
        }
    }

    protected Set<Pair> findAlllPairsAndCountTheirSupport(List<PseudoSequence> sequences) {
        HashMap<Pair, Pair> mapPairs = new HashMap<Pair, Pair>();
        PseudoSequence lastSequence = null;
        HashSet<Pair> alreadyCountedForSequenceID = new HashSet<Pair>();
        for (PseudoSequence sequence : sequences) {
            if (sequence != lastSequence) {
                alreadyCountedForSequenceID.clear();
                lastSequence = sequence;
            }
            int i = 0;
            while (i < sequence.size()) {
                int j = 0;
                while (j < sequence.getSizeOfItemsetAt(i)) {
                    ItemSimple item = sequence.getItemAtInItemsetAt(j, i);
                    Pair pair = new Pair(false, sequence.isCutAtLeft(i), item);
                    if (!alreadyCountedForSequenceID.contains(pair)) {
                        Pair oldPair = (Pair)mapPairs.get(pair);
                        if (oldPair == null) {
                            mapPairs.put(pair, pair);
                        } else {
                            pair = oldPair;
                        }
                        alreadyCountedForSequenceID.add(pair);
                        pair.getSequencesID().add(sequence.getId());
                    }
                    ++j;
                }
                ++i;
            }
        }
        return mapPairs.keySet();
    }

    private Sequence appendItemToSequence(Sequence prefix, ItemSimple item, long timestamp) {
        Sequence newPrefix = prefix.cloneSequence();
        newPrefix.addItemset(new Itemset(item, 0L));
        return newPrefix;
    }

    private Sequence appendItemToPrefixOfSequence(Sequence prefix, ItemSimple item) {
        Sequence newPrefix = prefix.cloneSequence();
        Itemset itemset2 = newPrefix.get(newPrefix.size() - 1);
        itemset2.addItem(item);
        return newPrefix;
    }

    public void printStatistics(int databaseSize) {
        StringBuilder r = new StringBuilder(200);
        r.append("=============  PREFIXSPAN - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : ");
        r.append(this.patterns.sequenceCount);
        r.append('\n');
        r.append(this.patterns.toString(databaseSize));
        r.append("===================================================\n");
        System.out.println(r.toString());
    }
}

