/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.cost;

import ca.pfv.spmf.algorithms.sequentialpatterns.cost.CostUtilityPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.DataMapper;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.EventSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SequentialPattern
implements Comparable<SequentialPattern> {
    private final List<EventSet> eventsets = new ArrayList<EventSet>();
    private Map<Integer, Integer> sequencesIdCost;
    private List<Integer> sequenceIDS;
    private double averageCost;
    private double occupancy;
    private double correlation;
    private double tradeOff;
    private double utility;
    private int numInPositive;
    private int numInNegative;
    private double averageCostInPos;
    private double averageCostInNeg;
    private ArrayList<CostUtilityPair> costUtilityPairs;

    public double getAverageCostInPos() {
        return this.averageCostInPos;
    }

    public void setAverageCostInPos(double averageCostInPos) {
        this.averageCostInPos = averageCostInPos;
    }

    public double getAverageCostInNeg() {
        return this.averageCostInNeg;
    }

    public void setAverageCostInNeg(double averageCostInNeg) {
        this.averageCostInNeg = averageCostInNeg;
    }

    public int getNumInPositive() {
        return this.numInPositive;
    }

    public void setNumInPositive(int numInPositive) {
        this.numInPositive = numInPositive;
    }

    public int getNumInNegative() {
        return this.numInNegative;
    }

    public void setNumInNegative(int numInNegative) {
        this.numInNegative = numInNegative;
    }

    public double getUtility() {
        return this.utility;
    }

    public void setUtility(double utility) {
        this.utility = utility;
    }

    public double getTradeOff() {
        return this.tradeOff;
    }

    public void setTradeOff(double tradeOff) {
        this.tradeOff = tradeOff;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(double correlation) {
        this.correlation = correlation;
    }

    public double getAverageCost() {
        return this.averageCost;
    }

    public void setAverageCost(double averageCost) {
        this.averageCost = averageCost;
    }

    public double getOccupancy() {
        return this.occupancy;
    }

    public void setOccupancy(double occupancy) {
        this.occupancy = occupancy;
    }

    public void setSequencesIdCost(Map<Integer, Integer> sequencesIdCost) {
        this.sequencesIdCost = sequencesIdCost;
    }

    public void setSequencesIDs(List<Integer> sequenceIDS) {
        this.sequenceIDS = sequenceIDS;
    }

    public List<Integer> getSequencesIDs() {
        return this.sequenceIDS;
    }

    public void addEventset(EventSet eventSet) {
        this.eventsets.add(eventSet);
    }

    public ArrayList<CostUtilityPair> getCostUtilityPairs() {
        return this.costUtilityPairs;
    }

    public void setCostUtilityPairs(ArrayList<CostUtilityPair> costUtilityPairs) {
        this.costUtilityPairs = costUtilityPairs;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String eventSetstoString() {
        StringBuilder r = new StringBuilder();
        for (EventSet eventset : this.eventsets) {
            for (Integer event : eventset.getEvents()) {
                String string = DataMapper.getKey(event);
                r.append(string);
            }
            r.append(" -1 ");
        }
        return r.append("-2").toString();
    }

    public String getRelativeSupportFormated(int sequencecount) {
        double relSupport = (double)this.sequencesIdCost.size() / (double)sequencecount;
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(5);
        return format.format(relSupport);
    }

    public int getAbsoluteSupport() {
        return this.sequenceIDS.size();
    }

    public Map<Integer, Integer> getSequenceIdCost() {
        return this.sequencesIdCost;
    }

    @Override
    public int compareTo(SequentialPattern arg0) {
        return 0;
    }
}

