/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.cost;

import ca.pfv.spmf.algorithms.sequentialpatterns.cost.DataMapper;
import ca.pfv.spmf.algorithms.sequentialpatterns.cost.Event;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceDatabase {
    List<Event[]> sequences = new ArrayList<Event[]>();
    Map<Integer, Double> sequenceIdUtility = new HashMap<Integer, Double>();
    long eventOccurrenceCount = 0L;

    public void loadFile(String path) throws IOException {
        this.eventOccurrenceCount = 0L;
        this.sequences = new ArrayList<Event[]>();
        try (BufferedReader myInput = null;){
            try {
                String thisLine;
                FileInputStream fin = new FileInputStream(new File(path));
                myInput = new BufferedReader(new InputStreamReader(fin));
                int lineNumber = 0;
                while ((thisLine = myInput.readLine()) != null) {
                    if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                    String[] tokens = thisLine.split(" ");
                    Event[] sequence = new Event[tokens.length - 1];
                    String sequenceUtilityString = tokens[tokens.length - 1];
                    int positionColons = sequenceUtilityString.indexOf(58);
                    Double sequenceUtility = Double.parseDouble(sequenceUtilityString.substring(positionColons + 1));
                    if (this.sequenceIdUtility.get(lineNumber) == null) {
                        this.sequenceIdUtility.put(lineNumber, sequenceUtility);
                        ++lineNumber;
                    }
                    int i = 0;
                    while (i < tokens.length - 1) {
                        String currentToken = tokens[i].trim();
                        if (currentToken.length() != 0 && currentToken.charAt(0) != '-') {
                            Event event;
                            int positionLeftBracketString = currentToken.indexOf(91);
                            int positionRightBracketString = currentToken.indexOf(93);
                            String itemString = currentToken.substring(0, positionLeftBracketString);
                            Integer item = DataMapper.mapKV(itemString);
                            String costString = currentToken.substring(positionLeftBracketString + 1, positionRightBracketString);
                            double cost = Integer.parseInt(costString);
                            sequence[i] = event = new Event(item, cost);
                        } else {
                            Integer current = Integer.parseInt(currentToken);
                            sequence[i] = new Event(current, -99.0);
                        }
                        ++i;
                    }
                    this.sequences.add(sequence);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (myInput != null) {
                    myInput.close();
                }
            }
        }
    }

    public void print() {
        System.out.println("============  SEQUENCE DATABASE ==========");
        System.out.println(this.toString());
    }

    public void printDatabaseStats() {
        System.out.println("============  STATS ==========");
        System.out.println("Number of sequences : " + this.sequences.size());
        double meansize = (float)this.eventOccurrenceCount / (float)this.sequences.size();
        System.out.println("mean size" + meansize);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.sequences.size()) {
            buffer.append(String.valueOf(i) + ":  ");
            Event[] sequence = this.sequences.get(i);
            boolean startingANewItemset = true;
            Event[] eventArray = sequence;
            int n = sequence.length;
            int n2 = 0;
            while (n2 < n) {
                Event token = eventArray[n2];
                if (token.getId() >= 0) {
                    if (startingANewItemset) {
                        startingANewItemset = false;
                        buffer.append("(");
                    } else {
                        buffer.append(" ");
                    }
                    buffer.append(DataMapper.getKey(token.getId()));
                    buffer.append('[');
                    buffer.append(token.getCost());
                    buffer.append(']');
                    ++this.eventOccurrenceCount;
                } else if (token.getId() == -1) {
                    buffer.append(")");
                    startingANewItemset = true;
                } else if (token.getId() == -2) break;
                ++n2;
            }
            buffer.append(System.lineSeparator());
            ++i;
        }
        return buffer.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Event[]> getSequences() {
        return this.sequences;
    }

    public double getSequenceUtility(int sequenceId) {
        return this.sequenceIdUtility.get(sequenceId);
    }
}

