/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model;

import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.model.tree.ClosedSequenceNode;
import java.util.LinkedList;

public class ListNode {
    private ListNode next;
    private int column;

    public ListNode(int c) {
        this.column = c;
    }

    public ListNode(int c, ListNode next) {
        this.column = c;
        this.next = next;
    }

    public int getColumn() {
        return this.column;
    }

    public void setNext(ListNode node) {
        this.next = node;
    }

    public ListNode next() {
        return this.next;
    }

    public ListNode before(ListNode succ) {
        while (succ != null) {
            if (this.column < succ.column) {
                return succ;
            }
            succ = succ.next;
        }
        return null;
    }

    public ListNode before(LinkedList<ClosedSequenceNode> succsNodes, Integer i) {
        ListNode curr = this;
        for (ClosedSequenceNode node : succsNodes) {
            if ((curr = curr.before(node.getVerticalIdList().getElements()[i])) == null) break;
        }
        return curr;
    }

    public ListNode equal(ListNode succ) {
        while (succ != null) {
            if (this.column == succ.column) {
                return succ;
            }
            succ = succ.next;
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ : " + this.column + "]");
        return buf.toString();
    }
}

