/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.creators;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.IDList;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.IDListStandard_Map;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.Position;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.idlists.creators.IdListCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.tries.TrieNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdListCreatorStandard_Map
implements IdListCreator {
    private static IdListCreatorStandard_Map instance = null;

    public static void clear() {
        instance = null;
    }

    private IdListCreatorStandard_Map() {
    }

    public static IdListCreator getInstance() {
        if (instance == null) {
            instance = new IdListCreatorStandard_Map();
        }
        return instance;
    }

    @Override
    public IDList create() {
        HashMap<Integer, List<Position>> sequencePositionsEntries = new HashMap<Integer, List<Position>>();
        return new IDListStandard_Map(sequencePositionsEntries);
    }

    @Override
    public void addAppearance(IDList idlist, Integer sequence, Integer timestamp, Integer item) {
        IDListStandard_Map id = (IDListStandard_Map)idlist;
        id.addAppearance(sequence, new Position(timestamp, item));
    }

    @Override
    public void addAppearancesInSequence(IDList idlist, Integer sequence, List<Position> itemsets) {
        IDListStandard_Map id = (IDListStandard_Map)idlist;
        id.addAppearancesInSequence(sequence, itemsets);
    }

    @Override
    public void initializeMaps(Map<Item, TrieNode> frequentItems, Map<Item, Map<Integer, List<Integer>>> projectingDistance, Map<Integer, Integer> sequenceSize, Map<Integer, List<Integer>> sequenceItemsetsSize) {
        for (Item frecuente : frequentItems.keySet()) {
            TrieNode node = frequentItems.get(frecuente);
            Map<Integer, List<Integer>> sequenceElementsProjectingByItemMap = projectingDistance.get(frecuente);
            int totalNumberOfProjectedElements = 0;
            for (Integer s : sequenceElementsProjectingByItemMap.keySet()) {
                List<Integer> elementsProjectedByPatternInSequence = sequenceElementsProjectingByItemMap.get(s);
                totalNumberOfProjectedElements += sequenceSize.get(s) - elementsProjectedByPatternInSequence.get(0);
            }
            node.getChild().getIdList().setTotalElementsAfterPrefixes(totalNumberOfProjectedElements);
        }
        IDListStandard_Map id = new IDListStandard_Map();
        id.SetOriginalSequenceLengths(sequenceSize);
    }

    @Override
    public void updateProjectionDistance(Map<Item, Map<Integer, List<Integer>>> projectingDistance, Item item, int id, int itemsetCount, int itemsCount) {
        List<Integer> itemscount;
        Map<Integer, List<Integer>> associatedMap = projectingDistance.get(item);
        if (associatedMap == null) {
            associatedMap = new HashMap<Integer, List<Integer>>();
            projectingDistance.put(item, associatedMap);
        }
        if ((itemscount = associatedMap.get(id)) == null) {
            itemscount = new ArrayList<Integer>();
            associatedMap.put(id, itemscount);
        }
        itemscount.add(itemsCount);
    }
}

