/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.patterns;

import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.abstracciones.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clasp_AGP.dataStructures.creators.AbstractionCreator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class Pattern
implements Comparable<Pattern> {
    private List<ItemAbstractionPair> elements;
    private BitSet appearingIn;

    public Pattern() {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.appearingIn = new BitSet();
    }

    public Pattern(List<ItemAbstractionPair> elements) {
        this.elements = elements;
        this.appearingIn = new BitSet();
    }

    public Pattern(ItemAbstractionPair pair) {
        this.elements = new ArrayList<ItemAbstractionPair>();
        this.elements.add(pair);
        this.appearingIn = new BitSet();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            result.append(this.elements.get(i).toString());
            ++i;
        }
        if (this.appearingIn.size() > 0) {
            result.append("\t(");
            result.append(this.appearingIn.size()).append(')');
            result.append("\t[");
            i = 0;
            while (i < this.appearingIn.size()) {
                result.append(this.getSupport()).append(", ");
                ++i;
            }
            result.deleteCharAt(result.length() - 1);
            result.deleteCharAt(result.length() - 1);
            result.append("]");
        }
        return result.toString();
    }

    public String toStringToFile(boolean outputSequenceIdentifiers) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.elements.size()) {
            if (i == this.elements.size() - 1) {
                if (i != 0) {
                    result.append(this.elements.get(i).toStringToFile());
                } else {
                    result.append(this.elements.get(i).getItem());
                }
                result.append(" -1");
            } else if (i == 0) {
                result.append(this.elements.get(i).getItem());
            } else {
                result.append(this.elements.get(i).toStringToFile());
            }
            ++i;
        }
        result.append(" #SUP: ");
        result.append(this.getSupport());
        if (outputSequenceIdentifiers) {
            result.append(" #SID: ");
            i = this.appearingIn.nextSetBit(0);
            while (i >= 0) {
                result.append(i - 1);
                result.append(" ");
                i = this.appearingIn.nextSetBit(i + 1);
            }
        }
        return result.toString();
    }

    public int getSupport() {
        return this.appearingIn.cardinality();
    }

    public Pattern clonePatron() {
        ArrayList<ItemAbstractionPair> elementsCopy = new ArrayList<ItemAbstractionPair>(this.elements);
        Pattern clon = new Pattern(elementsCopy);
        return clon;
    }

    public List<ItemAbstractionPair> getElements() {
        return this.elements;
    }

    public ItemAbstractionPair getIthElement(int i) {
        return this.elements.get(i);
    }

    public ItemAbstractionPair getPenultimoComponente() {
        if (this.size() > 1) {
            return this.getIthElement(this.size() - 2);
        }
        return null;
    }

    public ItemAbstractionPair getLastButOneElement() {
        if (this.size() > 0) {
            return this.getIthElement(this.size() - 1);
        }
        return null;
    }

    public void setElements(List<ItemAbstractionPair> elements) {
        this.elements = elements;
    }

    public void add(ItemAbstractionPair pair) {
        this.elements.add(pair);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int compareTo(Pattern o) {
        return this.getIthElement(this.size() - 1).compareTo(o.getIthElement(o.size() - 1));
    }

    public boolean equals(Object o) {
        if (o instanceof Pattern) {
            Pattern p = (Pattern)o;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.elements != null ? this.elements.hashCode() : 0);
        return hash;
    }

    public boolean isPrefix(Pattern p) {
        boolean output = false;
        ArrayList<ItemAbstractionPair> pElements = new ArrayList<ItemAbstractionPair>(p.getElements());
        pElements.remove(pElements.size() - 1);
        if (((ItemAbstractionPair)pElements.get(pElements.size() - 1)).equals(this.getIthElement(this.size() - 1))) {
            output = true;
        }
        return output;
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }

    public void clear() {
        this.elements.clear();
        this.appearingIn.clear();
    }

    public Pattern concatenate(ItemAbstractionPair pair) {
        Pattern result = this.clonePatron();
        result.add(pair);
        return result;
    }

    public Pattern concatenar(Pattern pattern) {
        Pattern result = this.clonePatron();
        result.getElements().addAll(pattern.getElements());
        return result;
    }

    public boolean isSubpattern(AbstractionCreator abstractionCreator, Pattern p) {
        ArrayList<Integer> positions = new ArrayList<Integer>(p.size());
        int i = 0;
        while (i < this.size()) {
            positions.add(0);
            ++i;
        }
        return abstractionCreator.isSubpattern(this, p, 0, positions);
    }
}

