/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings.PseudoSequence;
import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import java.util.ArrayList;
import java.util.List;

class PseudoSequenceBIDE
extends PseudoSequence {
    int lastItemset;
    int lastItem;

    protected PseudoSequenceBIDE(PseudoSequenceBIDE sequence, int indexItemset, int indexItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = sequence.lastItemset;
        this.lastItem = sequence.lastItem;
    }

    protected PseudoSequenceBIDE(PseudoSequenceBIDE sequence, int indexItemset, int indexItem, int lastItemset, int lastItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
        this.lastItemset = lastItemset;
        this.lastItem = lastItem;
    }

    protected PseudoSequenceBIDE(Sequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence;
        this.firstItemset = indexItemset;
        this.firstItem = indexItem;
        this.lastItemset = sequence.size() - 1;
        this.lastItem = sequence.getItemsets().get(this.lastItemset).size() - 1;
    }

    protected int getLastItemPosition() {
        return this.lastItem - this.firstItem - 1;
    }

    @Override
    protected boolean isLastItemset(int index) {
        return index + this.firstItemset == this.lastItemset;
    }

    @Override
    protected int getSizeOfItemsetAt(int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset).size();
        if (this.isLastItemset(index)) {
            size -= size - 1 - this.lastItem;
        }
        if (this.isFirstItemset(index)) {
            size -= this.firstItem;
        }
        return size;
    }

    @Override
    public String toString() {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            r.append("{");
            int j = 0;
            while (j < this.getSizeOfItemsetAt(i)) {
                if (!this.isLastItemset(i) || j <= this.lastItem) {
                    r.append(this.getItemAtInItemsetAt(j, i));
                    if (this.isPostfix(i)) {
                        r.append('*');
                    }
                    r.append(' ');
                }
                ++j;
            }
            r.append("}");
            ++i;
        }
        r.append("  ");
        return r.toString();
    }

    @Override
    public int size() {
        int size = this.sequence.size() - this.firstItemset - (this.sequence.size() - 1 - this.lastItemset);
        if (size == 1 && this.sequence.getItemsets().get(this.firstItemset).size() == 0) {
            return 0;
        }
        return size;
    }

    protected boolean isCutAtRight(int index) {
        if (!this.isLastItemset(index)) {
            return false;
        }
        return this.sequence.getItemsets().get(index + this.firstItemset).size() - 1 != this.lastItem;
    }

    protected List<PseudoSequencePair> getAllInstancesOfPrefix(List<Itemset> prefix, int i) {
        List<List<Position>> listInstances = this.getAllInstancesOfPrefixHelper(prefix, 0, new ArrayList<List<Position>>(), new ArrayList<Position>(), 0);
        ArrayList<PseudoSequencePair> allPairs = new ArrayList<PseudoSequencePair>();
        for (List<Position> listPositions : listInstances) {
            PseudoSequenceBIDE newSequence = new PseudoSequenceBIDE(this, this.firstItemset, this.firstItem, listPositions.get((int)(i - 1)).itemset, listPositions.get((int)(i - 1)).item);
            allPairs.add(new PseudoSequencePair(newSequence, listPositions));
        }
        return allPairs;
    }

    protected List<List<Position>> getAllInstancesOfPrefixHelper(List<Itemset> prefix, int indexItemset, List<List<Position>> allInstances, List<Position> listPositionsTotal, int decalageItemset) {
        int i = decalageItemset;
        while (i < this.size()) {
            int indexItem = 0;
            ArrayList<Position> listPositions = new ArrayList<Position>();
            String iDCourant = prefix.get(indexItemset).get(indexItem);
            int j = 0;
            while (j < this.getSizeOfItemsetAt(i)) {
                String id = this.getItemAtInItemsetAt(j, i);
                if (id.equals(iDCourant)) {
                    ArrayList<Position> newList;
                    listPositions.add(new Position(i, j));
                    if (listPositions.size() + listPositionsTotal.size() == this.getItemOccurencesTotalCount(prefix)) {
                        newList = new ArrayList<Position>(listPositionsTotal);
                        newList.addAll(listPositions);
                        allInstances.add(newList);
                    } else if (indexItem + 1 >= prefix.get(indexItemset).size()) {
                        newList = new ArrayList<Position>(listPositionsTotal);
                        newList.addAll(listPositions);
                        if (indexItemset + 1 < prefix.size()) {
                            this.getAllInstancesOfPrefixHelper(prefix, indexItemset + 1, allInstances, newList, i + 1);
                        }
                    } else {
                        iDCourant = prefix.get(indexItemset).get(++indexItem);
                    }
                }
                ++j;
            }
            ++i;
        }
        return allInstances;
    }

    protected PseudoSequencePair getLastInstanceOfPrefixSequence(List<Itemset> prefix, int i) {
        List<PseudoSequencePair> list = this.getAllInstancesOfPrefix(prefix, i);
        PseudoSequencePair sequenceRetourPair = list.get(0);
        for (PseudoSequencePair sequencePair : list) {
            PseudoSequenceBIDE sequence = sequencePair.pseudoSequence;
            PseudoSequenceBIDE sequenceRetour = sequenceRetourPair.pseudoSequence;
            if (sequence.lastItemset <= sequenceRetour.lastItemset && (sequenceRetour.lastItemset != sequence.lastItemset || sequence.lastItem <= sequenceRetour.lastItem)) continue;
            sequenceRetourPair = sequencePair;
        }
        return sequenceRetourPair;
    }

    protected PseudoSequencePair getFirstInstanceOfPrefixSequence(List<Itemset> prefix, int i) {
        List<PseudoSequencePair> list = this.getAllInstancesOfPrefix(prefix, i);
        PseudoSequencePair sequenceRetourPair = list.get(0);
        for (PseudoSequencePair sequencePair : list) {
            PseudoSequenceBIDE sequence = sequencePair.pseudoSequence;
            PseudoSequenceBIDE sequenceRetour = sequenceRetourPair.pseudoSequence;
            if (sequence.lastItemset >= sequenceRetour.lastItemset && (sequenceRetour.lastItemset != sequence.lastItemset || sequence.lastItem >= sequenceRetour.lastItem)) continue;
            sequenceRetourPair = sequencePair;
        }
        return sequenceRetourPair;
    }

    protected Position getIthLastInLastApearanceWithRespectToPrefix(List<Itemset> prefix, int i) {
        PseudoSequencePair lastInstancePair = this.getLastInstanceOfPrefixSequence(prefix, this.getItemOccurencesTotalCount(prefix));
        String iditem = this.getIthItem(prefix, i);
        if (i == this.getItemOccurencesTotalCount(prefix) - 1) {
            int j = lastInstancePair.pseudoSequence.size() - 1;
            while (j >= 0) {
                int k = lastInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if (lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        } else {
            Position LLiplus1 = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i + 1);
            int j = LLiplus1.itemset;
            while (j >= 0) {
                int k = lastInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if ((j != LLiplus1.itemset || k < LLiplus1.item) && lastInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        }
        return null;
    }

    protected PseudoSequenceBIDE getIthMaximumPeriodOfAPrefix(List<Itemset> prefix, int i) {
        if (i == 0) {
            Position ithlastlast = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, 0);
            return this.trimBeginingAndEnd(null, ithlastlast);
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequence(prefix, i);
        Position lastOfFirstInstance = firstInstance.list.get(i - 1);
        Position ithlastlast = this.getIthLastInLastApearanceWithRespectToPrefix(prefix, i);
        return this.trimBeginingAndEnd(lastOfFirstInstance, ithlastlast);
    }

    protected PseudoSequenceBIDE trimBeginingAndEnd(Position positionStart, Position positionEnd) {
        int itemsetStart = 0;
        int itemStart = 0;
        int itemsetEnd = this.lastItemset;
        int itemEnd = this.lastItem;
        if (positionStart != null) {
            itemStart = positionStart.item + 1;
            itemsetStart = positionStart.itemset;
            if (itemStart == this.getSizeOfItemsetAt(itemsetStart)) {
                ++itemsetStart;
                itemStart = 0;
            }
            if (itemsetStart == this.size()) {
                return null;
            }
        }
        if (positionEnd != null) {
            itemsetEnd = positionEnd.itemset;
            itemEnd = positionEnd.item - 1;
            if (itemEnd < 0) {
                if (--itemsetEnd < itemsetStart) {
                    return null;
                }
                itemEnd = this.getSizeOfItemsetAt(itemsetEnd) - 1;
            }
        }
        if (itemsetEnd == itemsetStart && itemEnd < itemStart) {
            return null;
        }
        return new PseudoSequenceBIDE(this, itemsetStart, itemStart, itemsetEnd, itemEnd);
    }

    protected PseudoSequenceBIDE getIthSemiMaximumPeriodOfAPrefix(List<Itemset> prefix, int i) {
        if (i == 0) {
            Position ithlastfirst = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, 0);
            PseudoSequenceBIDE pseudo = this.trimBeginingAndEnd(null, ithlastfirst);
            return pseudo;
        }
        PseudoSequencePair firstInstance = this.getFirstInstanceOfPrefixSequence(prefix, i);
        Position endOfFirstInstance = firstInstance.list.get(i - 1);
        Position ithlastfirst = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i);
        return this.trimBeginingAndEnd(endOfFirstInstance, ithlastfirst);
    }

    protected int getItemOccurencesTotalCount(List<Itemset> itemsets) {
        int count = 0;
        for (Itemset itemset2 : itemsets) {
            count += itemset2.size();
        }
        return count;
    }

    protected String getIthItem(List<Itemset> itemsets, int i) {
        int j = 0;
        while (j < itemsets.size()) {
            if (i < itemsets.get(j).size()) {
                return itemsets.get(j).get(i);
            }
            i -= itemsets.get(j).size();
            ++j;
        }
        return null;
    }

    protected Position getIthLastInFirstApearanceWithRespectToPrefix(List<Itemset> prefix, int i) {
        PseudoSequencePair firstInstancePair = this.getFirstInstanceOfPrefixSequence(prefix, this.getItemOccurencesTotalCount(prefix));
        String iditem = this.getIthItem(prefix, i);
        if (i == this.getItemOccurencesTotalCount(prefix) - 1) {
            int j = firstInstancePair.pseudoSequence.size() - 1;
            while (j >= 0) {
                int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if (firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        } else {
            Position LLiplus1 = this.getIthLastInFirstApearanceWithRespectToPrefix(prefix, i + 1);
            if (LLiplus1 == null) {
                System.out.println("DEBUG");
            }
            int j = LLiplus1.itemset;
            while (j >= 0) {
                int k = firstInstancePair.pseudoSequence.getItemset(j).size() - 1;
                while (k >= 0) {
                    if ((j != LLiplus1.itemset || k < LLiplus1.item) && firstInstancePair.pseudoSequence.getItemAtInItemsetAt(k, j).equals(iditem)) {
                        return new Position(j, k);
                    }
                    --k;
                }
                --j;
            }
        }
        return null;
    }

    protected static class Position {
        final int itemset;
        final int item;

        public Position(int itemset2, int item) {
            this.itemset = itemset2;
            this.item = item;
        }
    }

    protected static class PseudoSequencePair {
        final PseudoSequenceBIDE pseudoSequence;
        final List<Position> list;

        public PseudoSequencePair(PseudoSequenceBIDE pseudoSequence, List<Position> list) {
            this.pseudoSequence = pseudoSequence;
            this.list = list;
        }
    }
}

