/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan_with_strings;

import ca.pfv.spmf.input.sequence_database_list_strings.Sequence;
import java.util.List;

class PseudoSequence {
    protected Sequence sequence;
    protected int firstItemset;
    protected int firstItem;

    protected PseudoSequence() {
    }

    protected PseudoSequence(PseudoSequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence.sequence;
        this.firstItemset = indexItemset + sequence.firstItemset;
        this.firstItem = this.firstItemset == sequence.firstItemset ? indexItem + sequence.firstItem : indexItem;
    }

    protected PseudoSequence(Sequence sequence, int indexItemset, int indexItem) {
        this.sequence = sequence;
        this.firstItemset = indexItemset;
        this.firstItem = indexItem;
    }

    protected int size() {
        int size = this.sequence.size() - this.firstItemset;
        if (size == 1 && this.sequence.getItemsets().get(this.firstItemset).size() == 0) {
            return 0;
        }
        return size;
    }

    protected int getSizeOfItemsetAt(int index) {
        int size = this.sequence.getItemsets().get(index + this.firstItemset).size();
        if (this.isFirstItemset(index)) {
            size -= this.firstItem;
        }
        return size;
    }

    protected boolean isPostfix(int indexItemset) {
        return indexItemset == 0 && this.firstItem != 0;
    }

    protected boolean isFirstItemset(int index) {
        return index == 0;
    }

    protected boolean isLastItemset(int index) {
        return index + this.firstItemset == this.sequence.getItemsets().size() - 1;
    }

    protected String getItemAtInItemsetAt(int indexItem, int indexItemset) {
        if (this.isFirstItemset(indexItemset)) {
            return this.getItemset(indexItemset).get(indexItem + this.firstItem);
        }
        return this.getItemset(indexItemset).get(indexItem);
    }

    protected List<String> getItemset(int index) {
        return this.sequence.get(index + this.firstItemset);
    }

    protected int getId() {
        return this.sequence.getId();
    }

    public void print() {
        System.out.print(this.toString());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            int j = 0;
            while (j < this.getSizeOfItemsetAt(i)) {
                if (!this.isLastItemset(i)) {
                    r.append(this.getItemAtInItemsetAt(j, i));
                    if (this.isPostfix(i)) {
                        r.append('*');
                    }
                    r.append(' ');
                }
                ++j;
            }
            r.append(" -1 ");
            ++i;
        }
        r.append(" -2 ");
        return r.toString();
    }

    protected int indexOf(int indexItemset, String idItem) {
        int i = 0;
        while (i < this.getSizeOfItemsetAt(indexItemset)) {
            if (this.getItemAtInItemsetAt(i, indexItemset).equals(idItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

