/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.rulegrowth;

import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.ExpandLeftStore;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.LeftEquivalenceClass;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.LeftRule;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.Occurence;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.RightEquivalenceClass;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.RightRule;
import ca.pfv.spmf.algorithms.sequential_rules.rulegrowth.SparseMatrix;
import ca.pfv.spmf.input.sequence_database_list_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoERMiner {
    long timeStart = 0L;
    long timeEnd = 0L;
    int ruleCount;
    double minConfidence;
    int minsuppRelative;
    SequenceDatabase database;
    Map<Integer, Map<Integer, Occurence>> mapItemCount;
    BufferedWriter writer = null;
    ExpandLeftStore store = new ExpandLeftStore();
    SparseMatrix matrix = new SparseMatrix();
    private long totalCandidateCount;
    private long candidatePrunedCount;
    int maxAntecedentSize = Integer.MAX_VALUE;
    int maxConsequentSize = Integer.MAX_VALUE;

    public void runAlgorithm(double minSupport, double minConfidence, String input, String output) throws IOException {
        try {
            this.database = new SequenceDatabase();
            this.database.loadFile(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsuppRelative = (int)Math.ceil(minSupport * (double)this.database.size());
        this.runAlgorithm(input, output, this.minsuppRelative, minConfidence);
    }

    public void runAlgorithm(String input, String output, int relativeMinsup, double minConfidence) throws IOException {
        this.minConfidence = minConfidence;
        this.ruleCount = 0;
        if (this.database == null) {
            try {
                this.database = new SequenceDatabase();
                this.database.loadFile(input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minsuppRelative = relativeMinsup;
        if (this.minsuppRelative == 0) {
            this.minsuppRelative = 1;
        }
        this.timeStart = System.currentTimeMillis();
        if (this.maxAntecedentSize > 0 && this.maxConsequentSize > 0) {
            this.calculateFrequencyOfEachItem(this.database);
            this.generateMatrix(this.database);
        }
        HashMap<Integer, LeftEquivalenceClass> mapEclassLeft = new HashMap<Integer, LeftEquivalenceClass>();
        HashMap<Integer, RightEquivalenceClass> mapEclassRight = new HashMap<Integer, RightEquivalenceClass>();
        for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.matrix.getMatrix().entrySet()) {
            Integer intI = entry.getKey();
            Map<Integer, Occurence> occurencesI = this.mapItemCount.get(intI);
            Set<Integer> tidsI = occurencesI.keySet();
            for (Map.Entry<Integer, Integer> entryJ : entry.getValue().entrySet()) {
                Set<Integer> tidsJ;
                if (entryJ.getValue() < this.minsuppRelative) continue;
                Integer intJ = entryJ.getKey();
                Map<Integer, Occurence> occurencesJ = this.mapItemCount.get(intJ);
                HashSet<Integer> tidsIJ = new HashSet<Integer>();
                HashSet<Integer> tidsJI = new HashSet<Integer>();
                if (occurencesI.size() < occurencesJ.size()) {
                    this.calculateTidsetsIJandJI(occurencesI, occurencesJ, tidsIJ, tidsJI);
                } else {
                    this.calculateTidsetsIJandJI(occurencesJ, occurencesI, tidsJI, tidsIJ);
                }
                if (tidsIJ.size() >= this.minsuppRelative) {
                    double confIJ = (double)tidsIJ.size() / (double)occurencesI.size();
                    int[] itemsetI = new int[]{intI};
                    int[] itemsetJ = new int[]{intJ};
                    tidsJ = occurencesJ.keySet();
                    if (confIJ >= minConfidence) {
                        this.saveRule(tidsIJ, confIJ, itemsetI, itemsetJ);
                    }
                    if (this.maxAntecedentSize > 1 || this.maxConsequentSize > 1) {
                        this.registerRule11(intI, intJ, tidsI, tidsJ, tidsIJ, occurencesI, occurencesJ, mapEclassLeft, mapEclassRight);
                    }
                }
                if (tidsJI.size() < this.minsuppRelative) continue;
                int[] itemsetI = new int[]{intI};
                int[] itemsetJ = new int[]{intJ};
                double confJI = (double)tidsJI.size() / (double)occurencesJ.size();
                tidsJ = occurencesJ.keySet();
                if (confJI >= minConfidence) {
                    this.saveRule(tidsJI, confJI, itemsetJ, itemsetI);
                }
                if (this.maxAntecedentSize <= 1 && this.maxConsequentSize <= 1) continue;
                this.registerRule11(intJ, intI, tidsJ, tidsI, tidsJI, occurencesJ, occurencesI, mapEclassLeft, mapEclassRight);
            }
        }
        if (this.maxAntecedentSize > 1) {
            for (LeftEquivalenceClass leftEquivalenceClass : mapEclassLeft.values()) {
                if (leftEquivalenceClass.rules.size() == 1) continue;
                Collections.sort(leftEquivalenceClass.rules, new Comparator<LeftRule>(){

                    @Override
                    public int compare(LeftRule arg0, LeftRule arg1) {
                        return arg0.itemsetI[0] - arg1.itemsetI[0];
                    }
                });
                this.expandLeft(leftEquivalenceClass);
            }
        }
        mapEclassLeft = null;
        if (this.maxConsequentSize > 1) {
            for (RightEquivalenceClass rightEquivalenceClass : mapEclassRight.values()) {
                if (rightEquivalenceClass.rules.size() == 1) continue;
                Collections.sort(rightEquivalenceClass.rules, new Comparator<RightRule>(){

                    @Override
                    public int compare(RightRule arg0, RightRule arg1) {
                        return arg0.itemsetJ[0] - arg1.itemsetJ[0];
                    }
                });
                this.expandRight(rightEquivalenceClass, true);
            }
        }
        mapEclassRight = null;
        for (Map map : this.store.getStore().values()) {
            for (List eclassList : map.values()) {
                for (LeftEquivalenceClass eclass : eclassList) {
                    if (eclass.rules.size() == 1) continue;
                    Collections.sort(eclass.rules, new Comparator<LeftRule>(){

                        @Override
                        public int compare(LeftRule arg0, LeftRule arg1) {
                            return arg0.itemsetI[arg0.itemsetI.length - 1] - arg1.itemsetI[arg1.itemsetI.length - 1];
                        }
                    });
                    this.expandLeft(eclass);
                }
            }
        }
        this.timeEnd = System.currentTimeMillis();
        this.writer.close();
        this.database = null;
    }

    private void registerRule11(Integer intI, Integer intJ, Set<Integer> tidsI, Set<Integer> tidsJ, Set<Integer> tidsIJ, Map<Integer, Occurence> occurencesI, Map<Integer, Occurence> occurencesJ, Map<Integer, LeftEquivalenceClass> mapEclassLeft, Map<Integer, RightEquivalenceClass> mapEclassRight) {
        LeftEquivalenceClass leftClass = mapEclassLeft.get(intJ);
        if (leftClass == null) {
            leftClass = new LeftEquivalenceClass(new int[]{intJ}, tidsJ, occurencesJ);
            mapEclassLeft.put(intJ, leftClass);
        }
        LeftRule ruleL = new LeftRule(new int[]{intI}, tidsI, tidsIJ);
        leftClass.rules.add(ruleL);
        RightEquivalenceClass rightclass = mapEclassRight.get(intI);
        if (rightclass == null) {
            rightclass = new RightEquivalenceClass(new int[]{intI}, tidsI, occurencesI);
            mapEclassRight.put(intI, rightclass);
        }
        RightRule ruleR = new RightRule(new int[]{intJ}, tidsJ, tidsIJ, occurencesJ);
        rightclass.rules.add(ruleR);
    }

    private void calculateTidsetsIJandJI(Map<Integer, Occurence> occurencesI, Map<Integer, Occurence> occurencesJ, Set<Integer> tidsIJ, Set<Integer> tidsJI) {
        for (Map.Entry<Integer, Occurence> entryOccI : occurencesI.entrySet()) {
            Integer tid = entryOccI.getKey();
            Occurence occJ = occurencesJ.get(tid);
            if (occJ == null) continue;
            Occurence occI = entryOccI.getValue();
            if (occJ.firstItemset < occI.lastItemset) {
                tidsJI.add(tid);
            }
            if (occI.firstItemset >= occJ.lastItemset) continue;
            tidsIJ.add(tid);
        }
    }

    public int[] concatenate(int[] itemset2, int item) {
        int[] newItemset = new int[itemset2.length + 1];
        System.arraycopy(itemset2, 0, newItemset, 0, itemset2.length);
        newItemset[itemset2.length] = item;
        return newItemset;
    }

    private void expandLeft(LeftEquivalenceClass eclass) {
        int w = 0;
        while (w < eclass.rules.size() - 1) {
            LeftRule rule1 = eclass.rules.get(w);
            int d = rule1.itemsetI[rule1.itemsetI.length - 1];
            LeftEquivalenceClass rulesForRecursion = new LeftEquivalenceClass(eclass.itemsetJ, eclass.tidsJ, eclass.occurencesJ);
            int m = w + 1;
            while (m < eclass.rules.size()) {
                LeftRule rule2 = eclass.rules.get(m);
                int c = rule2.itemsetI[rule2.itemsetI.length - 1];
                if (this.matrix.getCount(c, d) < this.minsuppRelative) {
                    ++this.candidatePrunedCount;
                    ++this.totalCandidateCount;
                } else {
                    int remains;
                    ++this.totalCandidateCount;
                    HashSet<Integer> tidsIC = new HashSet<Integer>();
                    Map<Integer, Occurence> mapC = this.mapItemCount.get(c);
                    if (rule1.tidsI.size() < mapC.size()) {
                        remains = rule1.tidsI.size();
                        for (Integer n : rule1.tidsI) {
                            if (mapC.get(n) != null) {
                                tidsIC.add(n);
                            }
                            if (tidsIC.size() + --remains >= this.minsuppRelative) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        remains = mapC.size();
                        for (Integer n : mapC.keySet()) {
                            if (rule1.tidsI.contains(n)) {
                                tidsIC.add(n);
                            }
                            if (tidsIC.size() + --remains >= this.minsuppRelative) {
                                continue;
                            }
                            break;
                        }
                    }
                    HashSet<Integer> tidsIC_J = new HashSet<Integer>();
                    if (rule1.tidsIJ.size() < mapC.size()) {
                        for (Integer n : rule1.tidsIJ) {
                            Occurence occurenceC = mapC.get(n);
                            if (occurenceC == null) continue;
                            Occurence occurenceJ = eclass.occurencesJ.get(n);
                            if (occurenceC.firstItemset >= occurenceJ.lastItemset) continue;
                            tidsIC_J.add(n);
                        }
                    } else {
                        for (Map.Entry entry : mapC.entrySet()) {
                            int tid = (Integer)entry.getKey();
                            if (!rule1.tidsIJ.contains(tid)) continue;
                            Occurence occurenceC = (Occurence)entry.getValue();
                            Occurence occurenceJ = eclass.occurencesJ.get(tid);
                            if (occurenceC.firstItemset >= occurenceJ.lastItemset) continue;
                            tidsIC_J.add(tid);
                        }
                    }
                    if (tidsIC_J.size() >= this.minsuppRelative) {
                        double d2 = (double)tidsIC_J.size() / (double)tidsIC.size();
                        int[] itemsetIC = new int[rule1.itemsetI.length + 1];
                        System.arraycopy(rule1.itemsetI, 0, itemsetIC, 0, rule1.itemsetI.length);
                        itemsetIC[rule1.itemsetI.length] = c;
                        LeftRule newRule = new LeftRule(itemsetIC, tidsIC, tidsIC_J);
                        if (d2 >= this.minConfidence) {
                            this.saveRule(tidsIC_J, d2, itemsetIC, eclass.itemsetJ);
                        }
                        if (newRule.itemsetI.length < this.maxAntecedentSize) {
                            rulesForRecursion.rules.add(newRule);
                        }
                    }
                }
                ++m;
            }
            if (rulesForRecursion.rules.size() > 1) {
                this.expandLeft(rulesForRecursion);
            }
            ++w;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    /*
     * Could not resolve type clashes
     */
    private void expandRight(RightEquivalenceClass eclass, boolean firstTime) {
        int w = 0;
        while (w < eclass.rules.size() - 1) {
            RightRule rule1 = eclass.rules.get(w);
            int d = rule1.itemsetJ[rule1.itemsetJ.length - 1];
            RightEquivalenceClass rulesForRecursion = new RightEquivalenceClass(eclass.itemsetI, eclass.tidsI, eclass.occurencesI);
            int m = w + 1;
            while (m < eclass.rules.size()) {
                RightRule rule2 = eclass.rules.get(m);
                int c = rule2.itemsetJ[rule2.itemsetJ.length - 1];
                if (this.matrix.getCount(c, d) < this.minsuppRelative) {
                    ++this.candidatePrunedCount;
                    ++this.totalCandidateCount;
                } else {
                    int remains;
                    ++this.totalCandidateCount;
                    HashSet<Integer> tidsI_JC = new HashSet<Integer>();
                    Map<Integer, Occurence> mapC = this.mapItemCount.get(c);
                    if (rule1.tidsIJ.size() < mapC.size()) {
                        remains = rule1.tidsIJ.size();
                        for (Integer tid : rule1.tidsIJ) {
                            Occurence occurenceC = mapC.get(tid);
                            if (occurenceC != null) {
                                Occurence occurenceI = eclass.occurencesI.get(tid);
                                if (occurenceC.lastItemset > occurenceI.firstItemset) {
                                    tidsI_JC.add(tid);
                                }
                            }
                            if (tidsI_JC.size() + --remains >= this.minsuppRelative) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        remains = mapC.size();
                        for (Map.Entry entryC : mapC.entrySet()) {
                            int tid = (Integer)entryC.getKey();
                            if (!rule1.tidsIJ.contains(tid)) continue;
                            Occurence occurenceC = (Occurence)entryC.getValue();
                            Occurence occurenceI = eclass.occurencesI.get(tid);
                            if (occurenceC.lastItemset <= occurenceI.firstItemset) continue;
                            tidsI_JC.add(tid);
                        }
                        if (tidsI_JC.size() + --remains < this.minsuppRelative) break;
                    }
                    if (tidsI_JC.size() >= this.minsuppRelative) {
                        HashSet<Integer> tidsJC = new HashSet<Integer>(rule1.tidsJ.size());
                        HashMap<Integer, Occurence> occurencesJC = new HashMap<Integer, Occurence>();
                        if (rule1.tidsJ.size() < mapC.size()) {
                            for (Integer tid : rule1.tidsJ) {
                                Occurence occurrenceC = mapC.get(tid);
                                if (occurrenceC == null) continue;
                                tidsJC.add(tid);
                                Occurence occurenceJ = rule1.occurencesJ.get(tid);
                                if (occurrenceC.lastItemset < occurenceJ.lastItemset) {
                                    occurencesJC.put(tid, occurrenceC);
                                    continue;
                                }
                                occurencesJC.put(tid, occurenceJ);
                            }
                        } else {
                            for (Map.Entry entryC : mapC.entrySet()) {
                                int tid = (Integer)entryC.getKey();
                                if (!rule1.tidsJ.contains(tid)) continue;
                                tidsJC.add(tid);
                                Occurence occurrenceC = (Occurence)entryC.getValue();
                                Occurence occurenceJ = rule1.occurencesJ.get(tid);
                                if (occurrenceC.lastItemset < occurenceJ.lastItemset) {
                                    occurencesJC.put(tid, occurrenceC);
                                    continue;
                                }
                                occurencesJC.put(tid, occurenceJ);
                            }
                        }
                        double confI_JC = (double)tidsI_JC.size() / (double)eclass.tidsI.size();
                        int[] itemsetJC = new int[rule1.itemsetJ.length + 1];
                        System.arraycopy(rule1.itemsetJ, 0, itemsetJC, 0, rule1.itemsetJ.length);
                        itemsetJC[rule1.itemsetJ.length] = c;
                        if (confI_JC >= this.minConfidence) {
                            this.saveRule(tidsI_JC, confI_JC, eclass.itemsetI, itemsetJC);
                        }
                        RightRule rightRule = new RightRule(itemsetJC, tidsJC, tidsI_JC, occurencesJC);
                        if (rightRule.itemsetJ.length < this.maxConsequentSize) {
                            rulesForRecursion.rules.add(rightRule);
                        }
                        if (eclass.itemsetI.length < this.maxAntecedentSize) {
                            LeftRule leftRule = new LeftRule(eclass.itemsetI, eclass.tidsI, tidsI_JC);
                            this.store.register(leftRule, itemsetJC, tidsJC, eclass.occurencesI, occurencesJC);
                        }
                    }
                }
                ++m;
            }
            if (rulesForRecursion.rules.size() > 1) {
                this.expandRight(rulesForRecursion, false);
            }
            ++w;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private Map<Integer, Map<Integer, Occurence>> calculateFrequencyOfEachItem(SequenceDatabase database) {
        this.mapItemCount = new HashMap<Integer, Map<Integer, Occurence>>();
        int k = 0;
        while (k < database.size()) {
            Sequence sequence = database.getSequences().get(k);
            short j = 0;
            while (j < sequence.getItemsets().size()) {
                List<Integer> itemset2 = sequence.get(j);
                for (Integer itemI : itemset2) {
                    Map<Integer, Occurence> occurences = this.mapItemCount.get(itemI);
                    if (occurences == null) {
                        occurences = new HashMap<Integer, Occurence>();
                        this.mapItemCount.put(itemI, occurences);
                        occurences.put(k, new Occurence(j, j));
                        continue;
                    }
                    Occurence occurence = occurences.get(k);
                    if (occurence == null) {
                        occurences.put(k, new Occurence(j, j));
                        continue;
                    }
                    occurence.lastItemset = j;
                }
                j = (short)(j + 1);
            }
            ++k;
        }
        return this.mapItemCount;
    }

    private void generateMatrix(SequenceDatabase database) {
        for (Sequence sequence : database.getSequences()) {
            HashSet<Integer> alreadyProcessed = new HashSet<Integer>();
            for (List<Integer> itemsetj : sequence.getItemsets()) {
                for (Integer itemk : itemsetj) {
                    if (alreadyProcessed.contains(itemk) || this.mapItemCount.get(itemk).size() < this.minsuppRelative) continue;
                    HashSet<Integer> alreadyProcessedWithRespectToK = new HashSet<Integer>();
                    for (List<Integer> itemsetjj : sequence.getItemsets()) {
                        for (Integer itemkk : itemsetjj) {
                            if (itemkk.equals(itemk) || alreadyProcessedWithRespectToK.contains(itemkk) || this.mapItemCount.get(itemkk).size() < this.minsuppRelative) continue;
                            this.matrix.increaseCountOfPair(itemk, itemkk);
                            alreadyProcessedWithRespectToK.add(itemkk);
                        }
                    }
                    alreadyProcessed.add(itemk);
                }
            }
        }
    }

    private void saveRule(Set<Integer> tidsIJ, double confIJ, int[] itemsetI, int[] itemsetJ) {
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < itemsetI.length) {
            buffer.append(itemsetI[i]);
            if (i != itemsetI.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append(" ==> ");
        i = 0;
        while (i < itemsetJ.length) {
            buffer.append(itemsetJ[i]);
            if (i != itemsetJ.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append(" #SUP: ");
        buffer.append(tidsIJ.size());
        buffer.append(" #CONF: ");
        buffer.append(confIJ);
        try {
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printStats() {
        System.out.println("=============  ERMiner - STATS ========");
        System.out.println("Sequential rules count: " + this.ruleCount);
        System.out.println("Total time: " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println("Candidates pruned (%)" + this.candidatePrunedCount + " of " + this.totalCandidateCount);
        System.out.println("Max memory: " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("==========================================");
    }

    public void setMaxAntecedentSize(int maxAntecedentSize) {
        this.maxAntecedentSize = maxAntecedentSize;
    }

    public void setMaxConsequentSize(int maxConsequentSize) {
        this.maxConsequentSize = maxConsequentSize;
    }
}

