/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.husrm;

import ca.pfv.spmf.algorithms.sequential_rules.husrm.SequenceDatabaseWithUtility;
import ca.pfv.spmf.algorithms.sequential_rules.husrm.SequenceWithUtility;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoHUSRM {
    long timeStart = 0L;
    long timeEnd = 0L;
    int ruleCount;
    double minConfidence;
    double minutil;
    SequenceDatabaseWithUtility database;
    BufferedWriter writer = null;
    private Map<Integer, ListSequenceIDs> mapItemSequences;
    final boolean DEBUG = false;
    private int maxSizeAntecedent;
    private int maxSizeConsequent;
    private boolean deactivateStrategy1 = false;
    private boolean deactivateStrategy2 = false;
    private boolean deactivateStrategy3 = false;
    private boolean deactivateStrategy4 = false;

    /*
     * WARNING - void declaration
     */
    public void runAlgorithm(String input, String output, double minConfidence, double minutil, int maxAntecedentSize, int maxConsequentSize, int maximumNumberOfSequences) throws IOException {
        void var11_18;
        this.minConfidence = minConfidence;
        this.maxSizeAntecedent = maxAntecedentSize;
        this.maxSizeConsequent = maxConsequentSize;
        this.ruleCount = 0;
        this.minutil = minutil;
        if (this.database == null) {
            try {
                this.database = new SequenceDatabaseWithUtility();
                this.database.loadFile(input, maximumNumberOfSequences);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minutil = minutil;
        if (this.minutil == 0.0) {
            this.minutil = 0.001;
        }
        this.timeStart = System.currentTimeMillis();
        if (!this.deactivateStrategy1) {
            HashMap<Integer, Double> mapItemEstimatedUtility = new HashMap<Integer, Double>();
            for (SequenceWithUtility sequenceWithUtility : this.database.getSequences()) {
                for (List<Integer> itemset2 : sequenceWithUtility.getItemsets()) {
                    for (Integer item : itemset2) {
                        Double estimatedUtility = (Double)mapItemEstimatedUtility.get(item);
                        estimatedUtility = estimatedUtility == null ? Double.valueOf(sequenceWithUtility.exactUtility) : Double.valueOf(estimatedUtility + sequenceWithUtility.exactUtility);
                        mapItemEstimatedUtility.put(item, estimatedUtility);
                    }
                }
            }
            Iterator iterator = mapItemEstimatedUtility.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryMapItemEstimatedUtility = iterator.next();
                Double estimatedUtility = (Double)entryMapItemEstimatedUtility.getValue();
                if (!(estimatedUtility < minutil)) continue;
                iterator.remove();
            }
            Iterator<SequenceWithUtility> iteratorSequence = this.database.getSequences().iterator();
            while (iteratorSequence.hasNext()) {
                SequenceWithUtility sequence = iteratorSequence.next();
                Iterator<List<Integer>> iteratorItemset = sequence.getItemsets().iterator();
                Iterator<Object> iteratorItemsetUtilities = sequence.getUtilities().iterator();
                while (iteratorItemset.hasNext()) {
                    List<Integer> itemset3 = iteratorItemset.next();
                    List itemsetUtilities = (List)iteratorItemsetUtilities.next();
                    Iterator<Integer> iteratorItem = itemset3.iterator();
                    Iterator iteratorItemUtility = itemsetUtilities.iterator();
                    while (iteratorItem.hasNext()) {
                        Integer item = iteratorItem.next();
                        Double utility = (Double)iteratorItemUtility.next();
                        if (mapItemEstimatedUtility.get(item) != null) continue;
                        iteratorItem.remove();
                        iteratorItemUtility.remove();
                        sequence.exactUtility -= utility.doubleValue();
                    }
                    if (!itemset3.isEmpty()) continue;
                    iteratorItemset.remove();
                    iteratorItemsetUtilities.remove();
                }
                if (sequence.size() != 0) continue;
                iteratorSequence.remove();
            }
        }
        this.mapItemSequences = new HashMap<Integer, ListSequenceIDs>();
        int i = 0;
        while (i < this.database.getSequences().size()) {
            SequenceWithUtility sequenceWithUtility = this.database.getSequences().get(i);
            for (List<Integer> itemset4 : sequenceWithUtility.getItemsets()) {
                for (Integer item : itemset4) {
                    ListSequenceIDs numerosSequenceItem = this.mapItemSequences.get(item);
                    if (numerosSequenceItem == null) {
                        numerosSequenceItem = this.deactivateStrategy3 ? new ListSequenceIDsArrayList() : new ListSequenceIDsBitVector();
                        this.mapItemSequences.put(item, numerosSequenceItem);
                    }
                    numerosSequenceItem.addSequenceID(i);
                }
            }
            ++i;
        }
        HashMap mapItemItemEstimatedUtility = new HashMap();
        boolean bl = false;
        while (var11_18 < this.database.getSequences().size()) {
            SequenceWithUtility sequence = this.database.getSequences().get((int)var11_18);
            int i2 = 0;
            while (i2 < sequence.getItemsets().size()) {
                List<Integer> itemset5 = sequence.getItemsets().get(i2);
                int j = 0;
                while (j < itemset5.size()) {
                    Integer itemX = itemset5.get(j);
                    int k = i2 + 1;
                    while (k < sequence.getItemsets().size()) {
                        List<Integer> itemsetK = sequence.getItemsets().get(k);
                        for (Integer itemY : itemsetK) {
                            EstimatedUtilityAndSequences structure;
                            HashMap<Integer, EstimatedUtilityAndSequences> mapXItemUtility = (HashMap<Integer, EstimatedUtilityAndSequences>)mapItemItemEstimatedUtility.get(itemX);
                            if (mapXItemUtility == null) {
                                mapXItemUtility = new HashMap<Integer, EstimatedUtilityAndSequences>();
                                mapItemItemEstimatedUtility.put(itemX, mapXItemUtility);
                                structure = new EstimatedUtilityAndSequences();
                                structure.utility = sequence.exactUtility;
                                structure.sequenceIds.add((int)var11_18);
                                mapXItemUtility.put(itemY, structure);
                                continue;
                            }
                            structure = (EstimatedUtilityAndSequences)mapXItemUtility.get(itemY);
                            if (structure == null) {
                                structure = new EstimatedUtilityAndSequences();
                                structure.utility = sequence.exactUtility;
                                structure.sequenceIds.add((int)var11_18);
                                mapXItemUtility.put(itemY, structure);
                                continue;
                            }
                            structure.utility = structure.utility + sequence.exactUtility;
                            structure.sequenceIds.add((int)var11_18);
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            ++var11_18;
        }
        for (Map.Entry entry : mapItemItemEstimatedUtility.entrySet()) {
            Iterator iterEntry = ((Map)entry.getValue()).entrySet().iterator();
            while (iterEntry.hasNext()) {
                Map.Entry entry2 = iterEntry.next();
                if (!(((EstimatedUtilityAndSequences)entry2.getValue()).utility < minutil) || this.deactivateStrategy2) continue;
                iterEntry.remove();
            }
        }
        for (Map.Entry entry : mapItemItemEstimatedUtility.entrySet()) {
            Integer itemX = (Integer)entry.getKey();
            ListSequenceIDs sequenceIDsX = this.mapItemSequences.get(itemX);
            double supportX = sequenceIDsX.getSize();
            for (Map.Entry entryYUtility : ((Map)entry.getValue()).entrySet()) {
                double conditionExpandRight;
                double conditionExpandLeft;
                Integer itemY;
                itemY = (Integer)entryYUtility.getKey();
                EstimatedUtilityAndSequences structure = (EstimatedUtilityAndSequences)entryYUtility.getValue();
                List<Integer> sequencesIDsXY = structure.sequenceIds;
                double supportXY = sequencesIDsXY.size();
                UtilityTable table = new UtilityTable();
                for (Integer numeroSequence : sequencesIDsXY) {
                    List<Integer> itemset2;
                    Integer itemIJ;
                    int j;
                    SequenceWithUtility sequence = this.database.getSequences().get(numeroSequence);
                    ElementOfTable element = new ElementOfTable(numeroSequence);
                    int positionAlphaItem = -1;
                    int positionBetaItem = -1;
                    int i3 = 0;
                    block22: while (i3 < sequence.getItemsets().size()) {
                        List<Integer> itemset6 = sequence.getItemsets().get(i3);
                        j = 0;
                        while (j < itemset6.size()) {
                            itemIJ = itemset6.get(j);
                            if (itemX.equals(itemIJ)) {
                                double utilityXPositionIJ = sequence.getUtilities().get(i3).get(j);
                                element.utility += utilityXPositionIJ;
                                element.positionAlphaItemset = i3;
                                positionAlphaItem = j;
                                break block22;
                            }
                            if (itemIJ > itemX) {
                                double profitXPositionIJ = sequence.getUtilities().get(i3).get(j);
                                element.utilityLeft += profitXPositionIJ;
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    if (element.positionAlphaItemset == -1) continue;
                    int i2 = sequence.getItemsets().size() - 1;
                    block24: while (i2 > element.positionAlphaItemset) {
                        itemset2 = sequence.getItemsets().get(i2);
                        j = itemset2.size() - 1;
                        while (j >= 0) {
                            itemIJ = itemset2.get(j);
                            if (itemY.equals(itemIJ)) {
                                double profitYPositionIJ = sequence.getUtilities().get(i2).get(j);
                                element.utility += profitYPositionIJ;
                                element.positionBetaItemset = i2;
                                positionBetaItem = j;
                                break block24;
                            }
                            if (itemIJ > itemY) {
                                double profitXPositionIJ = sequence.getUtilities().get(i2).get(j);
                                element.utilityRight += profitXPositionIJ;
                            }
                            --j;
                        }
                        --i2;
                    }
                    if (element.positionBetaItemset == -1) continue;
                    List<Integer> itemsetAlpha = sequence.getItemsets().get(element.positionAlphaItemset);
                    int j2 = positionAlphaItem + 1;
                    while (j2 < itemsetAlpha.size()) {
                        double profitPositionIJ = sequence.getUtilities().get(element.positionAlphaItemset).get(j2);
                        element.utilityLeft += profitPositionIJ;
                        ++j2;
                    }
                    int i4 = element.positionAlphaItemset + 1;
                    while (i4 < element.positionBetaItemset) {
                        List<Integer> itemset7 = sequence.getItemsets().get(i4);
                        int j3 = 0;
                        while (j3 < itemset7.size()) {
                            double utilityPositionIJ;
                            Integer itemIJ2 = itemset7.get(j3);
                            if (itemIJ2 > itemX && itemIJ2 > itemY) {
                                utilityPositionIJ = sequence.getUtilities().get(i4).get(j3);
                                element.utilityLeftRight += utilityPositionIJ;
                            } else if (itemIJ2 > itemX) {
                                utilityPositionIJ = sequence.getUtilities().get(i4).get(j3);
                                element.utilityLeft += utilityPositionIJ;
                            } else if (itemIJ2 > itemY) {
                                utilityPositionIJ = sequence.getUtilities().get(i4).get(j3);
                                element.utilityRight += utilityPositionIJ;
                            }
                            ++j3;
                        }
                        ++i4;
                    }
                    itemset2 = sequence.getItemsets().get(element.positionBetaItemset);
                    j = 0;
                    while (j < positionBetaItem - 1) {
                        Integer itemIJ3 = itemset2.get(j);
                        if (itemIJ3 > itemY) {
                            double profitPositionIJ = sequence.getUtilities().get(element.positionBetaItemset).get(j);
                            element.utilityRight += profitPositionIJ;
                        }
                        ++j;
                    }
                    table.addElement(element);
                }
                double confidence = supportXY / supportX;
                if (this.deactivateStrategy4) {
                    conditionExpandRight = conditionExpandLeft = table.totalUtility + table.totalUtilityLeft + table.totalUtilityLeftRight + table.totalUtilityRight;
                } else {
                    conditionExpandLeft = table.totalUtility + table.totalUtilityLeft + table.totalUtilityLeftRight;
                    conditionExpandRight = table.totalUtility + table.totalUtilityRight + table.totalUtilityLeftRight + table.totalUtilityLeft;
                }
                int[] antecedent = new int[]{itemX};
                int[] consequent = new int[]{itemY};
                if (table.totalUtility >= minutil && confidence >= minConfidence) {
                    this.saveRule(antecedent, consequent, table.totalUtility, supportXY, confidence);
                }
                if (conditionExpandRight >= minutil && maxConsequentSize > 1) {
                    this.expandRight(table, antecedent, consequent, sequenceIDsX);
                }
                if (!(conditionExpandLeft >= minutil) || maxAntecedentSize <= 1) continue;
                this.expandFirstLeft(table, antecedent, consequent, sequenceIDsX);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.timeEnd = System.currentTimeMillis();
        this.writer.close();
        this.database = null;
    }

    private void saveRule(int[] antecedent, int[] consequent, double utility, double support, double confidence) throws IOException {
        ++this.ruleCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < antecedent.length) {
            buffer.append(antecedent[i]);
            if (i != antecedent.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append("\t==> ");
        i = 0;
        while (i < consequent.length) {
            buffer.append(consequent[i]);
            if (i != consequent.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append("\t#SUP: ");
        buffer.append(support);
        buffer.append("\t#CONF: ");
        buffer.append(confidence);
        buffer.append("\t#UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMeasuresForARule(int[] antecedent, int[] consequent, double utility, double support, double confidence) {
        double supportOfAntecedent = 0.0;
        double supportOfTheRule = 0.0;
        double utilityOfTheRule = 0.0;
        block0: for (SequenceWithUtility sequence : this.database.getSequences()) {
            int numberOfAntecedentItemsAlreadySeen = 0;
            double ruleUtilityInSequence = 0.0;
            int i = 0;
            block1: while (i < sequence.getItemsets().size()) {
                List<Integer> itemset2 = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset2.size()) {
                    Integer item = itemset2.get(j);
                    if (Arrays.binarySearch(antecedent, item) >= 0) {
                        double utilityItem = sequence.getUtilities().get(i).get(j);
                        ruleUtilityInSequence += utilityItem;
                        if (++numberOfAntecedentItemsAlreadySeen == antecedent.length) {
                            supportOfAntecedent += 1.0;
                            break block1;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ++i;
            int numberOfConsequentItemsAlreadySeen = 0;
            while (i < sequence.getItemsets().size()) {
                List<Integer> itemset3 = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemset3.size()) {
                    Integer item = itemset3.get(j);
                    if (Arrays.binarySearch(consequent, item) >= 0) {
                        double utilityItem = sequence.getUtilities().get(i).get(j);
                        ruleUtilityInSequence += utilityItem;
                        if (++numberOfConsequentItemsAlreadySeen == consequent.length) {
                            supportOfTheRule += 1.0;
                            utilityOfTheRule += ruleUtilityInSequence;
                            continue block0;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (support != supportOfTheRule) {
            throw new RuntimeException(" The support is incorrect for the rule : " + Arrays.toString(antecedent) + " ==>" + Arrays.toString(consequent) + "   support : " + support + " recalculated support: " + supportOfTheRule);
        }
        double recalculatedConfidence = supportOfTheRule / supportOfAntecedent;
        if (confidence != recalculatedConfidence) {
            throw new RuntimeException(" The confidence is incorrect for the rule :" + Arrays.toString(antecedent) + " ==>" + Arrays.toString(consequent) + "   confidence : " + confidence + " recalculated confidence: " + recalculatedConfidence);
        }
        if (utility != utilityOfTheRule) {
            throw new RuntimeException(" The utility is incorrect for the rule :" + Arrays.toString(antecedent) + " ==>" + Arrays.toString(consequent) + "   utility : " + utility + " recalculated utility " + utilityOfTheRule);
        }
    }

    private void expandRight(UtilityTable table, int[] antecedent, int[] consequent, ListSequenceIDs sequenceIdsAntecedent) throws IOException {
        int largestItemInAntecedent = antecedent[antecedent.length - 1];
        int largestItemInConsequent = consequent[consequent.length - 1];
        HashMap<Integer, UtilityTable> mapItemsTables = new HashMap<Integer, UtilityTable>();
        for (ElementOfTable elementOfTable : table.elements) {
            if (elementOfTable.utilityLeft + elementOfTable.utilityRight + elementOfTable.utilityLeftRight == 0.0) continue;
            SequenceWithUtility sequence = this.database.getSequences().get(elementOfTable.numeroSequence);
            int i = elementOfTable.positionBetaItemset;
            while (i < sequence.size()) {
                List<Integer> itemsetI = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemsetI.size()) {
                    Integer itemJ = itemsetI.get(j);
                    if (itemJ > largestItemInConsequent) {
                        UtilityTable tableItemJ = (UtilityTable)mapItemsTables.get(itemJ);
                        if (tableItemJ == null) {
                            tableItemJ = new UtilityTable();
                            mapItemsTables.put(itemJ, tableItemJ);
                        }
                        ElementOfTable newElement = new ElementOfTable(elementOfTable.numeroSequence);
                        double profitItemJ = sequence.getUtilities().get(i).get(j);
                        newElement.utility = elementOfTable.utility + profitItemJ;
                        newElement.utilityLeft = elementOfTable.utilityLeft;
                        newElement.utilityLeftRight = elementOfTable.utilityLeftRight;
                        newElement.utilityRight = elementOfTable.utilityRight - profitItemJ;
                        newElement.positionBetaItemset = elementOfTable.positionBetaItemset;
                        newElement.positionAlphaItemset = elementOfTable.positionAlphaItemset;
                        int z = elementOfTable.positionBetaItemset;
                        while (z < sequence.size()) {
                            List<Integer> itemsetZ = sequence.getItemsets().get(z);
                            int w = itemsetZ.size() - 1;
                            while (w >= 0) {
                                Integer itemW = itemsetZ.get(w);
                                if (itemW <= largestItemInConsequent) break;
                                if (itemW < itemJ) {
                                    double profitItemW = sequence.getUtilities().get(z).get(w);
                                    newElement.utilityRight -= profitItemW;
                                }
                                --w;
                            }
                            ++z;
                        }
                        tableItemJ.addElement(newElement);
                    }
                    ++j;
                }
                ++i;
            }
            int sumUtilityLeftRightUntilBetaPrime = 0;
            int sumUtilityLeftUntilBetaPrime = 0;
            int i2 = elementOfTable.positionBetaItemset - 1;
            while (i2 > elementOfTable.positionAlphaItemset) {
                List<Integer> itemsetI = sequence.getItemsets().get(i2);
                int j = 0;
                while (j < itemsetI.size()) {
                    double profitItemJ;
                    ElementOfTable newElement;
                    boolean isRight;
                    Integer itemJ = itemsetI.get(j);
                    boolean isLeft = itemJ > largestItemInAntecedent && itemJ < largestItemInConsequent;
                    boolean isLeftRight = itemJ > largestItemInAntecedent && itemJ > largestItemInConsequent;
                    boolean bl = isRight = itemJ > largestItemInConsequent && itemJ < largestItemInAntecedent;
                    if (isLeft) {
                        double profitItemJ2 = sequence.getUtilities().get(i2).get(j);
                        sumUtilityLeftUntilBetaPrime = (int)((double)sumUtilityLeftUntilBetaPrime + profitItemJ2);
                    } else if (isRight) {
                        UtilityTable tableItemJ = (UtilityTable)mapItemsTables.get(itemJ);
                        if (tableItemJ == null) {
                            tableItemJ = new UtilityTable();
                            mapItemsTables.put(itemJ, tableItemJ);
                        }
                        newElement = new ElementOfTable(elementOfTable.numeroSequence);
                        profitItemJ = sequence.getUtilities().get(i2).get(j);
                        newElement.utility = elementOfTable.utility + profitItemJ;
                        newElement.utilityLeft = elementOfTable.utilityLeft - (double)sumUtilityLeftUntilBetaPrime;
                        newElement.utilityLeftRight = elementOfTable.utilityLeftRight - (double)sumUtilityLeftRightUntilBetaPrime;
                        int sumUtilityRUtilItemsSmallerThanX = 0;
                        int sumUtilityLRUtilItemsSmallerThanX = 0;
                        int z = i2;
                        while (z < elementOfTable.positionBetaItemset) {
                            List<Integer> itemsetZ = sequence.getItemsets().get(z);
                            int w = 0;
                            while (w < itemsetZ.size()) {
                                double profitItemW;
                                boolean wIsRight;
                                Integer itemW = itemsetZ.get(w);
                                boolean wIsLeftRight = itemW > largestItemInAntecedent && itemW > largestItemInConsequent;
                                boolean bl2 = wIsRight = itemW > largestItemInConsequent && itemW < largestItemInAntecedent;
                                if (wIsRight && itemW < itemJ) {
                                    profitItemW = sequence.getUtilities().get(z).get(w);
                                    sumUtilityRUtilItemsSmallerThanX = (int)((double)sumUtilityRUtilItemsSmallerThanX + profitItemW);
                                } else if (wIsLeftRight && itemW > itemJ) {
                                    profitItemW = sequence.getUtilities().get(z).get(w);
                                    sumUtilityLRUtilItemsSmallerThanX = (int)((double)sumUtilityLRUtilItemsSmallerThanX + profitItemW);
                                }
                                ++w;
                            }
                            ++z;
                        }
                        newElement.utilityRight = elementOfTable.utilityRight - profitItemJ + (double)sumUtilityLRUtilItemsSmallerThanX - (double)sumUtilityRUtilItemsSmallerThanX;
                        newElement.positionBetaItemset = i2;
                        newElement.positionAlphaItemset = elementOfTable.positionAlphaItemset;
                        tableItemJ.addElement(newElement);
                    } else if (isLeftRight) {
                        UtilityTable tableItemJ = (UtilityTable)mapItemsTables.get(itemJ);
                        if (tableItemJ == null) {
                            tableItemJ = new UtilityTable();
                            mapItemsTables.put(itemJ, tableItemJ);
                        }
                        newElement = new ElementOfTable(elementOfTable.numeroSequence);
                        profitItemJ = sequence.getUtilities().get(i2).get(j);
                        newElement.utility = elementOfTable.utility + profitItemJ;
                        newElement.utilityLeft = elementOfTable.utilityLeft - (double)sumUtilityLeftUntilBetaPrime;
                        newElement.utilityLeftRight = elementOfTable.utilityLeftRight - profitItemJ - (double)sumUtilityLeftRightUntilBetaPrime;
                        sumUtilityLeftRightUntilBetaPrime = (int)((double)sumUtilityLeftRightUntilBetaPrime + profitItemJ);
                        int sumUtilityRigthItemSmallerThanX = 0;
                        int z = i2;
                        while (z < elementOfTable.positionBetaItemset) {
                            List<Integer> itemsetZ = sequence.getItemsets().get(z);
                            int w = 0;
                            while (w < itemsetZ.size()) {
                                boolean wEstD;
                                Integer itemW = itemsetZ.get(w);
                                if (itemW > itemJ) break;
                                boolean bl3 = wEstD = itemW > largestItemInConsequent && itemW < largestItemInAntecedent;
                                if (wEstD) {
                                    double profitItemW = sequence.getUtilities().get(z).get(w);
                                    sumUtilityRigthItemSmallerThanX = (int)((double)sumUtilityRigthItemSmallerThanX + profitItemW);
                                }
                                ++w;
                            }
                            ++z;
                        }
                        newElement.utilityRight = elementOfTable.utilityRight - (double)sumUtilityRigthItemSmallerThanX;
                        newElement.positionBetaItemset = i2;
                        newElement.positionAlphaItemset = elementOfTable.positionAlphaItemset;
                        tableItemJ.addElement(newElement);
                    }
                    ++j;
                }
                --i2;
            }
        }
        for (Map.Entry entry : mapItemsTables.entrySet()) {
            boolean shouldExpandRightSide;
            boolean shouldExpandLeftSide;
            Integer item = (Integer)entry.getKey();
            UtilityTable utilityTable = (UtilityTable)entry.getValue();
            if (this.deactivateStrategy4) {
                shouldExpandLeftSide = utilityTable.totalUtility + utilityTable.totalUtilityLeft + utilityTable.totalUtilityLeftRight + utilityTable.totalUtilityRight >= this.minutil && antecedent.length + 1 < this.maxSizeAntecedent;
                shouldExpandRightSide = utilityTable.totalUtility + utilityTable.totalUtilityRight + utilityTable.totalUtilityLeftRight + utilityTable.totalUtilityLeft >= this.minutil && consequent.length + 1 < this.maxSizeConsequent;
            } else {
                shouldExpandLeftSide = utilityTable.totalUtility + utilityTable.totalUtilityLeft + utilityTable.totalUtilityLeftRight >= this.minutil && antecedent.length + 1 < this.maxSizeAntecedent;
                shouldExpandRightSide = utilityTable.totalUtility + utilityTable.totalUtilityRight + utilityTable.totalUtilityLeftRight + utilityTable.totalUtilityLeft >= this.minutil && consequent.length + 1 < this.maxSizeConsequent;
            }
            boolean isHighUtility = utilityTable.totalUtility >= this.minutil;
            int[] newConsequent = new int[consequent.length + 1];
            System.arraycopy(consequent, 0, newConsequent, 0, consequent.length);
            newConsequent[consequent.length] = item;
            double confidence = (double)utilityTable.elements.size() / (double)sequenceIdsAntecedent.getSize();
            if (isHighUtility && confidence >= this.minConfidence) {
                this.saveRule(antecedent, newConsequent, utilityTable.totalUtility, utilityTable.elements.size(), confidence);
            }
            if (shouldExpandLeftSide) {
                this.expandFirstLeft(utilityTable, antecedent, newConsequent, sequenceIdsAntecedent);
            }
            if (!shouldExpandRightSide) continue;
            this.expandRight(utilityTable, antecedent, newConsequent, sequenceIdsAntecedent);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandFirstLeft(UtilityTable utilityTable, int[] antecedent, int[] consequent, ListSequenceIDs sequenceIDsConsequent) throws IOException {
        int largestItemInAntecedent = antecedent[antecedent.length - 1];
        HashMap<Integer, UtilityTableLeft> mapItemUtilityTable = new HashMap<Integer, UtilityTableLeft>();
        for (ElementOfTable element : utilityTable.elements) {
            if (element.utilityLeft == 0.0) continue;
            SequenceWithUtility sequence = this.database.getSequences().get(element.numeroSequence);
            int i = 0;
            while (i < element.positionBetaItemset) {
                List<Integer> itemsetI = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemsetI.size()) {
                    Integer itemJ = itemsetI.get(j);
                    if (itemJ > largestItemInAntecedent) {
                        UtilityTableLeft tableItemJ = (UtilityTableLeft)mapItemUtilityTable.get(itemJ);
                        if (tableItemJ == null) {
                            tableItemJ = new UtilityTableLeft();
                            mapItemUtilityTable.put(itemJ, tableItemJ);
                        }
                        ElementTableLeft newElement = new ElementTableLeft(element.numeroSequence);
                        double profitItemJ = sequence.getUtilities().get(i).get(j);
                        newElement.utility = element.utility + profitItemJ;
                        newElement.utilityLeft = this.deactivateStrategy4 ? element.utilityLeft + element.utilityLeftRight + element.utilityRight - profitItemJ : element.utilityLeft + element.utilityLeftRight - profitItemJ;
                        int z = 0;
                        while (z < element.positionBetaItemset) {
                            List<Integer> itemsetZ = sequence.getItemsets().get(z);
                            int w = itemsetZ.size() - 1;
                            while (w >= 0) {
                                Integer itemW = itemsetZ.get(w);
                                if (itemW <= largestItemInAntecedent) break;
                                if (itemJ > itemW) {
                                    double profitItemW = sequence.getUtilities().get(z).get(w);
                                    newElement.utilityLeft -= profitItemW;
                                }
                                --w;
                            }
                            ++z;
                        }
                        tableItemJ.addElement(newElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
        HashMap<Integer, Integer> tableBeta = null;
        for (Map.Entry entryItemTable : mapItemUtilityTable.entrySet()) {
            boolean isHighUtilityAndHighConfidence;
            Integer item = (Integer)entryItemTable.getKey();
            UtilityTableLeft tableItem = (UtilityTableLeft)entryItemTable.getValue();
            boolean shouldExpandLeftSide = (double)(tableItem.utility + tableItem.utilityLeft) >= this.minutil && antecedent.length + 1 < this.maxSizeAntecedent;
            ListSequenceIDs sequenceIdentifiersNewAntecedent = null;
            double confidence = 0.0;
            if (shouldExpandLeftSide || (double)tableItem.utility >= this.minutil) {
                ListSequenceIDs sequencesIdsItem = this.mapItemSequences.get(item);
                sequenceIdentifiersNewAntecedent = sequenceIDsConsequent.intersection(sequencesIdsItem);
                confidence = (double)tableItem.elements.size() / (double)sequenceIdentifiersNewAntecedent.getSize();
            }
            boolean bl = isHighUtilityAndHighConfidence = (double)tableItem.utility >= this.minutil && confidence >= this.minConfidence;
            if (isHighUtilityAndHighConfidence) {
                int[] nouvelAntecedent = new int[antecedent.length + 1];
                System.arraycopy(antecedent, 0, nouvelAntecedent, 0, antecedent.length);
                nouvelAntecedent[antecedent.length] = item;
                this.saveRule(nouvelAntecedent, consequent, tableItem.utility, tableItem.elements.size(), confidence);
            }
            if (!shouldExpandLeftSide) continue;
            int[] newAntecedent = new int[antecedent.length + 1];
            System.arraycopy(antecedent, 0, newAntecedent, 0, antecedent.length);
            newAntecedent[antecedent.length] = item;
            if (tableBeta == null) {
                tableBeta = new HashMap<Integer, Integer>();
                for (ElementOfTable element : utilityTable.elements) {
                    tableBeta.put(element.numeroSequence, element.positionBetaItemset);
                }
            }
            this.expandSecondLeft(tableItem, newAntecedent, consequent, sequenceIdentifiersNewAntecedent, tableBeta);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void expandSecondLeft(UtilityTableLeft utilityTable, int[] antecedent, int[] consequent, ListSequenceIDs sequenceIDsConsequent, Map<Integer, Integer> tableBeta) throws IOException {
        int largestItemInAntecedent = antecedent[antecedent.length - 1];
        HashMap<Integer, UtilityTableLeft> mapItemUtilityTable = new HashMap<Integer, UtilityTableLeft>();
        for (ElementTableLeft elementTableLeft : utilityTable.elements) {
            if (elementTableLeft.utilityLeft == 0.0) continue;
            SequenceWithUtility sequence = this.database.getSequences().get(elementTableLeft.sequenceID);
            Integer positionBetaItemset = tableBeta.get(elementTableLeft.sequenceID);
            int i = 0;
            while (i < positionBetaItemset) {
                List<Integer> itemsetI = sequence.getItemsets().get(i);
                int j = 0;
                while (j < itemsetI.size()) {
                    Integer itemJ = itemsetI.get(j);
                    if (itemJ > largestItemInAntecedent) {
                        UtilityTableLeft tableItemJ = (UtilityTableLeft)mapItemUtilityTable.get(itemJ);
                        if (tableItemJ == null) {
                            tableItemJ = new UtilityTableLeft();
                            mapItemUtilityTable.put(itemJ, tableItemJ);
                        }
                        ElementTableLeft newElement = new ElementTableLeft(elementTableLeft.sequenceID);
                        double utilityItemJ = sequence.getUtilities().get(i).get(j);
                        newElement.utility = elementTableLeft.utility + utilityItemJ;
                        newElement.utilityLeft = elementTableLeft.utilityLeft - utilityItemJ;
                        int z = 0;
                        while (z < positionBetaItemset) {
                            List<Integer> itemsetZ = sequence.getItemsets().get(z);
                            int w = itemsetZ.size() - 1;
                            while (w >= 0) {
                                Integer itemW = itemsetZ.get(w);
                                if (itemW <= largestItemInAntecedent) break;
                                if (itemW < itemJ) {
                                    double utilityItemW = sequence.getUtilities().get(z).get(w);
                                    newElement.utilityLeft -= utilityItemW;
                                }
                                --w;
                            }
                            ++z;
                        }
                        tableItemJ.addElement(newElement);
                    }
                    ++j;
                }
                ++i;
            }
        }
        for (Map.Entry entry : mapItemUtilityTable.entrySet()) {
            Integer item = (Integer)entry.getKey();
            UtilityTableLeft tableItem = (UtilityTableLeft)entry.getValue();
            boolean shouldExpandLeft = (double)(tableItem.utility + tableItem.utilityLeft) >= this.minutil && antecedent.length + 1 < this.maxSizeAntecedent;
            boolean isHighUtility = (double)tableItem.utility >= this.minutil;
            double confidence = 0.0;
            ListSequenceIDs sequenceIdentifiersNewAntecedent = null;
            if (shouldExpandLeft || isHighUtility) {
                ListSequenceIDs numerosequencesItem = this.mapItemSequences.get(item);
                sequenceIdentifiersNewAntecedent = sequenceIDsConsequent.intersection(numerosequencesItem);
                confidence = (double)tableItem.elements.size() / (double)sequenceIdentifiersNewAntecedent.getSize();
            }
            if (isHighUtility && confidence >= this.minConfidence) {
                int[] newAntecedent = new int[antecedent.length + 1];
                System.arraycopy(antecedent, 0, newAntecedent, 0, antecedent.length);
                newAntecedent[antecedent.length] = item;
                this.saveRule(newAntecedent, consequent, tableItem.utility, tableItem.elements.size(), confidence);
            }
            if (!shouldExpandLeft) continue;
            int[] nouvelAntecedent = new int[antecedent.length + 1];
            System.arraycopy(antecedent, 0, nouvelAntecedent, 0, antecedent.length);
            nouvelAntecedent[antecedent.length] = item;
            this.expandSecondLeft(tableItem, nouvelAntecedent, consequent, sequenceIdentifiersNewAntecedent, tableBeta);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void printStats() {
        System.out.println("=============== HUSRM algorithm v. 2.52 ===================");
        System.out.println(" Sequential rules count: " + this.ruleCount);
        System.out.println(" Total time : " + (this.timeEnd - this.timeStart) + " ms");
        System.out.println(" Max memory (mb) : " + MemoryLogger.getInstance().getMaxMemory());
        System.out.println("============================================================");
    }

    public class ElementOfTable {
        int numeroSequence;
        double utility;
        double utilityLeft;
        double utilityLeftRight;
        double utilityRight;
        int positionAlphaItemset = -1;
        int positionBetaItemset = -1;

        public ElementOfTable(int sequenceID) {
            this.numeroSequence = sequenceID;
            this.utility = 0.0;
            this.utilityLeft = 0.0;
            this.utilityLeftRight = 0.0;
            this.utilityRight = 0.0;
        }

        public ElementOfTable(int sequenceID, double utility, double utilityLeft, double utilityLeftRight, double utilityRight) {
            this.numeroSequence = sequenceID;
            this.utility = utility;
            this.utilityLeft = utilityLeft;
            this.utilityLeftRight = utilityLeftRight;
            this.utilityRight = utilityRight;
        }
    }

    public class ElementTableLeft {
        int sequenceID;
        double utility;
        double utilityLeft;

        public ElementTableLeft(int sequenceID) {
            this.sequenceID = sequenceID;
            this.utility = 0.0;
            this.utilityLeft = 0.0;
        }

        public ElementTableLeft(int sequenceID, int utility, int utilityLeft) {
            this.sequenceID = sequenceID;
            this.utility = utility;
            this.utilityLeft = utilityLeft;
        }
    }

    public class EstimatedUtilityAndSequences {
        Double utility = 0.0;
        List<Integer> sequenceIds = new ArrayList<Integer>();
    }

    public static interface ListSequenceIDs {
        public void addSequenceID(int var1);

        public int getSize();

        public ListSequenceIDs intersection(ListSequenceIDs var1);
    }

    public class ListSequenceIDsArrayList
    implements ListSequenceIDs {
        List<Integer> list = new ArrayList<Integer>();

        @Override
        public void addSequenceID(int noSequence) {
            this.list.add(noSequence);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public ListSequenceIDs intersection(ListSequenceIDs list2) {
            ListSequenceIDsArrayList arrayList2 = (ListSequenceIDsArrayList)list2;
            ListSequenceIDsArrayList result = new ListSequenceIDsArrayList();
            for (Integer no : this.list) {
                boolean appearInSecondList;
                boolean bl = appearInSecondList = Collections.binarySearch(arrayList2.list, no) >= 0;
                if (!appearInSecondList) continue;
                result.addSequenceID(no);
            }
            return result;
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public class ListSequenceIDsBitVector
    implements ListSequenceIDs {
        private BitSet bitset = new BitSet();
        private int size = -1;

        @Override
        public void addSequenceID(int bit) {
            this.bitset.set(bit);
        }

        @Override
        public int getSize() {
            if (this.size == -1) {
                this.size = this.bitset.cardinality();
            }
            return this.size;
        }

        @Override
        public ListSequenceIDs intersection(ListSequenceIDs vector2) {
            ListSequenceIDsBitVector bitVector2 = (ListSequenceIDsBitVector)vector2;
            ListSequenceIDsBitVector result = new ListSequenceIDsBitVector();
            result.bitset = (BitSet)this.bitset.clone();
            result.bitset.and(bitVector2.bitset);
            return result;
        }

        public String toString() {
            return this.bitset.toString();
        }
    }

    public class UtilityTable {
        List<ElementOfTable> elements = new ArrayList<ElementOfTable>();
        double totalUtility = 0.0;
        double totalUtilityLeft = 0.0;
        double totalUtilityLeftRight = 0.0;
        double totalUtilityRight = 0.0;

        public void addElement(ElementOfTable element) {
            this.elements.add(element);
            this.totalUtility += element.utility;
            this.totalUtilityLeft += element.utilityLeft;
            this.totalUtilityLeftRight += element.utilityLeftRight;
            this.totalUtilityRight += element.utilityRight;
        }
    }

    public class UtilityTableLeft {
        List<ElementTableLeft> elements = new ArrayList<ElementTableLeft>();
        int utility = 0;
        int utilityLeft = 0;

        public void addElement(ElementTableLeft element) {
            this.elements.add(element);
            this.utility = (int)((double)this.utility + element.utility);
            this.utilityLeft = (int)((double)this.utilityLeft + element.utilityLeft);
        }
    }
}

