/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequential_rules.cmrules;

import ca.pfv.spmf.datastructures.triangularmatrix.TriangularMatrix;
import ca.pfv.spmf.input.transaction_database_list_integers.TransactionDatabase;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoAprioriTID_forCMRules {
    protected Itemsets frequentItemsets = new Itemsets("FREQUENT ITEMSETS");
    protected TransactionDatabase database;
    protected int k;
    TriangularMatrix matrix;
    int minSuppRelative;
    int maxItemsetSize = Integer.MAX_VALUE;

    public AlgoAprioriTID_forCMRules(TransactionDatabase database, TriangularMatrix matrix) {
        this.database = database;
        this.matrix = matrix;
    }

    public Itemsets runAlgorithm(int minsuppRelative, List<Integer> listFrequentsSize1, Map<Integer, Set<Integer>> mapItemCount) {
        this.minSuppRelative = minsuppRelative;
        this.k = 1;
        List<Itemset> level = this.createLevelWithFrequentItemsetsSize1(listFrequentsSize1, mapItemCount);
        this.k = 2;
        while (!level.isEmpty() && this.k <= this.maxItemsetSize) {
            level = this.generateCandidateSizeK(level);
            ++this.k;
        }
        return this.frequentItemsets;
    }

    protected List<Itemset> createLevelWithFrequentItemsetsSize1(List<Integer> listFrequentsSize1, Map<Integer, Set<Integer>> mapItemCount) {
        ArrayList<Itemset> levelK = new ArrayList<Itemset>();
        for (Integer item : listFrequentsSize1) {
            Itemset itemset2 = new Itemset(item);
            itemset2.setTIDs(mapItemCount.get(item));
            levelK.add(itemset2);
            this.frequentItemsets.addItemset(itemset2, this.k);
        }
        return levelK;
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1) {
        ArrayList<Itemset> candidates = new ArrayList<Itemset>();
        int i = 0;
        while (i < levelK_1.size()) {
            Itemset itemset1 = levelK_1.get(i);
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block9: {
                    Itemset itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.size()) {
                        if (k == itemset1.size() - 1) {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                break block1;
                            }
                        } else {
                            if (itemset1.getItems()[k] >= itemset2.get(k)) {
                                if (itemset1.getItems()[k] > itemset2.get(k)) break block1;
                            }
                            break block9;
                        }
                        ++k;
                    }
                    HashSet<Integer> list = new HashSet<Integer>();
                    for (Integer val1 : itemset1.getTransactionsIds()) {
                        if (!itemset2.getTransactionsIds().contains(val1)) continue;
                        list.add(val1);
                    }
                    if (list.size() >= this.minSuppRelative) {
                        int[] newItemset = new int[itemset1.size() + 1];
                        System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                        newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                        Itemset candidate = new Itemset(newItemset);
                        candidate.setTIDs(list);
                        candidates.add(candidate);
                        this.frequentItemsets.addItemset(candidate, this.k);
                    }
                }
                ++j;
            }
            ++i;
        }
        return candidates;
    }

    public Itemsets getItemsets() {
        return this.frequentItemsets;
    }

    public void setMaxItemsetSize(int maxItemsetSize) {
        this.maxItemsetSize = maxItemsetSize;
    }
}

