/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.ScoreDistribution;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.Bitvector;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPTPlus.CPTHelper;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CountTable
implements Serializable {
    private TreeMap<Integer, Float> table = new TreeMap();
    private HashSet<Integer> branchVisited = new HashSet();
    private CPTHelper helper;

    public CountTable(CPTHelper helper) {
        this.helper = helper;
    }

    public void push(Integer key, int curSeqLength, int fullSeqLength, int numberOfSeqSameLength, int dist) {
        float weightLevel = 1.0f / (float)numberOfSeqSameLength;
        float weightDistance = 1.0f / (float)dist;
        float curValue = weightLevel * 1.0f + 1.0f + weightDistance * 1.0E-4f;
        Float oldVal = this.table.get(key);
        if (oldVal == null) {
            this.table.put(key, Float.valueOf(curValue));
        } else {
            this.table.put(key, Float.valueOf(oldVal.floatValue() * curValue));
        }
    }

    public int update(Item[] sequence, int initialSequenceSize) {
        int branchesUsed = 0;
        Bitvector ids = this.helper.getSimilarSequencesIds(sequence);
        int id = ids.nextSetBit(0);
        while (id >= 0) {
            if (!this.branchVisited.contains(id)) {
                this.branchVisited.add(id);
                Item[] seq = this.helper.getSequenceFromId(id);
                HashSet<Item> toAvoid = new HashSet<Item>();
                Item[] itemArray = sequence;
                int n = sequence.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    toAvoid.add(item);
                    ++n2;
                }
                int max = 99;
                int count = 1;
                Item[] itemArray2 = seq;
                int n3 = seq.length;
                int n4 = 0;
                while (n4 < n3) {
                    Item item = itemArray2[n4];
                    if (toAvoid.size() == 0 && count < max) {
                        this.push(item.val, sequence.length, initialSequenceSize, ids.cardinality(), count);
                        ++count;
                    } else if (toAvoid.contains(item)) {
                        toAvoid.remove(item);
                    }
                    ++n4;
                }
                if (count > 1) {
                    ++branchesUsed;
                }
            }
            id = ids.nextSetBit(id + 1);
        }
        return branchesUsed;
    }

    public Sequence getBestSequence(int count) {
        ScoreDistribution<Integer> sd = new ScoreDistribution<Integer>();
        for (Map.Entry<Integer, Float> it : this.table.entrySet()) {
            double confidence;
            double score = confidence = (double)it.getValue().floatValue();
            sd.put(it.getKey(), score);
        }
        Sequence seq = new Sequence(-1);
        List bestItems = sd.getBest(1.002);
        if (bestItems != null && bestItems.size() > 0) {
            int i = 0;
            while (i < count && i < bestItems.size()) {
                seq.addItem(new Item((Integer)bestItems.get(i)));
                ++i;
            }
        }
        return seq;
    }

    public TreeMap<Integer, Float> getTable() {
        return this.table;
    }
}

