/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPT;

import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Item;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.database.Sequence;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers.MemoryLogger;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPT.CPTHelper;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.CPT.CPT.PredictionTree;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Paramable;
import ca.pfv.spmf.algorithms.sequenceprediction.ipredict.predictor.Predictor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CPTPredictor_POC
extends Predictor {
    private PredictionTree Root = new PredictionTree();
    private Map<Integer, PredictionTree> LT = new HashMap<Integer, PredictionTree>();
    private Map<Integer, BitSet> II = new HashMap<Integer, BitSet>();
    private String TAG = "CPT13";
    private long nodeNumber = 0L;
    public Paramable parameters = new Paramable();

    public CPTPredictor_POC() {
    }

    public CPTPredictor_POC(String tag) {
        this();
        this.TAG = tag;
    }

    public CPTPredictor_POC(String tag, String params) {
        this(tag);
        this.parameters.setParameter(params);
    }

    private List<Integer> getMatchingSequences(Sequence target) {
        List<Item> items = target.getItems();
        BitSet intersection = null;
        int i = 0;
        while (i < items.size()) {
            BitSet bitset = this.II.get(items.get((int)i).val);
            if (bitset != null) {
                if (intersection == null) {
                    intersection = (BitSet)bitset.clone();
                } else {
                    intersection.and(bitset);
                }
            }
            ++i;
        }
        if (intersection == null || intersection.cardinality() == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> lastIndexes = new ArrayList<Integer>(intersection.cardinality());
        int i2 = intersection.nextSetBit(0);
        while (i2 >= 0) {
            lastIndexes.add(i2);
            i2 = intersection.nextSetBit(i2 + 1);
        }
        return lastIndexes;
    }

    private void UpdateCountTable(Sequence target, float weight, Map<Integer, Float> CountTable2, HashSet<Integer> hashSidVisited) {
        List<Integer> indexes = this.getMatchingSequences(target);
        HashSet<Integer> hashTarget = new HashSet<Integer>();
        for (Item it : target.getItems()) {
            hashTarget.add(it.val);
        }
        for (Integer index : indexes) {
            if (hashSidVisited.contains(index)) continue;
            PredictionTree curNode = this.LT.get(index);
            ArrayList<Item> branch = new ArrayList<Item>();
            while (curNode.Parent != this.Root) {
                branch.add(curNode.Item);
                curNode = curNode.Parent;
            }
            Collections.reverse(branch);
            HashSet hashTargetTMP = new HashSet(hashTarget);
            int i = 0;
            i = 0;
            while (i < branch.size() && hashTargetTMP.size() > 0) {
                if (hashTargetTMP.contains(((Item)branch.get((int)i)).val)) {
                    hashTargetTMP.remove(((Item)branch.get((int)i)).val);
                }
                ++i;
            }
            while (i < branch.size()) {
                float oldValue = 0.0f;
                if (CountTable2.containsKey(((Item)branch.get((int)i)).val)) {
                    oldValue = CountTable2.get(((Item)branch.get((int)i)).val).floatValue();
                }
                float curValue = 1.0f / (float)indexes.size();
                CountTable2.put(((Item)branch.get((int)i)).val, Float.valueOf(oldValue + weight / (float)indexes.size()));
                hashSidVisited.add(index);
                ++i;
            }
        }
    }

    private Sequence getBestSequenceFromCountTable(Map<Integer, Float> CountTable2, boolean useLift) {
        double maxValue = -1.0;
        double secondMaxValue = -1.0;
        Integer maxItem = -1;
        for (Map.Entry<Integer, Float> it : CountTable2.entrySet()) {
            double lift = it.getValue().floatValue() / (float)this.II.get(it.getKey()).cardinality();
            double support = this.II.get(it.getKey()).cardinality();
            double confidence = it.getValue().floatValue();
            double score = confidence;
            if (score > maxValue) {
                secondMaxValue = maxValue;
                maxItem = it.getKey();
                maxValue = score;
                continue;
            }
            if (!(score > secondMaxValue)) continue;
            secondMaxValue = score;
        }
        Sequence predicted = new Sequence(-1);
        double diff = 1.0 - secondMaxValue / maxValue;
        if (maxItem != -1) {
            if (secondMaxValue == -1.0 || diff >= 0.0) {
                Item predictedItem = new Item(maxItem);
                predicted.addItem(predictedItem);
            } else {
                double highestScore = 0.0;
                int newBestItem = -1;
                for (Map.Entry<Integer, Float> it : CountTable2.entrySet()) {
                    double lift;
                    double score;
                    if (maxValue != (double)it.getValue().floatValue() || !this.II.containsKey(it.getKey()) || !((score = (lift = (double)(it.getValue().floatValue() / (float)this.II.get(it.getKey()).cardinality()))) > highestScore)) continue;
                    highestScore = score;
                    newBestItem = it.getKey();
                }
                Item predictedItem = new Item(newBestItem);
                predicted.addItem(predictedItem);
            }
        }
        return predicted;
    }

    @Override
    public Sequence Predict(Sequence target) {
        Iterator<Item> iter = target.getItems().iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (this.II.get(item.val) != null) continue;
            iter.remove();
        }
        Sequence prediction = new Sequence(-1);
        int minRecursion = this.parameters.paramInt("recursiveDividerMin");
        int maxRecursion = this.parameters.paramInt("recursiveDividerMax") > target.size() ? target.size() : this.parameters.paramInt("recursiveDividerMax").intValue();
        int i = minRecursion;
        while (i < target.size() && prediction.size() == 0 && i < maxRecursion) {
            HashSet<Integer> hashSidVisited = new HashSet<Integer>();
            int minSize = target.size() - i;
            boolean useLift = false;
            ArrayList<Sequence> subSequences = new ArrayList<Sequence>();
            CPTHelper.RecursiveDivider(subSequences, target, minSize);
            HashMap<Integer, Float> CountTable2 = new HashMap<Integer, Float>();
            for (Sequence sequence : subSequences) {
                float weight = (float)sequence.size() / (float)target.size();
                this.UpdateCountTable(sequence, weight, CountTable2, hashSidVisited);
            }
            prediction = this.getBestSequenceFromCountTable(CountTable2, useLift);
            ++i;
        }
        return prediction;
    }

    @Override
    public String getTAG() {
        return this.TAG;
    }

    @Override
    public Boolean Train(List<Sequence> trainingSequences) {
        this.nodeNumber = 0L;
        int seqId = 0;
        this.Root = new PredictionTree();
        this.LT = new HashMap<Integer, PredictionTree>();
        this.II = new HashMap<Integer, BitSet>();
        MemoryLogger.addUpdate();
        ArrayList<Sequence> newTrainingSet = new ArrayList<Sequence>();
        for (Sequence seq : trainingSequences) {
            if (seq.size() > this.parameters.paramInt("splitLength") && this.parameters.paramInt("splitMethod") > 0) {
                if (this.parameters.paramInt("splitMethod") == 1) {
                    newTrainingSet.addAll(CPTHelper.sliceBasic(seq, this.parameters.paramInt("splitLength")));
                    continue;
                }
                newTrainingSet.addAll(CPTHelper.slice(seq, this.parameters.paramInt("splitLength")));
                continue;
            }
            newTrainingSet.add(seq);
        }
        for (Sequence curSeq : newTrainingSet) {
            PredictionTree curNode = this.Root;
            for (Item it : curSeq.getItems()) {
                if (!this.II.containsKey(it.val)) {
                    BitSet tmpBitset = new BitSet();
                    this.II.put(it.val, tmpBitset);
                }
                this.II.get(it.val).set(seqId);
                if (!curNode.hasChild(it).booleanValue()) {
                    curNode.addChild(it);
                    ++this.nodeNumber;
                }
                curNode = curNode.getChild(it);
            }
            this.LT.put(seqId, curNode);
            ++seqId;
        }
        MemoryLogger.addUpdate();
        return true;
    }

    @Override
    public long size() {
        return this.nodeNumber;
    }

    @Override
    public float memoryUsage() {
        return 0.0f;
    }
}

