/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequenceprediction.ipredict.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class ScoreDistribution<K> {
    private TreeMap<Double, List<K>> dict = new TreeMap();

    public void put(K key, Double value) {
        List<K> keys = this.dict.get(value);
        if (keys == null) {
            keys = new ArrayList<K>();
        }
        keys.add(key);
        this.dict.put(value, keys);
    }

    public void clear() {
        this.dict.clear();
    }

    public List<K> getBest(double minThreshold) {
        if (this.dict.size() == 0) {
            return null;
        }
        if (this.dict.size() == 1) {
            return this.dict.lastEntry().getValue();
        }
        Double bestVal1 = this.dict.lastKey();
        Double bestVal2 = this.dict.lowerKey(bestVal1);
        if (bestVal1 / bestVal2 < minThreshold) {
            return null;
        }
        return this.dict.get(bestVal1);
    }

    public List<K> getNextBest(double best) {
        Double nextBest = this.dict.lowerKey(best);
        if (nextBest == null) {
            return null;
        }
        return this.dict.get(nextBest);
    }
}

