/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class STPSet {
    private int size;
    private Map<Integer, Set<Integer>> STPMapping;

    public STPSet() {
        this.size = 0;
        this.STPMapping = new HashMap<Integer, Set<Integer>>();
    }

    public STPSet(List<Integer> timestamps, List<Set<Integer>> vIdSets) {
        this.STPMapping = new HashMap<Integer, Set<Integer>>();
        int i = 0;
        while (i < timestamps.size()) {
            int timestamp = timestamps.get(i);
            Set<Integer> vIdSet = vIdSets.get(i);
            this.size += vIdSet == null ? 0 : vIdSet.size();
            this.STPMapping.put(timestamp, vIdSets.get(i));
            ++i;
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public static STPSet mergeSTPSets(List<STPSet> stpSets) {
        STPSet retSTPSet = new STPSet();
        int sup = 0;
        for (STPSet stpSet : stpSets) {
            for (Integer timestamp : stpSet.getTimestamps()) {
                Set<Integer> vIdSet = stpSet.getVIdSet4Timestamp(timestamp);
                retSTPSet.addTimestampAndVIdSet(timestamp, vIdSet);
            }
            sup += stpSet.getSize();
        }
        retSTPSet.setSize(sup);
        return retSTPSet;
    }

    public void addSTP(int timestamp, int vId) {
        Set<Integer> vIdSet = this.STPMapping.get(timestamp);
        if (vIdSet == null) {
            vIdSet = new HashSet<Integer>();
            this.STPMapping.put(timestamp, vIdSet);
        }
        vIdSet.add(vId);
        ++this.size;
    }

    private void addTimestampAndVIdSet(Integer timestamp, Set<Integer> newVIdSet) {
        Set<Integer> vIdSet = this.STPMapping.get(timestamp);
        if (vIdSet == null) {
            vIdSet = new HashSet<Integer>();
            this.STPMapping.put(timestamp, vIdSet);
        }
        if (newVIdSet != null) {
            vIdSet.addAll(newVIdSet);
        }
    }

    public STPSet intersect(STPSet another) {
        LinkedList<Integer> timestamps = new LinkedList<Integer>();
        LinkedList<Set<Integer>> vIdSets = new LinkedList<Set<Integer>>();
        for (int timestamp : this.STPMapping.keySet()) {
            HashSet<Integer> retSet = new HashSet<Integer>();
            Set<Integer> vIdSet1 = this.STPMapping.get(timestamp);
            Set<Integer> vIdSet2 = another.getVIdSet4Timestamp(timestamp);
            if (vIdSet1 == null || vIdSet2 == null) continue;
            retSet.addAll(vIdSet1);
            retSet.retainAll(vIdSet2);
            if (retSet.size() == 0) continue;
            timestamps.add(timestamp);
            vIdSets.add(retSet);
        }
        STPSet ret = new STPSet(timestamps, vIdSets);
        return ret;
    }

    public Iterable<Integer> getTimestamps() {
        return this.STPMapping.keySet();
    }

    public Set<Integer> getVIdSet4Timestamp(int timestamp) {
        return this.STPMapping.get(timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#SUP:").append(this.size);
        sb.append("\nsupporting points:\n");
        for (int timestamp : this.STPMapping.keySet()) {
            sb.append("[").append(timestamp).append("] {");
            for (int vId : this.STPMapping.get(timestamp)) {
                sb.append(vId).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("}").append("\n");
        }
        return sb.toString();
    }

    public int getSize() {
        return this.size;
    }
}

