/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import java.util.Arrays;
import java.util.List;

public class Itemset
implements Comparable<Itemset> {
    private int[] items;
    private int size;

    public Itemset(List<Integer> prefixItems, Integer newItem) {
        this.size = prefixItems.size() + 1;
        this.items = new int[this.size];
        int i = 0;
        while (i < prefixItems.size()) {
            this.items[i] = prefixItems.get(i);
            ++i;
        }
        this.items[this.size - 1] = newItem;
        Arrays.sort(this.items);
    }

    public Itemset(String str) {
        String newStr = str.substring(1, str.length() - 1);
        String[] splitItems = newStr.split(",");
        this.size = splitItems.length;
        this.items = new int[this.size];
        int i = 0;
        while (i < this.size) {
            this.items[i] = Integer.parseInt(splitItems[i]);
            ++i;
        }
        Arrays.sort(this.items);
    }

    public int[] getItems() {
        return this.items;
    }

    public int getItemAT(int i) {
        return this.items[i];
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSupersetOf(Itemset another) {
        int thisLength = this.items.length;
        int anotherLength = another.size;
        int[] anotherItems = another.items;
        if (thisLength < anotherLength) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < thisLength && j < anotherLength) {
            if (this.items[i] > anotherItems[j]) {
                return false;
            }
            if (this.items[i] == anotherItems[j]) {
                ++i;
                ++j;
                continue;
            }
            ++i;
        }
        return i == thisLength && j == anotherLength || i != thisLength;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int[] nArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sb.append(i).append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public static void main(String[] args) {
        Itemset itemset1 = new Itemset("(4,5,1)");
        Itemset itemset2 = new Itemset("(1,5)");
        System.out.println(itemset1.isSupersetOf(itemset2));
    }

    @Override
    public int compareTo(Itemset o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof Itemset)) {
            return 1;
        }
        Itemset that = o;
        int commeonL = this.size > that.getSize() ? that.getSize() : this.size;
        int i = 0;
        while (i < commeonL) {
            if (this.items[i] < that.getItemAT(i)) {
                return -1;
            }
            if (this.items[i] > that.getItemAT(i)) {
                return 1;
            }
            ++i;
        }
        return this.size - that.getSize();
    }
}

