/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tseqminer;

import ca.pfv.spmf.algorithms.graph_mining.tseqminer.EclatAlgo;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ItemAttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.Itemset;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ParametersSetting;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.Preprocess;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.STPSet;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoTSeqMiner {
    private Map<Integer, ItemAttributedGraph> timestampMapItemAG;
    private int totalNumVertex;
    private Map<Integer, String> eventTypeMapName;
    private Map<Itemset, STPSet> itemsetMapSTPSet;
    private Map<Itemset, Double> itemsetMapSup;
    private int totalItemsetNum;
    private static Map<Integer, Set<Itemset>> levelMapItemsets;
    private static Map<Itemset, List<Itemset>> itemsetMapSuperset;
    private static Map<Itemset, Double> itemsetMapMinSup;
    private static BufferedWriter bw;
    private boolean INTERPRET_RESULT = true;
    private Map<Integer, String> vertexMapName;
    private static Map<Itemset, Set<Itemset>> itemsetMapDominantsSuperset;
    private long totalMiningTime = 0L;
    private int patternCount = 0;
    private static NumberFormat nf;

    static {
        nf = NumberFormat.getInstance();
    }

    public void runAlgorithm(String inputDirectory, String outputPath, float discretizationThreshold, float minInitSup, int minTailSup, float minSig, int attributeCount) throws IOException {
        ParametersSetting.INCRE_THRESHOLD = discretizationThreshold;
        ParametersSetting.MINSUP = minInitSup;
        ParametersSetting.MIN_TAIL_SUP = minTailSup;
        ParametersSetting.MIN_SIGNIFICANCE = minSig;
        ParametersSetting.TOTAL_NUM_ATTR = attributeCount;
        ParametersSetting.EDGE_FILE_PATH = String.valueOf(inputDirectory) + "graph.txt";
        ParametersSetting.ATTRI_MAPPING_PATH = String.valueOf(inputDirectory) + "attributes_mapping.txt";
        ParametersSetting.ATTR_FILE_PATH = String.valueOf(inputDirectory) + "attributes.txt";
        ParametersSetting.VERTEX_MAP_NAME_PATH = String.valueOf(inputDirectory) + "vertices_mapping.txt";
        File resDir = new File(String.valueOf(inputDirectory) + "result");
        File preprocessDir = new File(String.valueOf(inputDirectory) + "preprocess");
        if (!resDir.exists()) {
            resDir.mkdir();
        }
        if (!preprocessDir.exists()) {
            preprocessDir.mkdir();
        }
        ParametersSetting.PATTERN_PATH = outputPath;
        ParametersSetting.TRANSACTION_PATH = String.valueOf(inputDirectory) + "preprocess" + File.separator + "transactions.txt";
        ParametersSetting.EVENTTYPE_MAPPING_PATH = String.valueOf(inputDirectory) + "preprocess" + File.separator + "event_type_mapping.txt";
        ParametersSetting.FRE_ITEMSET_PATH = "frequent_itemset.txt";
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        long t1 = System.currentTimeMillis();
        this.readFrequentItemsetFromEclat();
        this.getItemDyAGFromPreprocessing();
        this.getBasicMappings();
        this.getItemsetMapSuperMinAndMapDominants();
        long t2 = System.currentTimeMillis();
        ParametersSetting.PREPARE = t2 - t1;
        nf.setMaximumFractionDigits(1);
        File patternPathFile = new File(ParametersSetting.PATTERN_PATH);
        if (!patternPathFile.exists()) {
            patternPathFile.createNewFile();
        }
        System.out.println(ParametersSetting.PATTERN_PATH);
        bw = new BufferedWriter(new FileWriter(ParametersSetting.PATTERN_PATH));
        String head = "sequence     support of tail itemset     significance\n";
        bw.write(head);
        MemoryLogger.getInstance().checkMemory();
        switch (ParametersSetting.TRAVERSAL_FLAG) {
            case 0: {
                this.seqMinerDFS();
                break;
            }
            case 1: {
                this.seqMinerTwoPhase(true);
                break;
            }
            case 2: {
                this.seqMinerTwoPhase(false);
            }
        }
        bw.close();
        this.totalMiningTime = System.currentTimeMillis() - t2;
    }

    private void seqMinerDFS() throws IOException {
        LinkedList<Itemset> prefix = new LinkedList<Itemset>();
        LinkedList<STPSet> prefixSTPSet = new LinkedList<STPSet>();
        LinkedList<Double> prefixSigList = new LinkedList<Double>();
        for (Map.Entry<Itemset, STPSet> entry : this.itemsetMapSTPSet.entrySet()) {
            Itemset itemset2 = entry.getKey();
            STPSet stpSet = entry.getValue();
            List<STPSet> neighboringPointsSet = this.acquireNeighboringPointsSet(stpSet);
            prefix.add(itemset2);
            prefixSTPSet.add(this.itemsetMapSTPSet.get(itemset2));
            prefixSigList.add(999.0);
            for (Itemset nextItemset : levelMapItemsets.get(1)) {
                LinkedList<Double> significanceList = new LinkedList<Double>();
                significanceList.add(9999.0);
                this.seqMinerDFSHelper(prefix, prefixSTPSet, prefixSigList, nextItemset, neighboringPointsSet);
            }
            prefix.remove(prefix.size() - 1);
            prefixSTPSet.remove(prefixSTPSet.size() - 1);
            prefixSigList.remove(prefixSigList.size() - 1);
        }
    }

    private void seqMinerDFSHelper(List<Itemset> prefix, List<STPSet> prefixSTPSet, List<Double> prefixSigList, Itemset itemset2, List<STPSet> neighborings) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        double originSup = this.itemsetMapSup.get(itemset2);
        LinkedList<STPSet> candidateList = new LinkedList<STPSet>();
        double localSupRatio = this.computeAvgLocalSupRatio(neighborings, itemset2, candidateList);
        STPSet candidateSTP = (STPSet)candidateList.get(0);
        double itSignificance = localSupRatio / originSup;
        if (itSignificance >= ParametersSetting.MIN_SIGNIFICANCE) {
            if (candidateSTP.getSize() >= ParametersSetting.MIN_TAIL_SUP) {
                if (ParametersSetting.OUTPUT_PATTERNS) {
                    this.saveSequencePattern(prefix, prefixSTPSet, prefixSigList, itemset2, candidateSTP, itSignificance);
                    ++this.patternCount;
                }
                prefix.add(itemset2);
                prefixSTPSet.add(candidateSTP);
                prefixSigList.add(itSignificance);
                List<STPSet> nextNeighbors = this.acquireNeighboringPointsSet(candidateSTP);
                for (Itemset nextItemset : levelMapItemsets.get(1)) {
                    this.seqMinerDFSHelper(prefix, prefixSTPSet, prefixSigList, nextItemset, nextNeighbors);
                }
                prefix.remove(prefix.size() - 1);
                prefixSigList.remove(prefixSigList.size() - 1);
                prefixSTPSet.remove(prefixSTPSet.size() - 1);
            }
            for (Itemset nextItemsetSameStep : itemsetMapDominantsSuperset.get(itemset2)) {
                this.seqMinerDFSHelper(prefix, prefixSTPSet, prefixSigList, nextItemsetSameStep, neighborings);
            }
        } else if (ParametersSetting.ADOPTING_PRUNING) {
            double supMinSup = itemsetMapMinSup.get(itemset2);
            double slackSignificance = localSupRatio / supMinSup;
            if (slackSignificance < ParametersSetting.MIN_SIGNIFICANCE) {
                return;
            }
            if (ParametersSetting.MINI_GRAINED_PRUNING) {
                for (Itemset nextItemsetSameStep : itemsetMapDominantsSuperset.get(itemset2)) {
                    supMinSup = itemsetMapMinSup.get(nextItemsetSameStep);
                    slackSignificance = localSupRatio / supMinSup;
                    if (!(slackSignificance >= ParametersSetting.MIN_SIGNIFICANCE)) continue;
                    this.seqMinerDFSHelper(prefix, prefixSTPSet, prefixSigList, nextItemsetSameStep, neighborings);
                }
            } else {
                for (Itemset nextItemsetSameStep : itemsetMapDominantsSuperset.get(itemset2)) {
                    this.seqMinerDFSHelper(prefix, prefixSTPSet, prefixSigList, nextItemsetSameStep, neighborings);
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void seqMinerTwoPhase(boolean innerDFS) throws IOException {
        LinkedList<Itemset> itemsetList = new LinkedList<Itemset>();
        LinkedList<STPSet> stpSetList = new LinkedList<STPSet>();
        LinkedList<Double> sigList = new LinkedList<Double>();
        for (Map.Entry<Itemset, STPSet> entry : this.itemsetMapSTPSet.entrySet()) {
            itemsetList.add(entry.getKey());
            stpSetList.add(entry.getValue());
            sigList.add(999.0);
        }
        LinkedList<Double> prefixSigList = new LinkedList<Double>();
        this.dfsOuter(new LinkedList<Itemset>(), new LinkedList<STPSet>(), prefixSigList, itemsetList, stpSetList, sigList, innerDFS);
    }

    private void dfsOuter(List<Itemset> prefix, List<STPSet> prefixSTPSETList, List<Double> prefixSigList, List<Itemset> newItemsetList, List<STPSet> newTailSupportingPointsList, List<Double> newSigList, boolean innerDFS) throws IOException {
        int i = 0;
        while (i < newItemsetList.size()) {
            Itemset newItemset = newItemsetList.get(i);
            STPSet newStpSet = newTailSupportingPointsList.get(i);
            double newSig = newSigList.get(i);
            if (prefix.size() != 0 && ParametersSetting.OUTPUT_PATTERNS) {
                this.saveSequencePattern(prefix, prefixSTPSETList, prefixSigList, newItemset, newStpSet, newSig);
                ++this.patternCount;
            }
            List<STPSet> neighboringSTPSetList = this.acquireNeighboringPointsSet(newStpSet);
            LinkedList<Itemset> addedItemsetList = new LinkedList<Itemset>();
            LinkedList<STPSet> addedTailPointsList = new LinkedList<STPSet>();
            LinkedList<Double> addedSigList = new LinkedList<Double>();
            if (innerDFS) {
                this.dfsInner(neighboringSTPSetList, addedItemsetList, addedTailPointsList, addedSigList);
            } else {
                this.bfsInner(neighboringSTPSetList, addedItemsetList, addedTailPointsList, addedSigList);
            }
            if (addedItemsetList.size() != 0) {
                prefix.add(newItemset);
                prefixSTPSETList.add(newStpSet);
                prefixSigList.add(newSig);
                this.dfsOuter(prefix, prefixSTPSETList, prefixSigList, addedItemsetList, addedTailPointsList, addedSigList, innerDFS);
                prefixSTPSETList.remove(prefixSTPSETList.size() - 1);
                prefix.remove(prefix.size() - 1);
                prefixSigList.remove(prefixSigList.size() - 1);
            }
            MemoryLogger.getInstance().checkMemory();
            ++i;
        }
    }

    private void dfsInner(List<STPSet> neiboringSTPSetList, List<Itemset> addedItemsetList, List<STPSet> addedTailPointsList, List<Double> significanceList) throws IOException {
        for (Itemset itemset2 : levelMapItemsets.get(1)) {
            this.dfsInnerHelp(itemset2, neiboringSTPSetList, addedItemsetList, addedTailPointsList, significanceList);
        }
    }

    private void dfsInnerHelp(Itemset itemset2, List<STPSet> neiboringSTPSetList, List<Itemset> addedItemsetList, List<STPSet> addedTailPointsList, List<Double> significanceList) throws IOException {
        double originalSupRatio = this.itemsetMapSup.get(itemset2);
        LinkedList<STPSet> candidateSTPSetList = new LinkedList<STPSet>();
        double localSupRatio = this.computeAvgLocalSupRatio(neiboringSTPSetList, itemset2, candidateSTPSetList);
        double itSignificance = localSupRatio / originalSupRatio;
        STPSet candidateSTPSet = (STPSet)candidateSTPSetList.get(0);
        if (itSignificance >= ParametersSetting.MIN_SIGNIFICANCE) {
            if (candidateSTPSet.getSize() >= ParametersSetting.MIN_TAIL_SUP) {
                addedItemsetList.add(itemset2);
                addedTailPointsList.add(candidateSTPSet);
                significanceList.add(itSignificance);
            }
            for (Itemset nextItemset : itemsetMapDominantsSuperset.get(itemset2)) {
                this.dfsInnerHelp(nextItemset, neiboringSTPSetList, addedItemsetList, addedTailPointsList, significanceList);
            }
        } else if (ParametersSetting.ADOPTING_PRUNING) {
            double superMinSup = itemsetMapMinSup.get(itemset2);
            double slackSignificance = localSupRatio / superMinSup;
            if (slackSignificance < ParametersSetting.MIN_SIGNIFICANCE) {
                return;
            }
            if (ParametersSetting.MINI_GRAINED_PRUNING) {
                for (Itemset nextItemset : itemsetMapDominantsSuperset.get(itemset2)) {
                    superMinSup = itemsetMapMinSup.get(nextItemset);
                    slackSignificance = localSupRatio / superMinSup;
                    if (!(slackSignificance >= ParametersSetting.MIN_SIGNIFICANCE)) continue;
                    this.dfsInnerHelp(nextItemset, neiboringSTPSetList, addedItemsetList, addedTailPointsList, significanceList);
                }
            } else {
                for (Itemset nextItemset : itemsetMapDominantsSuperset.get(itemset2)) {
                    this.dfsInnerHelp(nextItemset, neiboringSTPSetList, addedItemsetList, addedTailPointsList, significanceList);
                }
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void bfsInner(List<STPSet> neiboringSTPSetList, List<Itemset> addedItemsetList, List<STPSet> addedTailPointsList, List<Double> significanceList) throws IOException {
        if (neiboringSTPSetList.isEmpty()) {
            return;
        }
        HashSet nextLevelItemsets = new HashSet();
        nextLevelItemsets.addAll(levelMapItemsets.get(1));
        HashSet currentLevelItemsets = null;
        int level = 1;
        while (level <= levelMapItemsets.keySet().size()) {
            currentLevelItemsets = nextLevelItemsets;
            nextLevelItemsets = null;
            if (levelMapItemsets.containsKey(level + 1)) {
                nextLevelItemsets = new HashSet();
                nextLevelItemsets.addAll(levelMapItemsets.get(level + 1));
            }
            for (Itemset itemset2 : currentLevelItemsets) {
                STPSet supSTP;
                double originalSupRatio = this.itemsetMapSup.get(itemset2);
                LinkedList<STPSet> candidateSTPSetList = new LinkedList<STPSet>();
                double avgLocalSupRatio = this.computeAvgLocalSupRatio(neiboringSTPSetList, itemset2, candidateSTPSetList);
                double itSignificance = avgLocalSupRatio / originalSupRatio;
                if (itSignificance >= ParametersSetting.MIN_SIGNIFICANCE && (supSTP = (STPSet)candidateSTPSetList.get(0)).getSize() >= ParametersSetting.MIN_TAIL_SUP) {
                    addedItemsetList.add(itemset2);
                    addedTailPointsList.add(supSTP);
                    significanceList.add(itSignificance);
                }
                if (ParametersSetting.ADOPTING_PRUNING && nextLevelItemsets != null && itSignificance < ParametersSetting.MIN_SIGNIFICANCE) {
                    double superMinSup = itemsetMapMinSup.get(itemset2);
                    double itSlackSignificance = avgLocalSupRatio / superMinSup;
                    if (itSlackSignificance < ParametersSetting.MIN_SIGNIFICANCE) {
                        for (Itemset superSet : itemsetMapSuperset.get(itemset2)) {
                            if (!nextLevelItemsets.contains(superSet)) continue;
                            nextLevelItemsets.remove(superSet);
                        }
                    } else if (ParametersSetting.MINI_GRAINED_PRUNING) {
                        for (Itemset superset : itemsetMapSuperset.get(itemset2)) {
                            double superSup = this.itemsetMapSup.get(superset);
                            itSlackSignificance = avgLocalSupRatio / superSup;
                            if (!(itSlackSignificance < ParametersSetting.MIN_SIGNIFICANCE) || !nextLevelItemsets.contains(superset)) continue;
                            nextLevelItemsets.remove(superset);
                        }
                    }
                }
                MemoryLogger.getInstance().checkMemory();
            }
            ++level;
        }
    }

    private double computeAvgLocalSupRatio(List<STPSet> neiboringSTPSetList, Itemset itemset2, List<STPSet> candidateSTPSetList) {
        STPSet stpSet = this.itemsetMapSTPSet.get(itemset2);
        LinkedList<STPSet> tempSTPSetList = new LinkedList<STPSet>();
        double totalLocalSupRaio = 0.0;
        for (STPSet neibor : neiboringSTPSetList) {
            int neiboringSize = neibor.getSize();
            STPSet tempSTPSet = neibor.intersect(stpSet);
            tempSTPSetList.add(tempSTPSet);
            int localSup = tempSTPSet.getSize();
            if (neiboringSize == 0) continue;
            double localSupRatio = (double)localSup / (double)neiboringSize;
            totalLocalSupRaio += localSupRatio;
        }
        candidateSTPSetList.add(STPSet.mergeSTPSets(tempSTPSetList));
        return totalLocalSupRaio / (double)neiboringSTPSetList.size();
    }

    private List<STPSet> acquireNeighboringPointsSet(STPSet stpSet) {
        LinkedList<STPSet> neighboringSTPSetList = new LinkedList<STPSet>();
        for (int timestamp : stpSet.getTimestamps()) {
            for (int vId : stpSet.getVIdSet4Timestamp(timestamp)) {
                STPSet neighborSTPSet = null;
                if (ParametersSetting.NEIGHBOR_FLAG == 0) {
                    neighborSTPSet = this.findNeighbors0(timestamp, vId);
                } else if (ParametersSetting.NEIGHBOR_FLAG == 1) {
                    neighborSTPSet = this.findNeighbors1(timestamp, vId);
                }
                neighboringSTPSetList.add(neighborSTPSet);
            }
        }
        if (!ParametersSetting.ALLOW_OVERLAPPING) {
            LinkedList<STPSet> tempSTPSet = new LinkedList<STPSet>();
            tempSTPSet.add(STPSet.mergeSTPSets(neighboringSTPSetList));
            neighboringSTPSetList = tempSTPSet;
        }
        return neighboringSTPSetList;
    }

    private STPSet findNeighbors0(int timestamp, int vId) {
        LinkedList<Integer> nextTimestamps = new LinkedList<Integer>();
        LinkedList<Set<Integer>> vIdSets = new LinkedList<Set<Integer>>();
        ItemAttributedGraph itemAG = this.timestampMapItemAG.get(timestamp);
        nextTimestamps.add(timestamp + 1);
        Set<Integer> neighbors = itemAG.findAllNeighbors4V(vId);
        vIdSets.add(neighbors);
        return new STPSet(nextTimestamps, vIdSets);
    }

    private STPSet findNeighbors1(int timestamp, int vId) {
        LinkedList<Integer> nextTimestamps = new LinkedList<Integer>();
        LinkedList<Set<Integer>> vIdSets = new LinkedList<Set<Integer>>();
        nextTimestamps.add(timestamp + 1);
        HashSet<Integer> neighbors = new HashSet<Integer>();
        neighbors.add(vId);
        vIdSets.add(neighbors);
        return new STPSet(nextTimestamps, vIdSets);
    }

    private static void getItemsetMapDominantsSuperset() {
        itemsetMapDominantsSuperset = new HashMap<Itemset, Set<Itemset>>();
        int i = 1;
        while (i <= levelMapItemsets.keySet().size()) {
            for (Itemset itemset2 : levelMapItemsets.get(i)) {
                HashSet<Itemset> dominantSupersets = new HashSet<Itemset>();
                itemsetMapDominantsSuperset.put(itemset2, dominantSupersets);
                for (Itemset superset : itemsetMapSuperset.get(itemset2)) {
                    if (superset.compareTo(itemset2) <= 0) continue;
                    dominantSupersets.add(superset);
                }
            }
            ++i;
        }
    }

    private void getBasicMappings() {
        levelMapItemsets = new HashMap<Integer, Set<Itemset>>();
        for (Itemset itemset2 : this.itemsetMapSTPSet.keySet()) {
            int size = itemset2.getSize();
            Set<Itemset> itemsets = levelMapItemsets.get(size);
            if (itemsets == null) {
                itemsets = new HashSet<Itemset>();
                levelMapItemsets.put(size, itemsets);
            }
            itemsets.add(itemset2);
        }
        itemsetMapSuperset = new HashMap<Itemset, List<Itemset>>();
        int i = 1;
        while (i <= levelMapItemsets.size()) {
            for (Itemset itemset1 : levelMapItemsets.get(i)) {
                itemsetMapSuperset.put(itemset1, new LinkedList());
                Set<Itemset> itemset2List = levelMapItemsets.get(i + 1);
                if (itemset2List == null) continue;
                for (Itemset itemset2 : itemset2List) {
                    if (!itemset2.isSupersetOf(itemset1)) continue;
                    itemsetMapSuperset.get(itemset1).add(itemset2);
                }
            }
            ++i;
        }
        this.itemsetMapSup = new HashMap<Itemset, Double>();
        i = levelMapItemsets.size();
        while (i > 0) {
            for (Itemset itemset3 : levelMapItemsets.get(i)) {
                int sup = this.itemsetMapSTPSet.get(itemset3).getSize();
                this.itemsetMapSup.put(itemset3, (double)sup / (double)this.totalNumVertex);
            }
            --i;
        }
    }

    private void getItemsetMapSuperMinAndMapDominants() {
        if (ParametersSetting.TRAVERSAL_FLAG == 0 || ParametersSetting.TRAVERSAL_FLAG == 1) {
            AlgoTSeqMiner.getItemsetMapDominantsSuperset();
        }
        if (ParametersSetting.ADOPTING_PRUNING) {
            itemsetMapMinSup = new HashMap<Itemset, Double>();
            if (ParametersSetting.LARGE_GRAINED_PRUNING) {
                this.getItemsetMapSuperMinSlack();
            } else if (ParametersSetting.TRAVERSAL_FLAG == 0 || ParametersSetting.TRAVERSAL_FLAG == 1) {
                this.getItemsetMapSuperMinTight4DFS();
            } else {
                this.getItemsetMapSuperMinTight4BFS();
            }
        }
    }

    private void getItemsetMapSuperMinTight4BFS() {
        int level = 1;
        while (level <= levelMapItemsets.size()) {
            for (Itemset itemset2 : levelMapItemsets.get(level)) {
                double supRatioMin = this.itemsetMapSup.get(itemset2);
                for (Itemset superset : itemsetMapSuperset.get(itemset2)) {
                    double superSup = this.itemsetMapSup.get(superset);
                    if (!(superSup < supRatioMin)) continue;
                    supRatioMin = superSup;
                }
                itemsetMapMinSup.put(itemset2, supRatioMin);
            }
            ++level;
        }
    }

    private void getItemsetMapSuperMinTight4DFS() {
        int highestLevel = levelMapItemsets.size();
        for (Itemset itemset2 : levelMapItemsets.get(highestLevel)) {
            itemsetMapMinSup.put(itemset2, this.itemsetMapSup.get(itemset2));
        }
        int level = highestLevel - 1;
        while (level > 0) {
            for (Itemset itemset3 : levelMapItemsets.get(level)) {
                double supRatioMin = this.itemsetMapSup.get(itemset3);
                for (Itemset superset : itemsetMapDominantsSuperset.get(itemset3)) {
                    double superSup = itemsetMapMinSup.get(superset);
                    if (!(superSup < supRatioMin)) continue;
                    supRatioMin = superSup;
                }
                itemsetMapMinSup.put(itemset3, supRatioMin);
            }
            --level;
        }
    }

    private void getItemsetMapSuperMinSlack() {
        int i = levelMapItemsets.size();
        while (i > 0) {
            for (Itemset itemset2 : levelMapItemsets.get(i)) {
                double supRatioMin = this.itemsetMapSup.get(itemset2);
                for (Itemset superset : itemsetMapSuperset.get(itemset2)) {
                    double superSup = itemsetMapMinSup.get(superset);
                    if (!(superSup < supRatioMin)) continue;
                    supRatioMin = superSup;
                }
                itemsetMapMinSup.put(itemset2, supRatioMin);
            }
            --i;
        }
    }

    private void getItemDyAGFromPreprocessing() throws IOException {
        this.timestampMapItemAG = Preprocess.itDyAG;
        this.totalNumVertex = this.timestampMapItemAG.get(0).getTotalSize() * this.timestampMapItemAG.size();
        this.eventTypeMapName = Preprocess.eventTypeMapping;
        if (ParametersSetting.EXHIBIT_SUPPORTING_POINTS) {
            this.getVerterMapName();
        }
    }

    private void getVerterMapName() throws IOException {
        this.vertexMapName = new HashMap<Integer, String>();
        File vertexMapNameFile = new File(ParametersSetting.VERTEX_MAP_NAME_PATH);
        if (!vertexMapNameFile.exists()) {
            vertexMapNameFile.createNewFile();
        }
        BufferedReader br = new BufferedReader(new FileReader(ParametersSetting.VERTEX_MAP_NAME_PATH));
        String line = null;
        while ((line = br.readLine()) != null) {
            try {
                String[] items = line.split(",");
                int vId = Integer.parseInt(items[0]);
                String name = items[1];
                this.vertexMapName.put(vId, name);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println(line);
            }
        }
        br.close();
    }

    private void readFrequentItemsetFromEclat() throws IOException {
        this.itemsetMapSTPSet = EclatAlgo.extendFreItems();
        this.totalItemsetNum = this.itemsetMapSTPSet.size();
        System.out.println("total " + this.totalItemsetNum + " frequent itemsets");
    }

    private void saveSequencePattern(List<Itemset> prefix, List<STPSet> prefixSTPSet, List<Double> prefixSigList, Itemset newItemset, STPSet tailSTPSet, double newSig) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("{");
        if (this.INTERPRET_RESULT) {
            for (Itemset itemset2 : prefix) {
                sb.append(this.interpretItemset(itemset2)).append(",");
            }
            sb.append(this.interpretItemset(newItemset));
        } else {
            for (Itemset itemset2 : prefix) {
                sb.append(itemset2).append(",");
            }
            sb.append(newItemset);
        }
        sb.append("} {");
        for (STPSet stpSet : prefixSTPSet) {
            sb.append(stpSet.getSize()).append(",");
        }
        sb.append(tailSTPSet.getSize());
        sb.append("} {");
        int i = 1;
        while (i < prefixSigList.size()) {
            sb.append(nf.format(prefixSigList.get(i))).append(",");
            ++i;
        }
        sb.append(nf.format(newSig));
        sb.append("}\n");
        if (ParametersSetting.EXHIBIT_SUPPORTING_POINTS) {
            for (STPSet stpSet : prefixSTPSet) {
                for (Integer timestamp : stpSet.getTimestamps()) {
                    for (Integer vId : stpSet.getVIdSet4Timestamp(timestamp)) {
                        sb.append("(").append(timestamp).append(",").append(this.vertexMapName.get(vId)).append(") ");
                    }
                }
                sb.append("\n");
            }
            for (Integer timestamp : tailSTPSet.getTimestamps()) {
                for (Integer vId : tailSTPSet.getVIdSet4Timestamp(timestamp)) {
                    sb.append("(").append(timestamp).append(",").append(this.vertexMapName.get(vId)).append(") ");
                }
            }
            sb.append("\n");
        }
        bw.write(sb.toString());
    }

    private String interpretItemset(Itemset itemset2) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int[] nArray = itemset2.getItems();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer item = nArray[n2];
            sb.append(this.eventTypeMapName.get(item)).append(",");
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private void readFrequentItemsetFromFile() throws IOException {
        EclatAlgo.extendFreItems();
        String freqItemsetPath = "dataset/DBLP/result/frequent_itemset.txt";
        BufferedReader br = new BufferedReader(new FileReader(freqItemsetPath));
        this.itemsetMapSTPSet = new LinkedHashMap<Itemset, STPSet>();
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith("#")) {
                line = br.readLine();
                Itemset itemset2 = new Itemset(line);
                br.readLine();
                br.readLine();
                LinkedList<Integer> timestampList = new LinkedList<Integer>();
                LinkedList<Set<Integer>> vIdSetList = new LinkedList<Set<Integer>>();
                while ((line = br.readLine()).startsWith("[")) {
                    String[] splitItems = line.split(" ");
                    timestampList.add(Integer.parseInt(splitItems[0].substring(1, splitItems[0].length() - 1)));
                    HashSet<Integer> vIdSet = new HashSet<Integer>();
                    String idStr = splitItems[1].substring(1, splitItems[1].length() - 1);
                    String[] stringArray = idStr.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        vIdSet.add(Integer.parseInt(str));
                        ++n2;
                    }
                    vIdSetList.add(vIdSet);
                }
                this.itemsetMapSTPSet.put(itemset2, new STPSet(timestampList, vIdSetList));
                ++this.totalItemsetNum;
                continue;
            }
            line = br.readLine();
        }
    }

    public void printStats() {
        System.out.println("=============  TSeqMiner v2.40 - STATS =============");
        System.out.println(" Time to prepare the data: " + ParametersSetting.PREPARE + " ms");
        System.out.println(" Time to mine patterns from data: " + this.totalMiningTime + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Pattern count: " + this.patternCount);
        System.out.println("====================================================");
    }
}

