/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SparseTriangularMatrix {
    private Map<Integer, Map<Integer, Integer>> matrix = new HashMap<Integer, Map<Integer, Integer>>();

    public SparseTriangularMatrix() {
    }

    public SparseTriangularMatrix(int itemCount) {
    }

    public String toString() {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.matrix.keySet().size()) {
            temp.append(i);
            temp.append(": ");
            int j = 0;
            while (j < this.matrix.get(i).size()) {
                temp.append(this.matrix.get(i).get(j));
                temp.append(" ");
                ++j;
            }
            temp.append("\n");
            ++i;
        }
        return temp.toString();
    }

    public void incrementCount(int i, int j) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(i, mapCount);
                mapCount.put(j, 1);
            } else {
                Integer count = mapCount.get(j);
                if (count == null) {
                    mapCount.put(j, 1);
                } else {
                    count = count + 1;
                    mapCount.put(j, count);
                }
            }
        } else {
            Map<Integer, Integer> mapCount = this.matrix.get(j);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(j, mapCount);
                mapCount.put(i, 1);
            } else {
                Integer count = mapCount.get(i);
                if (count == null) {
                    mapCount.put(i, 1);
                } else {
                    count = count + 1;
                    mapCount.put(i, count);
                }
            }
        }
    }

    public int getSupportForItems(int i, int j) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                return 0;
            }
            Integer count = mapCount.get(j);
            if (count == null) {
                return 0;
            }
            return count;
        }
        Map<Integer, Integer> mapCount = this.matrix.get(j);
        if (mapCount == null) {
            return 0;
        }
        Integer count = mapCount.get(i);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void setSupport(Integer i, Integer j, int support) {
        if (i < j) {
            Map<Integer, Integer> mapCount = this.matrix.get(i);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(i, mapCount);
                mapCount.put(j, support);
            } else {
                mapCount.put(j, support);
            }
        } else {
            Map<Integer, Integer> mapCount = this.matrix.get(j);
            if (mapCount == null) {
                mapCount = new HashMap<Integer, Integer>();
                this.matrix.put(j, mapCount);
                mapCount.put(i, support);
            } else {
                mapCount.put(i, support);
            }
        }
    }

    public void removeInfrequentEntriesFromMatrix(int minsup) {
        for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.matrix.entrySet()) {
            Iterator<Map.Entry<Integer, Integer>> iter = entry.getValue().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, Integer> entry2 = iter.next();
                if (entry2.getValue() >= minsup) continue;
                iter.remove();
            }
        }
    }
}

