/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.DatabaseGraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.EdgeEnumeration;
import ca.pfv.spmf.algorithms.graph_mining.tkg.PDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Projected {
    private List<PDFS> projected = new LinkedList<PDFS>();
    private Set<Integer> graphIds;

    public void addProjection(PDFS projection) {
        this.projected.add(projection);
    }

    public List<Set<EdgeEnumeration>> buildKeys() {
        ArrayList<Set<EdgeEnumeration>> keys = new ArrayList<Set<EdgeEnumeration>>();
        if (this.projected.size() == 0) {
            return new ArrayList<Set<EdgeEnumeration>>();
        }
        int length = this.projected.get(0).getLength();
        int i = 0;
        while (i < length) {
            HashSet key = new HashSet();
            keys.add(key);
            ++i;
        }
        for (PDFS projection : this.projected) {
            int i2 = length - 1;
            while (projection != null) {
                EdgeEnumeration edgeEnumeration = projection.getEdgeEnumeration();
                Set key = (Set)keys.get(i2);
                key.add(edgeEnumeration);
                projection = projection.getPrevious();
                --i2;
            }
        }
        return keys;
    }

    public Set<EdgeEnumeration> lastEdgeKey() {
        HashSet<EdgeEnumeration> key = new HashSet<EdgeEnumeration>();
        if (this.projected.size() == 0) {
            return key;
        }
        for (PDFS projection : this.projected) {
            EdgeEnumeration edgeEnumeration = projection.getEdgeEnumeration();
            key.add(edgeEnumeration);
        }
        return key;
    }

    public Map<Integer, List<List<EdgeEnumeration>>> buildProjectionsInDatabaseGraph() {
        HashMap<Integer, List<List<EdgeEnumeration>>> graphProjections = new HashMap<Integer, List<List<EdgeEnumeration>>>();
        for (PDFS projection : this.projected) {
            Integer gid = projection.getEdgeEnumeration().getGid();
            if (!graphProjections.containsKey(gid)) {
                graphProjections.put(gid, new LinkedList());
            }
            LinkedList<EdgeEnumeration> projectionList = new LinkedList<EdgeEnumeration>();
            while (projection != null) {
                EdgeEnumeration edgeEnumeration = projection.getEdgeEnumeration();
                projectionList.add(0, edgeEnumeration);
                projection = projection.getPrevious();
            }
            ((List)graphProjections.get(gid)).add(projectionList);
        }
        return graphProjections;
    }

    public Set<Integer> getGraphIds() {
        return this.graphIds;
    }

    public void setGraphIds(Set<Integer> graphIds) {
        this.graphIds = graphIds;
    }

    public List<PDFS> getProjected() {
        return this.projected;
    }

    public void setProjected(List<PDFS> projected) {
        this.projected = projected;
    }

    public boolean hasEquivalentOccurrence(Projected extendedProjected) {
        if (!this.graphIds.equals(extendedProjected.getGraphIds())) {
            return false;
        }
        if (this.projected.size() > extendedProjected.getProjected().size()) {
            return false;
        }
        HashSet<PDFS> extendedPDFSPrevious = new HashSet<PDFS>();
        for (PDFS extendedPdfs : extendedProjected.getProjected()) {
            extendedPDFSPrevious.add(extendedPdfs.getPrevious());
        }
        for (PDFS pdfs : this.projected) {
            if (extendedPDFSPrevious.contains(pdfs)) continue;
            return false;
        }
        return true;
    }

    public List<Integer> projectionsGraphIds() {
        ArrayList<Integer> graphIds = new ArrayList<Integer>();
        for (PDFS pdfs : this.projected) {
            graphIds.add(pdfs.getEdgeEnumeration().getGid());
        }
        return graphIds;
    }

    public int verticesWithLabelCount(int label, List<DatabaseGraph> graphDatabase) {
        HashMap graphVerticesWithLabel = new HashMap();
        List<Integer> graphIds = this.projectionsGraphIds();
        for (Integer graphId : graphIds) {
            graphVerticesWithLabel.put(graphId, new HashSet());
        }
        Iterator<Object> iterator = this.projected.iterator();
        while (iterator.hasNext()) {
            PDFS pdfs;
            PDFS pdfsAt = pdfs = (PDFS)iterator.next();
            while (pdfsAt != null) {
                int label2;
                int gid = pdfsAt.getEdgeEnumeration().getGid();
                DatabaseGraph g = graphDatabase.get(gid);
                Edge edge = pdfsAt.getEdgeEnumeration().getEdge();
                int label1 = g.getVLabel(edge.v1);
                if (label1 == label) {
                    ((Set)graphVerticesWithLabel.get(gid)).add(edge.v1);
                }
                if ((label2 = g.getVLabel(edge.v2)) == label) {
                    ((Set)graphVerticesWithLabel.get(gid)).add(edge.v2);
                }
                pdfsAt = pdfsAt.getPrevious();
            }
        }
        int count = 0;
        Iterator iterator2 = graphVerticesWithLabel.keySet().iterator();
        while (iterator2.hasNext()) {
            int gid = (Integer)iterator2.next();
            count += ((Set)graphVerticesWithLabel.get(gid)).size();
        }
        return count;
    }
}

