/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.tkg;

import ca.pfv.spmf.algorithms.graph_mining.tkg.ClosedSubgraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.DFSCode;
import ca.pfv.spmf.algorithms.graph_mining.tkg.DatabaseGraph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.EarlyTerminationFailureHandler;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Edge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.EdgeEnumeration;
import ca.pfv.spmf.algorithms.graph_mining.tkg.ExtendedEdge;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Graph;
import ca.pfv.spmf.algorithms.graph_mining.tkg.PDFS;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Projected;
import ca.pfv.spmf.algorithms.graph_mining.tkg.SparseTriangularMatrix;
import ca.pfv.spmf.algorithms.graph_mining.tkg.Vertex;
import ca.pfv.spmf.algorithms.graph_mining.tkg.VizGraph;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AlgoCGSPAN {
    private int minSup;
    private List<ClosedSubgraph> closedSubgraphs;
    private long runtime = 0L;
    private double maxmemory = 0.0;
    private int patternCount = 0;
    private int graphCount = 0;
    List<Integer> frequentVertexLabels;
    private boolean DEBUG_MODE = false;
    private static final boolean ELIMINATE_INFREQUENT_VERTICES = true;
    private static final boolean ELIMINATE_INFREQUENT_VERTEX_PAIRS = true;
    private static final boolean ELIMINATE_INFREQUENT_EDGE_LABELS = true;
    private static final boolean EDGE_COUNT_PRUNING = true;
    private static final boolean SKIP_STRATEGY = false;
    int infrequentVertexPairsRemoved;
    int infrequentVerticesRemovedCount;
    int edgeRemovedByLabel;
    int eliminatedWithMaxSize;
    int emptyGraphsRemoved;
    int pruneByEdgeCountCount;
    int skipStrategyCount;
    int maxNumberOfEdges = Integer.MAX_VALUE;
    boolean outputGraphIds = true;
    boolean detectEarlyTerminationFailure = true;
    int earlyTerminationAppliedCount;
    int earlyTerminationFailureDetectedCount;
    Map<Set<EdgeEnumeration>, List<ClosedSubgraph>> closedSubgraphsHashTable = new HashMap<Set<EdgeEnumeration>, List<ClosedSubgraph>>();
    private HashMap<Integer, Integer> labelCountM;
    Map<Integer, Map<Integer, Integer>> labelInGraphCountM;

    public void runAlgorithm(String inPath, String outPath, double minSupport, boolean outputSingleVertices, boolean outputDotFile, int maxNumberOfEdges, boolean outputGraphIds) throws IOException, ClassNotFoundException {
        if (maxNumberOfEdges <= 0) {
            return;
        }
        double minFrequency = minSupport;
        this.maxNumberOfEdges = maxNumberOfEdges;
        this.outputGraphIds = outputGraphIds;
        this.infrequentVertexPairsRemoved = 0;
        this.infrequentVerticesRemovedCount = 0;
        this.edgeRemovedByLabel = 0;
        this.eliminatedWithMaxSize = 0;
        this.emptyGraphsRemoved = 0;
        this.pruneByEdgeCountCount = 0;
        this.earlyTerminationAppliedCount = 0;
        this.earlyTerminationFailureDetectedCount = 0;
        this.closedSubgraphs = new ArrayList<ClosedSubgraph>();
        MemoryLogger.getInstance().reset();
        this.patternCount = 0;
        Long t1 = System.currentTimeMillis();
        List<DatabaseGraph> graphDB = this.readGraphs(inPath);
        this.minSup = (int)Math.ceil(minFrequency * (double)graphDB.size());
        this.cgSpan(graphDB, outputSingleVertices);
        MemoryLogger.getInstance().checkMemory();
        this.writeResultToFile(outPath);
        Long t2 = System.currentTimeMillis();
        this.runtime = (t2 - t1) / 1000L;
        this.maxmemory = MemoryLogger.getInstance().getMaxMemory();
        this.patternCount = this.closedSubgraphs.size();
        if (outputDotFile) {
            AlgoCGSPAN.outputDotFile(outPath);
        }
    }

    private static void outputDotFile(String outputPath) throws IOException {
        String dirName = String.valueOf(outputPath) + "_dotfile";
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdir();
        }
        VizGraph.visulizeFromFile(outputPath, dirName);
    }

    private void writeResultToFile(String outputPath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputPath)));
        this.closedSubgraphs.sort((z1, z2) -> Integer.compare(z1.support, z2.support));
        int i = 0;
        for (ClosedSubgraph subgraph : this.closedSubgraphs) {
            StringBuilder sb = new StringBuilder();
            DFSCode dfsCode = subgraph.dfsCode;
            if (dfsCode.size() == 1) {
                ExtendedEdge ee = dfsCode.getEeL().get(0);
                if (ee.getEdgeLabel() == -1) {
                    sb.append("t # ").append(i).append(" * ").append(subgraph.support);
                    if (this.DEBUG_MODE) {
                        sb.append(" * ").append(this.labelCountM.get(ee.getvLabel1()));
                    }
                    sb.append(System.lineSeparator());
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                } else {
                    sb.append("t # ").append(i).append(" * ").append(subgraph.support);
                    if (this.DEBUG_MODE) {
                        sb.append(" * ").append(subgraph.getProjected().getProjected().size());
                    }
                    sb.append(System.lineSeparator());
                    sb.append("v 0 ").append(ee.getvLabel1()).append(System.lineSeparator());
                    sb.append("v 1 ").append(ee.getvLabel2()).append(System.lineSeparator());
                    sb.append("e 0 1 ").append(ee.getEdgeLabel()).append(System.lineSeparator());
                }
            } else {
                sb.append("t # ").append(i).append(" * ").append(subgraph.support);
                if (this.DEBUG_MODE) {
                    sb.append(" * ").append(subgraph.getProjected().getProjected().size());
                }
                sb.append(System.lineSeparator());
                List<Integer> vLabels = dfsCode.getAllVLabels();
                int j = 0;
                while (j < vLabels.size()) {
                    sb.append("v ").append(j).append(" ").append(vLabels.get(j)).append(System.lineSeparator());
                    ++j;
                }
                for (ExtendedEdge ee : dfsCode.getEeL()) {
                    int startV = ee.getV1();
                    int endV = ee.getV2();
                    int eL = ee.edgeLabel;
                    sb.append("e ").append(startV).append(" ").append(endV).append(" ").append(eL).append(System.lineSeparator());
                }
            }
            if (this.outputGraphIds) {
                if (dfsCode.size() > 1 || dfsCode.size() == 1 && dfsCode.getEeL().get(0).getEdgeLabel() != -1) {
                    List<Integer> projectionsGraphIds = subgraph.getProjected().projectionsGraphIds();
                    Map<Integer, Long> projectionsCounts = projectionsGraphIds.stream().collect(Collectors.groupingBy(p -> p, Collectors.counting()));
                    ArrayList sortedGraphIds = new ArrayList(subgraph.setOfGraphsIDs);
                    sortedGraphIds.sort(Integer::compare);
                    sb.append("x");
                    Iterator iterator = sortedGraphIds.iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)iterator.next();
                        sb.append(" ").append(id);
                        if (!this.DEBUG_MODE) continue;
                        sb.append('x').append(projectionsCounts.get(id));
                    }
                } else {
                    ArrayList<Integer> sortedGraphIds = new ArrayList<Integer>(this.labelInGraphCountM.keySet());
                    sortedGraphIds.sort(Integer::compare);
                    sb.append("x");
                    Iterator<ExtendedEdge> iterator = sortedGraphIds.iterator();
                    while (iterator.hasNext()) {
                        int id = (Integer)((Object)iterator.next());
                        Integer count = this.labelInGraphCountM.get(id).get(dfsCode.getEeL().get((int)0).vLabel1);
                        if (count == null || count <= 0) continue;
                        sb.append(" ").append(id);
                        if (!this.DEBUG_MODE) continue;
                        sb.append('x').append(count);
                    }
                }
            }
            sb.append(System.lineSeparator()).append(System.lineSeparator());
            bw.write(sb.toString());
            ++i;
        }
        bw.close();
    }

    private List<DatabaseGraph> readGraphs(String path) throws IOException {
        if (this.DEBUG_MODE) {
            System.out.println("start reading graphs...");
        }
        BufferedReader br = new BufferedReader(new FileReader(new File(path)));
        ArrayList<DatabaseGraph> graphDatabase = new ArrayList<DatabaseGraph>();
        String line = br.readLine();
        Boolean hasNextGraph = line != null && line.startsWith("t");
        while (hasNextGraph.booleanValue()) {
            hasNextGraph = false;
            int gId = Integer.parseInt(line.split(" ")[2]);
            HashMap<Integer, Vertex> vMap = new HashMap<Integer, Vertex>();
            while ((line = br.readLine()) != null && !line.startsWith("t")) {
                String[] items = line.split(" ");
                if (line.startsWith("v")) {
                    int vId = Integer.parseInt(items[1]);
                    int vLabel = Integer.parseInt(items[2]);
                    vMap.put(vId, new Vertex(vId, vLabel));
                    continue;
                }
                if (!line.startsWith("e")) continue;
                int v1 = Integer.parseInt(items[1]);
                int v2 = Integer.parseInt(items[2]);
                int eLabel = Integer.parseInt(items[3]);
                Edge e = new Edge(v1, v2, eLabel);
                ((Vertex)vMap.get(v1)).addEdge(e);
                ((Vertex)vMap.get(v2)).addEdge(e);
            }
            graphDatabase.add(new DatabaseGraph(gId, vMap));
            if (line == null) continue;
            hasNextGraph = true;
        }
        br.close();
        if (this.DEBUG_MODE) {
            System.out.println("read successfully, totally " + graphDatabase.size() + " graphs");
        }
        this.graphCount = graphDatabase.size();
        return graphDatabase;
    }

    private List<Map<Integer, Integer>> subgraphIsomorphisms(DFSCode c, Graph g) {
        ArrayList<Map<Integer, Integer>> isoms = new ArrayList<Map<Integer, Integer>>();
        int startLabel = c.getEeL().get(0).getvLabel1();
        int[] nArray = g.findAllWithLabel(startLabel);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int vID = nArray[n2];
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            map.put(0, vID);
            isoms.add(map);
            ++n2;
        }
        for (ExtendedEdge ee : c.getEeL()) {
            int v1 = ee.getV1();
            int v2 = ee.getV2();
            int v2Label = ee.getvLabel2();
            int eLabel = ee.getEdgeLabel();
            ArrayList<Map> updateIsoms = new ArrayList<Map>();
            for (Map map : isoms) {
                int mappedV1 = (Integer)map.get(v1);
                if (v1 < v2) {
                    Collection mappedVertices = map.values();
                    Vertex[] vertexArray = g.getAllNeighbors(mappedV1);
                    int n3 = vertexArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Vertex mappedV2 = vertexArray[n4];
                        if (v2Label == mappedV2.getLabel() && !mappedVertices.contains(mappedV2.getId()) && eLabel == g.getEdgeLabel(mappedV1, mappedV2.getId())) {
                            HashMap<Integer, Integer> tempM = new HashMap<Integer, Integer>(map.size() + 1);
                            tempM.putAll(map);
                            tempM.put(v2, mappedV2.getId());
                            updateIsoms.add(tempM);
                        }
                        ++n4;
                    }
                    continue;
                }
                int mappedV2 = (Integer)map.get(v2);
                if (!g.isNeighboring(mappedV1, mappedV2) || eLabel != g.getEdgeLabel(mappedV1, mappedV2)) continue;
                updateIsoms.add(map);
            }
            isoms = updateIsoms;
        }
        return isoms;
    }

    private Map<ExtendedEdge, Set<Integer>> rightMostPathExtensionsFromSingle(DFSCode c, Graph g) {
        int gid = g.getId();
        HashMap<ExtendedEdge, Set<Integer>> extensions = new HashMap<ExtendedEdge, Set<Integer>>();
        if (c.isEmpty()) {
            Vertex[] vertexArray = g.vertices;
            int n = g.vertices.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex vertex = vertexArray[n2];
                for (Edge e : vertex.getEdgeList()) {
                    int v2L;
                    int v1L = g.getVLabel(e.v1);
                    ExtendedEdge ee1 = v1L < (v2L = g.getVLabel(e.v2)) ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                    HashSet<Integer> setOfGraphIDs = (HashSet<Integer>)extensions.get(ee1);
                    if (setOfGraphIDs == null) {
                        setOfGraphIDs = new HashSet<Integer>();
                        extensions.put(ee1, setOfGraphIDs);
                    }
                    setOfGraphIDs.add(gid);
                }
                ++n2;
            }
        } else {
            int rightMost = c.getRightMost();
            List<Map<Integer, Integer>> isoms = this.subgraphIsomorphisms(c, g);
            for (Map<Integer, Integer> isom : isoms) {
                HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                    invertedISOM.put(entry.getValue(), entry.getKey());
                }
                int mappedRM = isom.get(rightMost);
                int mappedRMlabel = g.getVLabel(mappedRM);
                Vertex[] vertexArray = g.getAllNeighbors(mappedRM);
                int n = vertexArray.length;
                int ee1 = 0;
                while (ee1 < n) {
                    Vertex x = vertexArray[ee1];
                    Integer invertedX = (Integer)invertedISOM.get(x.getId());
                    if (invertedX != null && c.onRightMostPath(invertedX) && c.notPreOfRM(invertedX) && !c.containEdge(rightMost, invertedX)) {
                        ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                        if (extensions.get(ee) == null) {
                            extensions.put(ee, new HashSet());
                        }
                        ((Set)extensions.get(ee)).add(g.getId());
                    }
                    ++ee1;
                }
                Collection<Integer> mappedVertices = isom.values();
                for (int v : c.getRightMostPath()) {
                    int mappedV = isom.get(v);
                    int mappedVlabel = g.getVLabel(mappedV);
                    Vertex[] vertexArray2 = g.getAllNeighbors(mappedV);
                    int n3 = vertexArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Vertex x = vertexArray2[n4];
                        if (!mappedVertices.contains(x.getId())) {
                            ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                            if (extensions.get(ee) == null) {
                                extensions.put(ee, new HashSet());
                            }
                            ((Set)extensions.get(ee)).add(g.getId());
                        }
                        ++n4;
                    }
                }
            }
        }
        return extensions;
    }

    private Map<ExtendedEdge, Projected> rightMostPathExtensions(DFSCode c, List<DatabaseGraph> graphDatabase, Projected projected) {
        Set<Integer> graphIds = projected.getGraphIds();
        HashMap<ExtendedEdge, Projected> extensions = new HashMap<ExtendedEdge, Projected>();
        if (c.isEmpty()) {
            for (Integer graphId : graphIds) {
                DatabaseGraph g = graphDatabase.get(graphId);
                if (c.size() >= g.getEdgeCount()) {
                    ++this.pruneByEdgeCountCount;
                    continue;
                }
                Vertex[] vertexArray = g.vertices;
                int n = g.vertices.length;
                int n2 = 0;
                while (n2 < n) {
                    Vertex vertex = vertexArray[n2];
                    for (Edge e : vertex.getEdgeList()) {
                        int v2L;
                        int v1L = g.getVLabel(e.v1);
                        if (v1L != (v2L = g.getVLabel(e.v2)) && vertex.getId() != e.v1) continue;
                        ExtendedEdge ee1 = v1L < v2L ? new ExtendedEdge(0, 1, v1L, v2L, e.getEdgeLabel()) : new ExtendedEdge(0, 1, v2L, v1L, e.getEdgeLabel());
                        Projected extensionProjected = (Projected)extensions.get(ee1);
                        if (extensionProjected == null) {
                            extensionProjected = new Projected();
                            extensionProjected.setGraphIds(new HashSet<Integer>());
                            extensions.put(ee1, extensionProjected);
                        }
                        EdgeEnumeration edgeEnumeration = g.getEdgeEnumeration(e);
                        boolean isReversed = v1L < v2L ? false : (v2L < v1L ? true : vertex.getId() != e.v1);
                        PDFS pdfs2 = new PDFS(edgeEnumeration, isReversed, null);
                        extensionProjected.addProjection(pdfs2);
                        extensionProjected.getGraphIds().add(graphId);
                    }
                    ++n2;
                }
            }
        } else {
            int remaininggraphCount = graphIds.size();
            int highestSupport = 0;
            int rightMost = c.getRightMost();
            for (Integer graphId : graphIds) {
                DatabaseGraph g = graphDatabase.get(graphId);
                if (c.size() >= g.getEdgeCount()) {
                    ++this.pruneByEdgeCountCount;
                    continue;
                }
                for (PDFS pdfs : projected.getProjected()) {
                    if (pdfs.getEdgeEnumeration().getGid() != g.getId()) continue;
                    Map<Integer, Integer> isom = pdfs.subgraphIsomorphism(c);
                    HashMap<Integer, Integer> invertedISOM = new HashMap<Integer, Integer>();
                    for (Map.Entry<Integer, Integer> entry : isom.entrySet()) {
                        invertedISOM.put(entry.getValue(), entry.getKey());
                    }
                    int mappedRM = isom.get(rightMost);
                    int mappedRMlabel = g.getVLabel(mappedRM);
                    Vertex[] pdfs2 = g.getAllNeighbors(mappedRM);
                    int n = pdfs2.length;
                    int edgeEnumeration = 0;
                    while (edgeEnumeration < n) {
                        Vertex x = pdfs2[edgeEnumeration];
                        Integer invertedX = (Integer)invertedISOM.get(x.getId());
                        if (invertedX != null && c.onRightMostPath(invertedX) && c.notPreOfRM(invertedX) && !c.containEdge(rightMost, invertedX)) {
                            ExtendedEdge ee = new ExtendedEdge(rightMost, invertedX, mappedRMlabel, x.getLabel(), g.getEdgeLabel(mappedRM, x.getId()));
                            Projected extensionProjected = (Projected)extensions.get(ee);
                            if (extensionProjected == null) {
                                extensionProjected = new Projected();
                                extensionProjected.setGraphIds(new HashSet<Integer>());
                                extensions.put(ee, extensionProjected);
                            }
                            Edge e = g.getEdge(mappedRM, x.getId());
                            EdgeEnumeration edgeEnumeration2 = g.getEdgeEnumeration(e);
                            boolean isReversed = e.v1 != mappedRM;
                            PDFS extensionPdfs = new PDFS(edgeEnumeration2, isReversed, pdfs);
                            extensionProjected.addProjection(extensionPdfs);
                            extensionProjected.getGraphIds().add(graphId);
                        }
                        ++edgeEnumeration;
                    }
                    Collection<Integer> mappedVertices = isom.values();
                    for (int v : c.getRightMostPath()) {
                        int mappedV = isom.get(v);
                        int mappedVlabel = g.getVLabel(mappedV);
                        Vertex[] vertexArray = g.getAllNeighbors(mappedV);
                        int n3 = vertexArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Vertex x = vertexArray[n4];
                            if (!mappedVertices.contains(x.getId())) {
                                ExtendedEdge ee = new ExtendedEdge(v, rightMost + 1, mappedVlabel, x.getLabel(), g.getEdgeLabel(mappedV, x.getId()));
                                Projected extensionProjected = (Projected)extensions.get(ee);
                                if (extensionProjected == null) {
                                    extensionProjected = new Projected();
                                    extensionProjected.setGraphIds(new HashSet<Integer>());
                                    extensions.put(ee, extensionProjected);
                                }
                                Edge e = g.getEdge(mappedV, x.getId());
                                EdgeEnumeration edgeEnumeration3 = g.getEdgeEnumeration(e);
                                boolean isReversed = e.v1 != mappedV;
                                PDFS extensionPdfs = new PDFS(edgeEnumeration3, isReversed, pdfs);
                                extensionProjected.addProjection(extensionPdfs);
                                extensionProjected.getGraphIds().add(graphId);
                                if (extensionProjected.getGraphIds().size() > highestSupport) {
                                    highestSupport = extensionProjected.getGraphIds().size();
                                }
                            }
                            ++n4;
                        }
                    }
                }
                --remaininggraphCount;
            }
        }
        return extensions;
    }

    private void updateClosedSubgraphsHashTable(ClosedSubgraph closedSubgraph) {
        Projected projected = closedSubgraph.getProjected();
        List<Set<EdgeEnumeration>> keys = projected.buildKeys();
        for (Set<EdgeEnumeration> key : keys) {
            if (!this.closedSubgraphsHashTable.containsKey(key)) {
                this.closedSubgraphsHashTable.put(key, new LinkedList());
            }
            this.closedSubgraphsHashTable.get(key).add(closedSubgraph);
        }
    }

    private EarlyTerminationResult earlyTermination(Set<Integer> setOfGraphsIDs, Projected projected, EarlyTerminationFailureHandler earlyTerminationFailureHandler) {
        Set<EdgeEnumeration> key = projected.lastEdgeKey();
        if (!this.closedSubgraphsHashTable.containsKey(key)) {
            return new EarlyTerminationResult(false, false);
        }
        boolean earlyTermination = false;
        for (ClosedSubgraph closedSubgraph : this.closedSubgraphsHashTable.get(key)) {
            boolean earlyTerminationFailure;
            Map<Integer, Integer> isomorphism = closedSubgraph.checkEquivalentOccurrence(setOfGraphsIDs, setOfGraphsIDs.size(), projected);
            if (isomorphism == null) continue;
            earlyTermination = true;
            if (!this.detectEarlyTerminationFailure || !(earlyTerminationFailure = this.checkEarlyTerminationFailure(closedSubgraph, isomorphism, earlyTerminationFailureHandler))) continue;
            return new EarlyTerminationResult(false, true);
        }
        return new EarlyTerminationResult(earlyTermination, false);
    }

    private boolean checkEarlyTerminationFailure(ClosedSubgraph closedSubgraph, Map<Integer, Integer> isomorphism, EarlyTerminationFailureHandler earlyTerminationFailureHandler) {
        int maxDfsIndex = 0;
        for (int dfsIndex : isomorphism.values()) {
            if (dfsIndex <= maxDfsIndex) continue;
            maxDfsIndex = dfsIndex;
        }
        List<ExtendedEdge> extendedEdges = closedSubgraph.dfsCode.getEeL().subList(0, maxDfsIndex + 1);
        boolean detected = earlyTerminationFailureHandler.detect(extendedEdges);
        return detected;
    }

    private void cgSpan(List<DatabaseGraph> graphDB, boolean outputClosedVertices) throws IOException, ClassNotFoundException {
        this.findAllOnlyOneVertex(graphDB);
        for (DatabaseGraph g : graphDB) {
            g.precalculateVertexList();
        }
        this.removeInfrequentVertexPairs(graphDB);
        if (this.DEBUG_MODE) {
            System.out.println("Precalculating information...");
        }
        HashSet<Integer> graphIds = new HashSet<Integer>();
        int i = 0;
        while (i < graphDB.size()) {
            DatabaseGraph g = graphDB.get(i);
            if (g.vertices == null || g.vertices.length != 0) {
                if (this.infrequentVerticesRemovedCount > 0) {
                    g.precalculateVertexList();
                }
                graphIds.add(i);
                g.precalculateVertexNeighbors();
                g.precalculateLabelsToVertices();
                g.buildEdgeEnumeration();
            } else {
                if (this.DEBUG_MODE) {
                    System.out.println("EMPTY GRAPHS REMOVED");
                }
                ++this.emptyGraphsRemoved;
            }
            ++i;
        }
        if (outputClosedVertices) {
            Projected projected = new Projected();
            projected.setGraphIds(graphIds);
            this.outputClosedOneVertex(graphDB, projected);
        }
        if (this.frequentVertexLabels.size() != 0) {
            if (this.DEBUG_MODE) {
                System.out.println("Starting depth-first search...");
            }
            Projected projected = new Projected();
            projected.setGraphIds(graphIds);
            EarlyTerminationFailureHandler earlyTerminationFailureHandler = new EarlyTerminationFailureHandler(graphDB, this.minSup);
            this.cgSpanDFS(new DFSCode(), graphDB, graphIds, projected, earlyTerminationFailureHandler);
        }
    }

    private void removeInfrequentVertexPairs(List<DatabaseGraph> graphDB) {
        int labelV2;
        int v2;
        int labelV1;
        Vertex v1;
        int i;
        Vertex[] vertices;
        if (this.DEBUG_MODE) {
            System.out.println("Calculating the pruning matrix...");
        }
        SparseTriangularMatrix matrix = new SparseTriangularMatrix();
        HashSet<Pair> alreadySeenPair = new HashSet<Pair>();
        HashMap<Integer, Integer> mapEdgeLabelToSupport = new HashMap<Integer, Integer>();
        HashSet<Integer> alreadySeenEdgeLabel = new HashSet<Integer>();
        for (DatabaseGraph g : graphDB) {
            vertices = g.getAllVertices();
            i = 0;
            while (i < vertices.length) {
                v1 = vertices[i];
                labelV1 = v1.getLabel();
                for (Edge edge : v1.getEdgeList()) {
                    int edgeLabel;
                    v2 = edge.another(v1.getId());
                    labelV2 = g.getVLabel(v2);
                    Pair pair = new Pair(labelV1, labelV2);
                    boolean seen = alreadySeenPair.contains(pair);
                    if (!seen) {
                        matrix.incrementCount(labelV1, labelV2);
                        alreadySeenPair.add(pair);
                    }
                    if (alreadySeenEdgeLabel.contains(edgeLabel = edge.getEdgeLabel())) continue;
                    alreadySeenEdgeLabel.add(edgeLabel);
                    Integer edgeSupport = (Integer)mapEdgeLabelToSupport.get(edgeLabel);
                    if (edgeSupport == null) {
                        mapEdgeLabelToSupport.put(edgeLabel, 1);
                        continue;
                    }
                    mapEdgeLabelToSupport.put(edgeLabel, edgeSupport + 1);
                }
                ++i;
            }
            alreadySeenPair.clear();
            alreadySeenEdgeLabel.clear();
        }
        alreadySeenPair = null;
        if (this.DEBUG_MODE) {
            System.out.println("Removing infrequent pairs...  minsup = " + this.minSup);
        }
        matrix.removeInfrequentEntriesFromMatrix(this.minSup);
        for (DatabaseGraph g : graphDB) {
            vertices = g.getAllVertices();
            i = 0;
            while (i < vertices.length) {
                v1 = vertices[i];
                labelV1 = v1.getLabel();
                Iterator<Edge> iter = v1.getEdgeList().iterator();
                while (iter.hasNext()) {
                    Edge edge = iter.next();
                    v2 = edge.another(v1.getId());
                    labelV2 = g.getVLabel(v2);
                    int count = matrix.getSupportForItems(labelV1, labelV2);
                    if (count < this.minSup) {
                        iter.remove();
                        ++this.infrequentVertexPairsRemoved;
                        continue;
                    }
                    if ((Integer)mapEdgeLabelToSupport.get(edge.getEdgeLabel()) >= this.minSup) continue;
                    iter.remove();
                    ++this.edgeRemovedByLabel;
                }
                ++i;
            }
        }
    }

    private void cgSpanDFS(DFSCode c, List<DatabaseGraph> graphDB, Set<Integer> graphIds, Projected projected, EarlyTerminationFailureHandler earlyTerminationFailureHandler) throws IOException, ClassNotFoundException {
        if (c.size() == this.maxNumberOfEdges - 1) {
            return;
        }
        EarlyTerminationResult earlyTerminationResult = this.earlyTermination(graphIds, projected, earlyTerminationFailureHandler);
        if (earlyTerminationResult.isEarlyTerminationFailure()) {
            ++this.earlyTerminationFailureDetectedCount;
        }
        if (earlyTerminationResult.isEarlyTermination()) {
            ++this.earlyTerminationAppliedCount;
            return;
        }
        Map<ExtendedEdge, Projected> extensions = this.rightMostPathExtensions(c, graphDB, projected);
        if (extensions != null) {
            ArrayList<ExtendedEdge> orderedExtensions = new ArrayList<ExtendedEdge>(extensions.keySet());
            Collections.sort(orderedExtensions, new ExtendedEdgeLexicographicalComparator());
            for (ExtendedEdge extension : orderedExtensions) {
                Projected newProjected = extensions.get(extension);
                Set<Integer> newGraphIDs = newProjected.getGraphIds();
                int sup = newGraphIDs.size();
                if (sup < this.minSup) continue;
                DFSCode newC = c.copy();
                newC.add(extension);
                if (!this.isCanonical(newC)) continue;
                this.cgSpanDFS(newC, graphDB, newGraphIDs, newProjected, earlyTerminationFailureHandler);
            }
        }
        if (c.size() > 0) {
            if (this.detectEarlyTerminationFailure) {
                earlyTerminationFailureHandler.analyze(c, projected, extensions);
            }
            if (earlyTerminationResult.isEarlyTerminationFailure) {
                return;
            }
            boolean hasEquivalentOccurrence = false;
            if (extensions != null) {
                for (Projected extendedProjected : extensions.values()) {
                    if (!projected.hasEquivalentOccurrence(extendedProjected)) continue;
                    hasEquivalentOccurrence = true;
                    break;
                }
            }
            if (!hasEquivalentOccurrence) {
                ClosedSubgraph subgraph = new ClosedSubgraph(c, graphIds, graphIds.size(), projected);
                this.closedSubgraphs.add(subgraph);
                this.updateClosedSubgraphsHashTable(subgraph);
            }
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean isCanonical(DFSCode c) {
        DFSCode canC = new DFSCode();
        int i = 0;
        while (i < c.size()) {
            Map<ExtendedEdge, Set<Integer>> extensions = this.rightMostPathExtensionsFromSingle(canC, new Graph(c));
            ExtendedEdge minEE = null;
            for (ExtendedEdge ee : extensions.keySet()) {
                if (!ee.smallerThanOriginal(minEE)) continue;
                minEE = ee;
            }
            if (minEE.smallerThanOriginal(c.getAt(i))) {
                return false;
            }
            canC.add(minEE);
            ++i;
        }
        return true;
    }

    private void findAllOnlyOneVertex(List<DatabaseGraph> graphDB) {
        this.frequentVertexLabels = new ArrayList<Integer>();
        HashMap<Integer, HashSet<Integer>> labelM = new HashMap<Integer, HashSet<Integer>>();
        for (DatabaseGraph databaseGraph : graphDB) {
            for (Vertex v : databaseGraph.getNonPrecalculatedAllVertices()) {
                if (v.getEdgeList().isEmpty()) continue;
                Integer vLabel = v.getLabel();
                HashSet<Integer> set = (HashSet<Integer>)labelM.get(vLabel);
                if (set == null) {
                    set = new HashSet<Integer>();
                    labelM.put(vLabel, set);
                }
                set.add(databaseGraph.getId());
            }
        }
        for (Map.Entry entry : labelM.entrySet()) {
            int label = (Integer)entry.getKey();
            Set tempSupG = (Set)entry.getValue();
            int sup = tempSupG.size();
            if (sup >= this.minSup) {
                this.frequentVertexLabels.add(label);
                continue;
            }
            for (Integer graphid : tempSupG) {
                Graph g = graphDB.get(graphid);
                g.removeInfrequentLabel(label);
                ++this.infrequentVerticesRemovedCount;
            }
        }
    }

    private void outputClosedOneVertex(List<DatabaseGraph> graphDB, Projected projected) {
        HashMap<Integer, HashSet<Integer>> labelM = new HashMap<Integer, HashSet<Integer>>();
        this.labelCountM = new HashMap();
        this.labelInGraphCountM = new HashMap<Integer, Map<Integer, Integer>>();
        Set<Integer> gids = projected.getGraphIds();
        for (DatabaseGraph g : graphDB) {
            if (!gids.contains(g.getId())) continue;
            Vertex[] vertexArray = g.getAllVertices();
            int n = vertexArray.length;
            int n2 = 0;
            while (n2 < n) {
                Vertex v = vertexArray[n2];
                if (!v.getEdgeList().isEmpty()) {
                    Integer vLabel = v.getLabel();
                    HashSet<Integer> set = (HashSet<Integer>)labelM.get(vLabel);
                    if (set == null) {
                        set = new HashSet<Integer>();
                        labelM.put(vLabel, set);
                    }
                    set.add(g.getId());
                    if (!this.labelCountM.containsKey(vLabel)) {
                        this.labelCountM.put(vLabel, 0);
                    }
                    this.labelCountM.put(vLabel, this.labelCountM.get(vLabel) + 1);
                    if (!this.labelInGraphCountM.containsKey(g.getId())) {
                        this.labelInGraphCountM.put(g.getId(), new HashMap());
                    }
                    if (!this.labelInGraphCountM.get(g.getId()).containsKey(vLabel)) {
                        this.labelInGraphCountM.get(g.getId()).put(vLabel, 0);
                    }
                    this.labelInGraphCountM.get(g.getId()).put(vLabel, this.labelInGraphCountM.get(g.getId()).get(vLabel) + 1);
                }
                ++n2;
            }
        }
        Map<ExtendedEdge, Projected> extensions = this.rightMostPathExtensions(new DFSCode(), graphDB, projected);
        for (Map.Entry entry : labelM.entrySet()) {
            int label = (Integer)entry.getKey();
            Set tempSupG = (Set)entry.getValue();
            int sup = tempSupG.size();
            if (sup < this.minSup) continue;
            boolean output = true;
            int labelCount = this.labelCountM.get(label);
            for (ExtendedEdge extendedEdge : extensions.keySet()) {
                Projected extensionProjected;
                int labelCountInProjections;
                if (extendedEdge.vLabel1 != label && extendedEdge.vLabel2 != label || (labelCountInProjections = (extensionProjected = extensions.get(extendedEdge)).verticesWithLabelCount(label, graphDB)) != labelCount) continue;
                output = false;
                break;
            }
            if (!output) continue;
            DFSCode tempD = new DFSCode();
            tempD.add(new ExtendedEdge(0, 0, label, label, -1));
            this.closedSubgraphs.add(new ClosedSubgraph(tempD, tempSupG, sup, new Projected()));
        }
    }

    public boolean isDetectEarlyTerminationFailure() {
        return this.detectEarlyTerminationFailure;
    }

    public void setDetectEarlyTerminationFailure(boolean detectEarlyTerminationFailure) {
        this.detectEarlyTerminationFailure = detectEarlyTerminationFailure;
    }

    public void printStats() {
        System.out.println("=============  CGSPAN v2.53 - STATS =============");
        System.out.println(" Number of graph in the input database: " + this.graphCount);
        System.out.println(" Frequent subgraph count : " + this.patternCount);
        System.out.println(" Total time ~ " + this.runtime + " s");
        System.out.println(" Minsup : " + this.minSup + " graphs");
        System.out.println(" Maximum memory usage : " + this.maxmemory + " mb");
        if (this.DEBUG_MODE) {
            System.out.println("  -------------------");
            System.out.println("  Number of infrequent vertices pruned : " + this.infrequentVerticesRemovedCount);
            System.out.println("  Empty graphs removed : " + this.emptyGraphsRemoved);
            System.out.println("  Number of infrequent vertex pairs pruned : " + this.infrequentVertexPairsRemoved);
            System.out.println("  Number of infrequent edge labels pruned : " + this.edgeRemovedByLabel);
            System.out.println("  Extensions skipped (edge count pruning) : " + this.pruneByEdgeCountCount);
            System.out.println("early termination was applied " + this.earlyTerminationAppliedCount + " times");
            System.out.println("early termination failure was detected " + this.earlyTerminationFailureDetectedCount + " times");
        }
        System.out.println("===================================================");
    }

    public void setDebugMode(boolean value) {
        this.DEBUG_MODE = value;
    }

    private class EarlyTerminationResult {
        private boolean earlyTermination;
        private boolean isEarlyTerminationFailure;

        public EarlyTerminationResult(boolean earlyTermination, boolean isEarlyTerminationFailure) {
            this.earlyTermination = earlyTermination;
            this.isEarlyTerminationFailure = isEarlyTerminationFailure;
        }

        public boolean isEarlyTermination() {
            return this.earlyTermination;
        }

        public boolean isEarlyTerminationFailure() {
            return this.isEarlyTerminationFailure;
        }
    }

    public class ExtendedEdgeLexicographicalComparator
    implements Comparator<ExtendedEdge> {
        @Override
        public int compare(ExtendedEdge ee1, ExtendedEdge ee2) {
            if (ee1.equals(ee2)) {
                return 0;
            }
            if (ee1.smallerThanOriginal(ee2)) {
                return -1;
            }
            return 1;
        }
    }

    class Pair {
        int x;
        int y;

        Pair(int x, int y) {
            if (x < y) {
                this.x = x;
                this.y = y;
            } else {
                this.x = y;
                this.y = x;
            }
        }

        public boolean equals(Object obj) {
            Pair other = (Pair)obj;
            return other.x == this.x && other.y == this.y;
        }

        public int hashCode() {
            return this.x + 100 * this.y;
        }
    }
}

