/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.ParametersSettingAERMiner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class RandomDatasetGenerator {
    private static int noTimestamps = 0;
    private static int noVertex = 0;
    private static int noEdges = 0;
    private static int noAttribute = 0;
    private static String rootPath = String.valueOf(ParametersSettingAERMiner.projectPath) + "/dataset/synthetic/";
    private static String attrMapFileName = "/attrMap.txt";
    private static String edgesFileName = "/edges.txt";
    private static String attributesFileName = "/attributes.txt";
    private static String attrMapFilePath;
    private static String edgesFilePath;
    private static String attributesFilePath;
    private static String letters;
    private static String numbers;

    static {
        letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        numbers = "0123456789";
    }

    public static void main(String[] args) throws IOException {
        noTimestamps = 8;
        noVertex = 280;
        noEdges = 4;
        noAttribute = 8;
        RandomDatasetGenerator.generateDirectoryAndFiles();
        RandomDatasetGenerator.generateAttributeMapping();
        RandomDatasetGenerator.generateAttributes();
        RandomDatasetGenerator.generateEdges();
    }

    private static void generateAttributeMapping() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(attrMapFilePath));
        int count = 0;
        int i = 0;
        while (i < numbers.length() && count < noAttribute) {
            int j = 0;
            while (j < letters.length() && count < noAttribute) {
                ++count;
                String attribute = "" + letters.charAt(j) + numbers.charAt(i);
                bw.write(String.valueOf(attribute) + "\n");
                ++j;
            }
            ++i;
        }
        bw.close();
    }

    private static void generateEdges() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(edgesFilePath));
        int t = 0;
        while (t < noTimestamps) {
            StringBuilder sb = new StringBuilder();
            sb.append("T").append(t).append("\n");
            int v = 0;
            while (v < noVertex) {
                int anotherV;
                sb.append(v);
                int noEdge = RandomDatasetGenerator.gaussianNumber(noEdges, 6.0);
                HashSet<Integer> edgeList = new HashSet<Integer>();
                while (edgeList.size() < noEdge) {
                    anotherV = new Random().nextInt(noVertex);
                    if (anotherV == v) continue;
                    edgeList.add(anotherV);
                }
                Iterator iterator = edgeList.iterator();
                while (iterator.hasNext()) {
                    anotherV = (Integer)iterator.next();
                    sb.append(" ").append(anotherV);
                }
                sb.append("\n");
                ++v;
            }
            bw.write(sb.toString());
            ++t;
        }
        bw.close();
    }

    private static void generateAttributes() throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(attributesFilePath));
        int t = 0;
        while (t < noTimestamps) {
            StringBuilder sb = new StringBuilder();
            sb.append("T").append(t).append("\n");
            int v = 0;
            while (v < noVertex) {
                sb.append(v);
                int a = 0;
                while (a < noAttribute) {
                    sb.append(" ").append(RandomDatasetGenerator.gaussianNumber(0.0, 1.0));
                    ++a;
                }
                sb.append("\n");
                ++v;
            }
            bw.write(sb.toString());
            ++t;
        }
        bw.close();
    }

    private static int gaussianNumber(double mean, double stdV) {
        int num = (int)Math.floor(mean + stdV * new Random().nextGaussian());
        return num >= 0 ? num : -num;
    }

    private static void generateDirectoryAndFiles() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("t").append(noTimestamps).append("_v").append(noVertex).append("_e").append(noEdges).append("_a").append(noAttribute);
        String dirName = sb.toString();
        String dirPath = String.valueOf(rootPath) + dirName;
        File dirFile = new File(dirPath);
        dirFile.mkdir();
        LinkedList<File> files = new LinkedList<File>();
        attrMapFilePath = String.valueOf(dirPath) + attrMapFileName;
        edgesFilePath = String.valueOf(dirPath) + edgesFileName;
        attributesFilePath = String.valueOf(dirPath) + attributesFileName;
        files.add(new File(attrMapFilePath));
        files.add(new File(edgesFilePath));
        files.add(new File(attributesFilePath));
        for (File file : files) {
            file.createNewFile();
        }
    }
}

