/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CorePattern
implements Cloneable {
    private int size;
    private int childAttr;
    private List<Integer> parentAttr = new ArrayList<Integer>();

    public CorePattern(int attribute) {
        this.childAttr = attribute;
        this.size = 1;
    }

    public void growParentAttr(int attr) {
        this.parentAttr.add(attr);
        ++this.size;
    }

    public void deleteLastAttr() {
        if (this.parentAttr.size() > 0) {
            this.parentAttr.remove(this.parentAttr.size() - 1);
            --this.size;
        }
    }

    public int getLastAttr() {
        return this.parentAttr.size() == 0 ? 0 : this.parentAttr.get(this.parentAttr.size() - 1);
    }

    public int getSize() {
        return this.size;
    }

    public int getChildAttr() {
        return this.childAttr;
    }

    public List<Integer> getParentAttr() {
        return this.parentAttr;
    }

    public String toString() {
        return "CorePattern{ childAttr=" + this.childAttr + ", parentAttr=" + this.parentAttr + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorePattern pattern = (CorePattern)o;
        return this.getSize() == pattern.getSize() && this.getChildAttr() == pattern.getChildAttr() && this.getParentAttr().containsAll(pattern.getParentAttr());
    }

    public int hashCode() {
        return Objects.hash(this.getSize(), this.getChildAttr(), this.getParentAttr());
    }

    public CorePattern clone() {
        CorePattern p = new CorePattern(this.getChildAttr());
        if (this.getParentAttr() == null) {
            this.parentAttr = new ArrayList<Integer>();
        }
        for (int attr : this.getParentAttr()) {
            p.growParentAttr(attr);
        }
        return p;
    }
}

