/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.graph_mining.aerminer;

import ca.pfv.spmf.algorithms.graph_mining.aerminer.AttributedGraph;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.CorePattern;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.Instance;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.ParametersSettingAERMiner;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.Preprocess;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.SupportPoint;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.SupportPoints;
import ca.pfv.spmf.algorithms.graph_mining.aerminer.Vertex;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.ParametersSetting;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoAERMiner {
    private Map<Integer, AttributedGraph> trendDyAg;
    private int minSupRelative = Integer.MAX_VALUE;
    private double minConf = ParametersSettingAERMiner.MINCONF;
    private Map<Integer, Map<Integer, Double>> expectConBasedAttr = new HashMap<Integer, Map<Integer, Double>>();
    private Map<Integer, Double> expectConfience = new HashMap<Integer, Double>();
    private Map<Integer, String> eventTypeMapping = new LinkedHashMap<Integer, String>();
    private Map<Integer, SupportPoints> attrPointSet = new HashMap<Integer, SupportPoints>();
    private Map<CorePattern, Double> patterntoConfidence = new HashMap<CorePattern, Double>();
    private List<Map<CorePattern, Set<Instance>>> patterns;
    private List<List<CorePattern>> merge = new ArrayList<List<CorePattern>>();
    private int patternCount = 0;
    private long totalMiningTime = 0L;

    public void runAlgorithm(String inputDirectory, String outputPath, double minsup, double minconf, double minlift) throws IOException {
        ParametersSettingAERMiner.EDGE_FILE_PATH = String.valueOf(inputDirectory) + "graph.txt";
        ParametersSettingAERMiner.ATTRI_MAPPING_PATH = String.valueOf(inputDirectory) + "attributes_mapping.txt";
        ParametersSettingAERMiner.ATTR_FILE_PATH = String.valueOf(inputDirectory) + "attributes.txt";
        ParametersSettingAERMiner.VERTEX_MAP_NAME_PATH = String.valueOf(inputDirectory) + "vertices_mapping.txt";
        ParametersSettingAERMiner.MINSUP = minsup;
        ParametersSettingAERMiner.MINCONF = minconf;
        ParametersSettingAERMiner.MINLIFT = minlift;
        ParametersSettingAERMiner.PATTERN_PATH = outputPath;
        this.totalMiningTime = System.currentTimeMillis();
        this.trendDyAg = null;
        this.expectConBasedAttr = new HashMap<Integer, Map<Integer, Double>>();
        this.expectConfience = new HashMap<Integer, Double>();
        this.eventTypeMapping = new LinkedHashMap<Integer, String>();
        this.attrPointSet = new HashMap<Integer, SupportPoints>();
        this.patterntoConfidence = new HashMap<CorePattern, Double>();
        this.patterns = null;
        this.merge = new ArrayList<List<CorePattern>>();
        this.trendDyAg = Preprocess.convertToTrendGraph();
        this.eventTypeMapping = Preprocess.findEventTypeMapping();
        this.getAttrSupPointSet();
        this.calExpectConfidence();
        System.out.println("Start to seach pattern by bfs");
        this.bfsSearch();
        System.out.println("seach pattern by bfs end!");
        MemoryLogger.getInstance().checkMemory();
        this.filterCorePattern();
        this.mergeCorePatternSameChild();
        this.mergeCorePatternSamePattern();
        MemoryLogger.getInstance().checkMemory();
        System.out.println(this.eventTypeMapping);
        this.writePatternOnFile();
        this.totalMiningTime = System.currentTimeMillis() - this.totalMiningTime;
    }

    private void bfsSearch() {
        this.patterns = new ArrayList<Map<CorePattern, Set<Instance>>>();
        this.patterns.add(this.extendCorePattern(this.generateAllCoreVertex()));
        int i = 0;
        while (i < 2) {
            if (this.patterns.get(this.patterns.size() - 1) == null) break;
            this.patterns.add(this.extendCorePattern(this.patterns.get(this.patterns.size() - 1)));
            System.out.println("size " + (i + 3) + " patterns complete!");
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void mergeCorePatternSameChild() {
        int size = 0;
        while (size < this.patterns.size()) {
            Map<CorePattern, Set<Instance>> sizeiPatterns = this.patterns.get(size);
            ArrayList<CorePattern> sortpattern = new ArrayList<CorePattern>(sizeiPatterns.keySet());
            sortpattern.sort(Comparator.comparingInt(CorePattern::getChildAttr));
            int[] visted = new int[sortpattern.size()];
            int i = 0;
            while (i < sortpattern.size()) {
                if (visted[i] != 1) {
                    int j = i + 1;
                    while (j < sortpattern.size()) {
                        if (visted[j] != 1) {
                            CorePattern p1 = (CorePattern)sortpattern.get(i);
                            CorePattern p2 = (CorePattern)sortpattern.get(j);
                            if (p1.getChildAttr() != p2.getChildAttr()) break;
                            HashSet instances1 = new HashSet(sizeiPatterns.get(p1));
                            HashSet instances2 = new HashSet(sizeiPatterns.get(p2));
                            HashSet joinSet = new HashSet();
                            joinSet.addAll(instances1);
                            joinSet.retainAll(instances2);
                            if (joinSet.size() > this.minSupRelative) {
                                ArrayList<CorePattern> mergePari = new ArrayList<CorePattern>();
                                mergePari.add(p1);
                                mergePari.add(p2);
                                this.merge.add(mergePari);
                                visted[i] = 1;
                                visted[j] = 1;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++size;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void mergeCorePatternSamePattern() {
        int size = 0;
        while (size < this.patterns.size()) {
            Map<CorePattern, Set<Instance>> sizeiPatterns = this.patterns.get(size);
            ArrayList<CorePattern> keys = new ArrayList<CorePattern>(sizeiPatterns.keySet());
            int[] visted = new int[keys.size()];
            int i = 0;
            while (i < keys.size()) {
                if (visted[i] != 1) {
                    int j = i + 1;
                    while (j < keys.size()) {
                        CorePattern p1 = (CorePattern)keys.get(i);
                        CorePattern p2 = (CorePattern)keys.get(j);
                        ArrayList<Integer> list = new ArrayList<Integer>();
                        list.addAll(p1.getParentAttr());
                        list.retainAll(p2.getParentAttr());
                        if (list.size() != size + 1 || visted[j] == 1) break;
                        HashSet instances1 = new HashSet(sizeiPatterns.get(p1));
                        HashSet instances2 = new HashSet(sizeiPatterns.get(p2));
                        HashSet joinSet = new HashSet();
                        joinSet.addAll(instances1);
                        joinSet.retainAll(instances2);
                        if (joinSet.size() > this.minSupRelative) {
                            ArrayList<CorePattern> mergePari = new ArrayList<CorePattern>();
                            mergePari.add(p1);
                            mergePari.add(p2);
                            this.merge.add(mergePari);
                            visted[i] = 1;
                            visted[j] = 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++size;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void filterCorePattern() {
        MemoryLogger.getInstance().checkMemory();
        int i = 0;
        while (i < this.patterns.size()) {
            Iterator<CorePattern> it = this.patterns.get(i).keySet().iterator();
            while (it.hasNext()) {
                CorePattern p = it.next();
                if (i > 0) {
                    int attr = p.getLastAttr();
                    p.deleteLastAttr();
                    this.patterns.get(i - 1).remove(p);
                    this.patterntoConfidence.remove(p);
                    p.growParentAttr(attr);
                }
                if (!(this.patterntoConfidence.get(p) < this.minConf)) continue;
                it.remove();
                this.patterntoConfidence.remove(p);
            }
            ++i;
        }
        i = 0;
        while (i < this.patterns.size()) {
            System.out.println("size " + (i + 2) + "pattern number" + " : " + this.patterns.get(i).size());
            ++i;
        }
    }

    public Map<CorePattern, Set<Instance>> generateAllCoreVertex() {
        HashMap<CorePattern, Set<Instance>> patterns = new HashMap<CorePattern, Set<Instance>>();
        for (Map.Entry<Integer, SupportPoints> entry : this.attrPointSet.entrySet()) {
            Integer attr = entry.getKey();
            if (attr % 3 == 2) continue;
            SupportPoints sups = this.attrPointSet.get(attr);
            CorePattern p = new CorePattern(attr);
            HashSet<Instance> isos = new HashSet<Instance>();
            for (int timestamp : sups.getSupportPoints().keySet()) {
                for (int vId : sups.getSupportPoints().get(timestamp)) {
                    isos.add(new Instance(new SupportPoint(timestamp, vId)));
                }
            }
            patterns.put(p, isos);
        }
        return patterns;
    }

    public Map<CorePattern, Set<Instance>> extendCorePattern(Map<CorePattern, Set<Instance>> patterns) {
        HashMap<CorePattern, Set<Instance>> newPatterns = new HashMap<CorePattern, Set<Instance>>();
        for (Map.Entry<CorePattern, Set<Instance>> entry : patterns.entrySet()) {
            CorePattern pattern = entry.getKey();
            for (Map.Entry<Integer, SupportPoints> entry2 : this.attrPointSet.entrySet()) {
                Integer attr = entry2.getKey();
                int lastAttr = pattern.getLastAttr();
                if (attr % 3 == 2 || lastAttr > attr) continue;
                CorePattern newPattern = pattern.clone();
                newPattern.growParentAttr(attr);
                Set<Instance> newInstace = this.mapGrowth(attr, patterns.get(pattern));
                int support = newInstace.size();
                if (support <= this.minSupRelative) continue;
                double[] confidenceAndLift = this.calNewPatternLift(attr, pattern, patterns.get(pattern));
                double confidence = confidenceAndLift[0];
                double lift = confidenceAndLift[1];
                if (!(lift > ParametersSettingAERMiner.MINLIFT)) continue;
                newPatterns.put(newPattern, newInstace);
                this.patterntoConfidence.put(newPattern, confidence);
            }
        }
        System.out.println("candidate num:" + newPatterns.size());
        MemoryLogger.getInstance().checkMemory();
        return newPatterns;
    }

    private double[] calNewPatternLift(int attr, CorePattern pattern, Set<Instance> instances) {
        double lift;
        double[] result = new double[2];
        int count = 0;
        int sum = 0;
        for (Instance instance : instances) {
            SupportPoint sp = instance.getChildPoint();
            int vId = sp.getvId();
            int timeStamp = sp.getTimestamp() - 1;
            if (timeStamp < 0) continue;
            List<Integer> used = instance.getParentVIds();
            Set<Integer> neighbors = this.trendDyAg.get(timeStamp).getNeighbors(vId);
            neighbors.removeAll(used);
            for (int id : neighbors) {
                ++sum;
                if (this.trendDyAg.get(timeStamp).getVertex(id) == null || !this.trendDyAg.get(timeStamp).getVertex(id).getAttrDouMap().containsKey(attr)) continue;
                ++count;
            }
        }
        double confidence = (double)count / (double)sum;
        if (pattern.getSize() == 1) {
            double expectCon = this.expectConfience.get(attr);
            lift = confidence / expectCon;
            this.expectConBasedAttr.computeIfAbsent(pattern.getChildAttr(), k -> new HashMap());
            this.expectConBasedAttr.get(pattern.getChildAttr()).put(attr, confidence);
        } else {
            double expectCon = this.expectConBasedAttr.get(pattern.getChildAttr()).get(attr);
            lift = confidence / expectCon;
        }
        result[0] = confidence;
        result[1] = lift;
        return result;
    }

    private Set<Instance> mapGrowth(int attr, Set<Instance> instances) {
        HashSet<Instance> newInstaces = new HashSet<Instance>();
        for (Instance instance : instances) {
            SupportPoint sp = instance.getChildPoint();
            int vId = sp.getvId();
            int timeStamp = sp.getTimestamp() - 1;
            if (timeStamp < 0) continue;
            List<Integer> used = instance.getParentVIds();
            Set<Integer> neighbors = this.trendDyAg.get(timeStamp).getNeighbors(vId);
            neighbors.removeAll(used);
            MemoryLogger.getInstance().checkMemory();
            for (int id : neighbors) {
                if (this.trendDyAg.get(timeStamp).getVertex(id) == null || !this.trendDyAg.get(timeStamp).getVertex(id).getAttrDouMap().containsKey(attr)) continue;
                Instance newInstance = instance.clone();
                newInstance.growParent(id);
                newInstaces.add(newInstance);
                break;
            }
            MemoryLogger.getInstance().checkMemory();
        }
        MemoryLogger.getInstance().checkMemory();
        return newInstaces;
    }

    public void getAttrSupPointSet() {
        this.attrPointSet = new HashMap<Integer, SupportPoints>();
        int[] attCount = new int[ParametersSettingAERMiner.TOTAL_NUM_ATTR * 3 + 1];
        int i = 0;
        while (i < this.trendDyAg.size()) {
            AttributedGraph trendAg = this.trendDyAg.get(i);
            for (int vId : trendAg.getAllVerticeId()) {
                Vertex v = trendAg.getVertex(vId);
                Iterator<Integer> iterator = v.getAttrDouMap().keySet().iterator();
                while (iterator.hasNext()) {
                    int attribute;
                    int n = attribute = iterator.next().intValue();
                    attCount[n] = attCount[n] + 1;
                    SupportPoints sp = this.attrPointSet.get(attribute);
                    if (sp == null) {
                        sp = new SupportPoints();
                        this.attrPointSet.put(attribute, sp);
                    }
                    sp.addPoint(i, vId);
                }
            }
            ++i;
        }
        this.minSupRelative = (int)((double)(this.trendDyAg.size() * this.trendDyAg.get(0).getVerNum()) * ParametersSettingAERMiner.MINSUP);
        System.out.println("minSupRelative:" + this.minSupRelative);
    }

    private void calExpectConfidence() {
        for (Map.Entry<Integer, SupportPoints> entry : this.attrPointSet.entrySet()) {
            Integer attr = entry.getKey();
            this.expectConfience.put(attr, (double)this.attrPointSet.get(attr).getSize() / (double)(this.trendDyAg.size() * this.trendDyAg.get(0).getVerNum()));
        }
        System.out.println(this.expectConfience);
    }

    public void writePatternOnFile() throws IOException {
        FileWriter fileWriter = new FileWriter(ParametersSettingAERMiner.PATTERN_PATH);
        int i = 0;
        while (i < this.patterns.size()) {
            fileWriter.write("size " + (i + 2) + "pattern," + "count: " + this.patterns.get(i).size() + "\n");
            for (Map.Entry<CorePattern, Set<Instance>> entry : this.patterns.get(i).entrySet()) {
                CorePattern corePattern = entry.getKey();
                fileWriter.write(String.valueOf(corePattern.toString()) + " #SUP: " + this.patterns.get(i).get(corePattern).size() + " #CONF: " + this.patterntoConfidence.get(corePattern) + "\n");
            }
            this.patternCount += this.patterns.get(i).size();
            ++i;
        }
        fileWriter.close();
    }

    public void printStats() {
        System.out.println("=============  AERMiner v2.44 - STATS =============");
        System.out.println(" Time to prepare the data: " + ParametersSetting.PREPARE + " ms");
        System.out.println(" Time to mine patterns from data: " + this.totalMiningTime + " ms");
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Pattern count: " + this.patternCount);
        System.out.println("====================================================");
    }
}

