/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.vhuqi;

import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.EnumCombination;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.QItemTrans;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.Qitem;
import ca.pfv.spmf.algorithms.frequentpatterns.fhuqiminer.UtilityListFHUQIMiner;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;

public class AlgoVHUQI {
    public String outputFile;
    public String inputDatabase;
    private BufferedWriter writer_hqui = null;
    private Hashtable<Qitem, Integer> mapItemToTwu;
    private Hashtable<Integer, Integer> mapItemToProfit;
    private Hashtable<Integer, Integer> mapTransactionToUtility;
    private long minUtil;
    private long totalU;
    private int coefficient;
    private EnumCombination combiningMethod;
    long maxMemory = 0L;
    long startTime;
    long endTime;
    public float percent;
    private int HUQIcount = 0;
    private int countUL = 0;
    private int countConstruct = 0;
    private Qitem currentQitem;
    private final int BUFFERS_SIZE = 200;
    private Qitem[] itemsetBuffer = null;

    public void runAlgorithm(String inputData, String inputProfit, float minUtility, int coef, EnumCombination combinationmethod, String outputPath) throws IOException {
        System.gc();
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.writer_hqui = new BufferedWriter(new FileWriter(outputPath));
        this.itemsetBuffer = new Qitem[200];
        this.coefficient = coef;
        this.percent = minUtility;
        this.combiningMethod = combinationmethod;
        this.mapItemToProfit = new Hashtable();
        this.mapTransactionToUtility = new Hashtable();
        this.totalU = 0L;
        ArrayList<Qitem> qitemNameList = new ArrayList<Qitem>();
        Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList = new Hashtable<Qitem, UtilityListFHUQIMiner>();
        System.out.println("1. Build Initial Q-Utility Lists");
        this.buildInitialQUtilityLists(inputData, inputProfit, qitemNameList, mapItemToUtilityList);
        MemoryLogger.getInstance().checkMemory();
        System.out.println("2. Find Initial High Utility Range Q-items");
        ArrayList<Qitem> candidateList = new ArrayList<Qitem>();
        ArrayList<Qitem> hwQUI = new ArrayList<Qitem>();
        this.findInitialRHUQIs(qitemNameList, mapItemToUtilityList, candidateList, hwQUI);
        MemoryLogger.getInstance().checkMemory();
        System.out.println("3. Recurcive Mining Procedure");
        this.miner(this.itemsetBuffer, 0, null, mapItemToUtilityList, qitemNameList, this.writer_hqui, hwQUI);
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        this.writer_hqui.close();
    }

    public void printStatistics() {
        System.out.println("============= VHUQI v 2.45 Statistical results===============");
        System.out.println("MinUtil(%): " + this.percent);
        System.out.println("Coefficient:" + this.coefficient);
        System.out.println("HUQIcount:" + this.HUQIcount);
        System.out.println("Runtime: " + (double)(this.endTime - this.startTime) / 1000.0 + " (s)");
        System.out.println("Memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " (Mb)");
        System.out.println("Join opertaion count: " + this.countConstruct);
        System.out.println("================================================");
    }

    public void buildInitialQUtilityLists(String inputData, String inputProfit, ArrayList<Qitem> qitemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList) throws IOException {
        String str;
        BufferedReader br_profitTable = new BufferedReader(new FileReader(inputProfit));
        BufferedReader br_inputDatabase = new BufferedReader(new FileReader(inputData));
        while ((str = br_profitTable.readLine()) != null) {
            String[] itemProfit = str.split(", ");
            if (itemProfit.length < 2) continue;
            int profit = Integer.parseInt(itemProfit[1]);
            if (profit == 0) {
                profit = 1;
            }
            int item = Integer.parseInt(itemProfit[0]);
            this.mapItemToProfit.put(item, profit);
        }
        br_profitTable.close();
        this.mapItemToTwu = new Hashtable();
        int tid = 0;
        this.currentQitem = new Qitem(0, 0);
        while ((str = br_inputDatabase.readLine()) != null) {
            ++tid;
            String[] itemInfo = str.split(" ");
            int transactionU = 0;
            int i = 0;
            while (i < itemInfo.length) {
                this.currentQitem.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                this.currentQitem.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                this.currentQitem.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                transactionU += this.currentQitem.getQteMin() * this.mapItemToProfit.get(this.currentQitem.getItem());
                ++i;
            }
            i = 0;
            while (i < itemInfo.length) {
                this.currentQitem.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                this.currentQitem.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                this.currentQitem.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                Qitem Q = new Qitem();
                Q.copy(this.currentQitem);
                if (!this.mapItemToTwu.containsKey(Q)) {
                    this.mapItemToTwu.put(Q, transactionU);
                } else {
                    this.mapItemToTwu.put(Q, this.mapItemToTwu.get(Q) + transactionU);
                }
                ++i;
            }
            this.totalU += (long)transactionU;
        }
        this.minUtil = (long)((float)this.totalU * this.percent);
        for (Qitem item : this.mapItemToTwu.keySet()) {
            if (!((double)this.mapItemToTwu.get(item).intValue() >= Math.floor(this.minUtil / (long)this.coefficient))) continue;
            UtilityListFHUQIMiner ul = new UtilityListFHUQIMiner(item, 0L);
            mapItemToUtilityList.put(item, ul);
            qitemNameList.add(item);
        }
        br_inputDatabase.close();
        MemoryLogger.getInstance().checkMemory();
        br_inputDatabase = new BufferedReader(new FileReader(inputData));
        str = "";
        tid = 0;
        while ((str = br_inputDatabase.readLine()) != null) {
            ++tid;
            String[] itemInfo = str.split(" ");
            ArrayList qItemset = new ArrayList();
            int remainingUtility = 0;
            Integer newTWU = 0;
            ArrayList<Qitem> revisedTransaction = new ArrayList<Qitem>();
            int i = 0;
            while (i < itemInfo.length) {
                Qitem Q = new Qitem();
                Q.setItem(Integer.valueOf(new String(itemInfo[i].substring(0, itemInfo[i].indexOf(44)))));
                Q.setQteMin(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                Q.setQteMax(Integer.valueOf(new String(itemInfo[i].substring(itemInfo[i].indexOf(44) + 1, itemInfo[i].length()))));
                if (mapItemToUtilityList.containsKey(Q)) {
                    revisedTransaction.add(Q);
                    remainingUtility += Q.getQteMin() * this.mapItemToProfit.get(Q.getItem());
                    newTWU = newTWU + Q.getQteMin() * this.mapItemToProfit.get(Q.getItem());
                }
                this.mapTransactionToUtility.put(tid, newTWU);
                ++i;
            }
            Collections.sort(revisedTransaction, new Comparator<Qitem>(){

                @Override
                public int compare(Qitem o1, Qitem o2) {
                    return AlgoVHUQI.this.compareQItems(o1, o2);
                }
            });
            i = 0;
            while (i < revisedTransaction.size()) {
                Qitem q = (Qitem)revisedTransaction.get(i);
                UtilityListFHUQIMiner utilityListOfItem = mapItemToUtilityList.get(q);
                QItemTrans element = new QItemTrans(tid, q.getQteMin() * this.mapItemToProfit.get(q.getItem()), remainingUtility -= q.getQteMin() * this.mapItemToProfit.get(q.getItem()));
                utilityListOfItem.addTrans(element);
                utilityListOfItem.addTWU(this.mapTransactionToUtility.get(tid));
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        Collections.sort(qitemNameList, new Comparator<Qitem>(){

            @Override
            public int compare(Qitem o1, Qitem o2) {
                return AlgoVHUQI.this.compareQItems(o1, o2);
            }
        });
        MemoryLogger.getInstance().checkMemory();
    }

    public void findInitialRHUQIs(ArrayList<Qitem> qitemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList, ArrayList<Qitem> candidateList, ArrayList<Qitem> hwQUI) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < qitemNameList.size()) {
            long utility = mapItemToUtilityList.get(qitemNameList.get(i)).getSumIutils();
            if (utility >= this.minUtil) {
                sb.delete(0, sb.length());
                sb.append(qitemNameList.get(i));
                sb.append(" #UTIL: ");
                sb.append(utility);
                sb.append("\r\n");
                this.writer_hqui.write(sb.toString());
                hwQUI.add(qitemNameList.get(i));
                ++this.HUQIcount;
            } else {
                if (this.combiningMethod != EnumCombination.COMBINEMAX && (double)utility >= Math.floor(this.minUtil / (long)this.coefficient) || this.combiningMethod == EnumCombination.COMBINEMAX && (double)utility >= Math.floor(this.minUtil / 2L)) {
                    candidateList.add(qitemNameList.get(i));
                }
                if (utility + mapItemToUtilityList.get(qitemNameList.get(i)).getSumRutils() >= this.minUtil) {
                    hwQUI.add(qitemNameList.get(i));
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        this.combineMethod(null, 0, candidateList, qitemNameList, mapItemToUtilityList, hwQUI);
    }

    public ArrayList<Qitem> combineMethod(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList, ArrayList<Qitem> hwQUI) throws IOException {
        if (candidateList.size() > 2) {
            Collections.sort(candidateList, new Comparator<Qitem>(){

                @Override
                public int compare(Qitem o1, Qitem o2) {
                    return AlgoVHUQI.this.compareCandidateItems(o1, o2);
                }
            });
            if (EnumCombination.COMBINEALL.equals((Object)this.combiningMethod)) {
                this.combineAll(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            } else if (EnumCombination.COMBINEMIN.equals((Object)this.combiningMethod)) {
                this.combineMin(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            } else if (EnumCombination.COMBINEMAX.equals((Object)this.combiningMethod)) {
                this.combineMax(prefix, prefixLength, candidateList, qItemNameList, mapItemToUtilityList, hwQUI);
            }
            MemoryLogger.getInstance().checkMemory();
        }
        return qItemNameList;
    }

    public void combineAll(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList, ArrayList<Qitem> hwQUI) throws IOException {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        HashMap<Qitem, UtilityListFHUQIMiner> mapRangeToUtilityList = new HashMap<Qitem, UtilityListFHUQIMiner>();
        int i = 0;
        while (i < candidateList.size()) {
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                UtilityListFHUQIMiner res;
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        ++this.HUQIcount;
                        this.writeOut2(prefix, prefixLength, res.getSingleItemsetName(), res.getSumIutils());
                        hwQUI.add(res.getSingleItemsetName());
                        mapItemToUtilityList.put(res.getSingleItemsetName(), res);
                        int site = qItemNameList.indexOf(candidateList.get(j));
                        qItemNameList.add(site, res.getSingleItemsetName());
                    }
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListFHUQIMiner ulQitem1 = (UtilityListFHUQIMiner)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        ++this.HUQIcount;
                        this.writeOut2(prefix, prefixLength, res.getSingleItemsetName(), res.getSumIutils());
                        hwQUI.add(res.getSingleItemsetName());
                        mapItemToUtilityList.put(res.getSingleItemsetName(), res);
                        int site = qItemNameList.indexOf(candidateList.get(j));
                        qItemNameList.add(site, res.getSingleItemsetName());
                    }
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public void combineMin(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList, ArrayList<Qitem> hwQUI) throws IOException {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        ArrayList<Qitem> temporaryArrayList = new ArrayList<Qitem>();
        HashMap<Qitem, UtilityListFHUQIMiner> temporaryMap = new HashMap<Qitem, UtilityListFHUQIMiner>();
        HashMap<Qitem, UtilityListFHUQIMiner> mapRangeToUtilityList = new HashMap<Qitem, UtilityListFHUQIMiner>();
        int i = 0;
        while (i < candidateList.size()) {
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                UtilityListFHUQIMiner res;
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        if (temporaryArrayList.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax()) {
                            temporaryArrayList.add(res.getSingleItemsetName());
                            temporaryMap.put(res.getSingleItemsetName(), res);
                            break;
                        }
                        temporaryMap.remove(temporaryArrayList.get(temporaryArrayList.size() - 1));
                        temporaryArrayList.remove(temporaryArrayList.size() - 1);
                        temporaryArrayList.add(res.getSingleItemsetName());
                        temporaryMap.put(res.getSingleItemsetName(), res);
                        break;
                    }
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListFHUQIMiner ulQitem1 = (UtilityListFHUQIMiner)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                    if (res.getSumIutils() > this.minUtil) {
                        if (temporaryArrayList.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax()) {
                            temporaryArrayList.add(res.getSingleItemsetName());
                            temporaryMap.put(res.getSingleItemsetName(), res);
                            break;
                        }
                        temporaryMap.remove(temporaryArrayList.get(temporaryArrayList.size() - 1));
                        temporaryArrayList.remove(temporaryArrayList.size() - 1);
                        temporaryArrayList.add(res.getSingleItemsetName());
                        temporaryMap.put(res.getSingleItemsetName(), res);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < temporaryArrayList.size()) {
            Qitem currentQitem = (Qitem)temporaryArrayList.get(k);
            mapItemToUtilityList.put(currentQitem, (UtilityListFHUQIMiner)temporaryMap.get(currentQitem));
            this.writeOut2(prefix, prefixLength, currentQitem, ((UtilityListFHUQIMiner)temporaryMap.get(currentQitem)).getSumIutils());
            ++this.HUQIcount;
            hwQUI.add(currentQitem);
            Qitem q = new Qitem(currentQitem.getItem(), currentQitem.getQteMax());
            int site = qItemNameList.indexOf(q);
            qItemNameList.add(site, currentQitem);
            ++k;
        }
        temporaryArrayList.clear();
        temporaryMap.clear();
        MemoryLogger.getInstance().checkMemory();
    }

    public void combineMax(Qitem[] prefix, int prefixLength, ArrayList<Qitem> candidateList, ArrayList<Qitem> qItemNameList, Hashtable<Qitem, UtilityListFHUQIMiner> mapItemToUtilityList, ArrayList<Qitem> hwQUI) throws IOException {
        int s = 1;
        while (s < candidateList.size() - 1) {
            if (candidateList.get(s).getQteMin() == candidateList.get(s - 1).getQteMax() + 1 && candidateList.get(s).getItem() == candidateList.get(s - 1).getItem() || candidateList.get(s).getQteMax() == candidateList.get(s + 1).getQteMin() - 1 && candidateList.get(s).getItem() == candidateList.get(s + 1).getItem()) {
                ++s;
                continue;
            }
            candidateList.remove(s);
        }
        if (candidateList.size() > 2 && (candidateList.get(candidateList.size() - 1).getQteMin() != candidateList.get(candidateList.size() - 2).getQteMax() + 1 || candidateList.get(candidateList.size() - 2).getItem() != candidateList.get(candidateList.size() - 1).getItem())) {
            candidateList.remove(candidateList.size() - 1);
        }
        ArrayList<Qitem> temporaryArrayList = new ArrayList<Qitem>();
        HashMap<Qitem, UtilityListFHUQIMiner> temporaryMap = new HashMap<Qitem, UtilityListFHUQIMiner>();
        HashMap<Qitem, UtilityListFHUQIMiner> mapRangeToUtilityList = new HashMap<Qitem, UtilityListFHUQIMiner>();
        int i = 0;
        while (i < candidateList.size()) {
            UtilityListFHUQIMiner res = new UtilityListFHUQIMiner();
            int currentItem = candidateList.get(i).getItem();
            mapRangeToUtilityList.clear();
            int count = 1;
            int j = i + 1;
            while (j < candidateList.size()) {
                int nextItem = candidateList.get(j).getItem();
                if (currentItem != nextItem) break;
                if (j == i + 1) {
                    if (candidateList.get(j).getQteMin() != candidateList.get(i).getQteMax() + 1) break;
                    res = this.constructForCombine(mapItemToUtilityList.get(candidateList.get(i)), mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count > this.coefficient - 1) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                } else {
                    if (candidateList.get(j).getQteMin() != candidateList.get(j - 1).getQteMax() + 1) break;
                    Qitem qItem1 = new Qitem(currentItem, candidateList.get(i).getQteMin(), candidateList.get(j - 1).getQteMax());
                    UtilityListFHUQIMiner ulQitem1 = (UtilityListFHUQIMiner)mapRangeToUtilityList.get(qItem1);
                    res = this.constructForCombine(ulQitem1, mapItemToUtilityList.get(candidateList.get(j)));
                    if (++count >= this.coefficient) break;
                    mapRangeToUtilityList.put(res.getSingleItemsetName(), res);
                }
                ++j;
            }
            if (res.getSumIutils() > this.minUtil && (temporaryMap.isEmpty() || res.getSingleItemsetName().getItem() != ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getItem() || res.getSingleItemsetName().getQteMax() > ((Qitem)temporaryArrayList.get(temporaryArrayList.size() - 1)).getQteMax())) {
                temporaryMap.put(res.getSingleItemsetName(), res);
                temporaryArrayList.add(res.getSingleItemsetName());
            }
            ++i;
        }
        int k = 0;
        while (k < temporaryArrayList.size()) {
            Qitem currentQitem = (Qitem)temporaryArrayList.get(k);
            mapItemToUtilityList.put(currentQitem, (UtilityListFHUQIMiner)temporaryMap.get(currentQitem));
            this.writeOut2(prefix, prefixLength, currentQitem, ((UtilityListFHUQIMiner)temporaryMap.get(currentQitem)).getSumIutils());
            ++this.HUQIcount;
            hwQUI.add(currentQitem);
            Qitem q = new Qitem(currentQitem.getItem(), currentQitem.getQteMax());
            int site = qItemNameList.indexOf(q);
            qItemNameList.add(site, currentQitem);
            ++k;
        }
        temporaryArrayList.clear();
        temporaryMap.clear();
        MemoryLogger.getInstance().checkMemory();
    }

    public UtilityListFHUQIMiner constructForCombine(UtilityListFHUQIMiner ulQitem1, UtilityListFHUQIMiner ulQitem2) {
        UtilityListFHUQIMiner result = new UtilityListFHUQIMiner(new Qitem(ulQitem1.getSingleItemsetName().getItem(), ulQitem1.getSingleItemsetName().getQteMin(), ulQitem2.getSingleItemsetName().getQteMax()));
        ArrayList<QItemTrans> temp1 = ulQitem1.getQItemTrans();
        ArrayList<QItemTrans> temp2 = ulQitem2.getQItemTrans();
        ArrayList<QItemTrans> mainlist = new ArrayList<QItemTrans>();
        result.setSumIutils(ulQitem1.getSumIutils() + ulQitem2.getSumIutils());
        result.setSumRutils(ulQitem1.getSumRutils() + ulQitem2.getSumRutils());
        result.setTwu(ulQitem1.getTwu() + ulQitem2.getTwu());
        int i = 0;
        int j = 0;
        while (i < temp1.size() && j < temp2.size()) {
            int t2;
            int t1 = temp1.get(i).getTid();
            if (t1 > (t2 = temp2.get(j).getTid())) {
                mainlist.add(temp2.get(j));
                ++j;
                continue;
            }
            mainlist.add(temp1.get(i));
            ++i;
        }
        if (i == temp1.size()) {
            while (j < temp2.size()) {
                mainlist.add(temp2.get(j++));
            }
        } else if (j == temp2.size()) {
            while (i < temp1.size()) {
                mainlist.add(temp1.get(i++));
            }
        }
        result.setQItemTrans(mainlist);
        MemoryLogger.getInstance().checkMemory();
        return result;
    }

    public UtilityListFHUQIMiner constructForJoin(UtilityListFHUQIMiner ul1, UtilityListFHUQIMiner ul2, UtilityListFHUQIMiner ul0) {
        if (ul1.getSingleItemsetName().getItem() == ul2.getSingleItemsetName().getItem()) {
            return null;
        }
        ArrayList<QItemTrans> qT1 = ul1.getQItemTrans();
        ArrayList<QItemTrans> qT2 = ul2.getQItemTrans();
        UtilityListFHUQIMiner res = new UtilityListFHUQIMiner(ul2.getItemsetName());
        if (ul0 == null) {
            int i = 0;
            int j = 0;
            while (i < qT1.size() && j < qT2.size()) {
                int tid2;
                int tid1 = qT1.get(i).getTid();
                if (tid1 == (tid2 = qT2.get(j).getTid())) {
                    int eu1 = qT1.get(i).getEu();
                    int eu2 = qT2.get(j).getEu();
                    if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                        QItemTrans temp = new QItemTrans(tid1, eu1 + eu2, qT2.get(j).getRu());
                        res.addTrans(temp, this.mapTransactionToUtility.get(tid1).intValue());
                    }
                    ++i;
                    ++j;
                    continue;
                }
                if (tid1 > tid2) {
                    ++j;
                    continue;
                }
                ++i;
            }
        } else {
            ArrayList<QItemTrans> preQT = ul0.getQItemTrans();
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < qT1.size() && j < qT2.size()) {
                int tid2;
                int tid1 = qT1.get(i).getTid();
                if (tid1 == (tid2 = qT2.get(j).getTid())) {
                    int eu1 = qT1.get(i).getEu();
                    int ru1 = qT1.get(i).getRu();
                    int eu2 = qT2.get(j).getEu();
                    while (preQT.get(k).getTid() != tid1) {
                        ++k;
                    }
                    int preEU = preQT.get(k).getEu();
                    if (qT1.get(i).getRu() >= qT2.get(j).getRu()) {
                        QItemTrans temp = new QItemTrans(tid1, eu1 + eu2 - preEU, qT2.get(j).getRu());
                        res.addTrans(temp, this.mapTransactionToUtility.get(tid1).intValue());
                    }
                    ++i;
                    ++j;
                    continue;
                }
                if (tid1 > tid2) {
                    ++j;
                    continue;
                }
                ++i;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        if (!res.getQItemTrans().isEmpty()) {
            return res;
        }
        return null;
    }

    public void miner(Qitem[] prefix, int prefixLength, UtilityListFHUQIMiner prefixUL, Hashtable<Qitem, UtilityListFHUQIMiner> ULs, ArrayList<Qitem> qItemNameList, BufferedWriter br_writer_hqui, ArrayList<Qitem> hwQUI) throws IOException {
        ArrayList<Qitem> nextNameList = new ArrayList<Qitem>();
        int i = 0;
        while (i < qItemNameList.size()) {
            nextNameList.clear();
            ArrayList<Qitem> nextHWQUI = new ArrayList<Qitem>();
            ArrayList<Qitem> candidateList = new ArrayList<Qitem>();
            Hashtable<Qitem, UtilityListFHUQIMiner> nextHUL = new Hashtable<Qitem, UtilityListFHUQIMiner>();
            if (hwQUI.contains(qItemNameList.get(i))) {
                int j = i + 1;
                while (j < qItemNameList.size()) {
                    if (!qItemNameList.get(j).isRange()) {
                        UtilityListFHUQIMiner afterUL = null;
                        afterUL = this.constructForJoin(ULs.get(qItemNameList.get(i)), ULs.get(qItemNameList.get(j)), prefixUL);
                        if (afterUL != null && (double)afterUL.getTwu() >= Math.floor(this.minUtil / (long)this.coefficient)) {
                            nextNameList.add(afterUL.getSingleItemsetName());
                            nextHUL.put(afterUL.getSingleItemsetName(), afterUL);
                            ++this.countUL;
                            if (afterUL.getSumIutils() >= this.minUtil) {
                                this.writeOut1(prefix, prefixLength, qItemNameList.get(i), qItemNameList.get(j), afterUL.getSumIutils());
                                ++this.HUQIcount;
                                nextHWQUI.add(afterUL.getSingleItemsetName());
                            } else {
                                if (this.combiningMethod != EnumCombination.COMBINEMAX && (double)afterUL.getSumIutils() >= Math.floor(this.minUtil / (long)this.coefficient) || this.combiningMethod != EnumCombination.COMBINEMAX && (double)afterUL.getSumIutils() >= Math.floor(this.minUtil / 2L)) {
                                    candidateList.add(afterUL.getSingleItemsetName());
                                }
                                if (afterUL.getSumIutils() + afterUL.getSumRutils() >= this.minUtil) {
                                    nextHWQUI.add(afterUL.getSingleItemsetName());
                                }
                            }
                        }
                    }
                    ++j;
                }
                if (candidateList.size() > 0) {
                    nextNameList = this.combineMethod(prefix, prefixLength, candidateList, nextNameList, nextHUL, nextHWQUI);
                    candidateList.clear();
                }
                MemoryLogger.getInstance().checkMemory();
                if (nextNameList.size() >= 1) {
                    this.itemsetBuffer[prefixLength] = qItemNameList.get(i);
                    this.miner(this.itemsetBuffer, prefixLength + 1, ULs.get(qItemNameList.get(i)), nextHUL, nextNameList, br_writer_hqui, nextHWQUI);
                }
            }
            ++i;
        }
    }

    private void writeOut1(Qitem[] prefix, int prefixLength, Qitem x, Qitem y, long utility) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i].toString());
            buffer.append(' ');
            ++i;
        }
        buffer.append(String.valueOf(x.toString()) + " " + y.toString() + " #UTIL: ");
        buffer.append(utility);
        this.writer_hqui.write(buffer.toString());
        this.writer_hqui.newLine();
    }

    private void writeOut2(Qitem[] prefix, int prefixLength, Qitem x, long utility) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i].toString());
            buffer.append(' ');
            ++i;
        }
        buffer.append(String.valueOf(x.toString()) + " #UTIL: ");
        buffer.append(utility);
        this.writer_hqui.write(buffer.toString());
        this.writer_hqui.newLine();
    }

    private void writeFileStatistics() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("#HUQIcount:");
        buffer.append(this.HUQIcount);
        buffer.append(System.lineSeparator());
        buffer.append("#runTime:");
        buffer.append((double)(this.endTime - this.startTime) / 1000.0);
        buffer.append(System.lineSeparator());
        buffer.append("#memory use:");
        buffer.append(MemoryLogger.getInstance().getMaxMemory());
        buffer.append(System.lineSeparator());
        buffer.append("#countUL:");
        buffer.append(this.countUL);
        buffer.append(System.lineSeparator());
        buffer.append("#countJoin:");
        buffer.append(this.countConstruct);
        buffer.append(System.lineSeparator());
        this.writer_hqui.write(buffer.toString());
        this.writer_hqui.newLine();
    }

    private int compareQItems(Qitem q1, Qitem q2) {
        int compare = q2.getQteMin() * this.mapItemToProfit.get(q2.getItem()) - q1.getQteMin() * this.mapItemToProfit.get(q1.getItem());
        return compare == 0 ? q1.getItem() - q2.getItem() : compare;
    }

    private int compareCandidateItems(Qitem q1, Qitem q2) {
        int compare = q1.getItem() - q2.getItem();
        if (compare == 0) {
            compare = q1.getQteMin() - q2.getQteMin();
        }
        if (compare == 0) {
            compare = q1.getQteMax() - q2.getQteMax();
        }
        return compare;
    }
}

