/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.uphist;

import ca.pfv.spmf.algorithms.frequentpatterns.uphist.Hist;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.uphist.UPHistNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class UPHistTree {
    List<Integer> headerList = null;
    public UPHistNode histogram;
    boolean hasMoreThanOnePath = false;
    Map<Integer, UPHistNode> mapItemNodes = new HashMap<Integer, UPHistNode>();
    UPHistNode root = new UPHistNode();
    Map<Integer, UPHistNode> mapItemLastNode = new HashMap<Integer, UPHistNode>();

    public void addTransaction(List<Item> transaction, int RTU) {
        UPHistNode currentNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = transaction.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < transaction.size()) {
                RemainingUtility += transaction.get(k).getUtility();
                ++k;
            }
            int item = transaction.get(i).getName();
            int quantity = transaction.get(i).getUtility();
            UPHistNode child = currentNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = RTU - RemainingUtility;
                RemainingUtility = 0;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility, -1, true, quantity, null, null);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (RTU - RemainingUtility);
                RemainingUtility = 0;
                ++child.count;
                child.nodeUtility = nodeUtility;
                child.histogram.updateHist(quantity, child.count);
                currentNode = child;
            }
            ++i;
        }
    }

    public void addLocalTransaction(List<UPHistNode> localPath, int pathUtility, Map<Integer, Integer> mapMinimumItemUtility, int pathCount) {
        UPHistNode currentlocalNode = this.root;
        int i = 0;
        int RemainingUtility = 0;
        int size = localPath.size();
        i = 0;
        while (i < size) {
            int k = i + 1;
            while (k < localPath.size()) {
                UPHistNode search = localPath.get(k);
                RemainingUtility += search.histogram.getMinSupportInterU(pathCount);
                ++k;
            }
            int item = localPath.get((int)i).itemID;
            UPHistNode child = currentlocalNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = pathUtility - RemainingUtility;
                RemainingUtility = 0;
                currentlocalNode = this.insertNewNode(currentlocalNode, item, nodeUtility, pathCount, false, 0, localPath.get((int)i).histogram, localPath.get((int)i).uid);
            } else {
                int currentNU = child.nodeUtility;
                int nodeUtility = currentNU + (pathUtility - RemainingUtility);
                RemainingUtility = 0;
                child.count += pathCount;
                child.nodeUtility = nodeUtility;
                if (child.uid != localPath.get((int)i).uid) {
                    child.histogram.updateHist(localPath.get((int)i).histogram);
                }
                currentlocalNode = child;
            }
            ++i;
        }
    }

    private UPHistNode insertNewNode(UPHistNode currentlocalNode, int item, int nodeUtility, int pathCount, boolean global, int quantity, Hist hist_previous, UUID uid) {
        UPHistNode localheadernode;
        UPHistNode newNode = new UPHistNode();
        newNode.itemID = item;
        newNode.nodeUtility = nodeUtility;
        newNode.uid = global ? UUID.randomUUID() : uid;
        newNode.count = global ? 1 : pathCount;
        if (global) {
            newNode.histogram = new Hist();
            newNode.histogram.H.put(quantity, 1);
        } else {
            newNode.histogram = new Hist();
            newNode.histogram.updateHist(hist_previous);
        }
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(item)) == null) {
            this.mapItemNodes.put(item, newNode);
            this.mapItemLastNode.put(item, newNode);
        } else {
            UPHistNode lastNode = this.mapItemLastNode.get(item);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(item, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Integer> mapItemToEstimatedUtility) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapItemToEstimatedUtility.get(id2) - (Integer)mapItemToEstimatedUtility.get(id1);
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }

    public String toString() {
        String output = "";
        output = String.valueOf(output) + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = String.valueOf(output) + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return String.valueOf(output) + this.toString("", this.root);
    }

    public String toString(String indent, UPHistNode node) {
        String output = String.valueOf(indent) + node.toString() + "\n";
        String childsOutput = "";
        for (UPHistNode child : node.childs) {
            childsOutput = String.valueOf(childsOutput) + this.toString(String.valueOf(indent) + " ", child);
        }
        return String.valueOf(output) + childsOutput;
    }
}

