/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPTree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoUPGrowth {
    private double maxMemory = 0.0;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private int huiCount = 0;
    private int phuisCount;
    private Map<Integer, Integer> mapMinimumItemUtility;
    private BufferedWriter writer = null;
    private List<Itemset> phuis = new ArrayList<Itemset>();
    private final boolean DEBUG = false;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        String[] items;
        String[] split;
        String thisLine;
        BufferedReader myInput;
        HashMap<Integer, Integer> mapItemToTWU;
        block30: {
            block28: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = (Integer)mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.mapMinimumItemUtility = new HashMap<Integer, Integer>();
            try {
                try {
                    UPTree tree = new UPTree();
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split2 = thisLine.split(":");
                        String[] items2 = split2[0].split(" ");
                        String[] utilityValues = split2[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                        int i = 0;
                        while (i < items2.length) {
                            int itm = Integer.parseInt(items2[i]);
                            int utility = Integer.parseInt(utilityValues[i]);
                            if ((Integer)mapItemToTWU.get(itm) >= minUtility) {
                                Item element = new Item(itm, utility);
                                revisedTransaction.add(element);
                                remainingUtility += utility;
                                Integer minItemUtil = this.mapMinimumItemUtility.get(itm);
                                if (minItemUtil == null || minItemUtil >= utility) {
                                    this.mapMinimumItemUtility.put(itm, utility);
                                }
                                element = null;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Item>(){

                            @Override
                            public int compare(Item o1, Item o2) {
                                return AlgoUPGrowth.this.compareItemsDesc(o1.name, o2.name, mapItemToTWU);
                            }
                        });
                        tree.addTransaction(revisedTransaction, remainingUtility);
                    }
                    tree.createHeaderList(mapItemToTWU);
                    this.checkMemory();
                    this.upgrowth(tree, minUtility, new int[0]);
                    this.checkMemory();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.phuisCount = this.phuis.size();
        Collections.sort(this.phuis, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset arg0, Itemset arg1) {
                return arg0.size() - arg1.size();
            }
        });
        try {
            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            block14: while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                split = thisLine.split(":");
                items = split[0].split(" ");
                String[] utilityValues = split[2].split(" ");
                ArrayList<Item> revisedTransaction = new ArrayList<Item>();
                int i = 0;
                while (i < items.length) {
                    int item = Integer.parseInt(items[i]);
                    int utility = Integer.parseInt(utilityValues[i]);
                    Item element = new Item(item, utility);
                    if ((Integer)mapItemToTWU.get(item) >= minUtility) {
                        revisedTransaction.add(element);
                    }
                    ++i;
                }
                Collections.sort(revisedTransaction, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        return o1.name - o2.name;
                    }
                });
                for (Itemset itemset2 : this.phuis) {
                    if (itemset2.size() > revisedTransaction.size()) continue block14;
                    this.updateExactUtility(revisedTransaction, itemset2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Itemset itemset3 : this.phuis) {
            if (itemset3.getExactUtility() < minUtility) continue;
            this.writeOut(itemset3);
        }
        this.checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.phuis.clear();
        this.mapMinimumItemUtility = null;
        this.writer.close();
    }

    private int compareItemsDesc(int item1, int item2, Map<Integer, Integer> mapItemEstimatedUtility) {
        int compare = mapItemEstimatedUtility.get(item2) - mapItemEstimatedUtility.get(item1);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void upgrowth(UPTree tree, int minUtility, int[] prefix) throws IOException {
        int i = tree.headerList.size() - 1;
        while (i >= 0) {
            Integer item = tree.headerList.get(i);
            UPTree localTree = this.createLocalTree(minUtility, tree, item);
            UPNode pathCPB = tree.mapItemNodes.get(item);
            int pathCPBUtility = 0;
            while (pathCPB != null) {
                pathCPBUtility += pathCPB.nodeUtility;
                pathCPB = pathCPB.nodeLink;
            }
            if (pathCPBUtility >= minUtility) {
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = item;
                this.savePHUI(newPrefix);
                if (localTree.headerList.size() > 0) {
                    this.upgrowth(localTree, minUtility, newPrefix);
                }
            }
            --i;
        }
    }

    private UPTree createLocalTree(int minUtility, UPTree tree, Integer item) {
        ArrayList<List<UPNode>> prefixPaths = new ArrayList<List<UPNode>>();
        UPNode path = tree.mapItemNodes.get(item);
        final HashMap<Integer, Integer> itemPathUtility = new HashMap<Integer, Integer>();
        while (path != null) {
            int nodeutility = path.nodeUtility;
            if (path.parent.itemID != -1) {
                List<UPNode> prefixPath = new ArrayList<UPNode>();
                prefixPath.add(path);
                UPNode parentnode = path.parent;
                while (parentnode.itemID != -1) {
                    prefixPath.add(parentnode);
                    Integer pu = (Integer)itemPathUtility.get(parentnode.itemID);
                    pu = pu == null ? nodeutility : pu + nodeutility;
                    itemPathUtility.put(parentnode.itemID, pu);
                    parentnode = parentnode.parent;
                }
                prefixPaths.add(prefixPath);
            }
            path = path.nodeLink;
        }
        UPTree localTree = new UPTree();
        for (List<UPNode> prefixPath : prefixPaths) {
            int pathCount = ((UPNode)prefixPath.get((int)0)).count;
            int pathUtility = ((UPNode)prefixPath.get((int)0)).nodeUtility;
            ArrayList<Integer> localPath = new ArrayList<Integer>();
            int j = 1;
            while (j < prefixPath.size()) {
                int itemValue = 0;
                UPNode node = (UPNode)prefixPath.get(j);
                if ((Integer)itemPathUtility.get(node.itemID) >= minUtility) {
                    localPath.add(node.itemID);
                } else {
                    Integer minItemUtility = this.mapMinimumItemUtility.get(node.itemID);
                    itemValue = minItemUtility * pathCount;
                }
                pathUtility -= itemValue;
                ++j;
            }
            Collections.sort(localPath, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return AlgoUPGrowth.this.compareItemsDesc(o1, o2, itemPathUtility);
                }
            });
            localTree.addLocalTransaction(localPath, pathUtility, this.mapMinimumItemUtility, pathCount);
        }
        localTree.createHeaderList(itemPathUtility);
        return localTree;
    }

    private void savePHUI(int[] itemset2) {
        Itemset itemsetObj = new Itemset(itemset2);
        Arrays.sort(itemset2);
        this.phuis.add(itemsetObj);
    }

    public void updateExactUtility(List<Item> transaction, Itemset itemset2) {
        int utility = 0;
        int i = 0;
        while (i < itemset2.size()) {
            block4: {
                Integer itemI = itemset2.get(i);
                int j = 0;
                while (j < transaction.size()) {
                    Item itemJ = transaction.get(j);
                    if (itemJ.name == itemI) {
                        utility += transaction.get((int)j).utility;
                        break block4;
                    }
                    if (itemJ.name > itemI) {
                        return;
                    }
                    ++j;
                }
                return;
            }
            ++i;
        }
        itemset2.increaseUtility(utility);
    }

    private void writeOut(Itemset HUI2) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < HUI2.size()) {
            buffer.append(HUI2.get(i));
            buffer.append(' ');
            ++i;
        }
        buffer.append("#UTIL: ");
        buffer.append(HUI2.getExactUtility());
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  UP-GROWTH ALGORITHM - STATS =============");
        System.out.println(" PHUIs (candidates) count: " + this.phuisCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" HUIs count : " + this.huiCount);
        System.out.println("===================================================");
    }
}

