/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ulbminer;

import ca.pfv.spmf.algorithms.frequentpatterns.ulbminer.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.ulbminer.UtilityListBuffer;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AlgoULBMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int huiCount = 0;
    public int candidateCount = 0;
    Map<Integer, Long> mapItemToTWU;
    Map<Integer, Integer> mapItemToSupport;
    BufferedWriter writer = null;
    Map<Integer, Map<Integer, Long>> mapFMAP;
    boolean ENABLE_LA_PRUNE = true;
    boolean DEBUG = false;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;
    private UtilityListBuffer utilityListBuffer = null;

    public void runAlgorithm(String input, String output, int minUtility) throws IOException {
        int endPosition;
        block29: {
            String thisLine;
            BufferedReader myInput;
            block27: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.mapFMAP = new HashMap<Integer, Map<Integer, Long>>();
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToTWU = new HashMap<Integer, Long>();
                this.mapItemToSupport = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Object twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? (long)transactionUtility : (Long)twu + (long)transactionUtility;
                                this.mapItemToTWU.put(item, (Long)twu);
                                Integer support = this.mapItemToSupport.get(item);
                                support = support == null ? Integer.valueOf(1) : Integer.valueOf(support + 1);
                                this.mapItemToSupport.put(item, support);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            int sumSupport = 0;
            ArrayList<Integer> promisingItems = new ArrayList<Integer>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                if (this.mapItemToTWU.get(item) < (long)minUtility) continue;
                promisingItems.add(item);
                sumSupport += this.mapItemToSupport.get(item).intValue();
            }
            this.utilityListBuffer = new UtilityListBuffer(sumSupport, promisingItems.size());
            Collections.sort(promisingItems, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return AlgoULBMiner.this.compareItems(o1, o2);
                }
            });
            HashMap<Integer, Integer> mapItemToUtilityList = new HashMap<Integer, Integer>();
            endPosition = 0;
            for (Integer item : promisingItems) {
                int support = this.mapItemToSupport.get(item);
                this.utilityListBuffer.createANewUtilityList(item, endPosition);
                this.utilityListBuffer.allocateSpaceForElements(support);
                mapItemToUtilityList.put(item, endPosition);
                ++endPosition;
            }
            this.mapItemToSupport = null;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        Pair pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        long newTWU = 0L;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (this.mapItemToTWU.get(pair.item) >= (long)minUtility) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                                newTWU += (long)pair.utility;
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoULBMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        i = 0;
                        while (i < revisedTransaction.size()) {
                            pair = (Pair)revisedTransaction.get(i);
                            Integer utilityListPosition = (Integer)mapItemToUtilityList.get(pair.item);
                            this.utilityListBuffer.selectCurrentUtilityList(utilityListPosition);
                            this.utilityListBuffer.addElementToCurrentUtilityList(tid, pair.utility, remainingUtility -= pair.utility);
                            Map<Integer, Long> mapFMAPItem = this.mapFMAP.get(pair.item);
                            if (mapFMAPItem == null) {
                                mapFMAPItem = new HashMap<Integer, Long>();
                                this.mapFMAP.put(pair.item, mapFMAPItem);
                            }
                            int j = i + 1;
                            while (j < revisedTransaction.size()) {
                                Pair pairAfter = (Pair)revisedTransaction.get(j);
                                Long twuSum = mapFMAPItem.get(pairAfter.item);
                                if (twuSum == null) {
                                    mapFMAPItem.put(pairAfter.item, newTWU);
                                } else {
                                    mapFMAPItem.put(pairAfter.item, twuSum + newTWU);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.utilityListBuffer.finishBuildingSingleItemsUtilityLists();
        this.mapItemToTWU = null;
        this.fhm(this.itemsetBuffer, 0, -1, 0, endPosition, minUtility);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.utilityListBuffer = null;
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = (int)(this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2));
        return compare == 0 ? item1 - item2 : compare;
    }

    private void fhm(int[] prefix, int prefixLength, int pULPosition, int previousStartPosition, int previousEndPosition, int minUtility) throws IOException {
        int X = previousStartPosition;
        while (X < previousEndPosition) {
            this.utilityListBuffer.selectCurrentUtilityList(X);
            int sumIutils = this.utilityListBuffer.getSumIUtilCurrentUtilityList();
            int sumRutils = this.utilityListBuffer.getSumRUtilCurrentUtilityList();
            int itemX = this.utilityListBuffer.getItemCurrentUtilityList();
            if (sumIutils >= minUtility) {
                this.writeOut(prefix, prefixLength, itemX, sumIutils);
            }
            if (sumIutils + sumRutils >= minUtility) {
                int newStartPosition = previousEndPosition;
                int newEndPosition = previousEndPosition;
                int Y = X + 1;
                while (Y < previousEndPosition) {
                    Long twuF;
                    this.utilityListBuffer.selectCurrentUtilityList(Y);
                    int itemY = this.utilityListBuffer.getItemCurrentUtilityList();
                    Map<Integer, Long> mapTWUF = this.mapFMAP.get(itemX);
                    if (mapTWUF == null || (twuF = mapTWUF.get(itemY)) != null && twuF >= (long)minUtility) {
                        ++this.candidateCount;
                        boolean succeeded = this.construct(pULPosition, X, Y, minUtility, newEndPosition, itemY, sumIutils + sumRutils);
                        if (succeeded) {
                            ++newEndPosition;
                        }
                    }
                    ++Y;
                }
                this.itemsetBuffer[prefixLength] = itemX;
                this.fhm(this.itemsetBuffer, prefixLength + 1, X, newStartPosition, newEndPosition, minUtility);
            }
            ++X;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private boolean construct(int PPosition, int pXPosition, int pYPosition, int minUtility, int endPosition, int itemY, int totalUtility) {
        this.utilityListBuffer.createANewUtilityList(itemY, endPosition);
        this.utilityListBuffer.selectCurrentUtilityList(pXPosition);
        int countX = this.utilityListBuffer.getElementCountCurrentUtilityList();
        this.utilityListBuffer.selectCurrentUtilityList(pYPosition);
        int countY = this.utilityListBuffer.getElementCountCurrentUtilityList();
        int countP = 0;
        if (PPosition >= 0) {
            this.utilityListBuffer.selectCurrentUtilityList(PPosition);
            countP = this.utilityListBuffer.getElementCountCurrentUtilityList();
        }
        int posX = 0;
        int posY = 0;
        int posP = 0;
        while (posX < countX && posY < countY) {
            this.utilityListBuffer.selectCurrentUtilityList(pXPosition);
            Element ex = this.utilityListBuffer.getIthElementInCurrentUtilityList(posX);
            this.utilityListBuffer.selectCurrentUtilityList(pYPosition);
            Element ey = this.utilityListBuffer.getIthElementInCurrentUtilityList(posY);
            if (ex.tid < ey.tid) {
                if (this.ENABLE_LA_PRUNE && (totalUtility -= ex.iutils + ex.rutils) < minUtility) {
                    return false;
                }
                ++posX;
                continue;
            }
            if (ex.tid > ey.tid) {
                ++posY;
                continue;
            }
            int epIutil = 0;
            if (PPosition >= 0) {
                this.utilityListBuffer.selectCurrentUtilityList(PPosition);
                Element eP = this.utilityListBuffer.getIthElementInCurrentUtilityList(posP);
                while (posP < countP && eP.tid < ex.tid) {
                    eP = this.utilityListBuffer.getIthElementInCurrentUtilityList(++posP);
                }
                epIutil = eP != null ? eP.iutils : 0;
            }
            this.utilityListBuffer.selectCurrentUtilityList(endPosition);
            this.utilityListBuffer.addElementToCurrentUtilityList(ex.tid, ex.iutils + ey.iutils - epIutil, ey.rutils);
            ++posX;
            ++posY;
        }
        return true;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, long utility) throws IOException {
        ++this.huiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(item);
        buffer.append(" #UTIL: ");
        buffer.append(utility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() throws IOException {
        System.out.println("=============  ULB-Miner ALGORITHM - SPMF 0.2.19 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" High-utility itemsets count : " + this.huiCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        if (this.DEBUG) {
            int pairCount = 0;
            double maxMemory = this.getObjectSize(this.mapFMAP);
            for (Map.Entry<Integer, Map<Integer, Long>> entry : this.mapFMAP.entrySet()) {
                maxMemory += this.getObjectSize(entry.getKey());
                for (Map.Entry<Integer, Long> entry2 : entry.getValue().entrySet()) {
                    ++pairCount;
                    maxMemory += this.getObjectSize(entry2.getKey()) + this.getObjectSize(entry2.getValue());
                }
            }
            System.out.println("CMAP size " + maxMemory + " MB");
            System.out.println("PAIR COUNT " + pairCount);
        }
        System.out.println("===================================================");
    }

    private double getObjectSize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        double maxMemory = (double)baos.size() / 1024.0 / 1024.0;
        return maxMemory;
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

