/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.two_phase;

import ca.pfv.spmf.algorithms.frequentpatterns.two_phase.ItemsetTP;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ItemsetsTP {
    private final List<List<ItemsetTP>> levels = new ArrayList<List<ItemsetTP>>();
    private int itemsetsCount = 0;
    private String name;

    public ItemsetsTP(String name) {
        this.name = name;
        this.levels.add(new ArrayList());
    }

    public void printItemsets(int transactionCount) {
        System.out.println(" ------- " + this.name + " -------");
        int patternCount = 0;
        int levelCount = 0;
        for (List<ItemsetTP> level : this.levels) {
            System.out.println("  L" + levelCount + " ");
            for (ItemsetTP itemset2 : level) {
                System.out.print("  pattern " + patternCount + "  ");
                itemset2.print();
                System.out.print(" #SUP: " + itemset2.getAbsoluteSupport());
                System.out.print(" #UTIL: " + itemset2.getUtility());
                ++patternCount;
                System.out.println("");
            }
            ++levelCount;
        }
        System.out.println(" --------------------------------");
    }

    public void saveResultsToFile(String output, int transactionCount) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (List<ItemsetTP> level : this.levels) {
            for (ItemsetTP itemset2 : level) {
                writer.write(itemset2.toString());
                writer.write(" #SUP: " + itemset2.getRelativeSupport(transactionCount));
                writer.write(" #UTIL: " + itemset2.getUtility());
                writer.newLine();
            }
        }
        writer.close();
    }

    public void addItemset(ItemsetTP itemset2, int k) {
        while (this.levels.size() <= k) {
            this.levels.add(new ArrayList());
        }
        this.levels.get(k).add(itemset2);
        ++this.itemsetsCount;
    }

    public List<List<ItemsetTP>> getLevels() {
        return this.levels;
    }

    public int getItemsetsCount() {
        return this.itemsetsCount;
    }

    public void decreaseCount() {
        --this.itemsetsCount;
    }
}

