/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tshoun;

import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.DatabaseWithPeriods;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.HashTable;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.ItemUtility;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.ItemsetTP;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.Pair;
import ca.pfv.spmf.algorithms.frequentpatterns.tshoun.TransactionWithPeriod;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoTSHoun {
    protected DatabaseWithPeriods database;
    double minUtilityRatio;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    private int candidatesCount;
    Map<Integer, BitSet> mapItemPeriod = null;
    List<Integer> periodUtilities = null;
    Map<Integer, Pair> mapItemExactEstUtility = null;
    Set<Integer> negativeItems = null;
    HashTable hashtable = null;
    List<Integer> candidate1 = null;
    int resultCount = 0;
    BufferedWriter writer = null;
    boolean DEBUG = false;

    public void runAlgorithm(DatabaseWithPeriods database, double minUtilityRatio, String output, int periodCount) throws Exception {
        int itemI;
        this.database = database;
        this.minUtilityRatio = minUtilityRatio;
        this.writer = new BufferedWriter(new FileWriter(output));
        MemoryLogger.getInstance().reset();
        this.startTimestamp = System.currentTimeMillis();
        this.candidatesCount = 0;
        this.hashtable = new HashTable(10000);
        this.mapItemPeriod = database.getMapItemPeriod();
        this.negativeItems = database.getNegativeItems();
        this.periodUtilities = database.getPeriodUtilities();
        this.mapItemExactEstUtility = database.getMapItemExactEstUtility();
        if (this.DEBUG) {
            System.out.println("===== PERIOD UTILITIES =====");
            int i = 0;
            while (i < database.periodCount) {
                int periodUtility = database.getPeriodUtility(i);
                System.out.println(" period " + i + "  utility: " + periodUtility);
                ++i;
            }
        }
        for (Map.Entry<Integer, Pair> entry : database.getMapItemExactEstUtility().entrySet()) {
            int item = entry.getKey();
            Pair pair = entry.getValue();
            BitSet periodsOfItem = this.mapItemPeriod.get(item);
            boolean isPromisingInAtLeastOnePeriod = false;
            int sumPeriodUtility = 0;
            int i = periodsOfItem.nextSetBit(0);
            while (i >= 0) {
                int periodUtility = this.periodUtilities.get(i);
                if (!isPromisingInAtLeastOnePeriod && this.calculateRelativeUtility(periodUtility, pair.estimatedUtility[i].intValue()) >= minUtilityRatio) {
                    isPromisingInAtLeastOnePeriod = true;
                }
                sumPeriodUtility += periodUtility;
                i = periodsOfItem.nextSetBit(i + 1);
            }
            if (!isPromisingInAtLeastOnePeriod) {
                database.getAllItems().remove(item);
                continue;
            }
            double relativeUtility = this.calculateRelativeUtility(sumPeriodUtility, pair.exactUtility);
            if (!(relativeUtility >= minUtilityRatio)) continue;
            this.writeOutItem(item, pair.exactUtility, relativeUtility);
        }
        this.candidate1 = new ArrayList<Integer>();
        this.candidate1.addAll(database.getMapItemExactEstUtility().keySet());
        Collections.sort(this.candidate1);
        if (this.candidate1.size() == 0) {
            MemoryLogger.getInstance().checkMemory();
            this.endTimestamp = System.currentTimeMillis();
            this.writer.close();
            return;
        }
        if (this.DEBUG) {
            System.out.println("REMOVE UNPROMISING ITEMS");
        }
        Iterator<TransactionWithPeriod> iterTrans = database.getTransactions().iterator();
        while (iterTrans.hasNext()) {
            TransactionWithPeriod trans = iterTrans.next();
            Iterator<ItemUtility> iter = trans.getItems().iterator();
            while (iter.hasNext()) {
                ItemUtility itemUtility = iter.next();
                if (database.getAllItems().contains(itemUtility.item)) continue;
                int utility = itemUtility.utility;
                if (utility > 0) {
                    trans.transactionUtility -= utility;
                }
                iter.remove();
            }
            if (trans.size() != 0) continue;
            iterTrans.remove();
        }
        if (this.DEBUG) {
            System.out.println("END REMOVING UNPROMISING ITEMS");
        }
        Collections.sort(database.getTransactions(), new Comparator<TransactionWithPeriod>(){

            @Override
            public int compare(TransactionWithPeriod t1, TransactionWithPeriod t2) {
                if (t1 == t2) {
                    return 0;
                }
                int compare = t1.getPeriod() - t2.getPeriod();
                if (compare != 0) {
                    return compare;
                }
                return t1.getItems().get((int)0).item - t2.getItems().get((int)0).item;
            }
        });
        System.out.println();
        int[] periodsStart = new int[database.getPeriodCount()];
        int[] periodsEnd = new int[database.getPeriodCount()];
        int startIndex = 0;
        int endIndex = -1;
        int currentPeriod = 0;
        while (currentPeriod < database.getPeriodCount()) {
            endIndex = currentPeriod == database.getPeriodCount() - 1 ? database.getTransactions().size() - 1 : AlgoTSHoun.binarySearch(currentPeriod, database.getTransactions(), startIndex) - 1;
            periodsStart[currentPeriod] = startIndex;
            periodsEnd[currentPeriod] = endIndex;
            startIndex = endIndex + 1;
            currentPeriod = (short)(currentPeriod + 1);
        }
        if (this.DEBUG) {
            System.out.println("START CALCULATING TU OF 2-candidates");
        }
        HashMap mapItemItemUtility = new HashMap();
        for (TransactionWithPeriod transact : database.getTransactions()) {
            int period = transact.getPeriod();
            int i = 0;
            while (i < transact.size()) {
                itemI = transact.get((int)i).item;
                if (this.candidate1.contains(itemI)) {
                    HashMap<Integer, Pair> mapItemUtility = (HashMap<Integer, Pair>)mapItemItemUtility.get(itemI);
                    if (mapItemUtility == null) {
                        mapItemUtility = new HashMap<Integer, Pair>();
                        mapItemItemUtility.put(itemI, mapItemUtility);
                    }
                    int j = i + 1;
                    while (j < transact.size()) {
                        int itemJ = transact.get((int)j).item;
                        if (this.candidate1.contains(itemJ)) {
                            Pair pairIJ = (Pair)mapItemUtility.get(itemJ);
                            if (pairIJ == null) {
                                pairIJ = new Pair(periodCount);
                                mapItemUtility.put(itemJ, pairIJ);
                            }
                            pairIJ.exactUtility += transact.get((int)i).utility + transact.get((int)j).utility;
                            if (pairIJ.estimatedUtility[period] == null) {
                                pairIJ.estimatedUtility[period] = transact.getTransactionUtility();
                            } else {
                                int n = period;
                                pairIJ.estimatedUtility[n] = pairIJ.estimatedUtility[n] + transact.getTransactionUtility();
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.DEBUG) {
            System.out.println(" Removing unpromising 2-itemsets ");
            System.out.println(" and output HOU 2-itemsets ");
        }
        int candidate2count = 0;
        ArrayList<ItemsetTP> candidates2 = new ArrayList<ItemsetTP>();
        for (Map.Entry entryMap : mapItemItemUtility.entrySet()) {
            itemI = (Integer)entryMap.getKey();
            Iterator iter = ((Map)entryMap.getValue()).entrySet().iterator();
            BitSet bitsetI = this.mapItemPeriod.get(itemI);
            while (iter.hasNext()) {
                Map.Entry entryJ = iter.next();
                int itemJ = (Integer)entryJ.getKey();
                boolean isPromisingInAtLeastOnePeriod = false;
                Integer[] estimatedUtilityIJ = ((Pair)entryJ.getValue()).estimatedUtility;
                int sumOfPeriodUtility = 0;
                int i = 0;
                while (i < estimatedUtilityIJ.length) {
                    if (estimatedUtilityIJ[i] != null) {
                        boolean twuIJ = false;
                        if (!isPromisingInAtLeastOnePeriod && this.calculateRelativeUtility(this.periodUtilities.get(i), estimatedUtilityIJ[i].intValue()) >= minUtilityRatio) {
                            isPromisingInAtLeastOnePeriod = true;
                        }
                        sumOfPeriodUtility += this.periodUtilities.get(i).intValue();
                    }
                    ++i;
                }
                if (!isPromisingInAtLeastOnePeriod) {
                    iter.remove();
                    continue;
                }
                int[] array = new int[]{itemI, itemJ};
                ItemsetTP itemsetTP = new ItemsetTP(array);
                candidates2.add(itemsetTP);
                ++candidate2count;
                int exactUtilityIJ = ((Pair)entryJ.getValue()).exactUtility;
                double relativeUtility = this.calculateRelativeUtility(sumOfPeriodUtility, exactUtilityIJ);
                if (!(relativeUtility >= minUtilityRatio)) continue;
                this.writeOut(array, exactUtilityIJ, relativeUtility);
            }
        }
        if (candidates2.size() == 0) {
            MemoryLogger.getInstance().checkMemory();
            this.endTimestamp = System.currentTimeMillis();
            this.writer.close();
            return;
        }
        Collections.sort(candidates2, new Comparator<ItemsetTP>(){

            @Override
            public int compare(ItemsetTP o1, ItemsetTP o2) {
                if (o1.items[0] < o2.items[0]) {
                    return -1;
                }
                if (o1.items[0] > o2.items[0]) {
                    return 1;
                }
                if (o1.items[1] < o2.items[1]) {
                    return -1;
                }
                if (o1.items[1] > o2.items[1]) {
                    return 1;
                }
                return 0;
            }
        });
        MemoryLogger.getInstance().checkMemory();
        if (this.DEBUG) {
            System.out.println("FINISHED CALCULATING TU of 2-candidates  (" + candidate2count + ")");
            System.out.println("START MINING PERIODS FOR ALL CANDIDATES");
        }
        short currentPeriod2 = 0;
        while (currentPeriod2 < database.getPeriodCount()) {
            startIndex = periodsStart[currentPeriod2];
            endIndex = periodsEnd[currentPeriod2];
            if (this.DEBUG) {
                System.out.println("PERIOD " + currentPeriod2);
            }
            List<TransactionWithPeriod> periodDB = database.getTransactions().subList(startIndex, endIndex + 1);
            int periodUtility = this.periodUtilities.get(currentPeriod2);
            if (this.DEBUG) {
                System.out.println("TRANSACTIONS IN THIS PERIOD");
                for (TransactionWithPeriod trans : periodDB) {
                    System.out.println(trans.toString());
                }
                System.out.println();
            }
            this.performMiningOnPeriod(periodDB, periodUtility, candidates2, currentPeriod2);
            startIndex = endIndex + 1;
            currentPeriod2 = (short)(currentPeriod2 + 1);
        }
        if (this.DEBUG) {
            System.out.println("ENDED MINING PERIODS FOR ALL CANDIDATES");
        }
        MemoryLogger.getInstance().checkMemory();
        List<ItemsetTP>[] listArray = this.hashtable.table;
        int n = this.hashtable.table.length;
        int n2 = 0;
        while (n2 < n) {
            List<ItemsetTP> entryHash = listArray[n2];
            if (entryHash != null) {
                for (ItemsetTP itemset2 : entryHash) {
                    BitSet periods = (BitSet)this.mapItemPeriod.get(itemset2.items[0]).clone();
                    int i = 1;
                    while (i < itemset2.items.length) {
                        periods.and(this.mapItemPeriod.get(itemset2.items[i]));
                        ++i;
                    }
                    if (this.DEBUG) {
                        System.out.println(Arrays.toString(itemset2.items));
                        System.out.println();
                    }
                    int exactUtility = 0;
                    int sumPeriodUtility = 0;
                    int period = periods.nextSetBit(0);
                    while (period >= 0) {
                        block45: {
                            sumPeriodUtility += this.periodUtilities.get(period).intValue();
                            for (ItemsetTP.PeriodUtility pair : itemset2.listPeriodUtility) {
                                if (pair.period != period) continue;
                                exactUtility += pair.utility;
                                break block45;
                            }
                            startIndex = periodsStart[period];
                            endIndex = periodsEnd[period];
                            List<TransactionWithPeriod> periodDB = database.getTransactions().subList(startIndex, endIndex + 1);
                            int z = 0;
                            while (z < periodDB.size()) {
                                TransactionWithPeriod transaction = periodDB.get(z);
                                exactUtility += AlgoTSHoun.containsOrEquals(transaction.getItems(), itemset2.items);
                                ++z;
                            }
                        }
                        period = periods.nextSetBit(period + 1);
                    }
                    double relativeUtility = this.calculateRelativeUtility(sumPeriodUtility, exactUtility);
                    if (!(relativeUtility >= minUtilityRatio)) continue;
                    this.writeOut(itemset2.items, exactUtility, relativeUtility);
                }
            }
            ++n2;
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.writer.close();
    }

    private void writeOut(int[] prefix, int exactUtility, double relativeUtility) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefix.length) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append("#UTIL: ");
        buffer.append(exactUtility);
        buffer.append(" #RUTIL: ");
        buffer.append(relativeUtility);
        this.writer.write(buffer.toString());
        this.writer.newLine();
        ++this.resultCount;
    }

    private void writeOutItem(int item, int exactUtility, double relativeUtility) throws IOException {
        this.writer.write(String.valueOf(item) + " #UTIL: " + exactUtility);
        this.writer.newLine();
        this.writer.append(" #RUTIL: ");
        this.writer.append("" + relativeUtility);
        ++this.resultCount;
    }

    public static int binarySearch(int keyPeriod, List<TransactionWithPeriod> list, int startIndex) {
        int lo = startIndex;
        int hi = list.size() - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            if (AlgoTSHoun.compareForBinarySearch(keyPeriod, list, mid) > 0) {
                hi = mid - 1;
                continue;
            }
            if (AlgoTSHoun.compareForBinarySearch(keyPeriod, list, mid) < 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static int compareForBinarySearch(int keyPeriod, List<TransactionWithPeriod> list, int mid) {
        if (list.get(mid).getPeriod() == keyPeriod) {
            return -1;
        }
        if (list.get(mid).getPeriod() == keyPeriod + 1 && list.get(mid - 1).getPeriod() == keyPeriod) {
            return 0;
        }
        return 1;
    }

    public void performMiningOnPeriod(List<TransactionWithPeriod> database, int periodUtility, List<ItemsetTP> candidates2, short period) {
        MemoryLogger.getInstance().checkMemory();
        ArrayList<int[]> candidatesSize3 = new ArrayList<int[]>();
        int i = 0;
        while (i < candidates2.size()) {
            ItemsetTP itemset1 = candidates2.get(i);
            int j = i + 1;
            while (j < candidates2.size()) {
                ItemsetTP itemset2 = candidates2.get(j);
                if (itemset1.items[0] > itemset2.items[0]) break;
                if (itemset1.items[0] == itemset2.items[0]) {
                    int[] newItemset = new int[]{itemset1.items[0], itemset1.items[1], itemset2.items[1]};
                    candidatesSize3.add(newItemset);
                }
                ++j;
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.DEBUG) {
            System.out.println(" CANDIDATE size 3 count " + candidatesSize3.size());
        }
        this.pruneCandidatesAndCalculateExactUtility(database, periodUtility, period, candidatesSize3);
        List<int[]> previousCandidates = candidatesSize3;
        while (previousCandidates.size() > 0) {
            List<int[]> nextCandidates = this.generateCandidateSizeK(previousCandidates);
            this.pruneCandidatesAndCalculateExactUtility(database, periodUtility, period, nextCandidates);
            previousCandidates = nextCandidates;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void pruneCandidatesAndCalculateExactUtility(List<TransactionWithPeriod> database, int periodUtility, short period, List<int[]> candidates) {
        Iterator<int[]> iter = candidates.iterator();
        while (iter.hasNext()) {
            int[] itemset2 = iter.next();
            int estimatedUtility = 0;
            int exactUtility = 0;
            for (TransactionWithPeriod trans : database) {
                if (trans.getItems().get((int)0).item > itemset2[0]) break;
                int utilityInThatTransaction = AlgoTSHoun.containsOrEquals(trans.getItems(), itemset2);
                if (utilityInThatTransaction <= 0) continue;
                estimatedUtility += trans.transactionUtility;
                exactUtility += utilityInThatTransaction;
            }
            if ((double)estimatedUtility / Math.abs((double)periodUtility) < this.minUtilityRatio) {
                iter.remove();
            }
            if (!((double)exactUtility / Math.abs((double)periodUtility) >= this.minUtilityRatio)) continue;
            int hashcode = this.hashtable.hashCode(itemset2);
            ItemsetTP itemsetRetrieved = this.hashtable.retrieveItemset(itemset2, hashcode);
            if (itemsetRetrieved == null) {
                itemsetRetrieved = new ItemsetTP(itemset2);
                this.hashtable.put(itemsetRetrieved, hashcode);
            }
            itemsetRetrieved.setPeriodUtility(period, exactUtility);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public static int containsOrEquals(List<ItemUtility> list, int[] items) {
        int utility = 0;
        int i = 0;
        while (i < items.length) {
            block4: {
                int j = 0;
                while (j < list.size()) {
                    if (list.get((int)j).item == items[i]) {
                        utility += list.get((int)j).utility;
                        break block4;
                    }
                    if (list.get((int)j).item > items[i]) {
                        return 0;
                    }
                    ++j;
                }
                return 0;
            }
            ++i;
        }
        return utility;
    }

    protected List<int[]> generateCandidateSizeK(List<int[]> levelK_1) {
        ArrayList<int[]> candidatesK = new ArrayList<int[]>();
        int i = 0;
        while (i < levelK_1.size()) {
            int[] itemset1 = levelK_1.get(i);
            int j = i + 1;
            block1: while (j < levelK_1.size()) {
                block7: {
                    int[] itemset2 = levelK_1.get(j);
                    int k = 0;
                    while (k < itemset1.length) {
                        if (k == itemset1.length - 1) {
                            if (itemset1[k] >= itemset2[k]) {
                                break block1;
                            }
                        } else {
                            if (itemset1[k] >= itemset2[k]) {
                                if (itemset1[k] > itemset2[k]) break block1;
                            }
                            break block7;
                        }
                        ++k;
                    }
                    int[] newItemset = new int[itemset2.length + 1];
                    System.arraycopy(itemset1, 0, newItemset, 0, itemset1.length);
                    newItemset[itemset2.length] = itemset2[itemset2.length - 1];
                    candidatesK.add(newItemset);
                }
                ++j;
            }
            ++i;
        }
        return candidatesK;
    }

    private double calculateRelativeUtility(int sumPeriodUtility, double utility) {
        if (sumPeriodUtility == 0) {
            return 0.0;
        }
        return utility / (double)Math.abs(sumPeriodUtility);
    }

    public void printStats() {
        System.out.println("=============  TS-HOUN ALGORITHM v2.02 - STATS =============");
        System.out.println(" Transactions count from database : " + this.database.size());
        System.out.println(" Candidates count : " + this.candidatesCount);
        System.out.println(" Memory : " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" HOU count : " + this.resultCount);
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

