/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tkuce;

import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoTKUCEP {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    final int sampleSize = 2000;
    final int maxIteration = 2000;
    int actualIterations = 0;
    int transactionCount = 0;
    static int K = 0;
    int CUV = 0;
    final float rho = 0.2f;
    final float SF = 0.2f;
    Map<Integer, Integer> mapItemToU;
    Map<Integer, Integer> mapItemToTWU;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    float[] p;
    List<Particle> samples = new ArrayList<Particle>();
    List<HUI> huiSets = new ArrayList<HUI>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Particle> TopKHuiParticle = new ArrayList<Particle>();

    public void runAlgorithm(String input, String output, int TopK) throws IOException {
        block32: {
            Integer item;
            int i;
            Iterator<Object> items;
            String[] split;
            String thisLine;
            BufferedReader myInput;
            block30: {
                MemoryLogger.getInstance().reset();
                K = TopK;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToU = new HashMap<Integer, Integer>();
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.transactionCount;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            String[] utilities = split[2].split(" ");
                            i = 0;
                            while (i < ((Iterator<Object>)items).length) {
                                item = Integer.parseInt(items[i]);
                                Integer utility = Integer.parseInt(utilities[i]);
                                Integer u = this.mapItemToU.get(item);
                                u = u == null ? utility : u + utility;
                                this.mapItemToU.put(item, u);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.calculateCUV(this.mapItemToU);
            this.twuPattern = new ArrayList<Integer>();
            for (Map.Entry<Integer, Integer> vo : this.mapItemToTWU.entrySet()) {
                Integer item2 = vo.getKey();
                if (this.mapItemToTWU.get(item2) < this.CUV) continue;
                this.twuPattern.add(item2);
            }
            this.p = new float[this.twuPattern.size()];
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        i = 0;
                        while (i < ((Iterator<Object>)items).length) {
                            item = Integer.parseInt(items[i]);
                            if (this.mapItemToTWU.get(item) >= this.CUV) {
                                Pair pair = new Pair();
                                pair.item = Integer.parseInt(items[i]);
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                revisedTransaction.add(pair);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.Items = new ArrayList<Item>();
        for (Integer tempItem : this.twuPattern) {
            this.Items.add(new Item(tempItem));
        }
        int i = 0;
        while (i < this.database.size()) {
            for (Item item : this.Items) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (item.item == this.database.get((int)i).get((int)k).item) {
                        item.TIDS.set(i);
                    }
                    ++k;
                }
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
        if (this.twuPattern.size() > 0) {
            this.generateSample(1.0f);
            int i2 = 0;
            while (i2 < 2000) {
                ++this.actualIterations;
                this.samples.sort((itemset1, itemset2) -> -(itemset1.fitness - itemset2.fitness));
                float max_min = this.samples.get((int)0).fitness - this.samples.get((int)399).fitness;
                float propotion = max_min / (float)this.samples.get((int)0).fitness;
                if (max_min == 0.0f) break;
                this.update(0.8f * propotion);
                ++i2;
            }
            this.endTimestamp = System.currentTimeMillis();
            i2 = 0;
            while (i2 < K) {
                if (i2 <= this.TopKHuiParticle.size() - 1) {
                    this.insert(this.TopKHuiParticle.get(i2));
                }
                ++i2;
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.maxMemory = MemoryLogger.getInstance().getMaxMemory();
        this.endTimestamp = System.currentTimeMillis();
        this.writeOut();
        this.writer.close();
    }

    public void calculateCUV(Map<Integer, Integer> map) {
        if (map == null) {
            return;
        }
        int s = map.size();
        Collection<Integer> c = map.values();
        Object[] obj = c.toArray();
        Arrays.sort(obj, Collections.reverseOrder());
        s = Math.min(s, K);
        this.CUV = (Integer)obj[s - 1];
    }

    private void generateSample(float proportion) {
        int i = 0;
        while (i < (int)(proportion * 2000.0f)) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size() + 1.0);
            while (j < k) {
                int temp = (int)(Math.random() * (double)this.twuPattern.size());
                if (tempParticle.X.get(temp)) continue;
                ++j;
                tempParticle.X.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempParticle, transList);
            tempParticle.calculateFitness(k, transList);
            this.samples.add(i, tempParticle);
            this.insertTopList(this.samples.get(i));
            ++i;
        }
    }

    private void update(float proportion) {
        int[] num = new int[this.twuPattern.size()];
        int i = 0;
        while ((float)i < 400.0f) {
            int j = 0;
            while (j < this.twuPattern.size()) {
                if (this.samples.get((int)i).X.get(j)) {
                    int n = j;
                    num[n] = num[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        this.CUV = this.samples.get((int)399).fitness;
        i = 0;
        while (i < this.twuPattern.size()) {
            this.p[i] = (float)((double)num[i] / 400.0);
            ++i;
        }
        int i2 = 0;
        while (i2 < (int)(proportion * 2000.0f)) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            this.update_Particle(tempParticle);
            ArrayList<Integer> transList = new ArrayList<Integer>();
            if (this.isRBAIndividual(tempParticle, transList)) {
                int k = tempParticle.X.cardinality();
                tempParticle.calculateFitness(k, transList);
                if (tempParticle.fitness > this.CUV) {
                    this.samples.add(i2, tempParticle);
                    this.insertTopList(this.samples.get(i2));
                }
            }
            ++i2;
        }
        this.generateSample(0.2f);
    }

    private void update_Particle(Particle temp) {
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (Math.random() < (double)this.p[i]) {
                temp.X.set(i);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertTopList(Particle tmp) {
        block13: {
            temp = new Particle();
            temp.copyParticle(tmp);
            if (this.TopKHuiParticle.size() == 0) {
                this.TopKHuiParticle.add(temp);
                return;
            }
            max = 0;
            min = AlgoTKUCEP.K - 1;
            mid = 0;
            if (this.TopKHuiParticle.size() >= AlgoTKUCEP.K) break block13;
            min = this.TopKHuiParticle.size() - 1;
            if (temp.fitness < this.TopKHuiParticle.get((int)min).fitness) {
                this.TopKHuiParticle.add(temp);
                return;
            }
            ** GOTO lbl26
        }
        if (temp.fitness >= this.TopKHuiParticle.get((int)min).fitness) ** GOTO lbl26
        return;
lbl-1000:
        // 1 sources

        {
            mid = (max + min) / 2;
            if (temp.fitness > this.TopKHuiParticle.get((int)mid).fitness) {
                min = mid - 1;
                continue;
            }
            if (temp.fitness >= this.TopKHuiParticle.get((int)mid).fitness) break;
            max = mid + 1;
lbl26:
            // 4 sources

            ** while (max <= min)
        }
lbl27:
        // 2 sources

        mid_start = mid;
        mid_end = mid;
        if (temp.fitness > this.TopKHuiParticle.get((int)mid).fitness) {
            this.TopKHuiParticle.add(mid, temp);
        } else if (temp.fitness < this.TopKHuiParticle.get((int)mid).fitness) {
            this.TopKHuiParticle.add(mid + 1, temp);
        } else if (!this.TopKHuiParticle.contains(temp)) {
            while (this.TopKHuiParticle.get((int)mid_start).fitness == temp.fitness) {
                if (this.TopKHuiParticle.get((int)mid_start).X.equals(temp.X) || this.TopKHuiParticle.get((int)mid_end).X.equals(temp.X)) {
                    return;
                }
                if (--mid_start == -1) break;
            }
            while (this.TopKHuiParticle.get((int)mid_end).fitness == temp.fitness) {
                if (this.TopKHuiParticle.get((int)mid_end).X.equals(temp.X)) {
                    return;
                }
                if (++mid_end == this.TopKHuiParticle.size()) break;
            }
            this.TopKHuiParticle.add(mid, temp);
        }
    }

    public boolean isRBAIndividual(Particle tempParticle, List<Integer> tempList) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = new BitSet(this.transactionCount);
        BitSet midBitSet = new BitSet(this.transactionCount);
        tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempParticle.X.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                tempList.add(m);
            }
            ++m;
        }
        return true;
    }

    private void insert(Particle tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.X.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.huiSets.size() == 0) {
            this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
        } else {
            i = 0;
            while (i < this.huiSets.size()) {
                if (temp.toString().equals(this.huiSets.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.huiSets.size()) {
                this.huiSets.add(new HUI(temp.toString(), tempParticle.fitness));
            }
        }
    }

    private void writeOut() throws IOException {
        for (HUI huiSet : this.huiSets) {
            String buffer = String.valueOf(huiSet.itemset) + "#UTIL:" + huiSet.fitness;
            this.writer.write(buffer);
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("============ TKU-CE+ Algorithm v 2.52 ===========");
        System.out.println(" Total time: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory: " + this.maxMemory + " MB");
        System.out.println(" Actual iterations: " + this.actualIterations);
        System.out.println(" High-utility itemsets count: " + this.huiSets.size());
        System.out.println("=================================================");
    }

    static class HUI {
        String itemset;
        int fitness;

        public HUI(String itemset2, int fitness) {
            this.itemset = itemset2;
            this.fitness = fitness;
        }
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item(int item) {
            this.TIDS = new BitSet(AlgoTKUCEP.this.transactionCount);
            this.item = item;
        }
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }

    class Particle {
        BitSet X;
        int fitness;

        public Particle() {
            this.X = new BitSet(AlgoTKUCEP.this.twuPattern.size());
        }

        public Particle(int length) {
            this.X = new BitSet(length);
        }

        public void copyParticle(Particle particle1) {
            this.X = (BitSet)particle1.X.clone();
            this.fitness = particle1.fitness;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                block1: while (q < AlgoTKUCEP.this.database.get(p).size() && i < AlgoTKUCEP.this.twuPattern.size()) {
                    if (this.X.get(i)) {
                        int t = 0;
                        while (t < AlgoTKUCEP.this.database.get(p).size()) {
                            if (AlgoTKUCEP.this.database.get((int)p).get((int)t).item == AlgoTKUCEP.this.twuPattern.get(i)) {
                                sum += AlgoTKUCEP.this.database.get((int)p).get((int)t).utility;
                                ++i;
                                ++temp;
                                continue block1;
                            }
                            ++t;
                        }
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    fitness += sum;
                }
                ++m;
            }
            this.fitness = fitness;
        }
    }
}

