/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.tko;

import ca.pfv.spmf.algorithms.frequentpatterns.tko.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.tko.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.tko.UtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class AlgoTKO_Basic {
    long totalTime = 0L;
    int huiCount = 0;
    int k = 0;
    long minutility = 0L;
    PriorityQueue<Itemset> kItemsets;
    final Map<Integer, Integer> mapItemToTWU = new HashMap<Integer, Integer>();

    public void runAlgorithm(String input, String output, int k) throws IOException {
        ArrayList<UtilityList> listItems;
        long startTimestamp;
        block23: {
            String thisLine;
            BufferedReader myInput;
            block21: {
                MemoryLogger.getInstance().reset();
                startTimestamp = System.currentTimeMillis();
                this.minutility = 1L;
                this.k = k;
                this.kItemsets = new PriorityQueue();
                myInput = null;
                try {
                    try {
                        FileInputStream fin = new FileInputStream(new File(input));
                        myInput = new BufferedReader(new InputStreamReader(fin));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            int i = 0;
                            while (i < items.length) {
                                Integer item = Integer.parseInt(items[i]);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listItems = new ArrayList<UtilityList>();
            HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>(10000);
            for (Integer item : this.mapItemToTWU.keySet()) {
                UtilityList uList = new UtilityList(item);
                listItems.add(uList);
                mapItemToUtilityList.put(item, uList);
            }
            Collections.sort(listItems, new Comparator<UtilityList>(){

                @Override
                public int compare(UtilityList o1, UtilityList o2) {
                    int compare = AlgoTKO_Basic.this.mapItemToTWU.get(o1.item) - AlgoTKO_Basic.this.mapItemToTWU.get(o2.item);
                    if (compare == 0) {
                        return o1.item - o2.item;
                    }
                    return compare;
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            revisedTransaction.add(pair);
                            remainingUtility += pair.utility;
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return AlgoTKO_Basic.this.compareItems(o1.item, o2.item);
                            }
                        });
                        for (Pair pair : revisedTransaction) {
                            UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            utilityListOfItem.addElement(element);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.search(new int[0], null, listItems);
        MemoryLogger.getInstance().checkMemory();
        this.totalTime = (System.currentTimeMillis() - startTimestamp) / 1000L;
    }

    private void search(int[] prefix, UtilityList pUL, List<UtilityList> ULs) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        int i = 0;
        while (i < ULs.size()) {
            UtilityList X = ULs.get(i);
            if ((long)X.sumIutils >= this.minutility) {
                this.writeOut(prefix, X.item, X.sumIutils);
            }
            if ((long)(X.sumRutils + X.sumIutils) >= this.minutility) {
                ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                int j = i + 1;
                while (j < ULs.size()) {
                    UtilityList Y = ULs.get(j);
                    exULs.add(this.construct(pUL, X, Y));
                    ++j;
                }
                int[] newPrefix = new int[prefix.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                newPrefix[prefix.length] = X.item;
                this.search(newPrefix, X, exULs);
            }
            ++i;
        }
    }

    private void writeOut(int[] prefix, int item, long utility) {
        Itemset itemset2 = new Itemset(prefix, item, utility);
        this.kItemsets.add(itemset2);
        if (this.kItemsets.size() > this.k && utility > this.minutility) {
            Itemset lower;
            while ((lower = this.kItemsets.peek()) != null) {
                this.kItemsets.remove(lower);
                if (this.kItemsets.size() > this.k) continue;
            }
            this.minutility = this.kItemsets.peek().utility;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    public void writeResultTofile(String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        Iterator<Itemset> iter = this.kItemsets.iterator();
        while (iter.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            Itemset itemset2 = iter.next();
            int i = 0;
            while (i < itemset2.getItemset().length) {
                buffer.append(itemset2.getItemset()[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append(itemset2.item);
            buffer.append(" #UTIL: ");
            buffer.append(itemset2.utility);
            writer.write(buffer.toString());
            if (!iter.hasNext()) continue;
            writer.newLine();
        }
        writer.close();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    public void printStats() {
        System.out.println("=============  TKO-BASIC - v.2.28 =============");
        System.out.println(" High-utility itemsets count : " + this.kItemsets.size());
        System.out.println(" Total time ~ " + this.totalTime + " s");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

