/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.ssfim;

import ca.pfv.spmf.algorithms.frequentpatterns.ssfim.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class AlgoSSFIM {
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int patternCount = 0;
    BufferedWriter writer = null;
    private int[] itemsetBuffer = null;
    private int[] transactionBuffer = null;
    final int BUFFERS_SIZE = 200;
    int minSupportAbsolute = 0;

    public void runAlgorithm(String input, String output, double minSupport) throws IOException {
        int transactionCount;
        HashMap<Itemset, Integer> mapItemsetToSupport;
        block16: {
            this.itemsetBuffer = new int[200];
            this.transactionBuffer = new int[200];
            MemoryLogger.getInstance().reset();
            this.startTimestamp = System.currentTimeMillis();
            this.writer = new BufferedWriter(new FileWriter(output));
            mapItemsetToSupport = new HashMap<Itemset, Integer>();
            BufferedReader myInput = null;
            boolean itemOccurrencesCount = false;
            transactionCount = 0;
            try {
                try {
                    String thisLine;
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] items = thisLine.split(" ");
                        int count = items.length;
                        int i = 0;
                        while (i < items.length) {
                            this.transactionBuffer[i] = Integer.valueOf(items[i]);
                            ++i;
                        }
                        long i2 = 1L;
                        long max = 1 << count;
                        while (i2 < max) {
                            int itemCount = 0;
                            int j = 0;
                            while (j < count) {
                                int isSet = (int)i2 & 1 << j;
                                if (isSet > 0) {
                                    this.itemsetBuffer[itemCount] = this.transactionBuffer[j];
                                    ++itemCount;
                                }
                                ++j;
                            }
                            int[] newItemset = new int[itemCount];
                            System.arraycopy(this.itemsetBuffer, 0, newItemset, 0, itemCount);
                            Itemset itemsetObject = new Itemset(newItemset);
                            Integer support = (Integer)mapItemsetToSupport.get(itemsetObject);
                            if (support == null) {
                                mapItemsetToSupport.put(itemsetObject, 1);
                            } else {
                                mapItemsetToSupport.put(itemsetObject, support + 1);
                            }
                            ++i2;
                        }
                        ++transactionCount;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.minSupportAbsolute = (int)Math.ceil(minSupport * (double)transactionCount);
        for (Map.Entry entry : mapItemsetToSupport.entrySet()) {
            int support = (Integer)entry.getValue();
            if (support < this.minSupportAbsolute) continue;
            int[] itemset2 = ((Itemset)entry.getKey()).itemset;
            this.writeOut(itemset2, itemset2.length, support);
        }
        MemoryLogger.getInstance().checkMemory();
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private void writeOut(int[] itemset2, int length, int support) throws IOException {
        ++this.patternCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < length) {
            buffer.append(itemset2[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append("#SUP: ");
        buffer.append(support);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  SSFIM ALGORITHM v2.19 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Frequent itemsets count : " + this.patternCount);
        System.out.println("===================================================");
    }
}

