/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.skymine;

public class ItemSummary {
    int itemName;
    short minFrequency;
    short maxFrequency;
    long TWU;
    int totalFrequency;
    int support;

    ItemSummary() {
    }

    public ItemSummary(int item) {
        this.itemName = item;
        this.minFrequency = 0;
        this.maxFrequency = 0;
        this.TWU = 0L;
        this.totalFrequency = 0;
        this.support = 0;
    }

    public void updateMinFrequency(short minF) {
        if (this.minFrequency == 0) {
            this.minFrequency = minF;
        } else if (this.minFrequency > minF) {
            this.minFrequency = minF;
        }
    }

    public void updateMaxFrequency(short maxF) {
        if (this.maxFrequency < maxF) {
            this.maxFrequency = maxF;
        }
    }

    public void updateTWU(long twu) {
        this.TWU += twu;
    }

    public void updateTotalFrequency(int freq) {
        this.totalFrequency += freq;
    }

    public void incrementSupp() {
        ++this.support;
    }

    public long getTotalFreq() {
        return this.totalFrequency;
    }

    public int getSupport() {
        return this.support;
    }

    public String toString() {
        String line = "";
        line = String.valueOf(line) + this.itemName + " " + this.minFrequency + " " + this.maxFrequency + " " + this.TWU + " " + this.totalFrequency + " " + this.support;
        return line;
    }
}

