/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.sfui_uf;

import ca.pfv.spmf.algorithms.frequentpatterns.sfui_uf.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.sfui_uf.Skyline;
import ca.pfv.spmf.algorithms.frequentpatterns.sfui_uf.SkylineList;
import ca.pfv.spmf.algorithms.frequentpatterns.sfui_uf.UtilityList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoSFUI_UF {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int psfupCount = 0;
    int sfupCount = 0;
    int searchCount = 0;
    int MUS = 0;
    int fMax = 0;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToUtility;
    Map<Integer, Integer> mapItemToTempTWU;
    Map<Integer, Integer> mapItemToFrequent;
    BufferedWriter writer = null;

    public void runAlgorithm(String input, String output) throws IOException {
        int tid;
        ArrayList<UtilityList> UtilityLists;
        block40: {
            String thisLine;
            BufferedReader myInput;
            ArrayList<Integer> unpromising_list;
            block38: {
                Object utility;
                int i;
                String[] items;
                String[] split;
                block36: {
                    this.maxMemory = 0.0;
                    this.startTimestamp = System.currentTimeMillis();
                    this.writer = new BufferedWriter(new FileWriter(output));
                    this.mapItemToTWU = new HashMap<Integer, Integer>();
                    this.mapItemToUtility = new HashMap<Integer, Integer>();
                    this.mapItemToTempTWU = new HashMap<Integer, Integer>();
                    this.mapItemToFrequent = new HashMap<Integer, Integer>();
                    unpromising_list = new ArrayList<Integer>();
                    myInput = null;
                    try {
                        try {
                            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
                            while ((thisLine = myInput.readLine()) != null) {
                                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                                split = thisLine.split(":");
                                items = split[0].split(" ");
                                String[] utilities = split[2].split(" ");
                                int transactionUtility = Integer.parseInt(split[1]);
                                i = 0;
                                while (i < items.length) {
                                    Integer item = Integer.parseInt(items[i]);
                                    utility = Integer.parseInt(utilities[i]);
                                    Integer u = this.mapItemToUtility.get(item);
                                    Integer f = this.mapItemToFrequent.get(item);
                                    Integer twu = this.mapItemToTempTWU.get(item);
                                    u = u == null ? (Integer)utility : u + (Integer)utility;
                                    this.mapItemToUtility.put(item, u);
                                    f = f == null ? 1 : f + 1;
                                    this.mapItemToFrequent.put(item, f);
                                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                                    this.mapItemToTempTWU.put(item, twu);
                                    ++i;
                                }
                            }
                            for (Integer item : this.mapItemToFrequent.keySet()) {
                                int f = this.mapItemToFrequent.get(item);
                                int u = this.mapItemToUtility.get(item);
                                if (f > this.fMax) {
                                    this.fMax = f;
                                    this.MUS = u;
                                    continue;
                                }
                                if (f != this.fMax || u <= this.MUS) continue;
                                this.MUS = u;
                            }
                            for (Integer item : this.mapItemToTempTWU.keySet()) {
                                int twu = this.mapItemToTempTWU.get(item);
                                if (twu >= this.MUS) continue;
                                unpromising_list.add(item);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (myInput != null) {
                                myInput.close();
                            }
                            break block36;
                        }
                    }
                    catch (Throwable throwable) {
                        if (myInput != null) {
                            myInput.close();
                        }
                        throw throwable;
                    }
                    if (myInput != null) {
                        myInput.close();
                    }
                }
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            utility = items;
                            int item = items.length;
                            i = 0;
                            while (i < item) {
                                String s = utility[i];
                                Integer item2 = Integer.parseInt(s);
                                Integer twu = this.mapItemToTWU.get(item2);
                                if (!unpromising_list.contains(item2)) {
                                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                                    this.mapItemToTWU.put(item2, twu);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block38;
                    }
                }
                catch (Throwable twu) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw twu;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            UtilityLists = new ArrayList<UtilityList>();
            HashMap<Integer, UtilityList> mapItemToUtilityList = new HashMap<Integer, UtilityList>();
            for (Integer item : this.mapItemToTWU.keySet()) {
                UtilityList uList = new UtilityList(item);
                mapItemToUtilityList.put(item, uList);
                UtilityLists.add(uList);
            }
            UtilityLists.sort((o1, o2) -> this.compareItems(o1.item, o2.item));
            tid = 0;
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        int remainingUtility = 0;
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            Pair pair = new Pair();
                            pair.item = Integer.parseInt(items[i]);
                            pair.utility = Integer.parseInt(utilityValues[i]);
                            if (!unpromising_list.contains(pair.item)) {
                                revisedTransaction.add(pair);
                                remainingUtility += pair.utility;
                            }
                            ++i;
                        }
                        revisedTransaction.sort((o1, o2) -> this.compareItems(o1.item, o2.item));
                        for (Pair pair : revisedTransaction) {
                            UtilityList utilityListOfItem = (UtilityList)mapItemToUtilityList.get(pair.item);
                            Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                            utilityListOfItem.addElement(element);
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.checkMemory();
        int[] MUA = new int[this.fMax + 1];
        int i = 1;
        while (i < this.fMax + 1) {
            MUA[i] = this.MUS - 1;
            ++i;
        }
        SkylineList[] psfupList = new SkylineList[tid + 1];
        ArrayList<Skyline> skylineList = new ArrayList<Skyline>();
        this.SFUPMiner(new int[0], null, UtilityLists, psfupList, MUA, 0);
        this.SFUSMiner(skylineList, psfupList);
        this.writeOut(skylineList);
        this.psfupCount = this.getpsfupCount(psfupList);
        this.checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void SFUPMiner(int[] prefix, UtilityList pUL, List<UtilityList> ULs, SkylineList[] psfupList, int[] MUA, int MUE) {
        int i = 0;
        while (i < ULs.size()) {
            boolean isPass;
            UtilityList X = ULs.get(i);
            ++this.searchCount;
            if (i == 0) {
                isPass = X.sumIutils >= MUE;
            } else {
                boolean bl = isPass = X.sumIutils + X.sumRutils >= this.MUS;
            }
            if (isPass) {
                int temp;
                MUE = X.sumIutils;
                int k = temp = X.elements.size();
                while (k < MUA.length) {
                    if (MUA[k] > MUA[temp]) {
                        MUA[temp] = MUA[k];
                    }
                    ++k;
                }
                int t = temp - 1;
                while (t > 0) {
                    if (MUA[t] >= MUA[temp]) break;
                    MUA[t] = MUA[temp];
                    --t;
                }
                if (X.sumIutils == MUA[temp] && MUA[temp] != 0) {
                    Skyline tempPoint = new Skyline();
                    tempPoint.itemSet = this.itemSetString(prefix, X.item);
                    tempPoint.frequent = temp;
                    tempPoint.utility = X.sumIutils;
                    psfupList[temp].add(tempPoint);
                }
                if (X.sumIutils > MUA[temp]) {
                    MUA[temp] = X.sumIutils;
                    if (psfupList[temp] == null) {
                        SkylineList tempList = new SkylineList();
                        Skyline tempPoint = new Skyline();
                        tempPoint.itemSet = this.itemSetString(prefix, X.item);
                        tempPoint.frequent = temp;
                        tempPoint.utility = X.sumIutils;
                        tempList.add(tempPoint);
                        psfupList[temp] = tempList;
                    } else {
                        int templength = psfupList[temp].size();
                        if (templength == 1) {
                            psfupList[temp].get((int)0).itemSet = this.itemSetString(prefix, X.item);
                            psfupList[temp].get((int)0).utility = X.sumIutils;
                        } else {
                            int j = templength - 1;
                            while (j > 0) {
                                psfupList[temp].remove(j);
                                --j;
                            }
                            psfupList[temp].get((int)0).itemSet = this.itemSetString(prefix, X.item);
                            psfupList[temp].get((int)0).utility = X.sumIutils;
                        }
                    }
                }
                if (X.sumIutils + X.sumRutils >= MUA[temp] && MUA[temp] != 0) {
                    ArrayList<UtilityList> exULs = new ArrayList<UtilityList>();
                    int j = i + 1;
                    while (j < ULs.size()) {
                        UtilityList Y = ULs.get(j);
                        exULs.add(this.construct(pUL, X, Y));
                        ++j;
                    }
                    int[] newPrefix = new int[prefix.length + 1];
                    System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                    newPrefix[prefix.length] = X.item;
                    this.SFUPMiner(newPrefix, X, exULs, psfupList, MUA, MUE);
                }
            }
            ++i;
        }
    }

    private UtilityList construct(UtilityList P, UtilityList px, UtilityList py) {
        UtilityList pxyUL = new UtilityList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.iutils + ey.iutils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.iutils + ey.iutils - e.iutils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(UtilityList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private String itemSetString(int[] prefix, int item) {
        StringBuilder buffer = new StringBuilder();
        int[] nArray = prefix;
        int n = prefix.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            buffer.append(j);
            buffer.append(' ');
            ++n2;
        }
        buffer.append(item);
        return buffer.toString();
    }

    private void writeOut(List<Skyline> skylineList) throws IOException {
        this.sfupCount = skylineList.size();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.sfupCount) {
            buffer.append(skylineList.get((int)i).itemSet);
            buffer.append(" #SUP:");
            buffer.append(skylineList.get((int)i).frequent);
            buffer.append(" #UTILITY:");
            buffer.append(skylineList.get((int)i).utility);
            buffer.append(System.lineSeparator());
            ++i;
        }
        this.writer.write(buffer.toString());
    }

    private void SFUSMiner(List<Skyline> skylineList, SkylineList[] psfupList) {
        int i = 1;
        while (i < psfupList.length) {
            boolean temp = false;
            if (psfupList[i] != null) {
                int j = i + 1;
                while (j < psfupList.length) {
                    if (psfupList[j] == null) {
                        ++j;
                        continue;
                    }
                    if (psfupList[i].get((int)0).utility <= psfupList[j].get((int)0).utility) {
                        temp = true;
                        break;
                    }
                    ++j;
                }
                if (!temp) {
                    int k = 0;
                    while (k < psfupList[i].size()) {
                        skylineList.add(psfupList[i].get(k));
                        ++k;
                    }
                }
            }
            ++i;
        }
    }

    private int getpsfupCount(SkylineList[] psfupList) {
        int i = 1;
        while (i < psfupList.length) {
            if (psfupList[i] != null) {
                this.psfupCount += psfupList[i].size();
            }
            ++i;
        }
        return this.psfupCount;
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  SFUI-UF ALGORITHM v2.50  =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + this.maxMemory + " MB");
        System.out.println(" Skyline itemsets count : " + this.sfupCount);
        System.out.println(" Search itemsets count : " + this.searchCount);
        System.out.println(" Candidate itemsets count : " + this.psfupCount);
        System.out.println("===================================================");
    }

    static class Pair {
        int item = 0;
        int utility = 0;

        Pair() {
        }
    }
}

