/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.sfu_ce;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoSFU_CE {
    double maxMemory = 0.0;
    long startTimestamp = 0L;
    long endTimestamp = 0L;
    int popSize = 2000;
    int proSize = 0;
    final int iter = 2000;
    int transCount = 0;
    Integer cusItem;
    int acIter = 0;
    int CUS = 0;
    int fMax = 0;
    final double alpha = 0.2;
    final double beta = 0.3;
    Map<Integer, Integer> mapItemToU;
    Map<Integer, Integer> mapItemToTWU;
    Map<Integer, Integer> mapItemToF;
    List<Integer> twuPattern;
    BufferedWriter writer = null;
    double[] PV;
    List<Particle> population = new ArrayList<Particle>();
    List<List<Pair>> database = new ArrayList<List<Pair>>();
    List<Item> Items;
    List<Particle> CSFUIList = new ArrayList<Particle>();
    List<SFUI> SFUIList = new ArrayList<SFUI>();

    public void runAlgorithm(String input, String output) throws IOException {
        block32: {
            Integer item;
            int i;
            Object items;
            String thisLine;
            BufferedReader myInput;
            block30: {
                this.maxMemory = 0.0;
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemToU = new HashMap<Integer, Integer>();
                this.mapItemToTWU = new HashMap<Integer, Integer>();
                this.mapItemToF = new HashMap<Integer, Integer>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            ++this.transCount;
                            String[] split = thisLine.split(":");
                            items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            String[] utilities = split[2].split(" ");
                            i = 0;
                            while (i < ((Object)items).length) {
                                item = Integer.parseInt((String)items[i]);
                                Integer utility = Integer.parseInt(utilities[i]);
                                Integer u = this.mapItemToU.get(item);
                                Integer f = this.mapItemToF.get(item);
                                u = u == null ? utility : u + utility;
                                this.mapItemToU.put(item, u);
                                f = f == null ? 1 : f + 1;
                                this.mapItemToF.put(item, f);
                                Integer twu = this.mapItemToTWU.get(item);
                                twu = twu == null ? transactionUtility : twu + transactionUtility;
                                this.mapItemToTWU.put(item, twu);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.calculateCUS(this.mapItemToU, this.mapItemToF);
            this.twuPattern = new ArrayList<Integer>();
            for (Map.Entry<Integer, Integer> vo : this.mapItemToTWU.entrySet()) {
                Integer item2 = vo.getKey();
                if (this.mapItemToTWU.get(item2) < this.CUS) continue;
                this.twuPattern.add(item2);
            }
            int i2 = 0;
            while (i2 < this.twuPattern.size()) {
                if (this.twuPattern.get(i2).equals(this.cusItem)) {
                    BitSet X = new BitSet(this.twuPattern.size());
                    X.set(i2);
                    Particle sfui = new Particle(X, this.fMax, this.CUS);
                    this.population.add(sfui);
                    this.judge(sfui);
                    break;
                }
                ++i2;
            }
            this.PV = new double[this.twuPattern.size()];
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        i = 0;
                        while (i < ((Object)items).length) {
                            item = Integer.parseInt((String)items[i]);
                            if (this.mapItemToTWU.get(item) >= this.CUS) {
                                Pair pair = new Pair();
                                pair.item = Integer.parseInt((String)items[i]);
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                pair.frequency = 1;
                                revisedTransaction.add(pair);
                            }
                            ++i;
                        }
                        this.database.add(revisedTransaction);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        this.Items = new ArrayList<Item>();
        for (Integer tempitem : this.twuPattern) {
            this.Items.add(new Item(tempitem));
        }
        int i = 0;
        while (i < this.database.size()) {
            for (Item item : this.Items) {
                int k = 0;
                while (k < this.database.get(i).size()) {
                    if (item.item == this.database.get((int)i).get((int)k).item) {
                        item.TIDS.set(i);
                    }
                    ++k;
                }
            }
            ++i;
        }
        this.checkMemory();
        this.generatePop();
        int i3 = 0;
        while (i3 < 2000) {
            this.population.sort((itemset1, itemset2) -> -(itemset1.utilityFitness - itemset2.utilityFitness));
            int max_min = this.population.get((int)0).utilityFitness - this.population.get((int)((int)(0.7 * (double)this.population.size()) - 1)).utilityFitness;
            if (max_min == 0) break;
            ++this.acIter;
            this.update();
            ++i3;
        }
        this.CSFUIList.sort((itemset1, itemset2) -> -(itemset1.utilityFitness - itemset2.utilityFitness));
        for (Particle particle : this.CSFUIList) {
            this.insert(particle);
        }
        this.endTimestamp = System.currentTimeMillis();
        this.checkMemory();
        this.writeOut();
        this.writer.close();
    }

    public void calculateCUS(Map<Integer, Integer> mapToU, Map<Integer, Integer> mapToF) {
        if (mapToU == null || mapToF == null) {
            return;
        }
        for (Integer item : mapToF.keySet()) {
            if (mapToF.get(item) <= this.fMax) continue;
            this.fMax = mapToF.get(item);
        }
        for (Integer item : mapToF.keySet()) {
            if (mapToF.get(item) != this.fMax || this.CUS >= mapToU.get(item)) continue;
            this.CUS = mapToU.get(item);
            this.cusItem = item;
        }
    }

    private void generatePop() {
        int i = 0;
        while (i < this.popSize - 1) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)this.twuPattern.size() + 1.0);
            while (j < k) {
                int temp = (int)(Math.random() * (double)this.twuPattern.size());
                if (tempParticle.IV.get(temp)) continue;
                ++j;
                tempParticle.IV.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            this.isRBAIndividual(tempParticle, transList);
            tempParticle.calculateFitness(k, transList);
            this.population.add(tempParticle);
            this.judge(tempParticle);
            ++i;
        }
    }

    private void update() {
        ArrayList<Integer> mutlist = new ArrayList<Integer>();
        int[] num = new int[this.twuPattern.size()];
        int i = 0;
        while ((double)i < 0.2 * (double)this.popSize) {
            int j = 0;
            while (j < this.twuPattern.size()) {
                if (this.population.get((int)i).IV.get(j)) {
                    int n = j;
                    num[n] = num[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        this.population.clear();
        i = 0;
        while (i < this.twuPattern.size()) {
            this.PV[i] = (float)((double)num[i] / (0.2 * (double)this.popSize + 0.0));
            if (this.PV[i] > 0.5) {
                mutlist.add(i);
            }
            ++i;
        }
        this.proSize = mutlist.size() > 0 ? (int)(0.7 * (double)this.popSize) : this.popSize;
        int i2 = 0;
        while (i2 < this.proSize) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            this.update_Particle(tempParticle);
            ArrayList<Integer> transList = new ArrayList<Integer>();
            if (this.isRBAIndividual(tempParticle, transList)) {
                int k = tempParticle.IV.cardinality();
                tempParticle.calculateFitness(k, transList);
                this.population.add(tempParticle);
                this.judge(tempParticle);
            }
            ++i2;
        }
        this.mutation(mutlist);
    }

    private void update_Particle(Particle temp) {
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (Math.random() < this.PV[i]) {
                temp.IV.set(i);
            }
            ++i;
        }
    }

    private void mutation(List<Integer> MRList) {
        if (MRList.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.popSize - this.proSize) {
            Particle tempParticle = new Particle(this.twuPattern.size());
            int j = 0;
            int k = (int)(Math.random() * (double)MRList.size() + 1.0);
            while (j < k) {
                int temp = (int)(Math.random() * (double)MRList.size());
                if (tempParticle.IV.get(temp = MRList.get(temp).intValue())) continue;
                ++j;
                tempParticle.IV.set(temp);
            }
            ArrayList<Integer> transList = new ArrayList<Integer>();
            if (this.isRBAIndividual(tempParticle, transList)) {
                tempParticle.calculateFitness(k, transList);
                this.population.add(tempParticle);
                this.judge(tempParticle);
            }
            ++i;
        }
    }

    private void judge(Particle temp) {
        if (temp.utilityFitness < this.CUS) {
            return;
        }
        if (this.CSFUIList.isEmpty()) {
            this.CSFUIList.add(temp);
            return;
        }
        for (Particle particle : this.CSFUIList) {
            if (particle.frequentFitness < temp.frequentFitness || particle.utilityFitness < temp.utilityFitness) continue;
            return;
        }
        this.CSFUIList.removeIf(tempSFUI -> tempSFUI.frequentFitness < particle.frequentFitness && tempSFUI.utilityFitness <= particle.utilityFitness || tempSFUI.frequentFitness <= particle.frequentFitness && tempSFUI.utilityFitness < particle.utilityFitness);
        this.CSFUIList.add(temp);
    }

    public boolean isRBAIndividual(Particle tempParticle, List<Integer> list) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.IV.get(i)) {
                templist.add(i);
            }
            ++i;
        }
        if (templist.size() == 0) {
            return false;
        }
        BitSet tempBitSet = (BitSet)this.Items.get((int)((Integer)templist.get((int)0)).intValue()).TIDS.clone();
        BitSet midBitSet = (BitSet)tempBitSet.clone();
        int i2 = 1;
        while (i2 < templist.size()) {
            tempBitSet.and(this.Items.get((int)((Integer)templist.get((int)i2)).intValue()).TIDS);
            if (tempBitSet.cardinality() != 0) {
                midBitSet = (BitSet)tempBitSet.clone();
            } else {
                tempBitSet = (BitSet)midBitSet.clone();
                tempParticle.IV.clear((Integer)templist.get(i2));
            }
            ++i2;
        }
        if (tempBitSet.cardinality() == 0) {
            return false;
        }
        int m = 0;
        while (m < tempBitSet.length()) {
            if (tempBitSet.get(m)) {
                list.add(m);
            }
            ++m;
        }
        return true;
    }

    private void insert(Particle tempParticle) {
        StringBuilder temp = new StringBuilder();
        int i = 0;
        while (i < this.twuPattern.size()) {
            if (tempParticle.IV.get(i)) {
                temp.append(this.twuPattern.get(i));
                temp.append(' ');
            }
            ++i;
        }
        if (this.SFUIList.size() == 0) {
            this.SFUIList.add(new SFUI(temp.toString(), tempParticle.utilityFitness, tempParticle.frequentFitness));
        } else {
            i = 0;
            while (i < this.SFUIList.size()) {
                if (temp.toString().equals(this.SFUIList.get((int)i).itemset)) break;
                ++i;
            }
            if (i == this.SFUIList.size()) {
                this.SFUIList.add(new SFUI(temp.toString(), tempParticle.utilityFitness, tempParticle.frequentFitness));
            }
        }
    }

    private void writeOut() throws IOException {
        for (SFUI sfui : this.SFUIList) {
            String buffer = String.valueOf(sfui.itemset) + "#SUP: " + sfui.F_fitness + " #UTIL: " + sfui.U_fitness;
            this.writer.write(buffer);
            this.writer.newLine();
        }
    }

    private void checkMemory() {
        double currentMemory = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0 / 1024.0;
        if (currentMemory > this.maxMemory) {
            this.maxMemory = currentMemory;
        }
    }

    public void printStats() {
        System.out.println("=============  SFU-CE ALGORITHM v2.51  =============");
        System.out.println(" Total time                 : " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory                     : " + this.maxMemory + " MB");
        System.out.println(" Pattern count              : " + this.SFUIList.size());
        System.out.println(" Actual number of iterations: " + this.acIter);
        System.out.println("===================================================");
    }

    class Item {
        int item;
        BitSet TIDS;

        public Item(int item) {
            this.TIDS = new BitSet(AlgoSFU_CE.this.transCount);
            this.item = item;
        }
    }

    static class Pair {
        int item = 0;
        int utility = 0;
        int frequency = 0;

        Pair() {
        }
    }

    class Particle {
        BitSet IV;
        int frequentFitness;
        int utilityFitness;

        public Particle(int length) {
            this.IV = new BitSet(length);
        }

        Particle(BitSet IV, int frequentFitness, int utilityFitness) {
            this.IV = IV;
            this.frequentFitness = frequentFitness;
            this.utilityFitness = utilityFitness;
        }

        public void calculateFitness(int k, List<Integer> templist) {
            if (k == 0) {
                return;
            }
            int u_fitness = 0;
            int f_fitness = 0;
            int m = 0;
            while (m < templist.size()) {
                int p = templist.get(m);
                int i = 0;
                int q = 0;
                int temp = 0;
                int sum = 0;
                block1: while (q < AlgoSFU_CE.this.database.get(p).size() && i < AlgoSFU_CE.this.twuPattern.size()) {
                    if (this.IV.get(i)) {
                        int t = 0;
                        while (t < AlgoSFU_CE.this.database.get(p).size()) {
                            if (AlgoSFU_CE.this.database.get((int)p).get((int)t).item == AlgoSFU_CE.this.twuPattern.get(i)) {
                                sum += AlgoSFU_CE.this.database.get((int)p).get((int)t).utility;
                                ++i;
                                ++temp;
                                continue block1;
                            }
                            ++t;
                        }
                        continue;
                    }
                    ++i;
                }
                if (temp == k) {
                    u_fitness += sum;
                    ++f_fitness;
                }
                ++m;
            }
            this.utilityFitness = u_fitness;
            this.frequentFitness = f_fitness;
        }
    }

    static class SFUI {
        String itemset;
        int U_fitness;
        int F_fitness;

        public SFUI(String itemset2, int U_fitness, int F_fitness) {
            this.itemset = itemset2;
            this.U_fitness = U_fitness;
            this.F_fitness = F_fitness;
        }
    }
}

