/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth;

import ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth.RPNode;
import ca.pfv.spmf.algorithms.frequentpatterns.rpgrowth.RPTree;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemset;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoRPGrowth {
    private long startTimestamp;
    private long endTime;
    private int transactionCount = 0;
    private int itemsetCount;
    public int minRareSupportRelative;
    public int minSupportRelative;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private RPNode[] rpNodeTempBuffer = null;
    private int[] itemsetOutputBuffer = null;
    private int maxPatternLength = 1000;
    private int minPatternLength = 0;

    public Itemsets runAlgorithm(String input, String output, double minsupp, double minraresupp) throws FileNotFoundException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.itemsetCount = 0;
        MemoryLogger.getInstance().reset();
        MemoryLogger.getInstance().checkMemory();
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("RARE ITEMSETS");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
            this.itemsetOutputBuffer = new int[2000];
        }
        final Map<Integer, Integer> mapSupport = this.scanDatabaseToDetermineFrequencyOfSingleItems(input);
        this.minRareSupportRelative = (int)Math.ceil(minraresupp * (double)this.transactionCount);
        this.minSupportRelative = (int)Math.ceil(minsupp * (double)this.transactionCount);
        RPTree tree = new RPTree();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            int myCheck;
            int count;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            ArrayList<Integer> transaction = new ArrayList<Integer>();
            String[] stringArray = lineSplited;
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                if (mapSupport.get(item) >= this.minRareSupportRelative) {
                    transaction.add(item);
                }
                ++n2;
            }
            Collections.sort(transaction, new Comparator<Integer>(){

                @Override
                public int compare(Integer item1, Integer item2) {
                    int compare = (Integer)mapSupport.get(item2) - (Integer)mapSupport.get(item1);
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
            if (transaction.isEmpty() || (count = mapSupport.get(myCheck = ((Integer)transaction.get(transaction.size() - 1)).intValue()).intValue()) >= this.minSupportRelative) continue;
            tree.addTransaction(transaction);
        }
        reader.close();
        tree.createHeaderList(mapSupport);
        if (tree.headerList.size() > 0) {
            this.itemsetBuffer = new int[2000];
            this.rpNodeTempBuffer = new RPNode[2000];
            this.rpgrowth(tree, this.itemsetBuffer, 0, this.transactionCount, mapSupport);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.endTime = System.currentTimeMillis();
        MemoryLogger.getInstance().checkMemory();
        return this.patterns;
    }

    private void rpgrowth(RPTree tree, int[] prefix, int prefixLength, int prefixSupport, Map<Integer, Integer> mapSupport) throws IOException {
        if (prefixLength == this.maxPatternLength) {
            return;
        }
        boolean singlePath = true;
        int position = 0;
        if (tree.root.childs.size() > 1) {
            singlePath = false;
        } else {
            RPNode currentNode = tree.root.childs.get(0);
            while (true) {
                if (currentNode.childs.size() > 1) {
                    singlePath = false;
                    break;
                }
                this.rpNodeTempBuffer[position] = currentNode;
                ++position;
                if (currentNode.childs.size() == 0) break;
                currentNode = currentNode.childs.get(0);
            }
        }
        if (singlePath && prefixLength > 0) {
            this.saveAllCombinationsOfPrefixPath(this.rpNodeTempBuffer, position, prefix, prefixLength);
        } else {
            int i = tree.headerList.size() - 1;
            while (i >= 0) {
                int betaSupport;
                Integer item = tree.headerList.get(i);
                int support = mapSupport.get(item);
                if (prefixLength == 0 && support >= this.minSupportRelative) {
                    return;
                }
                prefix[prefixLength] = item;
                int n = betaSupport = prefixSupport < support ? prefixSupport : support;
                if (prefixLength > 0 || support < this.minSupportRelative) {
                    this.saveItemset(prefix, prefixLength + 1, betaSupport);
                }
                if (prefixLength + 1 < this.maxPatternLength) {
                    ArrayList prefixPaths = new ArrayList();
                    RPNode path = tree.mapItemNodes.get(item);
                    HashMap<Integer, Integer> mapSupportBeta = new HashMap<Integer, Integer>();
                    while (path != null) {
                        if (path.parent.itemID != -1) {
                            ArrayList<RPNode> prefixPath = new ArrayList<RPNode>();
                            prefixPath.add(path);
                            int n2 = path.counter;
                            RPNode parent = path.parent;
                            while (parent.itemID != -1) {
                                prefixPath.add(parent);
                                if (mapSupportBeta.get(parent.itemID) == null) {
                                    mapSupportBeta.put(parent.itemID, n2);
                                } else {
                                    mapSupportBeta.put(parent.itemID, (Integer)mapSupportBeta.get(parent.itemID) + n2);
                                }
                                parent = parent.parent;
                            }
                            prefixPaths.add(prefixPath);
                        }
                        path = path.nodeLink;
                    }
                    RPTree treeBeta = new RPTree();
                    for (List list : prefixPaths) {
                        treeBeta.addPrefixPath(list, mapSupportBeta, this.minSupportRelative, this.minRareSupportRelative);
                    }
                    if (treeBeta.root.childs.size() > 0) {
                        treeBeta.createHeaderList(mapSupportBeta);
                        this.rpgrowth(treeBeta, prefix, prefixLength + 1, betaSupport, mapSupportBeta);
                    }
                }
                --i;
            }
        }
    }

    private void saveAllCombinationsOfPrefixPath(RPNode[] rpNodeTempBuffer, int position, int[] prefix, int prefixLength) throws IOException {
        int support = 0;
        if (prefixLength == 0) {
            return;
        }
        long i = 1L;
        long max = 1 << position;
        while (i < max) {
            block5: {
                int newPrefixLength = prefixLength;
                int j = 0;
                while (j < position) {
                    int isSet = (int)i & 1 << j;
                    if (isSet > 0) {
                        if (newPrefixLength == this.maxPatternLength) break block5;
                        prefix[newPrefixLength++] = rpNodeTempBuffer[j].itemID;
                        support = rpNodeTempBuffer[j].counter;
                    }
                    ++j;
                }
                this.saveItemset(prefix, newPrefixLength, support);
            }
            ++i;
        }
    }

    private Map<Integer, Integer> scanDatabaseToDetermineFrequencyOfSingleItems(String input) throws FileNotFoundException, IOException {
        String line;
        HashMap<Integer, Integer> mapSupport = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapSupport.get(item);
                if (count == null) {
                    mapSupport.put(item, 1);
                } else {
                    count = count + 1;
                    mapSupport.put(item, count);
                }
                ++n2;
            }
            ++this.transactionCount;
        }
        reader.close();
        return mapSupport;
    }

    private void saveItemset(int[] itemset2, int itemsetLength, int support) throws IOException {
        if (itemsetLength < this.minPatternLength) {
            return;
        }
        ++this.itemsetCount;
        if (this.writer != null) {
            System.arraycopy(itemset2, 0, this.itemsetOutputBuffer, 0, itemsetLength);
            Arrays.sort(this.itemsetOutputBuffer, 0, itemsetLength);
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < itemsetLength) {
                buffer.append(this.itemsetOutputBuffer[i]);
                if (i != itemsetLength - 1) {
                    buffer.append(' ');
                }
                ++i;
            }
            buffer.append(" #SUP: ");
            buffer.append(support);
            this.writer.write(buffer.toString());
            this.writer.newLine();
        } else {
            int[] itemsetArray = new int[itemsetLength];
            System.arraycopy(itemset2, 0, itemsetArray, 0, itemsetLength);
            Arrays.sort(itemsetArray);
            Itemset itemsetObj = new Itemset(itemsetArray);
            itemsetObj.setAbsoluteSupport(support);
            this.patterns.addItemset(itemsetObj, itemsetLength);
        }
    }

    public void printStats() {
        System.out.println("=============  RP-GROWTH 2.38 - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Transactions count from database : " + this.transactionCount);
        System.out.print(" Max memory usage: " + MemoryLogger.getInstance().getMaxMemory() + " mb \n");
        System.out.println(" Rare itemsets count : " + this.itemsetCount);
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println("===================================================");
    }

    public int getDatabaseSize() {
        return this.transactionCount;
    }

    public void setMaximumPatternLength(int length) {
        this.maxPatternLength = length;
    }

    public void setMinimumPatternLength(int minPatternLength) {
        this.minPatternLength = minPatternLength;
    }
}

