/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.opusminer;

import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.AlgoOpusMiner;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.Global;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.ItemQElement;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.Utils;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemQClass;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.itemsetRec;
import ca.pfv.spmf.algorithms.frequentpatterns.opusminer.tidset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FindItemsets {
    public static float minValue = -3.4028235E38f;
    public static Map<itemset, Integer> TIDCount = new HashMap<itemset, Integer>();

    public static void find_itemsets() {
        itemQClass q = new itemQClass();
        int i = 1;
        while (i <= Global.noOfItems) {
            float ubVal;
            int c = Global.tids.get(i).size();
            float sup = Utils.countToSup(c);
            float f = ubVal = Global.searchByLift ? 1.0f / sup : sup - sup * sup;
            if (Utils.fisher(c, c, c) <= Global.getAlpha(2)) {
                q.append(ubVal, i);
            }
            ++i;
        }
        itemQClass newq = new itemQClass();
        if (q.size() > 0) {
            Collections.sort(q, new Comparator<ItemQElement>(){

                @Override
                public int compare(ItemQElement i1, ItemQElement i2) {
                    float val = i2.ubVal - i1.ubVal;
                    if (val > 0.0f) {
                        return 1;
                    }
                    if (val < 0.0f) {
                        return -1;
                    }
                    return 0;
                }
            });
            newq.insert(((ItemQElement)q.get((int)0)).ubVal, ((ItemQElement)q.get((int)0)).item);
        }
        float prevMinVal = minValue;
        itemsetRec is = new itemsetRec();
        i = 1;
        while (i < q.size() && ((ItemQElement)q.get((int)i)).ubVal > minValue) {
            Integer item = ((ItemQElement)q.get((int)i)).item;
            is.clear();
            is.add(item);
            CoverIsQ coverIsQ = new CoverIsQ();
            coverIsQ.is = (itemsetRec)is.clone();
            coverIsQ.cover = (tidset)Global.tids.get(item).clone();
            coverIsQ.q = (itemQClass)newq.clone();
            FindItemsets.opus(coverIsQ, Global.tids.get(item).size());
            newq.append(((ItemQElement)q.get((int)i)).ubVal, item);
            if (prevMinVal < minValue) {
                System.out.printf("<%f>", Float.valueOf(minValue));
                prevMinVal = minValue;
            } else {
                System.out.print('.');
            }
            ++i;
        }
        System.out.print('\n');
    }

    public static Integer getTIDCount(itemset is) {
        if (is.size() == 1) {
            return Global.tids.get((Integer)is.first()).size();
        }
        return TIDCount.get(is);
    }

    public static void checkImmediateSubsets(itemset is, int isCnt, RedundantAprioriFlags flags) {
        itemset subset = new itemset();
        subset.addAll(is);
        Iterator it = is.iterator();
        flags.redundant = false;
        flags.apriori = false;
        while (it.hasNext()) {
            Integer currentIt = (Integer)it.next();
            subset.remove(currentIt);
            Integer subsetCnt = FindItemsets.getTIDCount(subset);
            if (subsetCnt == null) {
                flags.redundant = true;
                flags.apriori = true;
                return;
            }
            if (Global.redundancyTests && subsetCnt.equals(isCnt)) {
                flags.redundant = true;
            }
            subset.add(currentIt);
        }
    }

    public static boolean checkSubsetsX(SoFarRemaining sfRemaining, Integer limit, int cnt, float new_sup, ValP valP, double alpha) {
        double this_p;
        float this_val;
        Integer sofarCnt = FindItemsets.getTIDCount(sfRemaining.sofar);
        Integer remainingCnt = FindItemsets.getTIDCount(sfRemaining.remaining);
        if (sofarCnt == null || remainingCnt == null) {
            return false;
        }
        float f = this_val = Global.searchByLift ? new_sup / (Utils.countToSup(remainingCnt) * Utils.countToSup(sofarCnt)) : new_sup - Utils.countToSup(remainingCnt) * Utils.countToSup(sofarCnt);
        if (this_val < valP.val) {
            valP.val = this_val;
            if (this_val <= minValue) {
                return false;
            }
        }
        if ((this_p = Utils.fisher(cnt, sofarCnt, remainingCnt)) > valP.p) {
            valP.p = this_p;
            if (valP.p > alpha) {
                return false;
            }
        }
        if (sfRemaining.remaining.size() > 1) {
            itemset new_remaining = new itemset();
            new_remaining.addAll(sfRemaining.remaining);
            for (Integer currentIt : sfRemaining.remaining) {
                if (currentIt >= limit) break;
                sfRemaining.sofar.add(currentIt);
                new_remaining.remove(currentIt);
                SoFarRemaining newSfRemaining = new SoFarRemaining();
                newSfRemaining.sofar = sfRemaining.sofar;
                newSfRemaining.remaining = new_remaining;
                if (!FindItemsets.checkSubsetsX(newSfRemaining, currentIt, cnt, new_sup, valP, alpha)) {
                    return false;
                }
                sfRemaining.sofar.remove(currentIt);
                new_remaining.add(currentIt);
            }
        }
        return valP.p <= alpha && valP.val > minValue;
    }

    public static boolean checkSubsets(Integer item, itemset is, int cnt, float new_sup, int parentCnt, float parentSup, ValP valP, double alpha) {
        assert (is.size() > 1);
        int itemCnt = Global.tids.get(item).size();
        float f = valP.val = Global.searchByLift ? new_sup / (parentSup * Utils.itemSup(item)) : new_sup - parentSup * Utils.itemSup(item);
        if (valP.val <= minValue) {
            return false;
        }
        valP.p = Utils.fisher(cnt, itemCnt, parentCnt);
        if (valP.p > alpha) {
            return false;
        }
        if (is.size() > 2) {
            SoFarRemaining sfRemaining = new SoFarRemaining();
            sfRemaining.remaining = new itemset();
            sfRemaining.remaining.addAll(is);
            sfRemaining.remaining.remove(item);
            sfRemaining.sofar = new itemset();
            sfRemaining.sofar.add(item);
            for (Integer currentIt : is) {
                if (currentIt.equals(item)) continue;
                sfRemaining.sofar.add(currentIt);
                sfRemaining.remaining.remove(currentIt);
                if (!FindItemsets.checkSubsetsX(sfRemaining, currentIt, cnt, new_sup, valP, alpha)) {
                    return false;
                }
                sfRemaining.sofar.remove(currentIt);
                sfRemaining.remaining.add(currentIt);
            }
        }
        return valP.p <= alpha && valP.val > minValue;
    }

    public static void insert_itemset(itemsetRec is) {
        float newMin;
        if (AlgoOpusMiner.itemsets.size() >= Global.k) {
            AlgoOpusMiner.itemsets.poll();
        }
        itemsetRec iss = new itemsetRec();
        iss = (itemsetRec)is.clone();
        AlgoOpusMiner.itemsets.add(iss);
        if (AlgoOpusMiner.itemsets.size() == Global.k && (newMin = AlgoOpusMiner.itemsets.peek().value) > minValue) {
            minValue = newMin;
        }
    }

    public static void opus(CoverIsQ coverIsQ, int maxItemCount) {
        float parentSup = Utils.countToSup(coverIsQ.cover.size());
        int depth = coverIsQ.is.size() + 1;
        tidset newCover = new tidset();
        itemQClass newQ = new itemQClass();
        int i = 0;
        while (i < coverIsQ.q.size()) {
            float ubval;
            Integer item = ((ItemQElement)coverIsQ.q.get((int)i)).item;
            tidset.intersection(newCover, coverIsQ.cover, Global.tids.get(item));
            int count = newCover.size();
            int newMaxItemCount = Math.max(maxItemCount, Global.tids.get(item).size());
            float new_sup = Utils.countToSup(count);
            double lb_p = Utils.fisher(count, newMaxItemCount, count);
            float f = Global.searchByLift ? (count == 0 ? 0.0f : 1.0f / Utils.countToSup(maxItemCount)) : (ubval = new_sup - new_sup * Utils.countToSup(maxItemCount));
            if (lb_p <= Global.getAlpha(depth) && ubval > minValue) {
                coverIsQ.is.add(item);
                RedundantAprioriFlags flags = new RedundantAprioriFlags();
                FindItemsets.checkImmediateSubsets(coverIsQ.is, count, flags);
                if (!flags.apriori) {
                    ValP valP = new ValP();
                    if (FindItemsets.checkSubsets(item, coverIsQ.is, count, new_sup, coverIsQ.cover.size(), parentSup, valP, Global.getAlpha(depth))) {
                        coverIsQ.is.count = count;
                        coverIsQ.is.value = valP.val;
                        coverIsQ.is.p = valP.p;
                        FindItemsets.insert_itemset(coverIsQ.is);
                    }
                    if (!flags.redundant) {
                        itemsetRec iss = (itemsetRec)coverIsQ.is.clone();
                        TIDCount.put(iss, count);
                        if (!newQ.isEmpty()) {
                            CoverIsQ newCoverIsQ = new CoverIsQ();
                            newCoverIsQ.is = (itemsetRec)coverIsQ.is.clone();
                            newCoverIsQ.cover = (tidset)newCover.clone();
                            newCoverIsQ.q = (itemQClass)newQ.clone();
                            FindItemsets.opus(newCoverIsQ, newMaxItemCount);
                        }
                        newQ.insert(ubval, item);
                    }
                }
                coverIsQ.is.remove(item);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    public static class CoverIsQ {
        itemsetRec is = null;
        tidset cover = null;
        itemQClass q = null;
    }

    public static class RedundantAprioriFlags {
        boolean redundant = false;
        boolean apriori = false;
    }

    public static class SoFarRemaining {
        itemset sofar = null;
        itemset remaining = null;
    }

    public static class ValP {
        float val;
        double p;
    }
}

