/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.negFIN;

class MyBitVector {
    static long[] TWO_POWER = new long[64];
    long[] bits;

    static {
        MyBitVector.TWO_POWER[0] = 1L;
        int i = 1;
        while (i < TWO_POWER.length) {
            MyBitVector.TWO_POWER[i] = TWO_POWER[i - 1] * 2L;
            ++i;
        }
    }

    public MyBitVector(int numOfBits) {
        this.bits = new long[(numOfBits - 1) / 64 + 1];
    }

    public Object clone() {
        MyBitVector result = new MyBitVector(this.bits.length * 64);
        System.arraycopy(this.bits, 0, result.bits, 0, result.bits.length);
        return result;
    }

    public void set(int bitIndex) {
        int n = bitIndex / 64;
        this.bits[n] = this.bits[n] | TWO_POWER[bitIndex % 64];
    }

    public boolean isSet(int bitIndex) {
        return (this.bits[bitIndex / 64] & TWO_POWER[bitIndex % 64]) != 0L;
    }
}

