/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.neclatclosed;

import ca.pfv.spmf.algorithms.frequentpatterns.neclatclosed.CPStorage;
import ca.pfv.spmf.algorithms.frequentpatterns.neclatclosed.MyBitVector;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AlgoNEclatClosed {
    long startTimestamp;
    long endTimestamp;
    int outputCount = 0;
    BufferedWriter writer = null;
    public int numOfFItem;
    public int minSupport;
    public Item[] item;
    public int[] itemsetX;
    public int itemsetXLen = 0;
    public SetEnumerationTreeNode nlRoot;
    private Map<Integer, BitSet> mapItemTIDS;
    private CPStorage cpStorage;
    static Comparator<Item> comp = new Comparator<Item>(){

        @Override
        public int compare(Item a, Item b) {
            return b.num - a.num;
        }
    };
    private int numOfTrans;

    public void runAlgorithm(String input_dataset, double minsup, String output) throws IOException {
        this.nlRoot = new SetEnumerationTreeNode();
        MemoryLogger.getInstance().reset();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.startTimestamp = System.currentTimeMillis();
        this.getData(input_dataset, minsup);
        this.itemsetXLen = 0;
        this.itemsetX = new int[this.numOfFItem];
        this.buildTree(input_dataset);
        this.nlRoot.label = this.numOfFItem;
        this.nlRoot.firstChild = null;
        this.nlRoot.next = null;
        this.initializeTree();
        this.cpStorage = new CPStorage();
        SetEnumerationTreeNode curNode = this.nlRoot.firstChild;
        this.nlRoot.firstChild = null;
        SetEnumerationTreeNode next = null;
        while (curNode != null) {
            this.traverse(curNode, 1);
            next = curNode.next;
            curNode.next = null;
            curNode = next;
        }
        this.writer.close();
        MemoryLogger.getInstance().checkMemory();
        this.endTimestamp = System.currentTimeMillis();
    }

    void buildTree(String filename) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        this.mapItemTIDS = new HashMap<Integer, BitSet>();
        int tid = 1;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                int itemX = Integer.parseInt(itemString);
                int j = 0;
                while (j < this.numOfFItem) {
                    if (itemX == this.item[j].index) {
                        BitSet tids = this.mapItemTIDS.get(j);
                        if (tids == null) {
                            tids = new BitSet();
                            this.mapItemTIDS.put(j, tids);
                        }
                        tids.set(tid);
                        break;
                    }
                    ++j;
                }
                ++n2;
            }
            ++tid;
        }
        reader.close();
    }

    void getData(String filename, double minSupport) throws IOException {
        String line;
        this.numOfTrans = 0;
        HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            ++this.numOfTrans;
            String[] stringArray = lineSplited = line.split(" ");
            int n = lineSplited.length;
            int n2 = 0;
            while (n2 < n) {
                String itemString = stringArray[n2];
                Integer item = Integer.parseInt(itemString);
                Integer count = (Integer)mapItemCount.get(item);
                if (count == null) {
                    mapItemCount.put(item, 1);
                } else {
                    count = count + 1;
                    mapItemCount.put(item, count);
                }
                ++n2;
            }
        }
        reader.close();
        this.minSupport = (int)Math.ceil(minSupport * (double)this.numOfTrans);
        this.numOfFItem = mapItemCount.size();
        Item[] tempItems = new Item[this.numOfFItem];
        int i = 0;
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Integer)entry.getValue() < this.minSupport) continue;
            tempItems[i] = new Item();
            tempItems[i].index = (Integer)entry.getKey();
            tempItems[i].num = (Integer)entry.getValue();
            ++i;
        }
        this.item = new Item[i];
        System.arraycopy(tempItems, 0, this.item, 0, i);
        this.numOfFItem = this.item.length;
        Arrays.sort(this.item, comp);
    }

    void initializeTree() {
        SetEnumerationTreeNode lastChild = null;
        int t = this.numOfFItem - 1;
        while (t >= 0) {
            SetEnumerationTreeNode nlNode = new SetEnumerationTreeNode();
            nlNode.label = t;
            nlNode.firstChild = null;
            nlNode.next = null;
            nlNode.tidSET = this.mapItemTIDS.get(nlNode.label);
            nlNode.count = nlNode.tidSET.cardinality();
            if (this.nlRoot.firstChild == null) {
                this.nlRoot.firstChild = nlNode;
                lastChild = nlNode;
            } else {
                lastChild.next = nlNode;
                lastChild = nlNode;
            }
            --t;
        }
    }

    public void traverse(SetEnumerationTreeNode curNode, int level) throws IOException {
        MemoryLogger.getInstance().checkMemory();
        SetEnumerationTreeNode prev = curNode;
        SetEnumerationTreeNode sibling = prev.next;
        SetEnumerationTreeNode lastChild = null;
        int sameCount = 0;
        this.itemsetX[this.itemsetXLen++] = curNode.label;
        while (sibling != null) {
            SetEnumerationTreeNode child = new SetEnumerationTreeNode();
            if (level == 1) {
                if (sibling.tidSET.cardinality() != 0) {
                    child.tidSET = (BitSet)curNode.tidSET.clone();
                    child.tidSET.andNot(sibling.tidSET);
                }
            } else if (curNode.tidSET.cardinality() != 0) {
                child.tidSET = (BitSet)sibling.tidSET.clone();
                child.tidSET.andNot(curNode.tidSET);
            }
            child.count = curNode.count - child.tidSET.cardinality();
            if (child.count >= this.minSupport) {
                if (curNode.count == child.count) {
                    this.itemsetX[this.itemsetXLen++] = sibling.label;
                    ++sameCount;
                } else {
                    child.label = sibling.label;
                    child.firstChild = null;
                    child.next = null;
                    if (curNode.firstChild == null) {
                        curNode.firstChild = child;
                        lastChild = child;
                    } else {
                        lastChild.next = child;
                        lastChild = child;
                    }
                }
            }
            sibling = sibling.next;
        }
        MyBitVector itemsetBitset = new MyBitVector(this.itemsetX, this.itemsetXLen);
        if (this.cpStorage.insertIfClose(itemsetBitset, curNode.count)) {
            this.writeItemsetsToFile(curNode.count);
        }
        SetEnumerationTreeNode child = curNode.firstChild;
        curNode.firstChild = null;
        while (child != null) {
            this.traverse(child, level + 1);
            SetEnumerationTreeNode next = child.next;
            child.next = null;
            child = next;
        }
        this.itemsetXLen -= 1 + sameCount;
    }

    private void writeItemsetsToFile(int support) throws IOException {
        StringBuilder buffer = new StringBuilder();
        ++this.outputCount;
        int i = 0;
        while (i < this.itemsetXLen) {
            buffer.append(this.item[this.itemsetX[i]].index);
            buffer.append(' ');
            ++i;
        }
        buffer.append("#SUP: ");
        buffer.append(support);
        buffer.append("\n");
        this.writer.write(buffer.toString());
    }

    public void printStats() {
        System.out.println("========== NEclatClosed - STATS ============");
        System.out.println("minSupport : " + (int)(100.0 * (double)this.minSupport / (double)this.numOfTrans) + "%");
        System.out.println(" Total time ~: " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Max memory:" + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println("=====================================");
    }

    class Item {
        public int index;
        public int num;

        Item() {
        }
    }

    class SetEnumerationTreeNode {
        public int label;
        public SetEnumerationTreeNode firstChild;
        public SetEnumerationTreeNode next;
        BitSet tidSET;
        int count;

        SetEnumerationTreeNode() {
        }
    }
}

