/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.mffi_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.mffi_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.mffi_miner.MFFIList;
import ca.pfv.spmf.algorithms.frequentpatterns.mffi_miner.MFFIRegions;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoMFFIMiner {
    public long startTimestamp = 0L;
    public long endTimestamp = 0L;
    public int MFFICount = 0;
    Map<Integer, Float> mapItemLowSUM;
    Map<Integer, Float> mapItemMiddleSUM;
    Map<Integer, Float> mapItemHighSUM;
    Map<Integer, Float> mapItemSUM;
    BufferedWriter writer = null;
    private int joinCount;
    final int BUFFERS_SIZE = 200;
    private int[] itemsetBuffer = null;

    public void runAlgorithm(String input, String output, float minSupport) throws IOException {
        ArrayList<MFFIList> listOfFFILists;
        block34: {
            float high;
            String thisLine;
            BufferedReader myInput;
            block32: {
                MemoryLogger.getInstance().reset();
                this.itemsetBuffer = new int[200];
                this.startTimestamp = System.currentTimeMillis();
                this.writer = new BufferedWriter(new FileWriter(output));
                this.mapItemLowSUM = new HashMap<Integer, Float>();
                this.mapItemMiddleSUM = new HashMap<Integer, Float>();
                this.mapItemHighSUM = new HashMap<Integer, Float>();
                myInput = null;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            String[] quanaities = split[2].split(" ");
                            int i = 0;
                            while (i < items.length) {
                                MFFIRegions regions = new MFFIRegions(Integer.parseInt(quanaities[i]));
                                Integer item = Integer.parseInt(items[i]);
                                if (this.mapItemLowSUM.containsKey(item)) {
                                    float low = this.mapItemLowSUM.get(item).floatValue();
                                    this.mapItemLowSUM.put(item, Float.valueOf(low += regions.low));
                                } else {
                                    this.mapItemLowSUM.put(item, Float.valueOf(regions.low));
                                }
                                if (this.mapItemMiddleSUM.containsKey(item)) {
                                    float middle = this.mapItemMiddleSUM.get(item).floatValue();
                                    this.mapItemMiddleSUM.put(item, Float.valueOf(middle += regions.middle));
                                } else {
                                    this.mapItemMiddleSUM.put(item, Float.valueOf(regions.middle));
                                }
                                if (this.mapItemHighSUM.containsKey(item)) {
                                    high = this.mapItemHighSUM.get(item).floatValue();
                                    this.mapItemHighSUM.put(item, Float.valueOf(high += regions.high));
                                } else {
                                    this.mapItemHighSUM.put(item, Float.valueOf(regions.high));
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            listOfFFILists = new ArrayList<MFFIList>();
            HashMap<Integer, MFFIList> mapItemToFFIList = new HashMap<Integer, MFFIList>();
            this.mapItemSUM = new HashMap<Integer, Float>();
            for (Integer item : this.mapItemLowSUM.keySet()) {
                MFFIList fuList;
                float low = this.mapItemLowSUM.get(item).floatValue();
                float middle = this.mapItemMiddleSUM.get(item).floatValue();
                high = this.mapItemHighSUM.get(item).floatValue();
                if (low >= minSupport) {
                    this.mapItemSUM.put(item * 100 + 12, Float.valueOf(low));
                    fuList = new MFFIList(item * 100 + 12);
                    mapItemToFFIList.put(item * 100 + 12, fuList);
                    listOfFFILists.add(fuList);
                }
                if (middle >= minSupport) {
                    this.mapItemSUM.put(item * 1000 + 123, Float.valueOf(middle));
                    fuList = new MFFIList(item * 1000 + 123);
                    mapItemToFFIList.put(item * 1000 + 123, fuList);
                    listOfFFILists.add(fuList);
                }
                if (!(high >= minSupport)) continue;
                this.mapItemSUM.put(item * 10000 + 1234, Float.valueOf(high));
                fuList = new MFFIList(item * 10000 + 1234);
                mapItemToFFIList.put(item * 10000 + 1234, fuList);
                listOfFFILists.add(fuList);
            }
            Collections.sort(listOfFFILists, new Comparator<MFFIList>(){

                @Override
                public int compare(MFFIList o1, MFFIList o2) {
                    return (int)AlgoMFFIMiner.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        Pair pair;
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] quanaities = split[2].split(" ");
                        ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                        int i = 0;
                        while (i < items.length) {
                            MFFIRegions regions = new MFFIRegions(Integer.parseInt(quanaities[i]));
                            if (this.mapItemSUM.containsKey(Integer.parseInt(items[i]) * 100 + 12) && regions.low > 0.0f) {
                                pair = new Pair();
                                pair.item = Integer.parseInt(items[i]) * 100 + 12;
                                pair.quanaity = regions.low;
                                revisedTransaction.add(pair);
                            }
                            if (this.mapItemSUM.containsKey(Integer.parseInt(items[i]) * 1000 + 123) && regions.middle > 0.0f) {
                                pair = new Pair();
                                pair.item = Integer.parseInt(items[i]) * 1000 + 123;
                                pair.quanaity = regions.middle;
                                revisedTransaction.add(pair);
                            }
                            if (this.mapItemSUM.containsKey(Integer.parseInt(items[i]) * 10000 + 1234) && regions.high > 0.0f) {
                                pair = new Pair();
                                pair.item = Integer.parseInt(items[i]) * 10000 + 1234;
                                pair.quanaity = regions.high;
                                revisedTransaction.add(pair);
                            }
                            ++i;
                        }
                        Collections.sort(revisedTransaction, new Comparator<Pair>(){

                            @Override
                            public int compare(Pair o1, Pair o2) {
                                return (int)AlgoMFFIMiner.this.compareItems(o1.item, o2.item);
                            }
                        });
                        float remainingUtility = -2.1474836E9f;
                        int i2 = revisedTransaction.size() - 1;
                        while (i2 >= 0) {
                            pair = (Pair)revisedTransaction.get(i2);
                            remainingUtility = pair.quanaity > remainingUtility ? pair.quanaity : remainingUtility;
                            MFFIList FFIListOfItem = (MFFIList)mapItemToFFIList.get(pair.item);
                            Element element = new Element(tid, pair.quanaity, remainingUtility);
                            FFIListOfItem.addElement(element);
                            --i2;
                        }
                        ++tid;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.MFFIMiner(this.itemsetBuffer, 0, listOfFFILists, minSupport);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private float compareItems(int item1, int item2) {
        float compare = this.mapItemSUM.get(item1).floatValue() - this.mapItemSUM.get(item2).floatValue();
        return compare == 0.0f ? (float)(item1 - item2) : compare;
    }

    private void MFFIMiner(int[] prefix, int prefixLength, List<MFFIList> FFILs, float minSupport) throws IOException {
        int i = 0;
        while (i < FFILs.size()) {
            MFFIList X = FFILs.get(i);
            if (X.sumIutils >= minSupport) {
                this.writeOut(prefix, prefixLength, X.item, X.sumIutils);
            }
            int xitem = 0;
            if (X.item % 10000 == 1234) {
                xitem = X.item / 10000;
            } else if (X.item % 1000 == 123) {
                xitem = X.item / 1000;
            } else if (X.item % 100 == 12) {
                xitem = X.item / 100;
            }
            if (X.sumRutils >= minSupport) {
                ArrayList<MFFIList> exULs = new ArrayList<MFFIList>();
                int j = i + 1;
                while (j < FFILs.size()) {
                    MFFIList Y = FFILs.get(j);
                    int yitem = 0;
                    if (Y.item % 10000 == 1234) {
                        yitem = Y.item / 10000;
                    } else if (Y.item % 1000 == 123) {
                        yitem = Y.item / 1000;
                    } else if (Y.item % 100 == 12) {
                        yitem = Y.item / 100;
                    }
                    if (xitem != yitem) {
                        exULs.add(this.construct(X, Y));
                        ++this.joinCount;
                    }
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.MFFIMiner(this.itemsetBuffer, prefixLength + 1, exULs, minSupport);
            }
            ++i;
        }
    }

    private MFFIList construct(MFFIList px, MFFIList py) {
        MFFIList pxyUL = new MFFIList(py.item);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            Element eXY = new Element(ex.tid, Float.min(ex.iutils, ey.iutils), ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(MFFIList ulist, int tid) {
        List<Element> list = ulist.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (list.get((int)middle).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (list.get((int)middle).tid > tid) {
                last = middle - 1;
                continue;
            }
            return list.get(middle);
        }
        return null;
    }

    private void writeOut(int[] prefix, int prefixLength, int item, float sumIutils) throws IOException {
        ++this.MFFICount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            if (prefix[i] % 10000 == 1234) {
                buffer.append(String.valueOf(prefix[i] / 10000) + ".H");
            } else if (prefix[i] % 1000 == 123) {
                buffer.append(String.valueOf(prefix[i] / 1000) + ".M");
            }
            if (prefix[i] % 100 == 12) {
                buffer.append(String.valueOf(prefix[i] / 100) + ".L");
            }
            buffer.append(' ');
            ++i;
        }
        if (item % 10000 == 1234) {
            buffer.append(String.valueOf(item / 10000) + ".H");
        } else if (item % 1000 == 123) {
            buffer.append(String.valueOf(item / 1000) + ".M");
        }
        if (item % 100 == 12) {
            buffer.append(String.valueOf(item / 100) + ".L");
        }
        buffer.append(" #SUP: ");
        buffer.append(sumIutils);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  MFFI-MINER ALGORITHM - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" MFFI count : " + this.MFFICount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println("===================================================");
    }

    class Pair {
        int item = 0;
        float quanaity = 0.0f;

        Pair() {
        }
    }
}

