/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lthui_miner;

import ca.pfv.spmf.algorithms.frequentpatterns.lthui_miner.Element;
import ca.pfv.spmf.algorithms.frequentpatterns.lthui_miner.Period;
import ca.pfv.spmf.algorithms.frequentpatterns.lthui_miner.TrendUtilityList;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlgoLTHUIMiner {
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private int lthuiCount = 0;
    private int candidateCount = 0;
    private Map<Integer, Integer> mapItemToTWU;
    private ArrayList<Double> timeDiff;
    private long minTime;
    private int numBin;
    private int numWin;
    private int numBinOfWin;
    private long dbLen = 0L;
    private BufferedWriter writer = null;
    private int joinCount;
    private static final int BUFFERS_SIZE = 300;
    private int[] itemsetBuffer = null;
    private ArrayList<Long> timeTid = new ArrayList();
    private ArrayList<Integer> binIndexTid = new ArrayList();

    public void runAlgorithm(String input, String output, int lminutil, int winLen, int binLen, double minSlope, long databaseStartTimestamp, boolean outputIndex) throws IOException {
        ArrayList<TrendUtilityList> listOfTUList;
        block45: {
            String thisLine;
            BufferedReader myInput;
            block43: {
                long maxTime;
                block41: {
                    this.lthuiCount = 0;
                    this.candidateCount = 0;
                    MemoryLogger.getInstance().reset();
                    this.itemsetBuffer = new int[300];
                    this.startTimestamp = System.currentTimeMillis();
                    if (databaseStartTimestamp >= 0L) {
                        this.minTime = databaseStartTimestamp;
                    }
                    this.numBinOfWin = winLen / binLen;
                    this.timeDiff = new ArrayList();
                    Double sum = 0.0;
                    double tmpSum = 0.0;
                    int i = 1;
                    while (i <= this.numBinOfWin) {
                        tmpSum += (double)i;
                        ++i;
                    }
                    double avg = tmpSum / (double)this.numBinOfWin;
                    int i2 = 1;
                    while (i2 <= this.numBinOfWin) {
                        this.timeDiff.add((double)i2 - avg);
                        sum = sum + Math.pow((double)i2 - avg, 2.0);
                        ++i2;
                    }
                    this.timeDiff.add(sum);
                    this.writer = new BufferedWriter(new FileWriter(output));
                    this.mapItemToTWU = new HashMap<Integer, Integer>();
                    myInput = null;
                    try {
                        try {
                            myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                            long time = 0L;
                            while ((thisLine = myInput.readLine()) != null) {
                                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                                ++this.dbLen;
                                String[] split = thisLine.split(":");
                                time = Long.parseLong(split[3]);
                                if (this.dbLen == 1L && databaseStartTimestamp < 0L) {
                                    this.minTime = time;
                                }
                                this.timeTid.add(time);
                            }
                            maxTime = time;
                            this.numBin = (int)((maxTime - this.minTime + 1L) / (long)binLen);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (myInput != null) {
                                myInput.close();
                            }
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        if (myInput != null) {
                            myInput.close();
                        }
                        throw throwable;
                    }
                    if (myInput != null) {
                        myInput.close();
                    }
                }
                maxTime = this.minTime + (long)(this.numBin * binLen) - 1L;
                try {
                    try {
                        myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                        int indexBin = 0;
                        long nextBinStart = 0L;
                        this.dbLen = 0L;
                        long time = 0L;
                        while ((thisLine = myInput.readLine()) != null) {
                            if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                            String[] split = thisLine.split(":");
                            String[] items = split[0].split(" ");
                            int transactionUtility = Integer.parseInt(split[1]);
                            time = Long.parseLong(split[3]);
                            if (time <= this.minTime + (long)(this.numBin * binLen) - 1L) {
                                int i = 0;
                                while (i < items.length) {
                                    Integer item = Integer.parseInt(items[i]);
                                    Integer twu = this.mapItemToTWU.get(item);
                                    twu = twu == null ? transactionUtility : twu + transactionUtility;
                                    this.mapItemToTWU.put(item, twu);
                                    ++i;
                                }
                                if (this.dbLen == 0L) {
                                    nextBinStart = this.minTime + (long)(binLen * 1);
                                }
                                while (time >= nextBinStart) {
                                    ++indexBin;
                                    nextBinStart += (long)binLen;
                                }
                                if (time < nextBinStart) {
                                    this.binIndexTid.add(indexBin);
                                }
                                ++this.dbLen;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (myInput != null) {
                            myInput.close();
                        }
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    if (myInput != null) {
                        myInput.close();
                    }
                    throw throwable;
                }
                if (myInput != null) {
                    myInput.close();
                }
            }
            this.numWin = this.numBin - this.numBinOfWin + 1;
            if (this.numWin < 1) {
                return;
            }
            listOfTUList = new ArrayList<TrendUtilityList>();
            HashMap<Integer, TrendUtilityList> mapItemToTUList = new HashMap<Integer, TrendUtilityList>();
            for (Map.Entry<Integer, Integer> entry : this.mapItemToTWU.entrySet()) {
                Integer item = entry.getKey();
                if (this.mapItemToTWU.get(item) < lminutil) continue;
                TrendUtilityList uList = new TrendUtilityList(item, this.numBin, this.numWin);
                mapItemToTUList.put(item, uList);
                listOfTUList.add(uList);
            }
            Collections.sort(listOfTUList, new Comparator<TrendUtilityList>(){

                @Override
                public int compare(TrendUtilityList o1, TrendUtilityList o2) {
                    return AlgoLTHUIMiner.this.compareItems(o1.item, o2.item);
                }
            });
            try {
                try {
                    myInput = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
                    int tid = 0;
                    while ((thisLine = myInput.readLine()) != null) {
                        if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                        String[] split = thisLine.split(":");
                        String[] items = split[0].split(" ");
                        String[] utilityValues = split[2].split(" ");
                        long time = Long.parseLong(split[3]);
                        if (time <= this.minTime + (long)(this.numBin * binLen) - 1L) {
                            int remainingUtility = 0;
                            ArrayList<Pair> revisedTransaction = new ArrayList<Pair>();
                            int i = 0;
                            while (i < items.length) {
                                Pair pair = new Pair();
                                pair.item = Integer.parseInt(items[i]);
                                pair.utility = Integer.parseInt(utilityValues[i]);
                                if (this.mapItemToTWU.get(pair.item) >= lminutil) {
                                    revisedTransaction.add(pair);
                                    remainingUtility += pair.utility;
                                }
                                ++i;
                            }
                            Collections.sort(revisedTransaction, new Comparator<Pair>(){

                                @Override
                                public int compare(Pair o1, Pair o2) {
                                    return AlgoLTHUIMiner.this.compareItems(o1.item, o2.item);
                                }
                            });
                            for (Pair pair : revisedTransaction) {
                                TrendUtilityList tuListOfItem = (TrendUtilityList)mapItemToTUList.get(pair.item);
                                Element element = new Element(tid, pair.utility, remainingUtility -= pair.utility);
                                tuListOfItem.addElement(element);
                            }
                            ++tid;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (myInput != null) {
                        myInput.close();
                    }
                    break block45;
                }
            }
            catch (Throwable throwable) {
                if (myInput != null) {
                    myInput.close();
                }
                throw throwable;
            }
            if (myInput != null) {
                myInput.close();
            }
        }
        for (TrendUtilityList tul : listOfTUList) {
            this.calBinInfos(tul);
            this.findTrend(null, tul, lminutil, winLen, binLen, minSlope);
        }
        MemoryLogger.getInstance().checkMemory();
        this.lthuiSearch(this.itemsetBuffer, 0, null, listOfTUList, lminutil, winLen, binLen, minSlope, outputIndex);
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
        this.endTimestamp = System.currentTimeMillis();
    }

    private int compareItems(int item1, int item2) {
        int compare = this.mapItemToTWU.get(item1) - this.mapItemToTWU.get(item2);
        return compare == 0 ? item1 - item2 : compare;
    }

    private void lthuiSearch(int[] prefix, int prefixLength, TrendUtilityList pUL, List<TrendUtilityList> ULs, int lminutil, int winLen, int binLen, double minSlope, boolean outputIndex) throws IOException {
        int i = 0;
        while (i < ULs.size()) {
            TrendUtilityList X = ULs.get(i);
            if (!X.trendPeriod.isEmpty()) {
                this.writeOut(prefix, prefixLength, X, binLen, outputIndex);
            }
            if (!X.rutilPeriod.isEmpty() && X.sumUtils + X.sumRutils >= lminutil) {
                ArrayList<TrendUtilityList> exULs = new ArrayList<TrendUtilityList>();
                ++this.candidateCount;
                int j = i + 1;
                while (j < ULs.size()) {
                    TrendUtilityList Y = ULs.get(j);
                    TrendUtilityList pXY = this.construct(pUL, X, Y);
                    this.calBinInfos(pXY);
                    this.findTrend(X, pXY, lminutil, winLen, binLen, minSlope);
                    exULs.add(pXY);
                    ++this.joinCount;
                    ++j;
                }
                this.itemsetBuffer[prefixLength] = X.item;
                this.lthuiSearch(this.itemsetBuffer, prefixLength + 1, X, exULs, lminutil, winLen, binLen, minSlope, outputIndex);
            }
            ++i;
        }
    }

    private TrendUtilityList construct(TrendUtilityList P, TrendUtilityList px, TrendUtilityList py) {
        TrendUtilityList pxyUL = new TrendUtilityList(py.item, this.numBin, this.numWin);
        for (Element ex : px.elements) {
            Element ey = this.findElementWithTID(py, ex.tid);
            if (ey == null) continue;
            if (P == null) {
                Element eXY = new Element(ex.tid, ex.utils + ey.utils, ey.rutils);
                pxyUL.addElement(eXY);
                continue;
            }
            Element e = this.findElementWithTID(P, ex.tid);
            if (e == null) continue;
            Element eXY = new Element(ex.tid, ex.utils + ey.utils - e.utils, ey.rutils);
            pxyUL.addElement(eXY);
        }
        return pxyUL;
    }

    private Element findElementWithTID(TrendUtilityList tuList, int tid) {
        ArrayList list = tuList.elements;
        int first = 0;
        int last = list.size() - 1;
        while (first <= last) {
            int middle = first + last >>> 1;
            if (((Element)list.get((int)middle)).tid < tid) {
                first = middle + 1;
                continue;
            }
            if (((Element)list.get((int)middle)).tid > tid) {
                last = middle - 1;
                continue;
            }
            return (Element)list.get(middle);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void findTrend(TrendUtilityList p, TrendUtilityList pX, int lminutil, int winLen, int binLen, double minSlope) {
        winEnd = this.numBinOfWin;
        k = winLen / binLen;
        zeroAble = k / 2;
        countZero = 0;
        winStart = 0;
        while (winStart < this.numBin && winEnd - 1 < this.numBin) {
            trendPreFlag = false;
            rutilPreFlag = false;
            numSliding = 0;
            sumSlope = 0.0;
            sumUtil = 0;
            sumRutil = 0;
            countBin = 0;
            countZero = 0;
            i = winStart;
            while (i < this.numBin && countBin != this.numBinOfWin) {
                block23: {
                    block21: {
                        block22: {
                            if (countZero > zeroAble) break block21;
                            if (countBin != 0) break block22;
                            winStart = i;
                            if (p != null && !p.winRemain.get(winStart)) break block23;
                        }
                        if (pX.utilBin[i] == 0) {
                            ++countZero;
                        }
                        sumUtil += pX.utilBin[i];
                        sumRutil += pX.rutilBin[i];
                        ++countBin;
                        break block23;
                    }
                    countBin = 0;
                    countZero = 0;
                    sumUtil = 0;
                    sumRutil = 0;
                    i = winStart;
                }
                ++i;
            }
            if (countBin != this.numBinOfWin) break;
            if (sumUtil + sumRutil >= lminutil) {
                rutilPreFlag = true;
            }
            if (sumUtil >= lminutil && (slope = this.calSlope(pX, winStart)) >= minSlope) {
                ++numSliding;
                sumSlope += slope;
                trendPreFlag = true;
            }
            winEnd = winStart + this.numBinOfWin;
            beginIndex = winStart;
            endIndex = winEnd;
            rBeginIndex = winStart;
            rEndIndex = winEnd;
            while (winStart < this.numBin && winEnd < this.numBin) {
                block25: {
                    block24: {
                        if (p != null && !p.winRemain.get(winStart + 1)) {
                            ++winStart;
                            ++winEnd;
                            break;
                        }
                        if (pX.utilBin[winEnd] == 0) {
                            ++countZero;
                        }
                        if (pX.utilBin[winStart] == 0) {
                            --countZero;
                        }
                        if (countZero > zeroAble) break;
                        sumUtil -= pX.utilBin[winStart];
                        sumRutil -= pX.rutilBin[winStart];
                        sumUtil += pX.utilBin[winEnd];
                        sumRutil += pX.rutilBin[winEnd];
                        ++winStart;
                        ++winEnd;
                        if (!trendPreFlag) break block24;
                        if (sumUtil < lminutil) ** GOTO lbl-1000
                        slope = this.calSlope(pX, winStart);
                        if (v0 < minSlope) lbl-1000:
                        // 2 sources

                        {
                            pX.trendPeriod.add(new Period(beginIndex, endIndex - 1));
                            pX.trendSlope.add(sumSlope / (double)numSliding);
                            numSliding = 0;
                            sumSlope = 0.0;
                            trendPreFlag = false;
                        } else {
                            ++numSliding;
                            sumSlope += slope;
                            endIndex = winEnd;
                        }
                        break block25;
                    }
                    if (sumUtil >= lminutil) {
                        slope = this.calSlope(pX, winStart);
                        if (v1 >= minSlope) {
                            beginIndex = winStart;
                            endIndex = winEnd;
                            ++numSliding;
                            sumSlope += slope;
                            trendPreFlag = true;
                        }
                    }
                }
                if (rutilPreFlag) {
                    if (sumUtil + sumRutil < lminutil) {
                        pX.rutilPeriod.add(new Period(rBeginIndex, rEndIndex - 1));
                        i = rBeginIndex;
                        while (i <= rEndIndex - 1 - this.numBinOfWin + 1) {
                            pX.winRemain.set(i);
                            ++i;
                        }
                        rutilPreFlag = false;
                        continue;
                    }
                    rEndIndex = winEnd;
                    continue;
                }
                if (sumUtil + sumRutil < lminutil) continue;
                rBeginIndex = winStart;
                rEndIndex = winEnd;
                rutilPreFlag = true;
            }
            if (trendPreFlag) {
                pX.trendPeriod.add(new Period(beginIndex, endIndex - 1));
                pX.trendSlope.add(sumSlope / (double)numSliding);
            }
            if (rutilPreFlag) {
                pX.rutilPeriod.add(new Period(rBeginIndex, rEndIndex - 1));
                i = rBeginIndex;
                while (i <= rEndIndex - 1 - this.numBinOfWin + 1) {
                    pX.winRemain.set(i);
                    ++i;
                }
            }
            ++winStart;
            ++winEnd;
        }
    }

    private double calSlope(TrendUtilityList tul, int winStart) {
        double slope = 0.0;
        double aveUtility = 0.0;
        int i = winStart;
        while (i < winStart + this.numBinOfWin) {
            aveUtility += (double)tul.utilBin[i];
            ++i;
        }
        aveUtility /= (double)this.numBinOfWin;
        double molecule = 0.0;
        double denominator = this.timeDiff.get(this.timeDiff.size() - 1);
        if (Double.doubleToLongBits(denominator) == Double.doubleToLongBits(0.0)) {
            return slope;
        }
        int i2 = winStart;
        int j = 0;
        while (i2 < winStart + this.numBinOfWin) {
            molecule += ((double)tul.utilBin[i2] - aveUtility) * this.timeDiff.get(j);
            ++i2;
            ++j;
        }
        slope = molecule / denominator;
        return slope;
    }

    private void calBinInfos(TrendUtilityList tul) {
        int i = 0;
        while (i < tul.elements.size()) {
            int indexBin;
            int n = indexBin = this.binIndexTid.get(((Element)tul.elements.get((int)i)).tid).intValue();
            tul.utilBin[n] = tul.utilBin[n] + ((Element)tul.elements.get((int)i)).utils;
            int n2 = indexBin;
            tul.rutilBin[n2] = tul.rutilBin[n2] + ((Element)tul.elements.get((int)i)).rutils;
            ++i;
        }
    }

    private void writeOut(int[] prefix, int prefixLength, TrendUtilityList ult, int binLen, boolean outputIndex) throws IOException {
        ++this.lthuiCount;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < prefixLength) {
            buffer.append(prefix[i]);
            buffer.append(' ');
            ++i;
        }
        buffer.append(ult.item);
        buffer.append(" #PERIOD-UTIL-SLOPE");
        i = 0;
        while (i < ult.trendPeriod.size()) {
            Period p = ult.trendPeriod.get(i);
            if (outputIndex) {
                buffer.append(" [" + (p.beginIndex + 1) + "," + (p.endIndex + 1) + "] ");
            } else {
                buffer.append(" [" + (this.minTime + (long)(p.beginIndex * binLen)) + "," + (this.minTime + (long)((p.endIndex + 1) * binLen) - 1L) + "] ");
            }
            double slope = ult.trendSlope.get(i);
            int sum = 0;
            int j = p.beginIndex;
            while (j <= p.endIndex) {
                sum += ult.utilBin[j];
                ++j;
            }
            buffer.append("(" + sum + "," + slope + ") ");
            ++i;
        }
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  LTHUI-MINER ALGORITHM v2.44 - STATS =============");
        System.out.println(" Total time ~ " + (this.endTimestamp - this.startTimestamp) + " ms");
        System.out.println(" Memory ~ " + MemoryLogger.getInstance().getMaxMemory() + " MB");
        System.out.println(" Locally Trending High-utility itemsets count : " + this.lthuiCount);
        System.out.println(" Join count : " + this.joinCount);
        System.out.println(" Candidate count : " + this.candidateCount);
        System.out.println("===================================================");
    }

    private class Pair {
        int item = 0;
        int utility = 0;

        private Pair() {
        }
    }
}

