/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lppm;

import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoLPPMDepth2 {
    private int maxPer;
    private int minDur;
    private int maxSoPer;
    private int itemsetCount;
    private long intersectionCount = 0L;
    protected Itemsets patterns = null;
    BufferedWriter writer = null;
    final int BUFFERS_SIZE = 2000;
    private int[] itemsetBuffer = null;
    private int largestTs;
    private boolean selfIncrement;
    private long startTimestamp;
    private long endTime;

    public Itemsets runAlgorithm(String input, String output, int maxPer, int minDur, int maxSoPer, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.maxPer = maxPer;
        this.minDur = minDur;
        this.maxSoPer = maxSoPer;
        this.selfIncrement = selfIncrement;
        this.intersectionCount = 0L;
        this.itemsetBuffer = new int[2000];
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Local Periodic Pattern");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.startTimestamp = System.currentTimeMillis();
        Map<Integer, BitSet> mapItemTS = this.convertTimeStamps(input);
        ArrayList<Integer> lpp1 = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, BitSet>> it = mapItemTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BitSet> entry = it.next();
            if (!this.generatePattern(entry)) {
                it.remove();
                continue;
            }
            lpp1.add(entry.getKey());
        }
        Collections.sort(lpp1);
        int i = 0;
        while (i < lpp1.size() - 1) {
            Integer itemI = (Integer)lpp1.get(i);
            BitSet tsSetI = mapItemTS.get(itemI);
            ArrayList<Integer> equivalenceClassIitems = new ArrayList<Integer>();
            ArrayList<BitSet> equivalenceClassItssets = new ArrayList<BitSet>();
            this.itemsetBuffer[0] = itemI;
            int j = i + 1;
            while (j < lpp1.size()) {
                int itemJ = (Integer)lpp1.get(j);
                BitSet tsSetJ = mapItemTS.get(itemJ);
                BitSet tsSetIJ = (BitSet)tsSetI.clone();
                tsSetIJ.and(tsSetJ);
                ++this.intersectionCount;
                ArrayList<int[]> timeIntervals = this.bitset2intervals(tsSetIJ);
                if (timeIntervals.size() > 0) {
                    equivalenceClassIitems.add(itemJ);
                    equivalenceClassItssets.add(tsSetIJ);
                    this.save(this.itemsetBuffer, 1, itemJ, timeIntervals);
                }
                ++j;
            }
            if (equivalenceClassIitems.size() > 0) {
                this.processEquivalenceClass(this.itemsetBuffer, 1, equivalenceClassIitems, equivalenceClassItssets);
            }
            ++i;
        }
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    private void processEquivalenceClass(int[] prefix, int prefixLength, List<Integer> equivalenceClassItems, List<BitSet> equivalenceClassItssets) throws IOException {
        if (equivalenceClassItems.size() <= 1) {
            return;
        }
        if (equivalenceClassItems.size() == 2) {
            int itemI = equivalenceClassItems.get(0);
            BitSet tsSetI = equivalenceClassItssets.get(0);
            int itemJ = equivalenceClassItems.get(1);
            BitSet tsSetJ = equivalenceClassItssets.get(1);
            BitSet tsSetIJ = (BitSet)tsSetI.clone();
            tsSetIJ.and(tsSetJ);
            ++this.intersectionCount;
            ArrayList<int[]> timeIntervals = this.bitset2intervals(tsSetIJ);
            if (timeIntervals.size() > 0) {
                int newPrefixLength = prefixLength + 1;
                prefix[prefixLength] = itemI;
                this.save(prefix, newPrefixLength, itemJ, timeIntervals);
            }
            return;
        }
        int i = 0;
        while (i < equivalenceClassItems.size() - 1) {
            int itemI = equivalenceClassItems.get(i);
            BitSet tsSetI = equivalenceClassItssets.get(i);
            ArrayList<Integer> equivalenceClassISuffixItems = new ArrayList<Integer>();
            ArrayList<BitSet> equivalenceClassISuffixtssets = new ArrayList<BitSet>();
            int newPrefixLength = prefixLength + 1;
            prefix[prefixLength] = itemI;
            int j = i + 1;
            while (j < equivalenceClassItems.size()) {
                int itemJ = equivalenceClassItems.get(j);
                BitSet tsSetJ = equivalenceClassItssets.get(j);
                BitSet tsSetIJ = (BitSet)tsSetI.clone();
                tsSetIJ.and(tsSetJ);
                ++this.intersectionCount;
                ArrayList<int[]> timeIntervals = this.bitset2intervals(tsSetIJ);
                if (timeIntervals.size() > 0) {
                    equivalenceClassISuffixItems.add(itemJ);
                    equivalenceClassISuffixtssets.add(tsSetIJ);
                    this.save(prefix, newPrefixLength, itemJ, timeIntervals);
                }
                ++j;
            }
            if (equivalenceClassISuffixItems.size() > 0) {
                this.processEquivalenceClass(prefix, newPrefixLength, equivalenceClassISuffixItems, equivalenceClassISuffixtssets);
            }
            ++i;
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void save(int[] prefix, int prefixLen, int itemJ, ArrayList<int[]> timeIntervals) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            int[] itemName = new int[prefixLen + 1];
            System.arraycopy(prefix, 0, itemName, 0, prefixLen);
            itemName[prefixLen] = itemJ;
            this.patterns.addItemset(new Itemset(itemName, timeIntervals), prefixLen + 1);
        } else {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < prefixLen) {
                int item = prefix[i];
                buffer.append(item);
                buffer.append(" ");
                ++i;
            }
            buffer.append(itemJ);
            buffer.append(" #Time-Interval: ");
            for (int[] time : timeIntervals) {
                buffer.append("[ ");
                buffer.append(time[0]);
                buffer.append(" , ");
                buffer.append(time[1]);
                buffer.append(" ]  ");
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private void saveSingleItem(int itemName, ArrayList<int[]> timeIntervals) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            this.patterns.addItemset(new Itemset(itemName, timeIntervals), 1);
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(itemName);
            buffer.append(" ");
            buffer.append(" #Time-Interval: ");
            for (int[] time : timeIntervals) {
                buffer.append("[ ");
                buffer.append(time[0]);
                buffer.append(" , ");
                buffer.append(time[1]);
                buffer.append(" ]  ");
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    private ArrayList<int[]> bitset2intervals(BitSet bitSet) {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        int soPer = this.maxSoPer;
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1 && (soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
                left = -1;
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            }
        }
        return timeIntervals;
    }

    private boolean generatePattern(Map.Entry<Integer, BitSet> entry) throws IOException {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        int soPer = this.maxSoPer;
        BitSet bitSet = entry.getValue();
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1) {
                if ((soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                    if (preTS - left >= this.minDur) {
                        timeIntervals.add(new int[]{left, preTS});
                    } else {
                        bitSet.clear(left, preTS);
                    }
                    left = -1;
                }
            } else {
                bitSet.clear(preTS);
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                } else {
                    bitSet.clear(left, preTS);
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            } else {
                bitSet.clear(left, this.largestTs);
            }
        }
        if (timeIntervals.size() > 0) {
            this.saveSingleItem(entry.getKey(), timeIntervals);
            entry.setValue(bitSet);
            return true;
        }
        return false;
    }

    public Map<Integer, BitSet> convertTimeStamps(String input) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, BitSet> mapItemTS = new HashMap<Integer, BitSet>();
        if (this.selfIncrement) {
            String line;
            int ts = 1;
            while ((line = reader.readLine()) != null) {
                String[] lineSplited;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] stringArray = lineSplited = line.split(" ");
                int n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n2;
                }
                ++ts;
            }
            this.largestTs = ts - 1;
        } else {
            String line;
            int ts = 0;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                ts = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n = lineItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String itemString = stringArray[n3];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n3;
                }
            }
            this.largestTs = ts;
        }
        reader.close();
        return mapItemTS;
    }

    public void printStats() {
        System.out.println("=============  LPPM_depth(no OTS) - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println(" Intersection count : " + this.intersectionCount);
        System.out.println("===================================================");
    }
}

