/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.lppm;

import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemset;
import ca.pfv.spmf.algorithms.frequentpatterns.lppm.Itemsets;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoLPPMBreadth1 {
    private int maxPer;
    private int minDur;
    private int maxSoPer;
    BufferedWriter writer = null;
    protected Itemsets patterns = null;
    private int largestTs;
    private boolean selfIncrement;
    private int itemsetCount;
    private long startTimestamp;
    private long endTime;

    public Itemsets runAlgorithm(String input, String output, int maxPer, int minDur, int maxSoPer, boolean selfIncrement) throws IOException {
        MemoryLogger.getInstance().reset();
        this.maxPer = maxPer;
        this.minDur = minDur;
        this.maxSoPer = maxSoPer;
        this.selfIncrement = selfIncrement;
        if (output == null) {
            this.writer = null;
            this.patterns = new Itemsets("Local Periodic Pattern");
        } else {
            this.patterns = null;
            this.writer = new BufferedWriter(new FileWriter(output));
        }
        this.itemsetCount = 0;
        this.startTimestamp = System.currentTimeMillis();
        Map<Integer, BitSet> mapItemTS = this.convertTimeStamps(input);
        List<int[]> level = new ArrayList<int[]>();
        Iterator<Map.Entry<Integer, BitSet>> it = mapItemTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BitSet> entry = it.next();
            if (!this.generatePattern(entry)) {
                it.remove();
                continue;
            }
            level.add(new int[]{entry.getKey()});
        }
        Collections.sort(level, new Comparator<int[]>(){

            @Override
            public int compare(int[] arg0, int[] arg1) {
                return arg0[0] - arg1[0];
            }
        });
        while (!level.isEmpty()) {
            MemoryLogger.getInstance().checkMemory();
            level = this.generateCandidateSizeK(level, mapItemTS);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        MemoryLogger.getInstance().checkMemory();
        this.endTime = System.currentTimeMillis();
        return this.patterns;
    }

    protected List<int[]> generateCandidateSizeK(List<int[]> levelK1, Map<Integer, BitSet> mapItemTS) throws IOException {
        ArrayList<int[]> candidates = new ArrayList<int[]>();
        int i = 0;
        while (i < levelK1.size()) {
            block9: {
                int[] itemset1 = levelK1.get(i);
                int j = i + 1;
                while (j < levelK1.size()) {
                    block10: {
                        int[] itemset2 = levelK1.get(j);
                        int k = 0;
                        while (k < itemset1.length) {
                            if (k == itemset1.length - 1) {
                                if (itemset1[k] >= itemset2[k]) {
                                    break block9;
                                }
                            } else {
                                if (itemset1[k] < itemset2[k]) break block10;
                                if (itemset1[k] > itemset2[k]) break block9;
                            }
                            ++k;
                        }
                        BitSet bitSetIJ = (BitSet)mapItemTS.get(itemset1[0]).clone();
                        int k2 = 1;
                        while (k2 < itemset1.length) {
                            bitSetIJ.and(mapItemTS.get(itemset1[k2]));
                            ++k2;
                        }
                        bitSetIJ.and(mapItemTS.get(itemset2[itemset2.length - 1]));
                        ArrayList<int[]> timeIntervals = this.bitset2intervals(bitSetIJ);
                        if (timeIntervals.size() > 0) {
                            int[] newItems = new int[itemset1.length + 1];
                            System.arraycopy(itemset1, 0, newItems, 0, itemset1.length);
                            newItems[itemset2.length] = itemset2[itemset2.length - 1];
                            this.save(newItems, timeIntervals);
                            candidates.add(newItems);
                        }
                    }
                    ++j;
                }
                MemoryLogger.getInstance().checkMemory();
            }
            ++i;
        }
        return candidates;
    }

    private ArrayList<int[]> bitset2intervals(BitSet bitSet) {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        int soPer = this.maxSoPer;
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1 && (soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
                left = -1;
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            }
        }
        return timeIntervals;
    }

    private boolean generatePattern(Map.Entry<Integer, BitSet> entry) throws IOException {
        ArrayList<int[]> timeIntervals = new ArrayList<int[]>();
        int left = -1;
        BitSet bitSet = entry.getValue();
        int soPer = this.maxSoPer;
        int preTS = bitSet.nextSetBit(1);
        int ts = bitSet.nextSetBit(preTS + 1);
        while (ts > 0) {
            if (ts - preTS <= this.maxPer && left == -1) {
                left = preTS;
                soPer = this.maxSoPer;
            }
            if (left != -1) {
                if ((soPer = Math.max(0, soPer + ts - preTS - this.maxPer)) > this.maxSoPer) {
                    if (preTS - left >= this.minDur) {
                        timeIntervals.add(new int[]{left, preTS});
                    } else {
                        bitSet.clear(left, preTS + 1);
                    }
                    left = -1;
                }
            } else {
                bitSet.clear(preTS);
            }
            preTS = ts;
            ts = bitSet.nextSetBit(preTS + 1);
        }
        if (left != -1) {
            if ((soPer = Math.max(0, soPer + this.largestTs - preTS - this.maxPer)) > this.maxSoPer) {
                if (preTS - left >= this.minDur) {
                    timeIntervals.add(new int[]{left, preTS});
                } else {
                    bitSet.clear(left, preTS + 1);
                }
            } else if (this.largestTs - left >= this.minDur) {
                timeIntervals.add(new int[]{left, this.largestTs});
            } else {
                bitSet.clear(left, this.largestTs + 1);
            }
        }
        if (timeIntervals.size() > 0) {
            this.save(new int[]{entry.getKey()}, timeIntervals);
            entry.setValue(bitSet);
            return true;
        }
        return false;
    }

    private Map<Integer, BitSet> convertTimeStamps(String input) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(input));
        HashMap<Integer, BitSet> mapItemTS = new HashMap<Integer, BitSet>();
        if (this.selfIncrement) {
            String line;
            int ts = 1;
            while ((line = reader.readLine()) != null) {
                String[] lineSplited;
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] stringArray = lineSplited = line.split(" ");
                int n = lineSplited.length;
                int n2 = 0;
                while (n2 < n) {
                    String itemString = stringArray[n2];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n2;
                }
                ++ts;
            }
            this.largestTs = ts - 1;
        } else {
            String line;
            int ts = 0;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
                String[] lineSplited = line.split("\\|");
                String[] lineItems = lineSplited[0].split(" ");
                ts = Integer.parseInt(lineSplited[1]);
                String[] stringArray = lineItems;
                int n = lineItems.length;
                int n3 = 0;
                while (n3 < n) {
                    String itemString = stringArray[n3];
                    Integer itemName = Integer.parseInt(itemString);
                    if (!mapItemTS.containsKey(itemName)) {
                        mapItemTS.put(itemName, new BitSet());
                    }
                    ((BitSet)mapItemTS.get(itemName)).set(ts);
                    ++n3;
                }
            }
            this.largestTs = ts;
        }
        reader.close();
        return mapItemTS;
    }

    private void save(int[] items, ArrayList<int[]> timeIntervals) throws IOException {
        ++this.itemsetCount;
        if (this.writer == null) {
            this.patterns.addItemset(new Itemset(items, timeIntervals), items.length);
        } else {
            StringBuilder buffer = new StringBuilder();
            int[] nArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                int item = nArray[n2];
                buffer.append(item);
                buffer.append(" ");
                ++n2;
            }
            buffer.append("#Time-Interval: ");
            for (int[] time : timeIntervals) {
                buffer.append("[ ");
                buffer.append(time[0]);
                buffer.append(" , ");
                buffer.append(time[1]);
                buffer.append(" ]  ");
            }
            this.writer.write(buffer.toString());
            this.writer.newLine();
        }
    }

    public void printStats() {
        System.out.println("=============  LPPM_breadth(no SPM) - STATS =============");
        long temps = this.endTime - this.startTimestamp;
        System.out.println(" Total time ~ " + temps + " ms");
        System.out.println(" Itemsets count : " + this.itemsetCount);
        System.out.println(" Maximum memory usage : " + MemoryLogger.getInstance().getMaxMemory() + " mb");
        System.out.println("===================================================");
    }
}

